/*
 *  $Id: socketlib.c,v 1.3 2001/09/07 18:46:17 davej Exp $
 *	This file is part of Powertweak Linux.
 *	(C) 2000 Dave Jones, Arjan van de Ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include <string.h>
#include <powertweak.h>
#include <messages.h>

void send_blob(int fd, void* data, int size)
{
	int result;
	
	
	result = write(fd,&size,sizeof(size));
	result = write(fd,data,size);
}

void send_int(int fd, int value)
{
	send_blob(fd,&value,sizeof(value));	
}

void send_string(int fd, char *string)
{
	int nul=0;
	int result;
	if (string==NULL) {
		result = write(fd,&nul,sizeof(nul));
	} else
	{
		send_blob(fd,string,strlen(string)+1);
	}	
}

void send_message(int fd, int message) 
{
	send_blob(fd,&message,sizeof(message));
}

void send_value(int fd, value_t value)
{
	int result;
	int size;
	
	size=sizeof(int);
	if (value.strVal!=NULL)
		size += strlen(value.strVal);
	
	result = write(fd,&size,sizeof(size));
	result = write(fd,&value.intVal,sizeof(value.intVal));
	if ((value.strVal!=NULL)&&(strlen(value.strVal)>0))
		result = write(fd,value.strVal,strlen(value.strVal));
	
}

void send_tweak(int fd, struct tweak *tweak)
{	
	/* This is cheating!!!! */
	
	send_string(fd, tweak->WidgetText);
	send_string(fd, tweak->Description);
	send_string(fd, tweak->ConfigName);
	send_int(fd, tweak->Type);
	send_int(fd, tweak->MinValue);
	send_int(fd, tweak->MaxValue);
}

static void receive_blob(int fd, void ** data, int *size)
{
	int result;
	
	result = read(fd,size,sizeof(*size));
	
	if (*size==0) {
		*data = NULL;
		return;
	}
	
	*data = malloc(*size);
	assert(*data!=NULL);
	
	result = read(fd,*data,*size);
}

int receive_int(int fd)
{
	int *val;
	int size;
	receive_blob(fd,(void*)&val,&size);
	assert(size==4);
	size = *val;
	free(val);
	return size;
}

char *receive_string(int fd)
{
	char *data,*data2;
	int len;
	receive_blob(fd,(void*)&data,&len);
	if (len==0) 
		return NULL;
	
	data2=malloc(len+1);
	assert(data2!=NULL);
	memset(data2,0,len+1);
	memcpy(data2,data,len);
	free(data);
	
	return data2;	
}

int receive_message(int fd) 
{
	return receive_int(fd);
}

value_t receive_value(int fd)
{
	value_t value;
	int result;
	unsigned int size;
	
	
	result = read(fd,&size,sizeof(size));
	result = read(fd,&value.intVal,sizeof(value.intVal));
	if (size>sizeof(int)) {
		/* We received a string. */
		value.strVal=malloc(1+size-sizeof(int));
		if (value.strVal==NULL)
			return value;
		memset(value.strVal,0,1+size-sizeof(int));
		result = read(fd,value.strVal,size-sizeof(int));
	} else {
		/* We received an integer. */
		value.strVal = NULL;
	}
	return value;
}

struct tweak *receive_tweak(int fd)
{	
	struct tweak *tweak;
	
	/* This is cheating!!!! */
	
	tweak = alloc_tweak(TYPE_NODE_ONLY);
	
	tweak->WidgetText=receive_string(fd);
	tweak->Description=receive_string(fd);
	tweak->ConfigName=receive_string(fd);
	tweak->Type=receive_int(fd);
	tweak->MinValue=receive_int(fd);
	tweak->MaxValue=receive_int(fd);
	
	return tweak;
}
