/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.info.VariableUsageMarker;

public class VariableCleaner
extends SimplifiedVisitor
implements AttributeVisitor {
    private final VariableUsageMarker variableUsageMarker = new VariableUsageMarker();

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.variableUsageMarker.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.u2localVariableTableLength = this.removeEmptyLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeEmptyLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
    }

    private int removeEmptyLocalVariables(LocalVariableInfo[] localVariableInfoArray, int n, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n && n3 < n2; ++n3) {
            if (!this.variableUsageMarker.isVariableUsed(n3)) continue;
            localVariableInfoArray[n4++] = localVariableInfoArray[n3];
        }
        for (n3 = n4; n3 < n; ++n3) {
            localVariableInfoArray[n3] = null;
        }
        return n4;
    }

    private int removeEmptyLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfoArray, int n, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n && n3 < n2; ++n3) {
            if (!this.variableUsageMarker.isVariableUsed(n3)) continue;
            localVariableTypeInfoArray[n4++] = localVariableTypeInfoArray[n3];
        }
        for (n3 = n4; n3 < n; ++n3) {
            localVariableTypeInfoArray[n3] = null;
        }
        return n4;
    }
}

