/*
    Document.h

    Interface declaration of the Document class for the KeyArcher
    application.

    Copyright (C) 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _DOCUMENT_H_
#define _DOCUMENT_H_

#import <AppKit/NSDocument.h>

@class NSData,
       NSString;

@class NSBrowser,
       NSMatrix,
       NSTableView,
       NSTableColumn;

@class ObjectGraph;

@interface Document : NSDocument
{
  ObjectGraph * graph;

  NSBrowser * browser;
  NSTableView * attributesTable,
              * classTable;
}

- (BOOL) loadDataRepresentation: (NSData *) data ofType: (NSString *) aType;
- (NSData *) dataRepresentationOfType: (NSString *) aType;

- (NSString *) windowNibName;

- (void) browser: (NSBrowser *)sender createRowsForColumn: (int)column
  inMatrix: (NSMatrix *)matrix;

- (void) refreshObjectDisplay: sender;

@end

#endif // _DOCUMENT_H_
