/***************************************************************************
                          jobbase.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef JOBBASE_H
#define JOBBASE_H

#include "prokyon.h"

#include <qthread.h>
#include <qdir.h>

class JobBase: public QThread  {
public:
	JobBase() {}
	~JobBase() {}	
	
	virtual int type() = 0;

protected:
	virtual void run() = 0;

	QList<TRACK> *getFileList(QDir *directory, bool append, QList<TRACK> *files=0);
	QList<TRACK> *readTags(QList<TRACK> *files, bool lazyRead=false);
	QList<TRACK> *readTagsOnly(QList<TRACK> *files);
	QList<TRACK> *writeTags(QList<TRACK> *files);

};

#endif
