/***************************************************************************
                          lvi_track.cpp  -  description
                             -------------------
    begin                : Wed May 23 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lvi_track.h"
#include "tagger.h"
#include "gui.h"
#include "pixmapcache.h"

//#include <sstream>

//using namespace std;

// ##################################################
// # constructor
// ##################################################
LVI_Track::LVI_Track(QListView *parent, TRACK *_track)
	: QListViewItem(parent), track(_track)
{
  QString s;
  
  setText(gui->getListing()->getColumnArtist(), track->artist);
  setText(gui->getListing()->getColumnTitle(), track->title);
  setText(gui->getListing()->getColumnLength(), s.sprintf("%d:%02d ", track->length/60, track->length%60));
  if(track->bitrate < 0) setText(gui->getListing()->getColumnBitrate(), s.sprintf("%d ", -track->bitrate));
  else setText(gui->getListing()->getColumnBitrate(), s.sprintf("%d ", track->bitrate)); 
  if(track->tracknumber == 0) setText(gui->getListing()->getColumnAlbum(), track->album);
  else if(track->album.isEmpty()) setText(gui->getListing()->getColumnAlbum(), s.sprintf("[%02d]", track->tracknumber));
  else {
    QString s( "[%1]" );
    setText(gui->getListing()->getColumnAlbum(), track->album + s.arg( track->tracknumber, 2 ).replace(' ','0') );
  }
  setText(gui->getListing()->getColumnComment(), track->comment);
  setText(gui->getListing()->getColumnYear(), track->year);
  setText(gui->getListing()->getColumnGenre(), Tagger::getGenre(track->genre));
  setText(gui->getListing()->getColumnPath(), track->path);
  setText(gui->getListing()->getColumnFilename(), track->filename);
  setText(gui->getListing()->getColumnNotes(), track->notes);
  setText(gui->getListing()->getColumnRating(), s.sprintf("%d ", track->rating));
  
  setPixmap(gui->getListing()->getColumnRating(), pixmapcache->get(QString::number(track->rating) + "star.png"));
  
  myfilename = track->filename;
  mygenre = track->genre;
  myalbum = track->album;
  mytracknumber = track->tracknumber;
  isShowed = true;
  isAvailable = true;
  setDragEnabled(true);
}

void LVI_Track::adjustIcon()
{
  switch(myType) {
  case MEDIUM_HARDDISK:
    setPixmap(0, pixmapcache->get("lvi_hdd.png")); break;
  case MEDIUM_CDROM:
    if(!isAvailable) setPixmap(0, pixmapcache->getFaded("lvi_cdrom.png"));
    else setPixmap(0, pixmapcache->get("lvi_cdrom.png"));
    break;
  case MEDIUM_SMB:
    if(!isAvailable) setPixmap(0, pixmapcache->getFaded("lvi_smb.png"));
    else setPixmap(0, pixmapcache->get("lvi_smb.png"));
    break;
  case MEDIUM_NFS:
    if(!isAvailable) setPixmap(0, pixmapcache->getFaded("lvi_nfs.png"));
    else setPixmap(0, pixmapcache->get("lvi_nfs.png"));
    break;
  }
}

void LVI_Track::applyMedium(int type, QString label) {
  myType = type;
  setText(gui->getListing()->getColumnMedium(), label);
  adjustIcon();
}

void LVI_Track::applyPath(QString path) {
  mypath = path;
}

void LVI_Track::setIsShowed(bool _isShowed)
{
  isShowed = _isShowed;

  if(isShowed) {
    if(myType == MEDIUM_CDROM) {
      if(!isAvailable) setText(gui->getListing()->getColumnPath(), QString("[" + text(1) + "]" + track->path));
      else setText(gui->getListing()->getColumnPath(), mypath + track->path);
    } else if(myType == MEDIUM_SMB || myType == MEDIUM_NFS) {
      if(!isAvailable) setText(gui->getListing()->getColumnPath(), QString("[" + text(1) + "]" + track->path));
      else setText(gui->getListing()->getColumnPath(), mypath + track->path);
    }
    setText(gui->getListing()->getColumnFilename(), myfilename);
    adjustIcon();
  }
}

void LVI_Track::setAvailability(bool state) {
  isAvailable = state;
  if(isShowed) setIsShowed(true);
    setDragEnabled(isAvailable);
}

void LVI_Track::setNewFilename(QString fname) {
  myfilename = fname;
  track->filename = fname;
  if(isShowed) setText(gui->getListing()->getColumnFilename(), fname);
}

// ##################################################
// # set informations for this track
// ##################################################
void LVI_Track::setFilename(QString filename) {
  setText(gui->getListing()->getColumnFilename(), filename);
  if(filename != track->filename) setPixmap(gui->getListing()->getColumnFilename(), pixmapcache->get("lvi_changed.png")); else setPixmap(gui->getListing()->getColumnFilename(), 0);
  myfilename = filename;
}

void LVI_Track::setArtist(QString artist) {
  setText(gui->getListing()->getColumnArtist(), artist.stripWhiteSpace());
  if(artist != track->artist) setPixmap(gui->getListing()->getColumnArtist(), pixmapcache->get("lvi_changed.png")); else setPixmap(gui->getListing()->getColumnArtist(), 0);
}

void LVI_Track::setTitle(QString title) {
  setText(gui->getListing()->getColumnTitle(), title);
  if(title != track->title) setPixmap(gui->getListing()->getColumnTitle(), pixmapcache->get("lvi_changed.png")); else setPixmap(gui->getListing()->getColumnTitle(), 0);
}

void LVI_Track::setAlbum(QString album) {
  QString s;
  if(mytracknumber == 0) setText(gui->getListing()->getColumnAlbum(), album);
  else {
    QString s( "[%1]" );
    setText(gui->getListing()->getColumnAlbum(), album + s.arg( mytracknumber, 2 ).replace(' ','0') );
  }
  if(album != track->album || mytracknumber != track->tracknumber) setPixmap(gui->getListing()->getColumnAlbum(), pixmapcache->get("lvi_changed.png")); else setPixmap(gui->getListing()->getColumnAlbum(), 0);
  myalbum = album;
}

void LVI_Track::setTracknumber(int tracknumber) {
  QString s;
  if(tracknumber == 0) setText(gui->getListing()->getColumnAlbum(), myalbum);
  else {
    QString s("[%1]");
    setText(gui->getListing()->getColumnAlbum(), myalbum + s.arg( tracknumber, 2 ).replace(' ','0'));
  }
  if(myalbum != track->album || tracknumber != track->tracknumber) setPixmap(gui->getListing()->getColumnAlbum(), pixmapcache->get("lvi_changed.png")); else setPixmap(gui->getListing()->getColumnAlbum(), 0);
  mytracknumber = tracknumber;
}

void LVI_Track::setYear(QString year) {
  setText(gui->getListing()->getColumnYear(), year);
  if(year != track->year) setPixmap(gui->getListing()->getColumnYear(), pixmapcache->get("lvi_changed.png")); else setPixmap(gui->getListing()->getColumnYear(), 0);
}

void LVI_Track::setComment(QString comment) {
  setText(gui->getListing()->getColumnComment(), comment);
  if(comment != track->comment) setPixmap(gui->getListing()->getColumnComment(), pixmapcache->get("lvi_changed.png")); else setPixmap(gui->getListing()->getColumnComment(), 0);
}

void LVI_Track::setGenre(int genre) {
  setText(gui->getListing()->getColumnGenre(), Tagger::getGenre(genre));
  if(genre != track->genre) setPixmap(gui->getListing()->getColumnGenre(), pixmapcache->get("lvi_changed.png")); else setPixmap(gui->getListing()->getColumnGenre(), 0);
  mygenre = genre;
}

void LVI_Track::setNotes(QString notes) {
  setText(gui->getListing()->getColumnNotes(), notes);
  if(notes != track->notes) setPixmap(gui->getListing()->getColumnNotes(), pixmapcache->get("lvi_changed.png")); else setPixmap(gui->getListing()->getColumnNotes(), 0);
}

void LVI_Track::setRating(int rating) {
  QString s;
  setText(gui->getListing()->getColumnRating(), s.sprintf("%d", rating));
  if(rating != track->rating) setPixmap(gui->getListing()->getColumnRating(), pixmapcache->get("lvi_changed.png"));
  else setPixmap(gui->getListing()->getColumnRating(), pixmapcache->get(QString::number(rating) + "star.png"));
}

// ##################################################
// # return informations for this track
// ##################################################
QString LVI_Track::getFilename() { return myfilename; }
QString LVI_Track::getArtist()   { return text(gui->getListing()->getColumnArtist()); }
QString LVI_Track::getTitle()    { return text(gui->getListing()->getColumnTitle()); }
QString LVI_Track::getAlbum()    { return myalbum; }
int     LVI_Track::getTracknumber() { return mytracknumber; }
QString LVI_Track::getYear()     { return text(gui->getListing()->getColumnYear()); }
int     LVI_Track::getGenre()    { return mygenre; }
QString LVI_Track::getComment()  { return text(gui->getListing()->getColumnComment()); }
QString LVI_Track::getPath()     { return text(gui->getListing()->getColumnPath()); }
QString LVI_Track::getNotes()    { return text(gui->getListing()->getColumnNotes()); }
int     LVI_Track::getRating()   { return text(gui->getListing()->getColumnRating()).toInt(); }

// ##################################################
// # has some infos changed?
// ##################################################
bool LVI_Track::hasFilenameChanged() { return track->filename != myfilename; }
bool LVI_Track::hasArtistChanged()   { return track->artist != text(gui->getListing()->getColumnArtist()); }
bool LVI_Track::hasTitleChanged()    { return track->title != text(gui->getListing()->getColumnTitle()); }
bool LVI_Track::hasAlbumChanged()    { return track->album != myalbum; }
bool LVI_Track::hasTracknumberChanged() { return track->tracknumber != mytracknumber; }
bool LVI_Track::hasYearChanged()     { return track->year != text(gui->getListing()->getColumnYear()); }
bool LVI_Track::hasGenreChanged()    { return track->genre != mygenre; }
bool LVI_Track::hasCommentChanged()  { return track->comment != text(gui->getListing()->getColumnComment()); }
bool LVI_Track::hasNotesChanged()    { return track->notes != text(gui->getListing()->getColumnNotes()); }
bool LVI_Track::hasRatingChanged()   { return track->rating != text(gui->getListing()->getColumnRating()).toInt(); }

// ##################################################
// # apply the changes
// ##################################################
void LVI_Track::applyChanges()
{
  track->artist   = text(gui->getListing()->getColumnArtist());
  track->filename = myfilename;
  track->title    = text(gui->getListing()->getColumnTitle());
  track->album    = myalbum;
  track->tracknumber = mytracknumber;
  track->year     = text(gui->getListing()->getColumnYear());
  track->comment  = text(gui->getListing()->getColumnComment());
  track->genre    = mygenre;
  track->notes    = text(gui->getListing()->getColumnNotes());
  track->rating   = text(gui->getListing()->getColumnRating()).toInt();

  setPixmap(gui->getListing()->getColumnTitle(), 0);
  setPixmap(gui->getListing()->getColumnGenre(), 0);
  setPixmap(gui->getListing()->getColumnArtist(), 0);
  setPixmap(gui->getListing()->getColumnFilename(), 0);
  setPixmap(gui->getListing()->getColumnAlbum(), 0);
  setPixmap(gui->getListing()->getColumnYear(), 0);
  setPixmap(gui->getListing()->getColumnComment(), 0);
  setPixmap(gui->getListing()->getColumnNotes(), 0);
  setPixmap(gui->getListing()->getColumnRating(), pixmapcache->get(QString::number(track->rating) + "star.png"));
}

// ##################################################
// if a backgroudpixmap is present, then text is written twice
// shifted by PIXEL_SHIFT pixels and  using inverted pen color.
// This  ensure good text visibility in all cases.
// ##################################################

void LVI_Track::paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int align)
{
  QListViewItem::paintCell(p,cg,column,width,align);   // call ancestor paintcell first
  /************** uncomment to enable double text painting***************
   QListView *lv = listView();
   if ( !pixmap(column) && lv->paletteBackgroundPixmap()) {    // pixmap() != 0 :  not covered here.... 
     if ( !isSelected() ||
 	 !(column == 0 || listView()->allColumnsShowFocus()) ) {
       if ( isEnabled() || !lv )
 	p->setPen( cg.text() );
       else if ( !isEnabled() && lv)
 	p->setPen( lv->palette().disabled().text() );
       int r = lv->itemMargin();
       //p->drawText( r, 0, width-2*r, height(), align, text( column )  );
       p->setPen( QColor( ~p->pen().color().rgb() ));  // invert pen
       p->drawText( r+PIXEL_SHIFT, 0, width-2*r, height(), align, text( column )  );
     }
   }
  ******************************/
}


// #################################################
// Treat numerical columns as numbers when sorting.
// Currently that's only the bitrate and the track length...
// #################################################
int LVI_Track::compare( QListViewItem *i, int col, bool ascending ) const
{
  LVI_Track *otherItem = dynamic_cast<LVI_Track *>(i);

  int ret = 0;
  if ( col == gui->getListing()->getColumnBitrate() ) 
  {
    // no string comparison for bitrate
    // compare the absolute numeric value
    int thisBitrate = getBitrate();
    if (thisBitrate < 0) thisBitrate = - thisBitrate;
    int thatBitrate = otherItem->getBitrate();
    if (thatBitrate < 0) thatBitrate = - thatBitrate;
    ret = thisBitrate - thatBitrate;
  } else if ( col == gui->getListing()->getColumnLength() ) {
    // compare length in seconds, not the string representation mm:ss
    ret = getLength() - otherItem->getLength();
  } else {
    // use default implementation
    ret = QListViewItem::compare(i, col, ascending);
  }

  return ret;
}


// ##################################################
// # destructor
// ##################################################
LVI_Track::~LVI_Track() {
  delete track;
}
