/***************************************************************************
                          lvi_smbshare.h  -  description
                             -------------------
    begin                : Sun Jun 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LVI_SMBSHARE_H
#define LVI_SMBSHARE_H

#include "prokyon.h"

#include <qlistview.h>

class LVI_SMBShare : public QListViewItem  {
public:
    LVI_SMBShare(QListView *parent, int _shareID, QString _path, QString _share);

    void lock(QString comment)
        ;
    void unlock();

    void applyMount();
    void applyUnmount();

    void applyInfo(int);

    int getShareID() {
        return shareID;
    }

    int getMediumID() {
        return medium;
    }

    bool getIsLocked() {
        return isLocked;
    }
    bool getIsMounted() {
        return isMounted;
    }
    bool getIsKnown() {
        return medium != -1;
    }

    QString getPath() {
        return path;
    }
    QString getDevice() {
        return device;
    }
    QString getLabel() {
        return label;
    }

private:
    int shareID;

    int medium;

    QString path;
    QString share;
    QString device;
    QString label;

    bool isLocked;
    bool isMounted;
    bool isKnown;
};

#endif
