#include "musicbrainzclient.h"
#include <qfileinfo.h>

#if HAVE_LIBMUSICBRAINZ

#include "gui.h"
#include "qmbfile.h"
#if HAVE_LIBMAD
#include "qmbmp3file.h"
#endif
#if HAVE_OGG
#include "qmbvorbisfile.h"
#endif
#if HAVE_FLAC
#include "qmbflacfile.h"
#endif

// *** constructor ***
MusicBrainzClient::MusicBrainzClient() {
    mB = new MusicBrainz();
    //set the default server info
    mB->SetServer(config->getMusicBrainzServer().ascii(), config->getMusicBrainzPort());
    //set it to not use UTF8
    mB->UseUTF8(false);
}

QValueVector<QMBMetadata> MusicBrainzClient::queryServer(const QString path, TRACK *track) {
    QValueVector<QMBMetadata> vec;
    QMBFile *file;
    QString ext = QFileInfo(path).extension(false).upper();
    #if HAVE_OGG

    if (ext == "OGG") {
        file = new QMBVorbisFile();
    } else
        #endif
        #if HAVE_LIBMAD
        if (ext == "MP3") {
            file = new QMBMP3File();
        } else
            #endif
            #if HAVE_FLAC
            if (ext == "FLAC") {
                file = new QMBFLACFile();
            } else
                #endif
                {
                    // TRANSLATORS: %1 = filename
                    MessageEvent* e = new MessageEvent(QString(_("The format of '%1' is not supported in your version of prokyon3")).arg( path ));
                    QApplication::sendEvent( gui, e );
                    delete e;
                    return vec;
                }

                file->setMetadata(track);
    if(verbose == 10) {
        qWarning("\ncreated qmbfile:");
        file->metadata.debugDump();
    }

    file->Extract(path);

    trm_t trm = trm_New();
    int idCreationResult = file->CreateID(trm);
    trm_Delete(trm);

    if(verbose == 10) {
        qWarning("\ntrm id creation result:");
        file->metadata.debugDump();
    }

    if (idCreationResult < 0) {
        // TRANSLATORS: %1 = filename
        MessageEvent* e = new MessageEvent( QString(_("The trmID creation for '%1' failed")).arg(path) );
        QApplication::sendEvent( gui, e );
        delete e;
        return vec;
    }

    int numtracks = file->QueryServer(mB);
    if (numtracks < 1) {
        // TRANSLATORS: %1 = filename
        MessageEvent* e = new MessageEvent(QString(_("The server returned no results for '%1'")).arg(path));
        QApplication::sendEvent( gui, e );
        delete e;
        return vec;
    }

    for(int i = 0; i < numtracks; ++i) {
        vec.append(file->queryresults[i]);
    }

    delete file;
    return vec;
}

#endif /* HAVE_LIBMUSICBRAINZ */
