/****************************************************************************
** busywidget.h - cool animating widget
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef BUSYWIDGET_H
#define BUSYWIDGET_H

#include<qwidget.h>
#include<qpixmap.h>
#include<qtimer.h>

class BusyWidget : public QWidget
{
	Q_OBJECT
public:
	BusyWidget(QWidget *parent=0, const char *name=0);

	void start();
	void stop();
	bool isActive() { return v_isActive; }

protected:
	void paintEvent(QPaintEvent *);
	void resizeEvent(QResizeEvent *);

private:
	bool v_isActive;
	int frame;
	int at;
	QPixmap pix;
	QTimer *t;

	void render();
	void renderPixmap();

private slots:
	void animate();
};

#endif
