/****************************************************************************
** idle.h - simple class to determine if you are idle
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef IDLE_H
#define IDLE_H

#include<qobject.h>
#include<qdatetime.h>
#include<qtimer.h>


class Idle : public QObject
{
	Q_OBJECT
public:
	Idle();
	~Idle();

	bool isActive() { return v_isActive; }
	static bool isSupported();
	void start();
	void stop();

signals:
	void secondsIdle(int);

private slots:
	void doCheck();

private:
	bool v_isActive;
	int idleTime;
	QDateTime startTime;
	QTimer checkTimer;
	bool available;

	void *d;
};

#endif
