/****************************************************************************
** infodlg.cpp - show contact info
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"infodlg.h"
#include<qlayout.h>
#include<qtabwidget.h>
#include<qpushbutton.h>
#include<qlineedit.h>
#include<qmessagebox.h>


InfoDlg::InfoDlg(int _type, const QString &jid, const VCard &_vcard, int _localStatus, QWidget *parent, const char *name)
:InfoUI(parent, name, FALSE, WDestructiveClose), UniqueWindow(TRUE, "InfoDlg", this, cleanJid(jid))
{
	v_jid = jid;
	vcard = _vcard;

	isBusy = FALSE;

	QWidget *w = new QWidget(this);
	busy = new BusyWidget(w);
	QHBoxLayout *hb1 = new QHBoxLayout(w);
	hb1->addStretch(1);
	hb1->addWidget(busy);

	int n = InfoDialog1Layout->findWidget(tabwidget);
	InfoDialog1Layout->insertWidget(n+1, w);

	setCaption(v_jid);
	setIcon(*pix_info);

	if(_localStatus == STATUS_OFFLINE) {
		pb_refresh->setEnabled(FALSE);
		pb_submit->setEnabled(FALSE);
	}

	connect(pb_refresh, SIGNAL(clicked()), this, SLOT(doRefresh()));
	connect(te_desc, SIGNAL(textChanged()), this, SLOT(textChanged()));

	type = _type;
	if(type == INFODLG_USER) {
		connect(pb_submit, SIGNAL(clicked()), this, SLOT(doSubmit()));
	}
	else {
		pb_submit->hide();
		setReadOnly(TRUE);
	}

	setData(vcard);
}

void InfoDlg::closeEvent(QCloseEvent *e)
{
	// don't close if submitting
	if(isBusy && actionType == 1) {
		e->ignore();
		return;
	}

	if(type == INFODLG_USER && edited()) {
		bool x = QMessageBox::information(this, tr("Warning"), tr("You have not published your account information changes.\nAre you sure you want to discard them?"), tr("Close and discard"), tr("Don't close"));
		if(x != 0) {
			e->ignore();
			return;
		}
	}

	// cancel active transaction (refresh only)
	if(isBusy && actionType == 0) {
		signalCancelTransaction(id);
	}

	e->accept();
}

void InfoDlg::localUpdate(const JabRosterEntry &e)
{
	int localStatus = e.localStatus();

	// if the user goes offline then cancel the request
	if(localStatus == STATUS_OFFLINE) {
		if(isBusy) {
			busy->stop();
			isBusy = FALSE;

//			if(actionType == 1)
//				QMessageBox::critical(this, tr("Error"), QString(tr("Disconnected")));
		}
		pb_refresh->setEnabled(FALSE);
		pb_submit->setEnabled(FALSE);
		fieldsEnable(TRUE);
	}
	else {
		if(!isBusy) {
			pb_refresh->setEnabled(TRUE);
			pb_submit->setEnabled(TRUE);
		}
	}

	pb_close->setEnabled(TRUE);
}

void InfoDlg::updateVCard(const VCard &_vcard)
{
	vcard = _vcard;
	setData(vcard);

	if(isBusy) {
		busy->stop();
		isBusy = FALSE;
		pb_refresh->setEnabled(TRUE);
		pb_submit->setEnabled(TRUE);
		pb_close->setEnabled(TRUE);
		fieldsEnable(TRUE);
	}
}

void InfoDlg::error()
{
	if(isBusy) {
		busy->stop();
		isBusy = FALSE;
		if(type == INFODLG_USER)
			QMessageBox::critical(this, tr("Error"), QString(tr("Unable to retrieve your account information.  Perhaps you haven't entered any yet.")));
		else
			QMessageBox::critical(this, tr("Error"), QString(tr("Unable to retrieve information about this contact.")));
		pb_refresh->setEnabled(TRUE);
		pb_submit->setEnabled(TRUE);
		pb_close->setEnabled(TRUE);
		fieldsEnable(TRUE);
	}
}

void InfoDlg::result(bool x)
{
	if(!isBusy)
		return;

	busy->stop();
	isBusy = FALSE;

	if(x) {
		QMessageBox::information(this, tr("Success"), QString(tr("Your account information has been published.")));
		vcard = submit_vcard;
		setData(submit_vcard);
	}
	else {
		QMessageBox::critical(this, tr("Error"), QString(tr("Unable to publish your account information.")));
	}

	pb_refresh->setEnabled(TRUE);
	pb_submit->setEnabled(TRUE);
	pb_close->setEnabled(TRUE);
	fieldsEnable(TRUE);
}

void InfoDlg::setData(const VCard &i)
{
	le_fullname->setText(i.field[vFullname]);
	le_nickname->setText(i.field[vNickname]);
	le_bday->setText(i.field[vBday]);
	le_email->setText(i.field[vEmail]);
	le_homepage->setText(i.field[vHomepage]);
	le_phone->setText(i.field[vPhone]);
	le_street->setText(i.field[vStreet]);
	le_ext->setText(i.field[vExt]);
	le_city->setText(i.field[vCity]);
	le_state->setText(i.field[vState]);
	le_pcode->setText(i.field[vPcode]);
	le_country->setText(i.field[vCountry]);
	le_orgName->setText(i.field[vOrgName]);
	le_orgUnit->setText(i.field[vOrgUnit]);
	le_title->setText(i.field[vTitle]);
	le_role->setText(i.field[vRole]);
	te_desc->setText(i.field[vDesc]);

	setEdited(FALSE);
}

void InfoDlg::fieldsEnable(bool x)
{
	le_fullname->setEnabled(x);
	le_nickname->setEnabled(x);
	le_bday->setEnabled(x);
	le_email->setEnabled(x);
	le_homepage->setEnabled(x);
	le_phone->setEnabled(x);

	le_street->setEnabled(x);
	le_ext->setEnabled(x);
	le_city->setEnabled(x);
	le_state->setEnabled(x);
	le_pcode->setEnabled(x);
	le_country->setEnabled(x);

	le_orgName->setEnabled(x);
	le_orgUnit->setEnabled(x);
	le_title->setEnabled(x);
	le_role->setEnabled(x);
	te_desc->setEnabled(x);

	setEdited(FALSE);
}

void InfoDlg::setEdited(bool x)
{
	le_fullname->setEdited(x);
	le_nickname->setEdited(x);
	le_bday->setEdited(x);
	le_email->setEdited(x);
	le_homepage->setEdited(x);
	le_phone->setEdited(x);
	le_street->setEdited(x);
	le_ext->setEdited(x);
	le_city->setEdited(x);
	le_state->setEdited(x);
	le_pcode->setEdited(x);
	le_country->setEdited(x);
	le_orgName->setEdited(x);
	le_orgUnit->setEdited(x);
	le_title->setEdited(x);
	le_role->setEdited(x);

	te_edited = x;
}

bool InfoDlg::edited()
{
	bool x = FALSE;

	if(le_fullname->edited()) x = TRUE;
	if(le_nickname->edited()) x = TRUE;
	if(le_bday->edited()) x = TRUE;
	if(le_email->edited()) x = TRUE;
	if(le_homepage->edited()) x = TRUE;
	if(le_phone->edited()) x = TRUE;
	if(le_street->edited()) x = TRUE;
	if(le_ext->edited()) x = TRUE;
	if(le_city->edited()) x = TRUE;
	if(le_state->edited()) x = TRUE;
	if(le_pcode->edited()) x = TRUE;
	if(le_country->edited()) x = TRUE;
	if(le_orgName->edited()) x = TRUE;
	if(le_orgUnit->edited()) x = TRUE;
	if(le_title->edited()) x = TRUE;
	if(le_role->edited()) x = TRUE;
	if(te_edited) x = TRUE;

	return x;
}

void InfoDlg::setReadOnly(bool x)
{
	le_fullname->setReadOnly(x);
	le_nickname->setReadOnly(x);
	le_bday->setReadOnly(x);
	le_email->setReadOnly(x);
	le_homepage->setReadOnly(x);
	le_phone->setReadOnly(x);
	le_street->setReadOnly(x);
	le_ext->setReadOnly(x);
	le_city->setReadOnly(x);
	le_state->setReadOnly(x);
	le_pcode->setReadOnly(x);
	le_country->setReadOnly(x);
	le_orgName->setReadOnly(x);
	le_orgUnit->setReadOnly(x);
	le_title->setReadOnly(x);
	le_role->setReadOnly(x);
	te_desc->setReadOnly(x);
}

void InfoDlg::doRefresh()
{
	if(!pb_refresh->isEnabled())
		return;
	if(isBusy)
		return;

	pb_submit->setEnabled(FALSE);
	pb_refresh->setEnabled(FALSE);
	fieldsEnable(FALSE);

	signalGetVCard(v_jid, &id);
	isBusy = TRUE;
	actionType = 0;
	busy->start();
}

void InfoDlg::doSubmit()
{
	if(!pb_submit->isEnabled())
		return;
	if(isBusy)
		return;

	pb_submit->setEnabled(FALSE);
	pb_refresh->setEnabled(FALSE);
	pb_close->setEnabled(FALSE);

	makeVCard();

	fieldsEnable(FALSE);
	signalSetVCard(submit_vcard, &id);
	isBusy = TRUE;
	actionType = 1;
	busy->start();
}

void InfoDlg::makeVCard()
{
	VCard *v = &submit_vcard;

	v->field[vFullname] = le_fullname->text();
	v->field[vNickname] = le_nickname->text();
	v->field[vBday] = le_bday->text();
	v->field[vEmail] = le_email->text();
	v->field[vHomepage] = le_homepage->text();
	v->field[vPhone] = le_phone->text();

	v->field[vStreet] = le_street->text();
	v->field[vExt] = le_ext->text();
	v->field[vCity] = le_city->text();
	v->field[vState] = le_state->text();
	v->field[vPcode] = le_pcode->text();
	v->field[vCountry] = le_country->text();

	v->field[vOrgName] = le_orgName->text();
	v->field[vOrgUnit] = le_orgUnit->text();
	v->field[vTitle] = le_title->text();
	v->field[vRole] = le_role->text();
	v->field[vDesc] = te_desc->text();
}

void InfoDlg::textChanged()
{
	te_edited = TRUE;
}


/*static*/ InfoDlg * InfoDlg::find(const QString &xjid)
{
        return (InfoDlg *)UniqueWindowBank::find("InfoDlg", cleanJid(xjid));
}
