/****************************************************************************
** infodlg.h - show contact info
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef INFODLG_H
#define INFODLG_H

#include<qwidget.h>
#include<qpixmap.h>
#include<qlabel.h>
#include"ui_info.h"
#include"userlist.h"
#include"jabber.h"
#include"uniquewindow.h"
#include"busywidget.h"

#define INFODLG_USER	0
#define INFODLG_CONTACT	1


class InfoDlg : public InfoUI, public UniqueWindow
{
	Q_OBJECT
public:
	InfoDlg(int type, const QString &, const VCard &, int localStatus, QWidget *parent=0, const char *name=0);

	static InfoDlg *find(const QString &);

protected:
	// reimplemented
	void closeEvent(QCloseEvent *);

signals:
	void signalGetVCard(const QString &, QString *);
	void signalCancelTransaction(const QString &);
	void signalSetVCard(const VCard &, QString *);

public slots:
	void doRefresh();
	void localUpdate(const JabRosterEntry &);
	void updateVCard(const VCard &);
	void result(bool);
	void error();

private slots:
	void doSubmit();
	void textChanged();

private:
	BusyWidget *busy;
	VCard vcard, submit_vcard;
	QString v_jid;
	int type;

	QString id;
	bool isBusy;
	int actionType;

	void setData(const VCard &);
	void makeVCard();
	void fieldsEnable(bool);
	void setReadOnly(bool);
	bool edited();
	void setEdited(bool);

	bool te_edited;
};

#endif

