/****************************************************************************
** optionsdlg.h - the preferences dialog
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef OPTIONSDLG_H
#define OPTIONSDLG_H

#include"ui_options.h"

#include<qbuttongroup.h>
#include<qpushbutton.h>
#include<qcolor.h>
#include<qstringlist.h>
#include<qradiobutton.h>
#include"common.h"

class OptionsDlg : public OptionsUI
{
	Q_OBJECT
public:
	OptionsDlg(const Options &, QWidget *parent=0, const char *name=0);
	~OptionsDlg();

	static OptionsDlg *find();

signals:
	void applyOptions(const Options &);

private:
	void showColor(QPushButton *pb, QColor c);

	Options opt;

	QButtonGroup *bg_defAct, *bg_color, *bg_font, *bg_oe, *bg_delChats;
	QLineEdit *le_font[3], *le_oe[7];

	QStringList iconsets;
	bool dirty; // whether or not data changed
	bool noDirty; // flag to disable dirty checks

	void doApplyOptions();
	void accept();

private slots:
	void chooseFont(int);
	void chooseColor(int);
	void chooseOnEvent(int);
	void selectIconSet(int);
	void selectAlertStyle(int);
	void selectStatusPreset(int);
	void selectBrowser(int);
	void newStatusPreset();
	void changeStatusPreset();
	void removeStatusPreset();
	void soundReset();

	void apply();

	// reimplemented
	void dataChanged();
};

#endif

