/****************************************************************************
** uniquewindow.cpp - helps keep track of unique windows
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"uniquewindow.h"

static UniqueWindowBank UWB;

/****************************************************************************
  UniqueWindowBank
****************************************************************************/
UniqueWindowBank::UniqueWindowBank()
{
}

UniqueWindowBank::~UniqueWindowBank()
{
        for(UniqueWindowBankItem *i = list.first(); i;) {
                list.remove(i);
                delete i->dict;
                delete i;
                i = list.current();
        }
}

void UniqueWindowBank::add(const QString &type, void *p, const QString &key)
{
        // see if we already have the type
        UniqueWindowBankItem *i;
        for(i = list.first(); i; i = list.next()) {
                if(i->type == type)
                        break;
        }
        if(!i) {
                i = new UniqueWindowBankItem;
                i->type = type;
                i->dict = new QDict<void>(17,FALSE);
                list.insert(0, i);
        }

        i->dict->insert(key, p);

        //printf("Registering: type=%s, jid=%s, p=[%p]\n", type.latin1(), jid.latin1(), p);
}

void UniqueWindowBank::remove(const QString &type, const QString &key)
{
        // see if we already have the type
        UniqueWindowBankItem *i;
        for(i = list.first(); i; i = list.next()) {
                if(i->type == type)
                        break;
        }
        if(!i)
                return;

        i->dict->remove(key);

        // last entry?  remove it
        if(i->dict->count() == 0) {
                list.remove(i);
                delete i->dict;
                delete i;
        }

        //printf("UnRegistering: type=%s, jid=%s\n", type.latin1(), jid.latin1());
}

void * UniqueWindowBank::finditem(const QString &type, const QString &key)
{
        // find the bank item
        UniqueWindowBankItem *i;
        for(i = list.first(); i; i = list.next()) {
                if(i->type == type)
                        break;
        }
        if(!i) {
                //printf("finditem: no such type! [%s]\n", type.latin1());
                return 0;
        }

        void *p = i->dict->find(key);

        //printf("finditem: type=%s, jid=%s, found=[%p]\n", type.latin1(), jid.latin1(), p);

        return p;
}

/*static*/ void * UniqueWindowBank::find(const QString &type, const QString &key)
{
        return UWB.finditem(type, key);
}


/****************************************************************************
  UniqueWindow
****************************************************************************/
UniqueWindow::UniqueWindow(bool xisUnique, const QString &xtype, void *p, const QString &xkey)
{
        v_isUnique = xisUnique;

        if(v_isUnique) {
                v_key = xkey;
                v_type = xtype;

                UWB.add(v_type, p, v_key);
        }
}

UniqueWindow::~UniqueWindow()
{
        if(v_isUnique)
                UWB.remove(v_type, v_key);
}
