# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: htmlio.t,v 1.1 2000/11/23 23:36:17 muaddib Exp $

use strict;
use Test;
use AtomicData;
use AtomicData::List;
use HTMLIO::Types;
use Data::Dumper;

plan tests => 32;

my ($data,$list,%htmlio);

ok $data = AtomicData->new("hi there");
ok $list = AtomicData::List->new("AtomicData","hi there");

ok @HTMLIO_TYPES == 9;
for my $type (@HTMLIO_TYPES) {
  #print "# creating a HTMLIO::$type ..\n";
  ok $htmlio{$type} = eval "HTMLIO::$type->new()";
}

for my $type (@HTMLIO_TYPES) {
 #print "# calling $type->html_view ..\n";
 if ($type eq "Password") {
   ok $htmlio{$type}->html_view($data) eq 
     '********';
 } else {
   ok $htmlio{$type}->html_view($data) eq 
     'hi there';
 }
}

for my $type (@HTMLIO_TYPES) {
 #print "# calling $type->html_view ..\n";
 if ($type eq "Password") {
   ok $htmlio{$type}->html_view($list) eq 
     '********';
 } else {
   ok $htmlio{$type}->html_view($list) eq 
     'hi there';
 }
}

ok $htmlio{Text}->html_input("hi",$data) eq
  '<input name="hi" type="text" value="hi there">';

ok $htmlio{Text}->html_hidden("hi",$data) eq
  '<input name="hi" type="hidden" value="hi there">';

