/*
 * Pspell interface header file
 * Copyright 2000 by Kevin Atkinson under the terms of the LGPL
 *
 */

#ifndef PSPELL_STRING_EMULATION__H
#define PSPELL_STRING_EMULATION__H

#ifdef __cplusplus

  class PspellStringEmulation {
  public:
    virtual PspellStringEmulation * clone() const = 0;
    virtual void assign(const PspellStringEmulation *) = 0;
    virtual bool at_end() const = 0;
    virtual const char * next() = 0;
    virtual ~PspellStringEmulation() {}
  }; 

#else

  typedef struct PspellStringEmulation PspellStringEmulation;

#endif

#ifdef __cplusplus
extern "C" {
#endif

  PspellStringEmulation * 
    pspell_string_emulation_clone
      (const PspellStringEmulation *);

  void delete_pspell_string_emulation
      (PspellStringEmulation *);

  void pspell_string_emulation_assign
      (PspellStringEmulation *, 
       const PspellStringEmulation *);
  
  int pspell_string_emulation_at_end
      (const PspellStringEmulation *);

  const char * pspell_string_emulation_next
      (PspellStringEmulation *);


#ifdef __cplusplus
}
#endif

#endif
