// Pspell implementation header file.
// Applications that just use the pspell library should not include 
// these files as they are subject to change.
// Pspell Modules MUST include some of the implementation files and
// spell checkers MAY include some of these files.
// If ANY of the implementation files are included you also should
// link with libaspell-impl to protect you from changes in these
// files.

// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#ifndef PSPELL_STRING_LIST_IMPL__HH
#define PSPELL_STRING_LIST_IMPL__HH

#include "string.hh"
#include "string_list.h"

struct PspellStringListNode {
  PspellString           data;
  PspellStringListNode * next;
  PspellStringListNode(const char * str,  PspellStringListNode * n = 0)
    : data(str), next(n) {}
};

class PspellStringListEmulation : public PspellStringEmulation {
private:
  PspellStringListNode * n_;
public:
  PspellStringEmulation * clone() const;
  void assign(const PspellStringEmulation *);

  PspellStringListEmulation(PspellStringListNode * n) : n_(n) {}
  const char * next() {
    const char * temp;
    if (n_ == 0) {
      temp = 0;
    } else {
      temp = n_->data.c_str();
      n_ = n_->next;
    }
    return temp;
  }
  bool at_end() const {
    return n_ == 0;
  }
};


class PspellStringListImpl : public PspellStringList {
private:
  PspellStringListNode * first;

  PspellStringListNode * * find (const char * str);
 public:
  PspellStringListImpl() : first(0) {}
  PspellStringList * clone() const;
  void assign(const PspellStringList *);

  bool add(const char *); 
  bool remove(const char *);
  void clear();

  PspellStringEmulation * elements() const;
  PspellStringListEmulation elements_obj() const 
  {
    return PspellStringListEmulation(first);
  }

  bool empty() const { return first == 0; }

};



#endif
