###########################################################################
# kdeappview - description                                                #
# ------------------------------                                          #
# begin     : Fri Jun 27 2005                                             #
# copyright : (C) 2005 by AUTHOR                                          #
# email     : your@email.com                                              #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

from qt import *
from kdecore import *
from kdeui import *
from kio import *
from khtml import *
from kparts import *
#from kdeappiface import *

class KdeAppView(QWidget):
    def __init__(self,parent):
        QWidget.__init__(self,parent)
        #self._dcopclient= KdeAppIface(self,"KdeAppIface")

        # setup our layout manager to automatically add our widgets
        top_layout = QHBoxLayout(self)
        top_layout.setAutoAdd(True)
        
        if True:
            self._html = KHTMLPart(self)
        else:

            # we want to look for all components that satisfy our needs.  the
            # trader will actually search through *all* registered KDE
            # applications and components -- not just KParts.  So we have to
            # specify two things: a service type and a constraint
            #
            # the service type is like a mime type.  we say that we want all
            # applications and components that can handle HTML -- 'text/html'
            #
            # however, by itself, this will return such things as Netscape..
            # not what we wanted.  so we constrain it by saying that the
            # string 'KParts/ReadOnlyPart' must be found in the ServiceTypes
            # field.  with this, only components of the type we want will be
            # returned.
            offers = KTrader.self().query("text/html", "'KParts/ReadOnlyPart' in ServiceTypes")
            
            self._html = None
            # in theory, we only care about the first one.. but let's try all
            # offers just in case the first can't be loaded for some reason
            for ptr in offers:
                # we now know that our offer can handle HTML and is a part.
                # since it is a part, it must also have a library... let's try to
                # load that now
                self._html = createReadOnlyPart(ptr.library(),self,ptr.name(),"KParts::ReadOnlyPart",QStringList())
                if self._html is not None:
                    break
        
            # if our factory is invalid, then we never found our component
            # and we might as well just exit now
            if self._html is None:
                KMessageBox.error(self, i18n("Could not find a suitable HTML component"))
                return
    
        QObject.connect(self._html, SIGNAL("setWindowCaption(const QString&)"), self.slotSetTitle)
        QObject.connect(self._html, SIGNAL("setStatusBarText(const QString&)"), self.slotOnURL)

    def print_(self,p,height,width):
        pass
        # do the actual printing, here
        # p.drawText(etc..)

    def currentURL(self):
        return self._html.url().url()

    def openURL(self,url):
        if isinstance(url,QString):
            url = KURL(url)
        self._html.openURL(url)

    def slotOnURL(self,url):
        self.emit(PYSIGNAL("signalChangeStatusbar"),(url,) )

    def slotSetTitle(self,title):
        self.emit(PYSIGNAL("signalChangeCaption"),(title,) )
