#!/usr/bin/env python
# -*- coding: Latin-1 -*-
# Copyright  2001, 2002, 2003 Progiciels Bourbeau-Pinard inc.
# Franois Pinard <pinard@iro.umontreal.ca>, 2001.

"""\
Un fichier `allout', pour lequel existe un mode Emacs, permet de reprsenter
une organisation hirarchique de l'information contenue, avec la possibilit
d'un court libell au sommet de chaque hirarchie ou sous-hirarchie.  Le
fichier utilise des marques spciales pour marquer la structure, soit `*'
compltement  gauche d'une ligne pour marquer le dbut d'une hirarchie
englobante, soit `.'  gauche d'une ligne, suivi d'un nombre arbitraire de
blancs et de l'un des caractres `*+-@.:,;', pour marquer le dbut d'une
hirarchie plus imbrique, l'imbrication tant d'autant plus importante que
le caractre `*+-@.:,;' est plus  droite.  La marque doit tre le dernier
caractre sur sa ligne, ou encore, tre suivie d'au moins un caractre blanc
puis d'un libell associ  la hirarchie introduite par cette marque.
Toute ligne n'introduisant pas de marque est une ligne de texte associe 
l'lment hirarchique le plus rcemment introduit.

Ce programme ajoute quelques interprtations particulires  un fichier
`allout' tel que dfini dans Emacs.  Pour permettre  un fichier d'utiliser
plusieurs hirarchies successivement introduites par une marque `*', un
texte qui prcderait la premire marque `*' est considr comme
super-englobant, et la toute premire ligne non-blanche de ce texte prfixe
est alors le libell associ  cette hirarchie super-englobante.  Dans
toutes les hirarchies, sont limines les lignes blanches prfixes ou
suffixes, les imbrications superflues (pas de libell et un seul lment),
et une marge gauche commune  toutes les lignes de texte d'un mme niveau.

Report bugs or suggestions to Franois Pinard <pinard@iro.umontreal.ca>.
"""

import sys

def read(input=sys.stdin):
    # Lire INPUT, qui est soit un fichier dj ouvert, soit le nom d'un
    # fichier  lire, puis retourner un arbre reprsentant la structure
    # `allout' de ce fichier, ou None dans le cas d'un fichier vide.
    # L'arbre produit est une liste contenant rcursivement d'autres listes.
    # Chaque liste dbute par une chane donnant le libell d'un noeud, et
    # contient ensuite dans l'ordre une chane par ligne ordinaire dans ce
    # noeud ou une sous-liste pour un sous-noeud dans ce noeud.

    # LEVEL vaut 0 pour la hirarchie super-englobante, 1 pour la hirarchie
    # `*', 2 pour la hirarchie `..', etc.  STACK[LEVEL] contient la liste
    # des hirarchies tout--fait compltes au niveau LEVEL.  Si
    # STACK[LEVEL+1] existe, STACK[LEVEL] devra ncessairement recevoir un
    # nouvel lment au plus tard  la rencontre de la fin de fichier.

    def collapse():
        # Rapetisser (ou allonger) la pile STACK pour lui donner exactement
        # la longueur LEVEL, tout en dclarant que les structures empiles
        # au-del ont termin leur croissance: on peut donc immdiatement
        # imbriquer ces structures dans l'arbre en construction.
        while len(stack) < level:
            stack.append([''])
        while len(stack) > level:
            structure = stack.pop()
            while len(structure) > 1 and structure[-1] == '':
                del structure[-1]
            if len(structure) == 2 and structure[0] == '':
                structure = structure[1]
            else:
                margin = None
                for line in structure[1:]:
                    if isinstance(line, str) and line:
                        count = re.match(' *', line).end(0)
                        if margin is None or count < margin:
                            margin = count
                if margin is not None:
                    for counter in range(1, len(structure)):
                        line = structure[counter]
                        if isinstance(line, str) and line:
                            structure[counter] = line[margin:]
            stack[-1].append(structure)

    if isinstance(input, str):
        input = file(input)
    import re
    stack = []
    for line in input:
        match = re.match(r'(\*|\. *[-*+@.:,;])', line)
        if match:
            level = match.end(0)
            collapse()
            stack.append([line[level:].strip()])
        elif stack:
            line = line.rstrip()
            if line or len(stack[-1]) > 1:
                stack[-1].append(line)
        else:
            line = line.strip()
            if line:
                stack.append([line])
    level = 1
    collapse()
    if len(stack[0]) == 2 and stack[0][0] == '':
        stack[0] = stack[0][1]
    return stack[0]
