/* 
A* -------------------------------------------------------------------
B* This file contains source code for the PyMOL computer program
C* copyright 1998-2000 by Warren Lyford Delano of DeLano Scientific. 
D* -------------------------------------------------------------------
E* It is unlawful to modify or remove this copyright notice.
F* -------------------------------------------------------------------
G* Please see the accompanying LICENSE file for further information. 
H* -------------------------------------------------------------------
I* Additional authors of this source file include:
-* 
-* 
-*
Z* -------------------------------------------------------------------
*/

#include"os_predef.h"
#include"os_std.h"
#include"os_gl.h"

#include "main.h"
#include "Base.h"
#include "ButMode.h"
#include "Scene.h"
#include "Util.h"
#include "Grap.h"
#include "Ortho.h"
#include "Setting.h"
#include "P.h"

#define cButModeLineHeight 12
#define cButModeLeftMargin 2
#define cButModeTopMargin 1

CButMode ButMode;

void ButModeDraw(Block *block);
int ButModeClick(Block *block,int button,int x,int y,int mod);

/*========================================================================*/
Block *ButModeGetBlock(void)
{
  CButMode *I=&ButMode;
  {return(I->Block);}
}
/*========================================================================*/
void ButModeSet(int button,int action)
{
  CButMode *I=&ButMode;
  if((button>=0)&&(button<I->NBut)&&
     (action>=0)&&(action<I->NCode)) {
    I->Mode[button]=action;
    OrthoDirty();
  }
}
/*========================================================================*/
void ButModeCaption(char *text)
{
  CButMode *I=&ButMode;
  int l;
  l = strlen(I->Caption);
  if((l>0)&&(l<(sizeof(WordType)-1)))
    strcat(I->Caption,",");
  l = (sizeof(WordType)-2)-l;
  UtilNConcat(I->Caption,text,l);
}
/*========================================================================*/
void ButModeCaptionReset(void)
{
  CButMode *I=&ButMode;
  I->Caption[0]=0;
}
/*========================================================================*/
void ButModeSetRate(float interval)
{
  CButMode *I=&ButMode;

  if(interval<0.001)
    interval = 0.001F;
  
  if(interval>0.1F) {
    I->Samples*=0.5F/(5.0F*interval);
    I->Rate*=0.5F/(5.0F*interval);
  } else {
    I->Samples*=0.99F-interval;
    I->Rate*=0.99F-interval;
  }
  
  I->Samples++;

  if(interval>=0.001)
	 I->Rate += 1/interval;
  else
	 I->Rate += 99;
  
}
/*========================================================================*/
void ButModeResetRate(void)
{
  CButMode *I=&ButMode;
  I->Samples=0.0;
  I->Rate=0.0;
}
/*========================================================================*/
void ButModeFree(void)
{
  CButMode *I=&ButMode;
  OrthoFreeBlock(I->Block);
}
/*========================================================================*/
void ButModeInit(void)
{

  CButMode *I=&ButMode;
  int a;

  I->Rate=0.0;
  I->Samples = 0.0;

  I->Caption[0] = 0;

  I->NCode = cButModeCount;
  I->NBut = 19;

  for(a=0;a<I->NBut;a++) {
    I->Mode[a]=-1;
  }

  strcpy(I->Code[cButModeRotXYZ],  "Rota ");
  strcpy(I->Code[cButModeRotZ],    "RotZ ");  
  strcpy(I->Code[cButModeTransXY], "Move ");
  strcpy(I->Code[cButModeTransZ],  "MovZ ");
  strcpy(I->Code[cButModeClipNF],  "Clip ");
  strcpy(I->Code[cButModeClipN],   "ClpN ");  
  strcpy(I->Code[cButModeClipF],   "ClpF ");
  strcpy(I->Code[cButModePickAtom],"PkAt ");
  strcpy(I->Code[cButModePickBond],"PkBd ");
  strcpy(I->Code[cButModeTorFrag], "TorF ");
  strcpy(I->Code[cButModeRotFrag], "RotF ");
  strcpy(I->Code[cButModeMovFrag], "MovF ");
  strcpy(I->Code[cButModeLB],     " lb  ");
  strcpy(I->Code[cButModeMB],     " mb  ");
  strcpy(I->Code[cButModeRB],     " rb  ");
  strcpy(I->Code[cButModeAddToLB],"+lb  ");
  strcpy(I->Code[cButModeAddToMB],"+mb  ");
  strcpy(I->Code[cButModeAddToRB],"+rb  ");
  strcpy(I->Code[cButModeOrigAt],  "Orig ");
  strcpy(I->Code[cButModeRectAdd], "+lBx ");
  strcpy(I->Code[cButModeRectSub], "-lBx ");
  strcpy(I->Code[cButModeRect],    "lbBx ");
  strcpy(I->Code[cButModeNone],    "  -  ");
  strcpy(I->Code[cButModeCent],    "Cent ");
  strcpy(I->Code[cButModePkTorBnd], "PkTB ");
  strcpy(I->Code[cButModeScaleSlab], "Slab ");
  strcpy(I->Code[cButModeMoveSlab], "MovS ");
  strcpy(I->Code[cButModePickAtom1], "Pk1  ");
  strcpy(I->Code[cButModeMoveAtom], "MovA ");
  strcpy(I->Code[cButModeMenu], "Menu ");
  strcpy(I->Code[cButModeSeleSet], "Sele ");
  strcpy(I->Code[cButModeSeleToggle], "+/-  ");
  strcpy(I->Code[cButModeSeleAdd], "+Box ");
  strcpy(I->Code[cButModeSeleSub], "-Box ");  


  I->Block = OrthoNewBlock(NULL);
  I->Block->fClick = ButModeClick;
  I->Block->fDraw    = ButModeDraw;
  I->Block->fReshape = BlockReshape;
  I->Block->active = true;

  I->Block->TextColor[0]=0.2F;
  I->Block->TextColor[1]=1.0F;
  I->Block->TextColor[2]=0.2F;

  I->TextColor1[0]=0.5F;
  I->TextColor1[1]=0.5F;
  I->TextColor1[2]=1.0F;

  I->TextColor2[0]=0.8F;
  I->TextColor2[1]=0.8F;
  I->TextColor2[2]=0.8F;

  I->TextColor3[0]=1.0F;
  I->TextColor3[1]=0.5F;
  I->TextColor3[2]=0.5F;

  OrthoAttach(I->Block,cOrthoTool);
}


/*========================================================================*/
int ButModeTranslate(int button, int mod)
{
  int mode = 0;
  CButMode *I=&ButMode;
  switch(button) {
  case P_GLUT_LEFT_BUTTON:
    mode = 0;
    break;
  case P_GLUT_MIDDLE_BUTTON:
    mode = 1;
    break;
  case P_GLUT_RIGHT_BUTTON:
    mode = 2;
    break;
  case P_GLUT_BUTTON_SCROLL_FORWARD:
  case P_GLUT_BUTTON_SCROLL_BACKWARD:
    switch(mod) {
    case 0:
      mode = 12;
      break;
    case cOrthoSHIFT:
      mode = 13;
      break;
    case cOrthoCTRL:
      mode = 14;
      break;
    case (cOrthoCTRL+cOrthoSHIFT):
      mode = 15;
    }
    switch(I->Mode[mode]) {
    case cButModeScaleSlab:
      if(button==P_GLUT_BUTTON_SCROLL_FORWARD) {
        return cButModeScaleSlabExpand;
      } else {
        return cButModeScaleSlabShrink;
      }
      break;
    case cButModeMoveSlab:
      if(button==P_GLUT_BUTTON_SCROLL_FORWARD) {
        return cButModeMoveSlabForward;
      } else {
        return cButModeMoveSlabBackward;
      }
      break;
    }
    return -1;
    break;
  case P_GLUT_DOUBLE_LEFT:
    mode = 16;
    mod = 0;
    break;
  case P_GLUT_DOUBLE_MIDDLE:
    mode = 17;
    mod = 0;
    break;
  case P_GLUT_DOUBLE_RIGHT:
    mode = 18;

    mod = 0;
    break;
  }
  switch(mod) {
  case 0:
    break;
  case cOrthoSHIFT:
    mode+=3;
    break;
  case cOrthoCTRL:
    mode+=6;
    break;
  case (cOrthoCTRL+cOrthoSHIFT):
    mode+=9;
    break;
  }
  return(I->Mode[mode]);
}
/*========================================================================*/
int ButModeClick(Block *block,int button,int x,int y,int mod)
{

  switch(mod) {
  case cOrthoSHIFT:
    PLog("cmd.mouse('backward')",cPLog_pym);
    OrthoCommandIn("mouse backward");
    break;
  default:
    PLog("cmd.mouse('forward')",cPLog_pym);
    OrthoCommandIn("mouse forward");
  }
  return(1);
}
/*========================================================================*/
void ButModeDraw(Block *block)
{
  CButMode *I=&ButMode;
  int x,y,a;
  float rate;
  char rateStr[255];
  int mode;
  int nf;

  if(PMGUI) {
    if(SettingGetGlobal_b(cSetting_internal_gui_mode)==0) {
      glColor3fv(I->Block->BackColor);
      BlockFill(I->Block);
    }

    x = I->Block->rect.left+cButModeLeftMargin;
    y = (I->Block->rect.top-cButModeLineHeight)-cButModeTopMargin;


    glColor3fv(I->TextColor2);
    GrapDrawStr("Mouse Mode ",x+1,y);
    glColor3fv(I->TextColor3);
    GrapDrawStr(SettingGetGlobal_s(cSetting_button_mode_name),x+88,y);
    /*    GrapDrawStr("2-Bttn Selecting",x+88,y);*/
    y-=cButModeLineHeight;



    glColor3fv(I->Block->TextColor);
    GrapDrawStr("Buttons ",x+1,y);
    glColor3fv(I->TextColor1);
    /*    GrapDrawStr("  Left Mddl Rght Scrl",x+48,y);*/
    GrapDrawStr("    L    M    R  Wheel",x+43,y);

    y-=cButModeLineHeight;
    /*    glColor3fv(I->Block->TextColor);
          GrapDrawStr("K",x,y-4);*/
    glColor3fv(I->Block->TextColor);
    GrapDrawStr("&",x+4,y);
    GrapDrawStr("Keys",x+16,y);
    glColor3fv(I->TextColor2);
    glRasterPos4d(x+64,y,0,1);
    for(a=0;a<3;a++) {
      mode = I->Mode[a];
      if(mode<0)
        GrapContStr("    ");
      else
        GrapContStr(I->Code[mode]);
    }
    mode = I->Mode[12];
    if(mode<0)
      GrapContStr("    ");
    else 
      GrapContStr(I->Code[mode]);

    y-=cButModeLineHeight;
    /*    glColor3fv(I->Block->TextColor);
          GrapDrawStr("e",x+5,y-1);*/
    glColor3fv(I->TextColor1);

    glColor3fv(I->TextColor1);
    GrapDrawStr("Shft ",x+24,y);
    glColor3fv(I->TextColor2);
    glRasterPos4d(x+64,y,0,1);
    for(a=3;a<6;a++) {
      mode = I->Mode[a];
      if(mode<0)
        GrapContStr("    ");
      else 
        GrapContStr(I->Code[mode]);
    }
    mode = I->Mode[13];
    if(mode<0)
      GrapContStr("    ");
    else 
      GrapContStr(I->Code[mode]);

    y-=cButModeLineHeight;
    /*    glColor3fv(I->Block->TextColor);
          GrapDrawStr("y",x+10,y+2);*/
    glColor3fv(I->TextColor1);
    GrapDrawStr("Ctrl ",x+24,y);
    glColor3fv(I->TextColor2);
    glRasterPos4d(x+64,y,0,1);
    for(a=6;a<9;a++) {
      mode = I->Mode[a];
      if(mode<0)
        GrapContStr("    ");
      else
        GrapContStr(I->Code[mode]);
    }
    mode = I->Mode[14];
    if(mode<0)
      GrapContStr("    ");
    else 
      GrapContStr(I->Code[mode]);
    y-=cButModeLineHeight;


    /*    glColor3fv(I->Block->TextColor);
          GrapDrawStr("s",x+15,y+3);*/
    glColor3fv(I->TextColor1);
    glColor3fv(I->TextColor1);
    GrapDrawStr("CtSh ",x+24,y);
    glColor3fv(I->TextColor2);
    glRasterPos4d(x+64,y,0,1);
    for(a=9;a<12;a++) {
      mode = I->Mode[a];
      if(mode<0)
        GrapContStr("    ");
      else
        GrapContStr(I->Code[mode]);
    }
    mode = I->Mode[15];
    if(mode<0)
      GrapContStr("    ");
    else 
      GrapContStr(I->Code[mode]);

    y-=cButModeLineHeight;


    glColor3fv(I->Block->TextColor);
    glColor3fv(I->TextColor1);
    GrapDrawStr(" DblClk",x,y);
    glColor3fv(I->TextColor2);
    glRasterPos4d(x+64,y,0,1);
    for(a=16;a<19;a++) {
      mode = I->Mode[a];
      if(mode<0)
        GrapContStr("    ");
      else
        GrapContStr(I->Code[mode]);
    }
    glColor3fv(I->Block->TextColor);
    y-=cButModeLineHeight;

    /*
    if(I->Caption[0]) GrapDrawStr(I->Caption,x,y);
    */

    {
      glColor3fv(I->Block->TextColor);
      GrapDrawStr("Selecting ",x,y);
      glColor3fv(I->TextColor3);
      switch(SettingGetGlobal_i(cSetting_mouse_selection_mode)) {
      case 0:
        GrapDrawStr("Atoms",x+80,y);        
        break;
      case 1:
        GrapDrawStr("Residues",x+80,y);        
        break;
      case 2:
        GrapDrawStr("Chains",x+80,y);        
        break;
      case 3:
        GrapDrawStr("Segments",x+80,y);        
        break;
      case 4:
        GrapDrawStr("Objects",x+80,y);        
        break;
      case 5:
        GrapDrawStr("Molecules",x+80,y);        
        break;
      case 6:
        GrapDrawStr("C-alphas",x+80,y);        
        break;
      }
    }

    glColor3fv(I->Block->TextColor);
    y-=cButModeLineHeight;
    if(I->Samples) 
      rate = I->Rate/I->Samples;
    else 
      rate = 0;
    nf = SceneGetNFrame();
    if(nf==0)
      nf=1;
    glColor3fv(I->Block->TextColor);
    GrapDrawStr("Frame ",x,y);
    glColor3fv(I->TextColor2);
    sprintf(rateStr,"[%3d/%3d] %d/sec",SceneGetFrame()+1,
            nf,(int)(rate+0.5F));
    GrapDrawStr(rateStr,x+48,y);


  }
}


