#!/usr/bin/env python

import sys
from distutils.core import setup, Extension

classifiers = """\
Development Status :: 5 - Production/Stable
Intended Audience :: Developers
License :: OSI-Approved Open Source :: GNU Library or Lesser General Public License (LGPL)
Programming Language :: Python
Programming Language :: C
Topic :: Database
Topic :: Software Development :: Libraries :: Python Modules
Operating System :: Microsoft :: Windows
Operating System :: Unix
"""

minpyver = (2, 4)
if sys.version_info < minpyver:
	print """
You're using Python %d.%d, but pymssql requires at least Python %d.%d.
Setup cannot continue.
""" % ( sys.version_info[0], sys.version_info[1], minpyver[0], minpyver[1] )
	sys.exit(1)

if sys.platform == "win32":
	p = ''
	import os, os.path
	try:
		# those modules are available out-of-the box in ActivePython
		import win32api, win32con

		# try to determine include and lib path
		try:
			h = win32api.RegOpenKey(win32con.HKEY_LOCAL_MACHINE, r'SOFTWARE\Microsoft\Microsoft SQL Server\80\Tools\ClientSetup')
			p = win32api.RegQueryValueEx(h,'SQLPath')[0]
		except:
			e = sys.exc_info()
			print """
Setup.py is unable to find path to SQL 2000 tools. Either it's not installed
or you have insufficient permissions to read Windows registry. Please make
sure you've got administrator rights. Setup.py will try some generic paths.
"""
		if p:
			e = ''
			if (not os.path.exists(os.path.join(p, r'DevTools\include'))):
				e += "Setup.py is unable to find SQL 2000 developer tools include directory.\n"
			if (not os.path.exists(os.path.join(p, r'DevTools\lib'))):
				e += "Setup.py is unable to find SQL 2000 developer tools library directory.\n"

			if e:
				print e + """
Either the developer tools package is not installed or you have insufficient
permissions to read the files. Please make sure you've got administrator
rights. Setup.py will try some generic paths.
"""
	except ImportError:
		pass

	# first some generic paths
	include_dirs = [ r'c:\Program Files\Microsoft SQL Server\80\Tools\DevTools\Include', r'c:\mssql7\DevTools\Include',]
	library_dirs = [ r'c:\Program Files\Microsoft SQL Server\80\Tools\DevTools\Lib', r'\mssql7\DevTools\Lib',]
	libraries = ["ntwdblib", "msvcrt", "kernel32", "user32", "gdi32", "winspool", "comdlg32", "advapi32", "shell32", "ole32", "oleaut32", "uuid", "odbc32", "odbccp32", ]
	data_files = [("LIB/site-packages",["ntwdblib.dll",]),]

	# prepend path from registry, if any
	if p:
		include_dirs.insert(0, os.path.join(p, r'DevTools\include'))
		library_dirs.insert(0, os.path.join(p, r'DevTools\lib'))

else:	# try some generic paths
	include_dirs = [
		'/usr/include', '/usr/local/include',
		'/usr/include/freetds', '/usr/local/include/freetds',
		'/usr/pkg/freetds/include'	# netbsd
	]
	library_dirs = [
		'/usr/lib', '/usr/local/lib',
		'/usr/lib/freetds', '/usr/local/lib/freetds'
		'/usr/pkg/freetds/lib'		# netbsd
	]
	libraries = ["sybdb"]
	data_files = []

if sys.platform == "cygwin":
	libraries.append("iconv")

# we can't use 2.3 or lower anymore...
#if sys.version_info < (2, 3):
#	_setup = setup
#	def setup(**kwargs):
#		if kwargs.has_key("classifiers"):
#			del kwargs["classifiers"]
#			_setup(**kwargs)

#import pymssql
# no, we can't import pymssql because _mssql is not installed yet
# and it blows up with the following exception:
# DECIMAL = DBAPITypeObject(_mssql.DECIMAL)
# AttributeError: 'module' object has no attribute 'DECIMAL'
setup(name = 'pymssql',
	version = '0.8.0',
	description = 'A simple database interface to MS-SQL for Python.',
	long_description = 'A simple database interface to MS-SQL for Python.',
	author = 'Joon-cheol Park',
	author_email = 'jooncheol@gmail.com',
	maintainer = 'Andrzej Kukula',
	maintainer_email = 'akukula@gmail.com',
	license = 'LGPL',
	url = 'http://pymssql.sourceforge.net',
	py_modules = [ 'pymssql', ],
	ext_modules = [Extension('_mssql', ['mssqldbmodule.c'],
			include_dirs = include_dirs,
			library_dirs = library_dirs,
			libraries = libraries)],
	classifiers = filter(None, classifiers.split('\n')),
	data_files = data_files
)
