#
# A GtkVBox Inherited objects for selecting storage method
# of a mailbox and converting stuff from one method to
# another.
#

from gtk import *
import os
import os.path
import GtkExtra
import __init__
import pynei18n

class configbox(GtkVBox):
	
	def __init__(self, mailbox, parent_user):
		self.parent_user = parent_user
		self.mailbox = mailbox
		#self.change_to = self.mailbox.export_format
		self.change_to = (0,0)

		GtkVBox.__init__(self, spacing=5)
		self.set_border_width(5)

		##		
		box1 = GtkHBox(spacing=5)
		self.pack_start(box1, expand=FALSE)
		box1.show()

		label = GtkLabel(_("Current Format: "))
		box1.pack_start(label, expand=FALSE)
		label.show()

		entry = GtkEntry()
		entry.set_text(__init__.bignames[self.mailbox.export_format[0]])
		box1.pack_start(entry)
		entry.set_editable(FALSE)
		entry.show()

		##
		box2 = GtkHBox(spacing=5)
		self.pack_start(box2, expand=FALSE)
		box2.show()

		def change_boxtype(item, self=self):
			type = __init__.bignames.index(item.get_data("0"))
			if type == __init__.BF_MHBOX:
				location = os.environ["HOME"]+"/mhmail"
			else:
				location = ""
			self.change_to = (type, location)
			if type == __init__.BF_MHBOX:
				self.location_box.set_editable(TRUE)
				self.location_box.set_text(location)
			else:
				self.location_box.set_editable(FALSE)
				self.location_box.set_text("")
			print self.change_to

		# menu of possible box format types
		menu = GtkMenu()
		menu.show()
		for x in __init__.bignames:
			menuitem = GtkMenuItem(x)
			menuitem.set_data("0", x)
			menuitem.connect("activate", change_boxtype)
			menu.append(menuitem)
			menuitem.show()
		self.format_menu = GtkOptionMenu()
		self.format_menu.set_menu(menu)
		box2.pack_end(self.format_menu, expand=FALSE)
		self.format_menu.show()

		label = GtkLabel(_("Change to: "))
		box2.pack_end(label, expand=FALSE)
		label.show()

		##
		box3 = GtkHBox(spacing=5)
		self.pack_start(box3, expand=FALSE)
		box3.show()

		# by default we convert existing messages to new format
		self.convert_toggle = GtkCheckButton(_("Convert existing messages"))
		self.convert_toggle.set_active(TRUE)
		box3.pack_end(self.convert_toggle, expand=FALSE)
		self.convert_toggle.show()

		##
		box4 = GtkHBox(spacing=5)
		self.pack_start(box4, expand=FALSE)
		box4.show()

		label = GtkLabel(_("Location: "))
		box4.pack_start(label, expand=FALSE)
		label.show()

		self.location_box = GtkEntry()
		if self.mailbox.export_format[0] == __init__.BF_MHBOX:
			self.location_box.set_text(self.mailbox.export_format[1])
			self.location_box.set_editable(TRUE)
		else:
			self.location_box.set_editable(FALSE)
		box4.pack_start(self.location_box)
		self.location_box.show()

		def get_location(_button, self=self):
			# only mhboxes need location
			if self.change_to[0] == __init__.BF_MHBOX:
				location = GtkExtra.file_sel_box(_("Location of mh mailbox"))
				if location == None:
					return
				if os.path.isdir(location):
					self.location_box.set_text(location)
					self.change_to = (self.change_to[0], location)
				else:
					GtkExtra.message_box(_("Error"), _("You must select a directory\nfor an MH Mailbox"), (_("Ok"),))
			print self.change_to

		button = GtkButton(" "+_("Change")+" ")
		button.connect("clicked", get_location)
		box4.pack_start(button, expand=FALSE)
		button.show()

		##
		box5 = GtkHBox(spacing=5)
		self.pack_end(box5, expand=FALSE)
		box5.show()

		button = GtkButton(" "+_("Do conversion")+" ")
		button.connect("clicked", self.do_conversion)
		box5.pack_end(button, expand=FALSE)
		button.show()

	def do_conversion(self, _button=None):
		if self.change_to == self.mailbox.export_format:
			# nothing to do
			return
		# one last chance
		if GtkExtra.message_box(_("Confirm"), _("Are you sure you want to convert\nyour mailbox?"), (_("Yes"), _("No"))) \
			== _("No"):
			return
		# okay, let's do it
		do_convert = self.convert_toggle.get_active()

		self.mailbox.export_format = self.change_to	

		if do_convert == FALSE:
			# trash old mailbox
			self.mailbox.io.nuke()
			self.mailbox.startup(self.parent_user)
			self.mailbox.messages = self.mailbox.io.get_contents()
		else:
			# convert
			old_io = self.mailbox.io
			self.mailbox.startup(self.parent_user)
			# copy messages from old to new
			for x in old_io.get_contents():
				msg = old_io.load_article(x)
				if msg != None:
					self.mailbox.io.save_article(msg)
			# XXX BUG XXX this really messes up nntpboxes
			self.mailbox.messages = self.mailbox.io.get_contents()
			old_io.nuke()
		self.parent_user.update()

