# A mail collector thingy using imap4
from gtk import *

import imaplib
import string
import recv
from ptk.big_edit_box import *
import pynei18n

class imap4_recv:
	def __init__(self, conf):
		self.conf = conf
		self.connection = imaplib.IMAP4(conf["server"], conf["port"])

	def close_connection(self):
		### in future check if we are authed in first...
		try:
			self.connection.expunge()
			self.connection.close()
		except imaplib.IMAP4.error:
			pass
		self.connection.logout()

	def auth(self):
		try:
			if self.conf["username"] != "":
				self.connection.login(self.conf["username"], self.conf["password"])
		except imaplib.IMAP4.error:
			raise recv.auth_exception

	def get_msg_list(self):
		self.connection.select()
		# get list of message ids, eg [ "1", "2", ... ]
		ids = string.split(self.connection.search(None, "ALL")[1][0])
		# get sizes. eg [ "1 (RFC822.SIZE 1400', '2 (RFC822.SIZE 19342' ]
		if len(ids) == 0:
			return {}
		raw_sizes = self.connection.fetch( string.join(ids, ","), "(RFC822.SIZE)" )[1]
		# parse to dictionary of {'id': size}
		y = {}
		for  i in raw_sizes:
			id, crap, size = string.split(i)
			# get rid of ')' and convert to int
			size = int(size[:-1])
			y[id] = size
		return y
		
	def get_header(self, index):
		head = self.connection.fetch(index, "(RFC822.HEADER)")[1][0][1]
		head = string.replace(head, "\r\n", "\n")
		# [:-2] to remove terminating \n\n
		return head[:-2]

	def get_body(self, index):
		body = self.connection.fetch(index, "(RFC822.TEXT)")[1][0][1]
		body = string.replace(body, "\r\n", "\n")
		return body

	def delete_msg(self, index):
		self.connection.store(index, "+FLAGS", "\\Deleted")

def fix_defaults(conf):
	conf["port"] = 143

def get_connection(conf):
	"""
	return a connection object thingy.
	"""
	return imap4_recv(conf)

def setup(parent_mailbox, conf):
	"""
	Open a configuration dialog box.
	"""
	win = GtkWindow()
	win.set_title(_("%s IMAP4 Settings") % parent_mailbox.name)

	box = GtkVBox()
	box.set_border_width(5)
	win.add(box)
	box.show()

	# dummy class object for settings
	class _dummy:
		pass
	settings = _dummy()
	settings.__dict__ = conf

	settings_box0 = big_edit_box( settings,
	      ( ("server", _("IMAP4 server:"), VAR_TYPE_STRING, 0, 0),
		("port", _("Port:"), VAR_TYPE_INTEGER, 0, 143),
		("username", _("Username:"), VAR_TYPE_STRING, 0, 0),
		("password", _("Password:"), VAR_TYPE_STRING, MOD_HIDE, 0) )
	)
	box.pack_start(settings_box0, expand=FALSE)
	settings_box0.show()

	# separator between entry boxes and buttons
	separator = GtkHSeparator()
	box.pack_start(separator, expand=FALSE)
	separator.show()

	def save_changes(_button, win=win, settings=settings, settings_box0=settings_box0):
		# Extract info
		settings_box0.apply_changes()
		win.destroy()

	# boootons
	buttonbox = GtkHBox(spacing=5)
	buttonbox.set_border_width(5)
	box.pack_start(buttonbox, expand=FALSE)
	buttonbox.show()

	cancel_button = GtkButton(" "+_("Cancel")+" ")
	cancel_button.connect("clicked", win.destroy)
	buttonbox.pack_end(cancel_button, expand=FALSE)
	cancel_button.show()

	ok_button = GtkButton(" "+_("Ok")+" ")
	ok_button.connect("clicked", save_changes)
	buttonbox.pack_end(ok_button, expand=FALSE)
	ok_button.show()

	win.show()

	
