#
# Incoming mail filters.
#
# Pop boxes may contain many in the filters[] list.
#

CONDITION_EQUAL =	0
CONDITION_NOTEQUAL =	1
CONDITION_CONTAINS =	2
CONDITION_LARGERTHAN =	3
CONDITION_REGEX_MATCH = 4
CONDITION_MATCH_ALL =	5

ACTION_MOVE = 0
ACTION_LEAVE = 1
ACTION_DELETE = 2
ACTION_FORWARD = 3
ACTION_LEAVE_COLLECT = 4

conditions = [ "equals", "not equals", "contains", "size > (Kb)", "regex match", "match all" ]

actions = [ "Move to folder:",
	    "Leave on server",
            "Delete from server",
            "Forward to address:",
	    "Collect & leave on server"]

import time
import re
import string
from gtk import *
import ptk.folder_tree
from pyneheaders import *
import pynemsg
import boxtypes
import pynei18n
from boxtypes import superbox

# a filter is a tuple like so:
# ( string name, string header to match, integer condition,
#   string value to match, integer action, string action argument )
# eg: ( "Ignore annoying guy", "from", CONDITION_EQUAL, "twat@aol.com",
#       ACTION_MOVE, <Deleted folder UID as string> )
# will move mail from 'twat@aol.com' to the deleted folder

def filter_collect(parent_user, _mailbox, connection, index):
	"""
	Collect message 'index' from `connection`, applying
	filters.
	"""
	# return message
	r = ""
	# download headers only ATM
	msg = pynemsg.pynemsg()
	
	head = _mailbox.remote_get_header(connection, index)
	if head == None:
		return ""
	msg.body = head + "\n\n"
	# have we appended the body yet?
	gotbody = 0
	# Parse headers
	msg.parseheaders(parent_user, headers_only=1)
	msg.date_received = time.gmtime(time.time())
	# Does it match any filters (multiple matches possible)
	nomatches = 1
	for filtr in _mailbox.filters:
		name, head, cond, carg, actn, aarg = filtr
		match = 0
		# this condition tests not filthy headers...
		if cond != CONDITION_LARGERTHAN:
			if not msg.headers.has_key(head):
				continue
			head = msg.headers[head]

		if cond == CONDITION_LARGERTHAN:
			# get body and check size
			if isinstance(_mailbox, boxtypes.nntpbox.newsgroup):
				# don't bother if we are only collecting headers
				if (_mailbox.opts & superbox.OPT_HEADERS_ONLY):
					continue
				if gotbody == 0:
					body = _mailbox.remote_get_body(connection, index)
					msg.opts = msg.opts & (~MSG_NO_BODY)
					msg.body = msg.body + body
					gotbody = 1
				## including headers XXX
				if len(msg.body) > (1024*int(carg)):
					match = 1
			elif isinstance(_mailbox, boxtypes.mailbox.mailbox):
				# get message size from our {id: size} message  dict
				size = _mailbox.pending_msgs[index]
				if int(size) > (1024*int(carg)):
					match = 1
		elif cond == CONDITION_EQUAL:
			if head == carg:
				match = 1
		elif cond == CONDITION_NOTEQUAL:
			if head != carg:
				match = 1
		elif cond == CONDITION_CONTAINS:
			if string.find(head, carg) != -1:
				match = 1
		elif cond == CONDITION_REGEX_MATCH:
			if re.match(carg, head) != None:
				match = 1
		elif cond == CONDITION_MATCH_ALL:
			match = 1

		if match == 1:
			r = "\""+name+"\" "+_("filter match.")
			nomatches = 0

		if match == 1:
			# It matched a filter. do action
			if actn == ACTION_MOVE:
				# get body
				if (gotbody == 0) and not (_mailbox.opts & superbox.OPT_HEADERS_ONLY):
					body = _mailbox.remote_get_body(connection, index)
					msg.body = msg.body + body
					msg.opts = msg.opts & (~MSG_NO_BODY)
					gotbody = 1
				# get folder to move to, from UID
				# String or integer UID. great implementation, man :-{
				try:
					uid = int(aarg)
				except ValueError:
					uid = aarg
				folder = parent_user.get_folder_by_uid(uid)
				if folder == None:
					print "FILTER: Error. move_to folder not found."
					print "FILTER: "+str(filtr)
				else:
					folder.io.save_article(msg)

					# Add message to mailbox
					folder.messages.append(msg.headers["message-id"])

					# Delete from server
					_mailbox.remote_delete(connection, index)

					# Mark folder for update
					folder.changed = 1
				# some obsoleted comment clinging to existence
				return r

			elif actn == ACTION_LEAVE:
				# leave on server. don't store
				return r
			elif actn == ACTION_DELETE:
				# Delete from server. don't store
				_mailbox.remote_delete(connection, index)
				return r
			elif actn == ACTION_FORWARD:
				# get body
				if (gotbody == 0) and not (_mailbox.opts & superbox.OPT_HEADERS_ONLY):
					body = _mailbox.remote_get_body(connection, index)
					msg.body = msg.body + body
					msg.opts = msg.opts & (~MSG_NO_BODY)
					gotbody = 1
				msg.parseheaders(parent_user)
				outbox = parent_user.get_folder_by_uid("outbox")
				outbox._reply(parent_user, _mailbox, _mailbox, msg, \
				    REPLY_FORWARD, send_to=aarg, dont_open_editbox=1)
				# delete from server
				_mailbox.remote_delete(connection, index)
				return r
			elif actn == ACTION_LEAVE_COLLECT:
				# collect but leave on server
				if (gotbody == 0) and not (_mailbox.opts & superbox.OPT_HEADERS_ONLY):
					body = _mailbox.remote_get_body(connection, index)
					msg.body = msg.body + body
					msg.opts = msg.opts & (~MSG_NO_BODY)
					gotbody = 1
				_mailbox.io.save_article(msg)

				# Add message to mailbox
				_mailbox.messages.append(msg.headers["message-id"])
				return r
	if nomatches == 1:
		# default action. store to mailbox and trash
		# from server
		if (gotbody == 0) and not (_mailbox.opts & superbox.OPT_HEADERS_ONLY):
			body = _mailbox.remote_get_body(connection, index)
			msg.body = msg.body + body
			msg.opts = msg.opts & (~MSG_NO_BODY)
			gotbody = 1
		_mailbox.io.save_article(msg)

		# Add message to mailbox
		_mailbox.messages.append(msg.headers["message-id"])

		# Delete from server
		_mailbox.remote_delete(connection, index)
		return r

class filter_editbox(GtkVBox):
	"""
	A GtkBox full of shit for editing a mailbox.filters
	"""

	def sel_folder(self, w, event, tree):
		folder = self.parent_user.get_folder_by_uid(tree.selected[0])
		self.aarg_in.set_text(folder.name)
		self.f_aarg = str(folder.uid)

	def ch_condition(self, item):
		self.f_cond = int(item.get_data("0"))
	
	def ch_header(self, item):
		self.header_in.set_text(item.get_data("0"))
		self.f_head = item.get_data("0")
	
	def ch_action(self, item):
		self.f_actn = int(item.get_data("0"))
		# show folder list and action arguments entry as required
		if self.f_actn == ACTION_MOVE:
			self.folder_list.show()
		else:
			self.folder_list.hide()
		if self.f_actn == ACTION_LEAVE or self.f_actn == ACTION_DELETE:
			self.aarg_in.hide()
		else:
			self.aarg_in.show()

	def load_filter(self, user, filternum):
		"""
		filternum should be None for new filter.
		"""
		if filternum == None:
			# elements of currently edited filter:
			self.f_name = ""
			self.f_head = ""
			self.f_cond = CONDITION_EQUAL
			self.f_carg = ""
			self.f_actn = ACTION_MOVE
			self.f_aarg = ""
		else:
			filter = self.filters[filternum]
			self.f_name = filter[0]
			self.f_head = filter[1]
			self.f_cond = filter[2]
			self.f_carg = filter[3]
			self.f_actn = filter[4]
			self.f_aarg = filter[5]
		# Stuff the Gtk thingies with this junk
		self.name_in.set_text(self.f_name)
		self.header_in.set_text(self.f_head)
		self.carg_in.set_text(self.f_carg)
		self.act_menu.set_history(self.f_actn)
		self.cond_menu.set_history(self.f_cond)
		# in a fit of crap design uids are integers or strings...
		if self.f_actn == ACTION_MOVE:
			try:
				uid = int(self.f_aarg)
			except ValueError:
				uid = self.f_aarg
			folder = user.get_folder_by_uid(uid)
			if folder != None:
				self.aarg_in.set_text(folder.name)
		elif self.f_actn == ACTION_FORWARD:
			self.aarg_in.set_text(self.f_aarg)
		# show folder list and action arguments entry as required
		if self.f_actn == ACTION_MOVE:
			self.folder_list.show()
		else:
			self.folder_list.hide()
		if self.f_actn == ACTION_LEAVE or self.f_actn == ACTION_DELETE:
			self.aarg_in.hide()
		else:
			self.aarg_in.show()

	def update_filter_list(self):
		self.filter_list.freeze()
		self.filter_list.clear()
		for x in self.filters:
			self.filter_list.append( [ x[0] ] )
		self.filter_list.thaw()

	def __init__(self, mailbox, parent_user):
		GtkVBox.__init__(self)
		self.parent_user = parent_user

		import copy
		self.filters = copy.deepcopy(mailbox.filters)
		self.cur_edit = None	# currently editing which filter?

		# Disgusting over-use of GtkBoxes seems like a nice way
		# of constructing this ;-)
		box0 = GtkHBox(spacing=5) ; box0.set_border_width(5)
		box1 = GtkHBox(spacing=5) ; box1.set_border_width(5)
		box2 = GtkHBox(spacing=5) ; box2.set_border_width(5)
		box3 = GtkHBox(spacing=5) ; box3.set_border_width(5)
		box4 = GtkHBox()
		box4_1 = GtkVBox(spacing=5) ; box4_1.set_border_width(5)
		box4_2 = GtkVBox(spacing=5) ; box4_2.set_border_width(5)

		# Box0: filter name
		label = GtkLabel(_("Filter name: "))
		box0.pack_start(label, expand=FALSE)
		label.show()

		self.name_in = GtkEntry()
		box0.pack_start(self.name_in)
		self.name_in.show()

		self.pack_start(box0, expand=FALSE)
		box0.show()
	
		# Box1: if [text-in] <suggested headers>
		# eg:   if "subject"
		label = GtkLabel(_("If header"))
		box1.pack_start(label, expand=FALSE)
		label.show()
	
		self.header_in = GtkEntry()
		box1.pack_start(self.header_in)
		self.header_in.show()
	
		menu = GtkMenu()
		menu.show()
		for x in [ "to", "from", "subject" ]:
			menuitem = GtkMenuItem(x)
			menuitem.set_data("0", x)
			menuitem.connect("activate", self.ch_header)
			menu.append(menuitem)
			menuitem.show()
		optmenu = GtkOptionMenu()
		optmenu.set_menu(menu)
		box1.pack_end(optmenu, expand=FALSE)
		optmenu.show()
	
		self.pack_start(box1, expand=FALSE)
		box1.show()
	
		# Box2: <condition> <textin>
		# eg:   Equals "Here to torment you"
		menu = GtkMenu()
		menu.show()
		for x in range(0, len(conditions)):
			menuitem = GtkMenuItem(conditions[x])
			menuitem.set_data("0", x)
			menuitem.connect("activate", self.ch_condition)
			menu.append(menuitem)
			menuitem.show()
		self.cond_menu = GtkOptionMenu()
		self.cond_menu.set_menu(menu)
		box2.pack_start(self.cond_menu, expand=FALSE)
		self.cond_menu.show()
	
		self.carg_in = GtkEntry()
		box2.pack_end(self.carg_in)
		self.carg_in.show()
	
		self.pack_start(box2, expand=FALSE)
		box2.show()

		# Box3: then <action> <argument>
		# eg:   then "move to" deleted
		label = GtkLabel(_("then"))
		box3.pack_start(label, expand=FALSE)
		label.show()

		menu = GtkMenu()
		menu.show()
		for x in range(0, len(actions)):
			menuitem = GtkMenuItem(actions[x])
			menuitem.set_data("0", x)
			menuitem.connect("activate", self.ch_action)
			menu.append(menuitem)
			menuitem.show()
		self.act_menu = GtkOptionMenu()
		self.act_menu.set_menu(menu)
		box3.pack_start(self.act_menu, expand=FALSE)
		self.act_menu.show()

		self.aarg_in = GtkEntry()
		box3.pack_end(self.aarg_in)
		self.aarg_in.show()

		self.pack_start(box3, expand=FALSE)
		box3.show()

		# Box4_1: bunch of buttons and folder selector
		# for move_to rule
		self.folder_list = ptk.folder_tree.folder_tree()
		self.folder_list.update(parent_user.contents, update_all=1)
		self.folder_list.connect_button_press_event(self.sel_folder)
		swin = GtkScrolledWindow()
		swin.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
		swin.show()
		swin.add(self.folder_list)
		box4_1.pack_start(swin)#, expand=FALSE)
		swin.show()

		# buttons horizontal in yet another box...
		button_box = GtkHBox(spacing=5)
		box4_1.pack_start(button_box, expand=FALSE)
		button_box.show()

		def new_filter(button, self=self):
			self.cur_edit = None
			self.load_filter(self.parent_user, None)
		button = GtkButton(" "+_("New")+" ")
		button.connect("clicked", new_filter)
		button_box.pack_start(button, expand=FALSE)
		button.show()

		def copy_filter(button, self=self):
			if len(self.filter_list.selection)==0:
				return
			x = self.filter_list.selection[0]
			self.filters.append(self.filters[x])
			self.update_filter_list()
		button = GtkButton(" "+_("Copy")+" ")
		button.connect("clicked", copy_filter)
		button_box.pack_start(button, expand=FALSE)
		button.show()

		def delete_filter(button, self=self):
			if len(self.filter_list.selection)==0:
				return
			del self.filters[self.filter_list.selection[0]]
			self.update_filter_list()
		button = GtkButton(" "+_("Delete")+" ")
		button.connect("clicked", delete_filter)
		button_box.pack_start(button, expand=FALSE)
		button.show()

		def _load_filter(button, self=self):
			if len(self.filter_list.selection)==0:
				return
			self.cur_edit = self.filter_list.selection[0]
			self.load_filter(self.parent_user, self.filter_list.selection[0])
		button = GtkButton(" "+_("Load")+" ")
		button.connect("clicked", _load_filter)
		button_box.pack_start(button, expand=FALSE)
		button.show()

		def save_filter(button, self=self):
			self.cur_edit
			self.f_name = self.name_in.get_text()
			self.f_head = self.header_in.get_text()
			# (if action is move then f_aarg is already a folder UID)
			if self.f_actn != ACTION_MOVE:
				self.f_aarg = self.aarg_in.get_text()
			self.f_carg = self.carg_in.get_text()
			if self.cur_edit == None:
				self.filters.append((self.f_name, self.f_head, \
					self.f_cond, self.f_carg, self.f_actn, self.f_aarg))
			else:
				self.filters[self.cur_edit] = (self.f_name, self.f_head, \
					self.f_cond, self.f_carg, self.f_actn, self.f_aarg)
			self.update_filter_list()
		button = GtkButton(" "+_("Save")+" ")
		button.connect("clicked", save_filter)
		button_box.pack_start(button, expand=FALSE)
		button.show()

		self.pack_start(box4)
		box4.show()
		box4.pack_start(box4_1, expand=FALSE)
		box4_1.show()

		# Box4_2: List of rules
		self.filter_list = GtkCList(1, [ _("Filters") ])
		swin = GtkScrolledWindow()
		swin.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
		swin.show()
		swin.add(self.filter_list)
		self.filter_list.show()
		box4_2.pack_start(swin)
		swin.show()

		box4.pack_start(box4_2)
		box4_2.show()

		# prepare for input
		self.load_filter(self.parent_user, None)
		self.update_filter_list()

