import utils
import string
from gtk import *
from sort import *
from pyneheaders import *
from boxtypes import superbox
from time import strftime
import pynei18n

# used in threading, and made global for the sake of laze
CHILDREN = HEAD_LENGTH

# message_tree and folder_tree are best used attached to
# GtkScrolledWindow objects.
class message_tree(GtkCTree):
	"""
	A GtkCTree for showing NNTP or email messages with
	threading code and that stuff...
	"""
	def __init__(self, parent_user, width):
		GtkCTree.__init__(self, 3, 0, [ _("Subject"), _("From"), _("Date") ] )
		self.cur_object = None # current mailbox shown
		self.set_selection_mode(SELECTION_EXTENDED)
		self.set_column_width(0, 2*width/5)
		self.set_column_width(1, width/3)
		self.set_column_width(2, 50)
		self.set_expander_style(CTREE_EXPANDER_SQUARE)
		self.set_line_style(CTREE_LINES_DOTTED)
		self.button_press_function = None
		self.parent_user = parent_user

		def change_sort_method(w, column, self=self):
			# Change sorting method according to column head clicked on
			oldmethod = self.parent_user.sort_type

			# invert if same
			if oldmethod[0] == column:
				self.parent_user.sort_type = (column, 1-oldmethod[1])
			else:
				self.parent_user.sort_type = (column, 0)
			# force update
			box = self.cur_object
			self.cur_object = None
			self.update(box)
		self.connect("click-column", change_sort_method)
		# setup DND. Only move at the moment. no copy
		targets = [ ("pyne_msgid", 0, -1) ]
		def dnd_drag_data_get(w, context, selection_data, info, time, self=self):
			# give folder.uid/message-id
			selected = str(self.cur_object.uid)+"/"+repr(self.get_selected_msg_ids())
			
			selection_data.set(selection_data.target, 8, selected)
		self.connect("drag_data_get", dnd_drag_data_get)
		self.drag_source_set(GDK.BUTTON1_MASK|GDK.BUTTON3_MASK, targets, GDK.ACTION_MOVE)
		def click_tree_item(widget, event, self=self):
			"""
			Get id of clicked message and pass to user_press_function
			"""
			user = self.parent_user
			mousebutton = event.button
			msg_id = None
			# Get message-id of message clicked on. Ignore right mouse button
			if mousebutton != 3:
				selected = widget.get_selection_info(event.x, event.y)
				if selected:
					row = selected[0]
					node = self.node_nth(row)
					msg_id = self.node_get_row_data(node)
			# Call secondary event handler
			if self.button_press_function != None:
				self.button_press_function(self, event, msg_id)

		self.connect("button_press_event", click_tree_item)

		# make clicking the expander open whole thread
		def _expand_recursive(_ctree, _node):
			for i in _node.children:
				_ctree.expand_recursive(i)
		self.connect("tree-expand", _expand_recursive)

	def update_node(self, user, msg_opts, msg_id=None, node=None):
		"""
		The msg.opts of this node have changed. Update to
		reflect this. Either there should be a given node,
		or we search for one by msg_id.
		"""
		# search for the node if none is given
		if node==None:
			node = self.find_by_row_data(None, msg_id)
		txt,space,c,d,e,f,leaf,expanded = self.get_node_info(node)

		if (msg_opts & MSG_NO_BODY):
			icon, mask = user.msg_icons["000%d" % ((msg_opts & MSG_ISMARKED)==MSG_ISMARKED) ]
			self.set_node_info(node, txt, space, icon, mask, icon, mask, leaf, expanded)
		else:
			isread = (msg_opts & MSG_ISREAD) == MSG_ISREAD
			isreplied = (msg_opts & MSG_ISREPLIED) == MSG_ISREPLIED
			ismarked = (msg_opts & MSG_ISMARKED) == MSG_ISMARKED
			icon, mask = user.msg_icons[ "1%d%d%d" % (isread, isreplied, ismarked) ]
			self.set_node_info(node, txt, space, icon, mask, icon, mask, leaf, expanded)

	def get_selected_msg_ids(self):
		"""
		Return list of selected message-ids
		"""
		msg_ids = []
		for i in self.selection:
			id = self.node_get_row_data(i)
			if id != None:
				msg_ids.append(id)
		return msg_ids

	def connect_button_press_event(self, function):
		"""
		Allow "button_press_event"s to be passed to a secondary
		function for things like right click menus and doing more
		than just remembering what is selected :-)
		"""
		self.button_press_function = function

	def update(self, object, clear=0):
		"""
		Thread messages in mailbox/nntpbox 'object'.
		"""
		user = self.parent_user
		# clear if clear=1 and object==self.cur_object
		if clear == 1 and object == self.cur_object:
			# freeze gtk widget
			self.freeze()
			# Wipe contents
			while (self.node_nth(0) != None):
				self.remove_node( self.node_nth(0) )
			self.thaw()
			return
		# If nothing specified simply update what is already shown
		if object == None and self.cur_object != None:
			if self.cur_object.__dict__.has_key("changed"):
				object = self.cur_object
			else:
				return
		# Nothing to do
		elif object == None:
			return
		# no need to update currently displayed folder
		elif object == self.cur_object and \
		     not object.__dict__.has_key("changed"):
			return
		elif object != self.cur_object:
			# Scroll back to top because we are changing viewed folder
			if self.node_nth(0) != None:
				self.node_moveto(self.node_nth(0), 0, 0.0, 0.0)

		# Remember what mailbox is being viewed
		self.cur_object = object

		# DEBUG
		#t_start = time.time()
		
		# freeze gtk widget
		self.freeze()
		# Wipe contents. Remember expanded message ids
		expanded = []
		i = 0
		while (self.node_nth(i) != None):
			node = self.node_nth(i)
			msgid = self.node_get_row_data(node)
			# get expanded
			_exp = self.get_node_info(node)[7]
			if _exp == TRUE:
				expanded.append(msgid)
			i = i + 1
		while self.node_nth(0) != None:
			# remove node
			self.remove_node( self.node_nth(0) )
		# build cache of actual message objects
		r_messages = []
		for x in object.messages:
			msg = object.io.load_header(x)
			if msg != None:
				r_messages.append(msg)
			else:
				print "Missing headers message ",x
		# Sort
		sort_type, sort_polarity = self.parent_user.sort_type
		if object.opts & superbox.OPT_THREAD:
			# objects to be threaded. sort backwards
			r_messages.sort(sort_methods[sort_type][1-sort_polarity])
		else:
			r_messages.sort(sort_methods[sort_type][sort_polarity])
		# transfer back to object.messages
		object.messages = []
		for x in r_messages:
			object.messages.append(x[HEAD_MESSAGE_ID])

		# name the to/from column correctly
		if object.uid == "sent" or object.uid == "outbox":
			self.set_column_title(1, _("To"))
		else:
			self.set_column_title(1, _("From"))

		########################################### BUILD

		def make_thread(self, messages, msg_dict, ref_cache, expanded):
			"""
			{fast} threading routine.
			'expanded' is a list of message-ids of expanded nodes.
			"""
			user = self.parent_user

			#__t = time.time()
			def make_node(headers, date):
				# format: ( headers, [children] )
				if headers != None:
					node = list(headers)
					node.append([])
				else:
					node = [ None, None, None, None, None,
						 "", None, None, [] ]
				node[HEAD_DATE] = date
				return node
			# supernode, empty
			thread = make_node(None, (0,0,0, 0,0,0, 0,0,0))
			node_cache = {}
			for x in range(0, len(messages)):
				refs = ref_cache[x]
				msg = messages[x]
				t = thread[CHILDREN]
				for depth in xrange(0, len(refs)):
					# has the message-id been added to the
					# tree yet?
					if node_cache.has_key(refs[depth]):
						node = node_cache[refs[depth]]
						t = node[CHILDREN]
					else:
						# if the message's headers are downloaded
						if msg_dict.has_key(refs[depth]):
							node = make_node(msg_dict[refs[depth]], msg_dict[refs[depth]][0])
							t.insert(0, node)
							t = node[CHILDREN]
							node_cache[refs[depth]] = node
						# else create empty node (dated to this message)
						else:
							node = make_node(None, msg[HEAD_DATE])
							t.insert(0, node)
							t = node[CHILDREN]
							node_cache[refs[depth]] = node
					# mark depth 0 message as unread if any are unread above it :-]
					# mark as replied if there are replied messages in this thread.
					# makes finding threads you posted to nice and easy.
					if depth == 0 and node[HEAD_MESSAGE_ID] != None:
						if not (msg[HEAD_OPTS] & MSG_ISREAD):
							node[HEAD_OPTS] = node[HEAD_OPTS] & (~MSG_ISREAD)
						if msg[HEAD_OPTS] & MSG_ISREPLIED:
							node[HEAD_OPTS] = node[HEAD_OPTS] | MSG_ISREPLIED
						if msg[HEAD_OPTS] & MSG_ISMARKED:
							node[HEAD_OPTS] = node[HEAD_OPTS] | MSG_ISMARKED
			#print "PART 1:", time.time() - __t,
			# build thread [recursively] :-)
			def build_node(build_node, this_node, parent, depth, self=self, user=user, expanded=expanded):
				msg = this_node
				if msg[HEAD_MESSAGE_ID] != None:
					# expanded?
					if msg[HEAD_MESSAGE_ID] in expanded:
						_exp = TRUE
					else:
						_exp = FALSE
					# chose icon by 'read' status
					if (msg[HEAD_OPTS]&MSG_NO_BODY):
						icon, mask = user.msg_icons["000%d" % ((msg[HEAD_OPTS]&MSG_ISMARKED)==MSG_ISMARKED)]
					else:
						isread = (msg[HEAD_OPTS]&MSG_ISREAD) == MSG_ISREAD
						isreplied = (msg[HEAD_OPTS]&MSG_ISREPLIED) == MSG_ISREPLIED
						ismarked = (msg[HEAD_OPTS]&MSG_ISMARKED) == MSG_ISMARKED
						icon, mask = user.msg_icons[ "1%d%d%d" % (isread, isreplied, ismarked) ]
					node = self.insert_node(parent, None, [ msg[HEAD_SUBJECT], utils.split_address(msg[HEAD_FROM_TO])[0], strftime("%d %b %Y %H:%M:%S", msg[HEAD_DATE]) ], 0, icon, mask, icon, mask, FALSE, _exp)
					self.node_set_row_data(node, msg[HEAD_MESSAGE_ID]) # set node data as message-id
				else:
					# if the message is a dummy only
					# (possibly) show at base of thread
					if depth > 0:
						# if it has only 1 child don't show it obviously
						if len(this_node[CHILDREN]) < 2:
							node = parent
						else:
							try:
								# otherwise get name from nearest 'real' message
								_this_node = this_node
								while msg[HEAD_MESSAGE_ID] == None:
									_this_node = _this_node[CHILDREN][0]
									msg = _this_node
								# uncached message icon
								icon, mask = user.msg_icons["0000"]
								node = self.insert_node(parent, None, [ msg[HEAD_SUBJECT], "", strftime("%d %b %Y %H:%M:%S", msg[HEAD_DATE]) ], 0, icon, mask, icon, mask, FALSE, FALSE)
								self.node_set_row_data(node, None)
							except IndexError, e:
								# Messages with screwed up references (ie. 2
								# copies of one message-id) may cause index
								# error in '_this_node = _this_node[CHILDREN][0]'
								node = parent
					else:
						# move onto it's children
						node = parent
				depth = depth + 1
				# recurse into each child
				for x in this_node[CHILDREN]:
					build_node(build_node, x, node, depth)
			# recursively build thread
			#__t = time.time()
			build_node(build_node, thread, None, 0)
			#print "  PART 2:", time.time() - __t,
											

		if object.opts & superbox.OPT_THREAD:
			# Newsgroups or mailboxes explicitly requesting
			# threading of message should be
			ref_cache = []
			d_messages = {}
			for x in r_messages:
				# if there are references
				if x[HEAD_REFERENCES] != None:
					# a = references + " " + message-id
					a = x[HEAD_REFERENCES]+" "+x[HEAD_MESSAGE_ID]
				else:
					a = x[HEAD_MESSAGE_ID]
				a = tuple(string.split(a))
				ref_cache.append(a)
				# a dictionary of message headers indexed by message-ids
				d_messages[x[HEAD_MESSAGE_ID]] = x
			make_thread(self, r_messages, d_messages, ref_cache, expanded)
		else:
			# otherwise no threading of messages
			for y in r_messages:
				isread = (y[HEAD_OPTS]&MSG_ISREAD) == MSG_ISREAD
				isreplied = (y[HEAD_OPTS]&MSG_ISREPLIED) == MSG_ISREPLIED
				ismarked = (y[HEAD_OPTS]&MSG_ISMARKED) == MSG_ISMARKED
				icon, mask = user.msg_icons[ "1%d%d%d" % (isread, isreplied, ismarked) ]
				try:
					date = strftime("%d %b %Y %H:%M:%S", y[HEAD_DATE])
				except ValueError:
					# Crappy headers. foobarred date field.
					date = ""
				# HEAD_FROM_TO is to: in outgoing mail and from
				# header on incoming mail.
				node = self.insert_node(None, None, [ y[HEAD_SUBJECT], utils.split_address(y[HEAD_FROM_TO])[0], date ], 0, icon, mask, icon, mask, FALSE, FALSE)
				self.node_set_row_data(node, y[HEAD_MESSAGE_ID])
		self.thaw()


