#include <qdialog.h>
#include <qwt_counter.h>

class QLabel;
class QPushButton;
class QMenuBar;
class QPopupMenu;
class QwtCounter;
class QwtThermo;

//
// A simple first-order lowpass used for averaging
//
class Lowpass
{
public:
    Lowpass();
    
    void setTConst(double t){tconst = t; recalc();}
    void setTSampl(double t){tsampl = t; recalc();}
    void reset(double v) { val = v; }
    double input(double v); 
    double value() {return val;}
    
private:
    void recalc();
    double val;
    double tsampl;
    double tconst;
    double c1;
    double c2;
};

//
//  A dialog for configuring the sampling rate and the lowpass constant
//
class ConfigDiag : public QDialog
{
    Q_OBJECT
public:
    ConfigDiag(QWidget *p = 0, const char *name = 0);
    ~ConfigDiag();

    double tSampl() {return ctSampl->value();}
    double tConst() {return ctConst->value();}

signals:
    void tSamplChg(double);
    void tConstChg(double);

public slots:
    void setTSampl(double);
    void setTConst(double);

protected slots:
    void chgTSampl(double t) { emit tSamplChg(t); }
    void chgTConst(double t) { emit tConstChg(t); }

private:
    QwtCounter *ctSampl;
    QwtCounter *ctConst;
    QLabel *lbSampl;
    QLabel *lbConst;
    QPushButton *btDismiss;
};

//
//  The main window
//
class MainWin : public QWidget 
{
    Q_OBJECT
   
public:
    MainWin(QApplication &a);
    ~MainWin();

    void start();
    void update();
    void read();
    void setTimer(int ms);

public slots:
    void setTSampl(double sec);
    void setTConst(double sec);
    void setFixedScale();
    void setDynScale() { dynscale = 1; }
    void showDialog();

protected:
    void timerEvent(QTimerEvent *e);

private:
    enum { CpuUser, CpuNice, CpuSystem, CpuIdle, ThermoCnt };
    QwtThermo *th[ThermoCnt];
    QLabel  *lb[ThermoCnt];
    ConfigDiag *cfg;
    QMenuBar *menu;
    QPopupMenu *puProg;
    QPopupMenu *puConf;
    QPopupMenu *puScale;

    Lowpass lp[ThermoCnt];

    unsigned long val[ThermoCnt];
    unsigned long old[ThermoCnt];
    
    int dynscale;
    int tmrID;
 };

