########################################################################
#
# File Name:            _4xupdate.py
#
# Documentation:        http://docs.4suite.org/Lib/_4xupdate.py.html
#
"""
Command-line invokation of the 4Xupdate processor
WWW: http://4suite.org/4Xupdate        e-mail: support@4suite.org

Copyright (c) 2001 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import os, sys, getopt, cStringIO
import xml.dom.ext
from Ft import __version__
from Ft.Lib import pDomlette, XUpdate

def Run(options,args):
    dump = options.get('inplace')
    driver = options.get('outfile')
    source_uri = args['source-uri']
    xupdate_uri = args['xupdate-uri']

    reader = pDomlette.PyExpatReader()
    xureader = XUpdate.Reader()

    processor = XUpdate.Processor()
    source = reader.fromUri(source_uri)
    xupdate = xureader.fromUri(xupdate_uri)

    processor.execute(source, xupdate)
    text = cStringIO.StringIO()
    
    xml.dom.ext.Print(source, stream=text)
    result = text.getvalue()
    print result
    
    reader.releaseNode(source)
    xureader.releaseNode(xupdate)
    return


from Ft.Lib.CommandLine import Options, CommandLineApp, Arguments, Command

class XUpdateCommandLineApp(CommandLineApp.CommandLineApp):

    def __init__(self):
        CommandLineApp.CommandLineApp.__init__(
            self,
            '4xupdate',
            '4XUpdate version %s' % __version__,
            __doc__,
            [],
            ourOptions = Options.Options([Options.Option('i',
                                                         'in-place',
                                                         'Update the source file in place',
                                                         ),
                                          Options.Option('o',
                                                         'out-file=',
                                                         'Write the result to the given output file.',
                                                         ),
                                          ]),
            
            enableShowCommands = 0
            )
        
        self.function = Run
        self.arguments = [Arguments.RequiredArgument('source-uri',
                                                     'The URI of the source XML document.  Note: if you use "-" as the name'\
                                                     'of the source document, the source will  instead be read from standard input.  "-" cannot be specified as the source URI if the "-i" option is used.',
                                                     str),
                          Arguments.RequiredArgument('xupdate-uri',
                                                     'The URI of the XUpdate instruction file.  Note: if you use "-" as the name'\
                                                     'of the source document, the source will  instead be read from standard input.'\
                                                     'The "-" option can only be used for the source or the XUpdate argument, not both.',
                                                     str),
                          ]


    def validate_arguments(self,args):
        return Command.Command.validate_arguments(self,args)


