########################################################################
#
# File Name:            __init__.py
#
# Documentation:        http://docs.4suite.org/4XSLT/__init__.py.html
#
"""
WWW: http://4suite.org/4XSLT         e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""
import sys, string
XSL_NAMESPACE='http://www.w3.org/1999/XSL/Transform'

import Ft

from distutils import version
pyxml_required = version.StrictVersion(Ft.__pyxml_version__)
try:
    import xml
    xml_version = xml.version_info
except:
    xml_version = (0, 0, 0)
del version

if xml_version < pyxml_required.version:
    print """
    PyXML v%s is required for 4Suite.  It is available at
    http://sourceforge.net/projects/pyxml.
    """ % str(pyxml_required)
    sys.exit(1)


import xml.dom.ext
from xml import xpath
from xml.xpath import Util, g_xpathRecognizedNodes
from Ft.Lib import pDomlette

g_extElements = {}
g_xsltRecognizedNodes = g_xpathRecognizedNodes + [pDomlette.Node.DOCUMENT_FRAGMENT_NODE]


from types import StringType, ListType
g_stringTypes = [StringType]
try:
    from types import UnicodeType
    g_stringTypes.append(UnicodeType)
except:
    pass


def RegisterExtensionModules(moduleNames, moduleList=g_extElements):
    mod_names = moduleNames[:]
    mods = []
    for mod_name in mod_names:
        module_used = 0
        if mod_name:
            mod = __import__(mod_name, {}, {}, ['ExtElements', 'ExtFunctions'])
            if hasattr(mod, 'ExtFunctions'):
                xpath.g_extFunctions.update(mod.ExtFunctions)
                module_used = 1
            if hasattr(mod, 'ExtElements'):
                moduleList.update(mod.ExtElements)
                module_used = 1
            module_used and mods.append(mod)
    return mods


class XsltException(Exception):
    def __init__(self, errorCode, *args):
        self.errorCode = errorCode
        msg = MessageSource.g_errorMessages[errorCode] % args
        #self.element = element
        #self.message = _("While processing uri %s, line %d, column %d\n%s" % (
        #                 element.baseUri, element._ft_lineNumber,
        #                 element._ft_columnNumber, msg))
        Exception.__init__(self, msg)
        return

class XsltElement(pDomlette.Element):
    _ft_lineNumber = '??'
    _ft_columnNumber = '??'
    
    def __init__(self, doc, uri, localName, prefix, baseUri, importIndex=0):
        pDomlette.Element.__init__(self, doc, uri, localName, prefix)
        self.baseUri = baseUri
        self.importIndex = importIndex
        return

    def parseAVT(self, avt):
        try:
            return AttributeValueTemplate.AttributeValueTemplate(avt)
        except SyntaxError, error:
            raise XsltException(Error.INVALID_AVT, self.baseUri,
                                self._ft_lineNumber, self._ft_columnNumber,
                                str(error))
        except XsltException, error:
            raise XsltException(Error.INVALID_AVT, self.baseUri,
                                self._ft_lineNumber, self._ft_columnNumber,
                                error.args[0])

    def parseExpression(self, expression):
        p = xpath.parser.new()
        try:
            return p.parse(expression)
        except SyntaxError, error:
            raise XsltException(Error.INVALID_EXPRESSION, self.baseUri, 
                                self._ft_lineNumber, self._ft_columnNumber,
                                str(error))

    def parsePattern(self, pattern):
        p = parser.new()
        try:
            return p.parse(pattern)
        except SyntaxError, error:
            raise XsltException(Error.INVALID_PATTERN, self.baseUri, 
                                self._ft_lineNumber, self._ft_columnNumber,
                                str(error))

    def setup(self):
        self._nss = xml.dom.ext.GetAllNs(self)
        return

    def prime(self, processor, context):
        return

    def idle(self, processor):
        return

    def instantiate(self, context, processor):
        for child in self.childNodes:
            if (child.namespaceURI, child.localName) == (XSL_NAMESPACE, 'fallback'):
                child.instantiate(context, processor)
        return (context,)

    def __repr__(self):
        return "<XsltElement at %x: '%s', %d attrs, %d children>" % (
            id(self),
            self.nodeName,
            len(self.attributes),
            len(self.childNodes))

    def __getinitargs__(self):
        return (None, self.namespaceURI, self.localName, self.prefix,
                self.baseUri)

    def __getstate__(self):
         base_state = pDomlette.Element.__getstate__(self)
         new_state = (base_state, self.baseUri, self.importIndex,
                      self._ft_lineNumber, self._ft_columnNumber)
         return new_state

    def __setstate__(self, state):
        pDomlette.Element.__setstate__(self, state[0])
        self.baseUri = state[1]
        self.importIndex = state[2]
        self._ft_lineNumber = state[3]
        self._ft_columnNumber = state[4]
        return


class Error:
    INTERNAL_ERROR = 1
    PATTERN_SYNTAX = 2
    PATTERN_SEMANTIC = 3
    NO_STYLESHEET = 4
    AVT_SYNTAX = 5
    STYLESHEET_MISSING_VERSION = 6
    STYLESHEET_MISSING_VERSION_NOTE1 = 7
    STYLESHEET_PARSE_ERROR = 8
    SOURCE_PARSE_ERROR = 9
    XSL_STYLESHEET_NOT_DOCELEM = 10

    TOP_LEVEL_ELEM_WITH_NULL_NS = 10
    XSLT_ILLEGAL_ATTR = 11
    XSLT_ILLEGAL_ELEMENT = 12
    STYLESHEET_ILLEGAL_ROOT = 13
    CIRCULAR_VAR = 14
    
    WHEN_AFTER_OTHERWISE = 111
    MULTIPLE_OTHERWISE = 112

    APPLYIMPORTS_WITH_NULL_CURR_TPL = 120
    
    DUPLICATE_NAMESPACE_ALIAS = 300
    DUPLICATE_TOP_LEVEL_VAR = 301
    KEY_WITH_RTF_CONTEXT = 310

    #xsl:import and xsl:include
    ILLEGAL_IMPORT = 130
    IMPORT_NOT_FOUND = 131
    INCLUDE_NOT_FOUND = 132

    #xsl:choose
    ILLEGAL_CHOOSE_CHILD = 140
    CHOOSE_REQUIRES_WHEN_CHILD = 141
    CHOOSE_WHEN_AFTER_OTHERWISE = 142
    CHOOSE_MULTIPLE_OTHERWISE = 143

    #xsl:call-template
    ILLEGAL_CALLTEMPLATE_CHILD = 150
    NAMED_TEMPLATE_NOT_FOUND = 151

    #xsl:template
    ILLEGAL_TEMPLATE_PRIORITY = 160

    #xsl:attribute
    ATTRIBUTE_ADDED_AFTER_ELEMENT = 170
    ATTRIBUTE_MISSING_NAME = 171

    #xsl:element
    UNDEFINED_ATTRIBUTE_SET = 180

    #xsl:for-each
    INVALID_FOREACH_SELECT = 190

    #xsl:value-of
    VALUEOF_MISSING_SELECT = 200

    #xsl:copy-of
    COPYOF_MISSING_SELECT = 210

    #xsl:text
    ILLEGAL_TEXT_CHILD = 220

    #xsl:apply-template
    ILLEGAL_APPLYTEMPLATE_CHILD = 230

    #xsl:when
    WHEN_MISSING_TEST = 240

    #xsl:attribute-set
    ILLEGAL_ATTRIBUTESET_CHILD = 250
    ATTRIBUTESET_REQUIRES_NAME = 251

    #xsl:param
    ILLEGAL_PARAM = 260
    ILLEGAL_PARAM_PARENT = 261
    ILLEGAL_SHADOWING = 262

    # patterns and expressions
    INVALID_PATTERN = 1000
    INVALID_EXPRESSION = 1001
    INVALID_AVT = 1002

    ILLEGAL_SORT_DATA_TYPE_VALUE = 2010
    ILLEGAL_SORT_CASE_ORDER_VALUE = 2011
    ILLEGAL_SORT_ORDER_VALUE = 2012
    
    ILLEGAL_NUMBER_GROUPING_SIZE_VALUE = 2020
    ILLEGAL_NUMBER_LEVEL_VALUE = 2021
    ILLEGAL_NUMBER_LETTER_VALUE_VALUE = 2022
    ILLEGAL_NUMBER_FORMAT_VALUE = 2023

    INVALID_NAMESPACE_ALIAS = 2030

    WRONG_NUMBER_OF_ARGUMENTS = 5000
    WRONG_ARGUMENT_TYPE = 5001

    RESTRICTED_OUTPUT_VIOLATION = 7000

    FEATURE_NOT_SUPPORTED = 9999

    STYLESHEET_REQUESTED_TERMINATION = 10000


class OutputParameters:
    
    _attrnames=['method', 'version', 'encoding',
                'omitXmlDeclaration', 'standalone', 'doctypeSystem',
                'doctypePublic', 'mediaType', 'cdataSectionElements',
                'indent']
    
    def __init__(self):
        self._attrchanged=[]
        #Initialize with defaults according to spec
        self.set('method',None,check=0,default=1)             # xml,html,text,QName,auto
        self.set('version',"1.0",check=0,default=1)           # NMToken, opt
        self.set('encoding',None,check=0,default=1)           # string, opt
        self.set('omitXmlDeclaration','no',check=0,default=1) # y/n, opt, default no
        self.set('standalone',None,check=0,default=1)         # y/n, opt, default None
        self.set('doctypeSystem',None,check=0,default=1)      # string, opt
        self.set('doctypePublic',None,check=0,default=1)      # string, opt
        self.set('mediaType',None,check=0,default=1)          # string, opt
        self.set('cdataSectionElements',[],check=0,default=1) # QNames. opt
        self.set('indent','no',check=0,default=1)             # y/n, opt, default no

    def __setattr__(self, attr, value):
        if attr in self._attrnames:
            # check value depending on attribute
            self.set(attr, value)
        else:
            self.__dict__[attr]=value

    def setDefault(self, attr, value):
        if attr not in self._attrchanged:
            self.set(attr, value, default=1)

    def set(self, attr, value, check=1, default=0):
        if check==1:
            if attr in ['omitXmlDeclaration', 'standalone', 'indent']:
                if value not in ['yes', 'no']:
                    raise ValueError, "%s must be either 'yes' or 'no' (got %s)"%(attr, repr(value))
            elif attr=='mediaType':
                if type(value) in g_stringTypes:
                    st=string.split(value,'/')
                    if len(st)!=2:
                        raise ValueError, "mediaType must look like 'type/subtype' (got %s)"%repr(value)
                else:
                    raise ValueError, "mediaType must be a string (got %s)"%repr(value)
            elif attr in ['doctypeSystem', 'doctypePublic', 'encoding',
                          'version', 'method']:
                if type(value) not in g_stringTypes:
                    raise ValueError, "%s must be a string (%s, %s)"%(attr, str(value), type(value))
            elif attr=='cdataSectionElements':
                if type(value)!=ListType:
                    raise ValueError, "cdataSectionElements must a list of QNames (got %s)"%repr(value)
        if default==0 or (default==1 and attr not in self._attrchanged):
            self.__dict__[attr]=value
        if default==0 and attr not in self._attrchanged:
            self._attrchanged.append(attr)

    def avtParsePrep(self, node, nss):
        self._cache_nss = nss
        self._avt_method = AttributeValueTemplate.AttributeValueTemplate(node.getAttributeNS('', 'method') or 'xml')
        self._avt_version = AttributeValueTemplate.AttributeValueTemplate(node.getAttributeNS('', 'version'))
        self._avt_encoding = AttributeValueTemplate.AttributeValueTemplate(node.getAttributeNS('', 'encoding'))
        self._avt_omitXmlDecl = AttributeValueTemplate.AttributeValueTemplate(node.getAttributeNS('', 'omit-xml-declaration'))
        self._avt_standalone = AttributeValueTemplate.AttributeValueTemplate(node.getAttributeNS('', 'standalone'))
        self._avt_doctypeSystem = AttributeValueTemplate.AttributeValueTemplate(node.getAttributeNS('', 'doctype-system'))
        self._avt_doctypePublic = AttributeValueTemplate.AttributeValueTemplate(node.getAttributeNS('', 'doctype-public'))
        self._avt_mediaType = AttributeValueTemplate.AttributeValueTemplate(node.getAttributeNS('', 'media-type'))
        self._avt_cdataSecElem = AttributeValueTemplate.AttributeValueTemplate(node.getAttributeNS('', 'cdata-section-elements'))
        self._avt_indent = AttributeValueTemplate.AttributeValueTemplate(node.getAttributeNS('', 'indent'))
        return

    def avtParse(self, context):
        method = self._avt_method.evaluate(context)
        if method: self.method = method
        version = self._avt_version.evaluate(context)
        if version: self.version = version
        encoding = self._avt_encoding.evaluate(context)
        if encoding: self.encoding = encoding
        omit_xml_decl = self._avt_omitXmlDecl.evaluate(context)
        if omit_xml_decl: self.omitXmlDeclaration = omit_xml_decl
        standalone = self._avt_standalone.evaluate(context)
        if standalone: self.standalone = standalone
        doctype_system = self._avt_doctypeSystem.evaluate(context)
        if doctype_system: self.doctypeSystem = doctype_system
        doctype_public = self._avt_doctypePublic.evaluate(context)
        if doctype_public: self.doctypePublic = doctype_public
        media_type = self._avt_mediaType.evaluate(context)
        if media_type: self.mediaType = media_type
        self.cdataSectionElements = []
        qnames = string.splitfields(self._avt_cdataSecElem.evaluate(context))
        for qname in qnames:
            self.cdataSectionElements.append(Util.ExpandQName(qname, namespaces=self._cache_nss))
        indent = self._avt_indent.evaluate(context)
        if indent: self.indent = indent
        return

    def parse(self, node, nss):
        """
        parses the specified node for valid xsl:output attributes
        and stores their values internally.
        if called repeatedly, it will overwrite old values (this
        is by the specs, cause the last xsl:output element is the
        the one with most precedence).
        """
        method = node.getAttributeNS('', 'method')
        if method: self.method = method
        version = node.getAttributeNS('', 'version')
        if version: self.version = version
        encoding = node.getAttributeNS('', 'encoding')
        if encoding: self.encoding = encoding
        omit_xml_decl = node.getAttributeNS('', 'omit-xml-declaration')
        if omit_xml_decl: self.omitXmlDeclaration = omit_xml_decl
        standalone = node.getAttributeNS('', 'standalone')
        if standalone: self.standalone = standalone
        doctype_system = node.getAttributeNS('', 'doctype-system')
        if doctype_system: self.doctypeSystem = doctype_system
        doctype_public = node.getAttributeNS('', 'doctype-public')
        if doctype_public: self.doctypePublic = doctype_public
        media_type = node.getAttributeNS('', 'media-type')
        if media_type: self.mediaType = media_type
        self.cdataSectionElements = []
        qnames = string.splitfields(node.getAttributeNS('', 'cdata-section-elements'))
        for qname in qnames:
            self.cdataSectionElements.append(Util.ExpandQName(qname, namespaces=nss))
        indent = node.getAttributeNS('', 'indent')
        if indent: self.indent = indent
        return


g_registered = 0

def Register():
    import os,string
    from xml.xslt import XsltFunctions, BuiltInExtElements, Exslt
    xpath.g_extFunctions.update(Exslt.ExtFunctions)
    xpath.g_extFunctions.update(XsltFunctions.ExtFunctions)
    if os.environ.has_key('EXTMODULES'):
        RegisterExtensionModules(
            string.split(os.environ["EXTMODULES"], ':')
            )
    g_extElements.update(Exslt.ExtElements)
    g_extElements.update(BuiltInExtElements.ExtElements)
    global g_registered
    g_registered = 1

try:
    import XPatternParserc
    parser = XPatternParserc
except:
    import XPatternParser
    parser = XPatternParser

def Init():
    pass

Init()

import MessageSource
import AttributeValueTemplate
