########################################################################
#
# File Name: 		TimeImp.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/DateFactory.py.html
#
"""
Implements the Time interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""
#"

class TimeImp:


    GMT = 0
    GMT1 = 1
    GMT2 = 2
    GMT3 = 3
    GMT4 = 4
    GMT5 = 5
    GMT6 = 6
    GMT7 = 7
    GMT8 = 8
    GMT9 = 9
    GMT10 = 10
    GMT11 = 11
    GMT12 = 12
    GMT_1 = -1
    GMT_2 = -2
    GMT_3 = -3
    GMT_4 = -4
    GMT_5 = -5
    GMT_6 = -6
    GMT_7 = -7
    GMT_8 = -8
    GMT_9 = -9
    GMT_10 = -10
    GMT_11 = -11
    GMT_12 = -12

    USeastern = -5
    UScenteral = -6
    USmountain = -7
    USpacific = -8


    def __init__(self,db,data):
        if data is None:
            data = (0,0,0,0,0,0)
        elif len(data) == 2:
            data = map(lambda x:x[0],data[1])

        (self._hour,self._minute,self._second,self._millisecond,self._tz_hour,self._tz_minute) = data

        self.value = self._hour*3600 + self._minute*60 + self._second + float(self._millisecond) / 1000.0

    def hour(self):
        return self._hour

    def minute(self):
        return self._minute

    def second(self):
        return self._second

    def millisecond(self):
        return self._millisecond

    def tz_hour(self):
        return self._tz_hour

    def tz_minute(self):
        return self._tz_minute

    def is_equal(self,a_time):
        return self.value == a_time.value

    def is_greater(self,a_time):
        return self.value > a_time.value

    def is_greater_or_equal(self,a_time):
        return self.value >= a_time.value

    def is_less(self,a_time):
        return self.value < a_time.value

    def is_less_or_equal(self,a_time):
        return self.value <= a_time.value

    def is_between(self,a_time,b_time):
        return self.value >= a_time.value and self.value <= b_time.value

    def add_interval(self,an_interval):

        #Note, we ignore days
        hour = self._hour + an_interval.hour()
        minute = self._minute + an_interval.minute()
        second = self._second + an_interval.second()
        millisecond = self._millisecond + an_interval.millisecond()
        return TimeImp(None,(hour,minute,second,millisecond,self._tz_hour,self._tz_minute))
    
    def subtract_interval(self,an_interval):
        #Note, we ignore days
        hour = self._hour - an_interval.hour()
        minute = self._minute - an_interval.minute()
        second = self._second - an_interval.second()
        millisecond = self._millisecond - an_interval.millisecond()
        return TimeImp(None,(hour,minute,second,millisecond,self._tz_hour,self._tz_minute))

    def subtract_time(self,a_time):
        #FIXME this may not work with different ime zones?
        from Ft.Ods import Interval
        return Interval.Interval(None,self.value - a_time.value)

    def __str__(self):
        return "<Time at %x %s:%s:%s.%s>"% (id(self),self.hour(),self.minute(),self.second(),self.millisecond())

    def __cmp__(self,other):
        if isinstance(other,TimeImp):
            return not (self.hour() == other.hour() and self.minute() == other.minute() and self.second() == other.second() and self.millisecond() == other.millisecond() and self.tz_hour() == other.tz_hour() and self.tz_minute() == other.tz_minute())
        return 1


    def _4ods_getData(self):
        return (None,((self.hour(),),(self.minute(),),(self.second(),),(self.millisecond(),),(self.tz_hour(),),(self.tz_minute(),)))


    def _4ods_isModified(self):
        return 1


