<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY fschema "http://schemas.4suite.org/4ss">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fcore="http://xmlns.4suite.org/4ss/score" xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" xmlns:fhttp="http://xmlns.4suite.org/4ss/http" xmlns:exslt="http://exslt.org/common" xmlns:exslt-set="http://exslt.org/sets" xmlns:exslt-math="http://exslt.org/math" xmlns:exslt-functions="http://exslt.org/functions" xmlns:exslt-date-time="http://exslt.org/dates-and-times" xmlns:dc="&dc;" xmlns:fres="&fres;" xmlns:rdf="&rdf;" xmlns:f="&f;" xmlns:fschema="http://schemas.4suite.org/4ss" extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">
      
  <xsl:include href="menu-includes.xslt"/>
  <xsl:include href="managerRequestProcessor.xslt"/>
  <!-- the managers -->
  <xsl:include href="container.xslt"/>
  <xsl:include href="user.xslt"/>
  <xsl:include href="group.xslt"/>
  <xsl:include href="repository.xslt"/>
  <xsl:include href="rawfile.xslt"/>
  <xsl:include href="urireference.xslt"/>
  <xsl:include href="server.xslt"/>
  <xsl:include href="alias.xslt"/>
  <xsl:include href="command.xslt"/>
  <xsl:param name="fres:uri-path"/>
  <xsl:param name="fres:resource-id"/>
  <xsl:variable name="genericManage" select="fhttp:get-query-args()//genericManage"/>
  <xsl:variable name="managedResourcePath" select="fhttp:get-query-args()//managedResourcePath"/>
  <xsl:variable name="action" select="string(fhttp:get-query-args()//action)"/>
  <xsl:variable name="newResourceType" select="fhttp:get-query-args()//newResourceType"/>
  <xsl:variable name="resourcePath">
    <xsl:choose>
      <xsl:when test="fhttp:get-query-args()//nonXMLPath">
        <xsl:value-of select="fhttp:get-query-args()//nonXMLPath"/>
      </xsl:when>
      <xsl:when test="$genericManage">
        <xsl:value-of select="$managedResourcePath"/>
      </xsl:when>
      <xsl:when test="f:ends-with($fres:uri-path,'/')">
        <xsl:value-of select="substring($fres:uri-path,0,string-length($fres:uri-path))"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$fres:uri-path"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="resourceType" select='frdf:complete($resourcePath,"&fschema;#type","")/Object'/>
  <xsl:variable name="displayName">
    <xsl:choose>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#repository"'>Repository</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#container"'>Container</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#group"'>Group</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#user"'>User</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#rawfile"'>Raw File</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#urireferencefile"'>Uri Reference File</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#xmldocument"'>XML Document</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#xpathdocumentdefinition"'>XPATH Document Definition</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#xsltdocumentdefinition"'>XSLT Document Definition</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#xsltdocument"'>XSLT Document</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#schrematrondocument"'>Schematron Document</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#rdfdocument"'>Rdf Document</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#documentdefinition"'>Document Definition</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#command"'>4SS Command</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#server"'>Server</xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#alias"'>Alias</xsl:when>
      <xsl:otherwise>Unknown Resource</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:output method="html"/>
  <xsl:template match="/">
    <!--<f:dump-vars/>-->
    <xsl:variable name="help-reference">
      <xsl:choose>
        <xsl:when test="$resourcePath = '/ftss/dashboard/DashboardConfig.xml'">configuration</xsl:when>
        <xsl:when test='starts-with($genericManage,"Edit")'>rawfile-manager</xsl:when>
        <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#urireferencefile"'>urireference-manager</xsl:when>
        <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#repository"'/>
        <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#container"'>container-manager</xsl:when>
        <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#command"'>command-manager</xsl:when>
        <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#server"'>server-manager</xsl:when>
        <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#user"'>user-manager</xsl:when>
        <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#group"'>group-manager</xsl:when>
        <xsl:otherwise>rawfile-manager</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:call-template name="menus">
      <xsl:with-param name="displayName" select="$displayName"/>
      <xsl:with-param name="help-reference" select="string($help-reference)"/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="body">
    <xsl:choose>
      <xsl:when test="fhttp:get-query-args()//basic">
        <xsl:call-template name="rawfile-manager"/>
      </xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#urireferencefile"'>
        <xsl:call-template name="urireference-manager"/>
      </xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#repository"'>
        <xsl:call-template name="container-manager"/>
      </xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#container"'>
        <xsl:call-template name="container-manager"/>
      </xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#command"'>
        <xsl:call-template name="command-manager"/>
      </xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#server"'>
        <xsl:call-template name="server-manager"/>
      </xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#user"'>
        <xsl:call-template name="user-manager"/>
      </xsl:when>
      <xsl:when test='$resourceType = "http://schemas.4suite.org/4ss#group"'>
        <xsl:call-template name="group-manager"/>
      </xsl:when>
      <xsl:otherwise>
        <!-- we know it's a resource w/ xml or text content. FIXME: we should branch off its IMT -->
        <xsl:call-template name="rawfile-manager"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="genericManager">
    <xsl:variable name="actionLabel">
      <xsl:choose>
        <xsl:when test='starts-with($genericManage,"Edit")'>Edit XML</xsl:when>
        <xsl:when test='contains($genericManage,"Meta")'>View Meta Data</xsl:when>
        <xsl:otherwise>View content</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="imt" select="frdf:complete($resourcePath,'http://schemas.4suite.org/4ss#rawfile.imt','')/Object"/>
    <tr>
      <td colspan="3" class="titleBar">
        <xsl:value-of select="concat('Generic Manager (',$actionLabel,')')"/>
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <span class="blackTitle">Generic Resource Path:</span>
        <span class="path">
          <xsl:call-template name="PathLink">
            <xsl:with-param name="path" select="$managedResourcePath"/>
          </xsl:call-template>
        </span>
      </td>
      <td align="right">[<a href="{$managedResourcePath}">Default Manager</a>]</td>
    </tr>
    <xsl:choose>
      <xsl:when test='starts-with($genericManage,"Edit")'>
        <!-- edit xml requested -->
        <xsl:call-template name="rawfile-manager"/>
      </xsl:when>
      <xsl:when test='contains($genericManage,"Meta")'>
        <xsl:message>redirecting to metadata view</xsl:message>
        <!-- view metadata requested (triclops redirect)-->
        <!--
        <xsl:call-template name="metaDataView"/>
        -->
        <fhttp:response-uri uri="/?xslt=/ftss/dashboard/Triclops.xslt&amp;versa-query=@'{$resourcePath}'&amp;queryType=Graph"/>
        <!--
        <xsl:choose>
          <xsl:when test="$resourceType = 'http://schemas.4suite.org/4ss#urireferencefile'"/>
          <xsl:when test="$resourceType = 'http://schemas.4suite.org/4ss#rawfile'">
            <fhttp:response-uri uri="/?nonXMLPath={$resourcePath}&amp;xslt=/ftss/dashboard/Triclops.xslt&amp;uri={$resourcePath}"/>
          </xsl:when>
          <xsl:otherwise>
            <fhttp:response-uri uri="{$resourcePath}?xslt=/ftss/dashboard/Triclops.xslt&amp;uri={$resourcePath}"/>
          </xsl:otherwise>
        </xsl:choose>-->
      </xsl:when>
      <xsl:otherwise>
        <!-- view content requested -->
        <xsl:choose>
          <xsl:when test="$imt = 'text/xml'">
            <fhttp:response-uri uri="{$resourcePath}?xslt=/ftss/data/decorated-xml.xslt"/>
          </xsl:when>
          <xsl:otherwise>
            <fhttp:response-uri uri="{$resourcePath}"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="metaDataView">
    <tr>
      <th colspan="3">Outgoing RDF Arcs:</th>
    </tr>
    <tr>
      <th align="middle">Subject</th>
      <th align="middle">Predicate</th>
      <th align="middle">Object</th>
    </tr>
    <xsl:for-each select="frdf:complete($managedResourcePath,frdf:any(),frdf:any())">
      <tr>
        <th class="grayBar">
          <xsl:value-of select="Subject"/>
        </th>
        <td>
          <xsl:value-of select="Predicate"/>
        </td>
        <td>
          <xsl:value-of select="Object"/>
        </td>
      </tr>
    </xsl:for-each>
    <tr>
      <th colspan="3">Incoming RDF Arcs:</th>
    </tr>
    <tr>
      <th align="middle">Subject</th>
      <th align="middle">Predicate</th>
      <th align="middle">Object</th>
    </tr>
    <xsl:for-each select="frdf:complete(frdf:any(),frdf:any(),$managedResourcePath)">
      <tr>
        <td>
          <xsl:value-of select="Subject"/>
        </td>
        <td>
          <xsl:value-of select="Predicate"/>
        </td>
        <th class="grayBar">
          <xsl:value-of select="Object"/>
        </th>
      </tr>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
