
from Ft.Lib.CommandLine import CommandLineTestUtil
import test_prime
from Ft.Server.Client import Core

from Server.Client.Core import test_helper


FIRST_CONTAINER = '/' + test_prime.BASE_CONTAINER + '/con1'
DEEP_CONTAINER = '/' + test_prime.BASE_CONTAINER + '/con2/con3'


def val1(tester):
    repo = test_helper.GetRepo(tester)
    try:
        return repo.hasResource(FIRST_CONTAINER)
    finally:
        repo.txRollback()

def val2(tester):
    repo = test_helper.GetRepo(tester)
    try:
        return repo.hasResource(DEEP_CONTAINER)
    finally:
        repo.txRollback()
        

def Init(repo):
    if repo.hasResource(FIRST_CONTAINER):
        repo.deleteResource(FIRST_CONTAINER)
    if repo.hasResource('/' + test_prime.BASE_CONTAINER + '/con2'):
        repo.deleteResource('/' + test_prime.BASE_CONTAINER + '/con2')
    

def Test(tester):

    test_prime.InitRepo(tester,Init,['4ss','create','container'])

    baseConfig = {'host':tester.test_data['ftrpc-host'],
                  'port':tester.test_data['ftrpc-port'],
                  'username':tester.test_data['userName'],
                  'password':tester.test_data['password'],
                  }

    #No options, just create a container
    tr1 = CommandLineTestUtil.TestRun('Basic Create',
                                      baseConfig,
                                      [FIRST_CONTAINER],
                                      validationFunc = val1)


    cfg = baseConfig.copy()
    cfg['create-parents'] = None
    tr2 = CommandLineTestUtil.TestRun('Deep Create',
                                      cfg,
                                      [DEEP_CONTAINER],
                                      validationFunc = val2)

    #Create on that already exists
    tr3 = CommandLineTestUtil.TestRun('Re Create Error',
                                      baseConfig,
                                      [FIRST_CONTAINER],
                                      expectedOut=expected_3%FIRST_CONTAINER)

    #Create one without permissions to execute
    uri = '/' + test_prime.BASE_CONTAINER + '/con1'
    cfg = baseConfig.copy()
    cfg['anonymous'] = None
    del cfg['username']
    del cfg['password']
    tr4 = CommandLineTestUtil.TestRun('No permissions to execute Error',
                                      cfg,
                                      [uri],
                                      expectedOut=expected_4)

    #No permissions to create
    uri = '/' + test_prime.BASE_CONTAINER + '/con3'
    cfg = baseConfig.copy()
    cfg['username'] = 'testUser'
    cfg['password'] = 'testUser'
    tr5 = CommandLineTestUtil.TestRun('No permissions to create Error',
                                      cfg,
                                      [uri],
                                      expectedOut=expected_5%test_prime.BASE_CONTAINER)


    t = CommandLineTestUtil.Test('4ss create container',[tr1,tr2,tr3,tr4,tr5])

    return t.test(tester)

expected_3 = "Path %s is already in the repository\n"
expected_4 = "You do not have 'execute' access to /ftss/commands/4ss.create.container\n"
expected_5 = "You do not have 'write' access to /%s\n"
