from Ft.Xml.Xslt import AttributeValueTemplate

def Test(tester):
    test_strings = ['Senatus{{populisque}}romae',
                    'Senatus{{{"populisque}}"}romae',
                    ''
        ]

    expected = [(['Senatus{populisque}romae'], []),
                (['Senatus{', 'romae'], ['"populisque}"']),
                ([''], [])
        ]

    combine = map(lambda a,b: (a,b), test_strings, expected)

    tester.startGroup("Attribute Value Templates")
    
    for input, expected in combine:
        avt = AttributeValueTemplate.AttributeValueTemplate(input)
        tester.startTest(input)
        plain = avt.__dict__['_plainParts']
        tester.compare(expected[0], plain)
        parsed = avt.__dict__['_parsedParts']
        if parsed:
            # Needed because of expression parsing
            parsed = ['"' + parsed[0].evaluate(None) + '"']
        tester.compare(expected[1], parsed)
        tester.testDone()

    tester.groupDone()
