from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model
from Ft.Rdf import Statement

def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model(db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('Inference Assert')
    
    test.startTest('Syntax')
    from Ft.Rdf.Inference import InferenceEngine
    from Ft.Rdf.Parsers.Ril import RilParserImp
    test.testDone()

    test.startTest('Parsed Assert')
    exp = """<?xml version = "1.0"?>
<ril:expression xmlns:ril = "http://namespaces.rdfinference.org/ril" xmlns:ft = "http://namespaces.fourthought.com/test">
  <ril:assert>
    <ft:wet>
        <ril:string-list>
          <ril:string>Mike</ril:string>
          <ril:string>Uche</ril:string>
        </ril:string-list>
    </ft:wet>
    <ft:creator>
        <ril:string>Mike</ril:string>
        <ril:string-list>
          <ril:string>A Book</ril:string>
          <ril:string>Another Book</ril:string>
        </ril:string-list>
    </ft:creator>
  </ril:assert>
</ril:expression>
"""

    p = RilParserImp.RilParserImp()
    defs = p.parse(exp)

    infeng = CreateInfEng()
    infeng.execute(defs)
    
    test.compare(1, infeng.contains(Statement.Statement("Mike","http://namespaces.fourthought.com/test#wet","1")))
    test.compare(1, infeng.contains(Statement.Statement("Uche","http://namespaces.fourthought.com/test#wet","1")))
    test.compare(1, infeng.contains(Statement.Statement("Mike","http://namespaces.fourthought.com/test#creator","A Book")))
    test.compare(1, infeng.contains(Statement.Statement("Mike","http://namespaces.fourthought.com/test#creator","Another Book")))

    test.testDone()
    test.groupDone()


if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)

