

from Ft.Server.Common import ResourceTypes, ValidationInfo, Schema

import test_helper

from Ft.Server.Server import FtServerServerException, Error

from Ft.Server import FTSERVER_NAMESPACE

from Ft.Xml.XLink import XLINK_NAMESPACE

def test_create(tester):


    tester.startTest("Create Server Document")

    #Create XML Document
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.createDocument('server',SERVER1,forcedType=ResourceTypes.ResourceType.SERVER)


    dMd = doc.getMetaDataResource().getContent()
    dContent = doc.getContent()

    cd,md = test_helper.TestMetaData(tester,
                                     dMd,
                                     'server',
                                     ResourceTypes.ResourceType.SERVER,
                                     [],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(dContent)),
                                     [],
                                     )

    tester.compare(SERVER1,dContent)

    test_helper.TestServerRdf(tester,
                              repo,
                              '/test/server',
                              len(dContent),
                              tester.test_data['userName'],
                              cd,
                              md,
                              Schema.NULL_DOCDEF,
                              'foo',
                              'Ft.Server.Server.FtRpc.FtRpcHandler',
                              1,
                              )




    repo.txCommit()

    tester.testDone()
    return


def test_state(tester):


    tester.startTest("Change Server State")

    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.fetchResource('server')

    doc.setStopped()
    
    dMd = doc.getMetaDataResource().getContent()
    dContent = doc.getContent()

    cd,md = test_helper.TestMetaData(tester,
                                     dMd,
                                     'server',
                                     ResourceTypes.ResourceType.SERVER,
                                     [],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(dContent)),
                                     [],
                                     )

    test_helper.TestServerRdf(tester,
                              repo,
                              '/test/server',
                              len(dContent),
                              tester.test_data['userName'],
                              cd,
                              md,
                              Schema.NULL_DOCDEF,
                              'foo',
                              'Ft.Server.Server.FtRpc.FtRpcHandler',
                              0,
                              )



    doc.setRunning()
    
    dMd = doc.getMetaDataResource().getContent()
    dContent = doc.getContent()

    cd,md = test_helper.TestMetaData(tester,
                                     dMd,
                                     'server',
                                     ResourceTypes.ResourceType.SERVER,
                                     [],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(dContent)),
                                     [],
                                     )

    test_helper.TestServerRdf(tester,
                              repo,
                              '/test/server',
                              len(dContent),
                              tester.test_data['userName'],
                              cd,
                              md,
                              Schema.NULL_DOCDEF,
                              'foo',
                              'Ft.Server.Server.FtRpc.FtRpcHandler',
                              1,
                              )



    repo.txCommit()

    tester.testDone()
    return



def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        repo.deleteResource('/test')
    repo.createContainer("/test",1)
    repo.txCommit()
    tester.testDone()



SERVER1="""<ftss:Server xmlns:ftss="%s" xmlns:dc="%s" name='foo'>
  <dc:Description>This is a test server</dc:Description>
  <ftss:Port>8080</ftss:Port>
  <ftss:Handler>Ft.Server.Server.FtRpc.FtRpcHandler</ftss:Handler>
  <ftss:Status running='1'/>
</ftss:Server>
""" % (FTSERVER_NAMESPACE,Schema.DC)




def Test(tester):

    cleanup(tester)
    test_create(tester)
    test_state(tester)


