# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContentSummary(Model):
    """Data Lake Store content summary information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar directory_count: the number of directories.
    :vartype directory_count: long
    :ivar file_count: the number of files.
    :vartype file_count: long
    :ivar length: the number of bytes used by the contet.
    :vartype length: long
    :ivar space_consumed: the disk space consumed by the content.
    :vartype space_consumed: long
    """ 

    _validation = {
        'directory_count': {'readonly': True},
        'file_count': {'readonly': True},
        'length': {'readonly': True},
        'space_consumed': {'readonly': True},
    }

    _attribute_map = {
        'directory_count': {'key': 'directoryCount', 'type': 'long'},
        'file_count': {'key': 'fileCount', 'type': 'long'},
        'length': {'key': 'length', 'type': 'long'},
        'space_consumed': {'key': 'spaceConsumed', 'type': 'long'},
    }

    def __init__(self):
        self.directory_count = None
        self.file_count = None
        self.length = None
        self.space_consumed = None
