# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._api_management_client_enums import *


class AccessInformationCollection(msrest.serialization.Model):
    """Paged AccessInformation list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.AccessInformationContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AccessInformationContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        """
        super(AccessInformationCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AccessInformationContract(Resource):
    """Tenant Settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar id_properties_id: Access Information type ('access' or 'gitAccess').
    :vartype id_properties_id: str
    :ivar principal_id: Principal (User) Identifier.
    :vartype principal_id: str
    :ivar enabled: Determines whether direct access is enabled.
    :vartype enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id_properties_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id_properties_id: Access Information type ('access' or 'gitAccess').
        :paramtype id_properties_id: str
        :keyword principal_id: Principal (User) Identifier.
        :paramtype principal_id: str
        :keyword enabled: Determines whether direct access is enabled.
        :paramtype enabled: bool
        """
        super(AccessInformationContract, self).__init__(**kwargs)
        self.id_properties_id = id_properties_id
        self.principal_id = principal_id
        self.enabled = enabled


class AccessInformationCreateParameters(msrest.serialization.Model):
    """Tenant access information update parameters.

    :ivar principal_id: Principal (User) Identifier.
    :vartype principal_id: str
    :ivar primary_key: Primary access key. This property will not be filled on 'GET' operations!
     Use '/listSecrets' POST request to get the value.
    :vartype primary_key: str
    :ivar secondary_key: Secondary access key. This property will not be filled on 'GET'
     operations! Use '/listSecrets' POST request to get the value.
    :vartype secondary_key: str
    :ivar enabled: Determines whether direct access is enabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'primary_key': {'key': 'properties.primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'properties.secondaryKey', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword principal_id: Principal (User) Identifier.
        :paramtype principal_id: str
        :keyword primary_key: Primary access key. This property will not be filled on 'GET' operations!
         Use '/listSecrets' POST request to get the value.
        :paramtype primary_key: str
        :keyword secondary_key: Secondary access key. This property will not be filled on 'GET'
         operations! Use '/listSecrets' POST request to get the value.
        :paramtype secondary_key: str
        :keyword enabled: Determines whether direct access is enabled.
        :paramtype enabled: bool
        """
        super(AccessInformationCreateParameters, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.enabled = enabled


class AccessInformationSecretsContract(msrest.serialization.Model):
    """Tenant access information contract of the API Management service.

    :ivar id: Access Information type ('access' or 'gitAccess').
    :vartype id: str
    :ivar principal_id: Principal (User) Identifier.
    :vartype principal_id: str
    :ivar primary_key: Primary access key. This property will not be filled on 'GET' operations!
     Use '/listSecrets' POST request to get the value.
    :vartype primary_key: str
    :ivar secondary_key: Secondary access key. This property will not be filled on 'GET'
     operations! Use '/listSecrets' POST request to get the value.
    :vartype secondary_key: str
    :ivar enabled: Determines whether direct access is enabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        principal_id: Optional[str] = None,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Access Information type ('access' or 'gitAccess').
        :paramtype id: str
        :keyword principal_id: Principal (User) Identifier.
        :paramtype principal_id: str
        :keyword primary_key: Primary access key. This property will not be filled on 'GET' operations!
         Use '/listSecrets' POST request to get the value.
        :paramtype primary_key: str
        :keyword secondary_key: Secondary access key. This property will not be filled on 'GET'
         operations! Use '/listSecrets' POST request to get the value.
        :paramtype secondary_key: str
        :keyword enabled: Determines whether direct access is enabled.
        :paramtype enabled: bool
        """
        super(AccessInformationSecretsContract, self).__init__(**kwargs)
        self.id = id
        self.principal_id = principal_id
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.enabled = enabled


class AccessInformationUpdateParameters(msrest.serialization.Model):
    """Tenant access information update parameters.

    :ivar enabled: Determines whether direct access is enabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: Determines whether direct access is enabled.
        :paramtype enabled: bool
        """
        super(AccessInformationUpdateParameters, self).__init__(**kwargs)
        self.enabled = enabled


class AdditionalLocation(msrest.serialization.Model):
    """Description of an additional API Management resource location.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. The location name of the additional region among Azure Data center
     regions.
    :vartype location: str
    :ivar sku: Required. SKU properties of the API Management service.
    :vartype sku: ~api_management_client.models.ApiManagementServiceSkuProperties
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in the additional location. Available only for Basic, Standard, Premium and Isolated
     SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service which is deployed in an Internal Virtual Network in a particular additional location.
     Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :ivar public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
     Virtual Network deployed service in the location. Supported only for Premium SKU being deployed
     in Virtual Network.
    :vartype public_ip_address_id: str
    :ivar virtual_network_configuration: Virtual network configuration for the location.
    :vartype virtual_network_configuration:
     ~api_management_client.models.VirtualNetworkConfiguration
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Region.
    :vartype gateway_regional_url: str
    :ivar disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in this additional location.
    :vartype disable_gateway: bool
    :ivar platform_version: Compute Platform Version running the service. Possible values include:
     "undetermined", "stv1", "stv2", "mtv1".
    :vartype platform_version: str or ~api_management_client.models.PlatformVersion
    """

    _validation = {
        'location': {'required': True},
        'sku': {'required': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'platform_version': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ApiManagementServiceSkuProperties'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'public_ip_addresses': {'key': 'publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'privateIPAddresses', 'type': '[str]'},
        'public_ip_address_id': {'key': 'publicIpAddressId', 'type': 'str'},
        'virtual_network_configuration': {'key': 'virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'gateway_regional_url': {'key': 'gatewayRegionalUrl', 'type': 'str'},
        'disable_gateway': {'key': 'disableGateway', 'type': 'bool'},
        'platform_version': {'key': 'platformVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "ApiManagementServiceSkuProperties",
        zones: Optional[List[str]] = None,
        public_ip_address_id: Optional[str] = None,
        virtual_network_configuration: Optional["VirtualNetworkConfiguration"] = None,
        disable_gateway: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword location: Required. The location name of the additional region among Azure Data center
         regions.
        :paramtype location: str
        :keyword sku: Required. SKU properties of the API Management service.
        :paramtype sku: ~api_management_client.models.ApiManagementServiceSkuProperties
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
         Virtual Network deployed service in the location. Supported only for Premium SKU being deployed
         in Virtual Network.
        :paramtype public_ip_address_id: str
        :keyword virtual_network_configuration: Virtual network configuration for the location.
        :paramtype virtual_network_configuration:
         ~api_management_client.models.VirtualNetworkConfiguration
        :keyword disable_gateway: Property only valid for an Api Management service deployed in
         multiple locations. This can be used to disable the gateway in this additional location.
        :paramtype disable_gateway: bool
        """
        super(AdditionalLocation, self).__init__(**kwargs)
        self.location = location
        self.sku = sku
        self.zones = zones
        self.public_ip_addresses = None
        self.private_ip_addresses = None
        self.public_ip_address_id = public_ip_address_id
        self.virtual_network_configuration = virtual_network_configuration
        self.gateway_regional_url = None
        self.disable_gateway = disable_gateway
        self.platform_version = None


class ApiCollection(msrest.serialization.Model):
    """Paged API list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.ApiContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        """
        super(ApiCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class ApiContactInformation(msrest.serialization.Model):
    """API contact information.

    :ivar name: The identifying name of the contact person/organization.
    :vartype name: str
    :ivar url: The URL pointing to the contact information. MUST be in the format of a URL.
    :vartype url: str
    :ivar email: The email address of the contact person/organization. MUST be in the format of an
     email address.
    :vartype email: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        url: Optional[str] = None,
        email: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The identifying name of the contact person/organization.
        :paramtype name: str
        :keyword url: The URL pointing to the contact information. MUST be in the format of a URL.
        :paramtype url: str
        :keyword email: The email address of the contact person/organization. MUST be in the format of
         an email address.
        :paramtype email: str
        """
        super(ApiContactInformation, self).__init__(**kwargs)
        self.name = name
        self.url = url
        self.email = email


class ApiContract(Resource):
    """API details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar description: Description of the API. May include HTML formatting tags.
    :vartype description: str
    :ivar authentication_settings: Collection of authentication settings included into this API.
    :vartype authentication_settings: ~api_management_client.models.AuthenticationSettingsContract
    :ivar subscription_key_parameter_names: Protocols over which API is made available.
    :vartype subscription_key_parameter_names:
     ~api_management_client.models.SubscriptionKeyParameterNamesContract
    :ivar api_type: Type of API. Possible values include: "http", "soap", "websocket", "graphql".
    :vartype api_type: str or ~api_management_client.models.ApiType
    :ivar api_revision: Describes the revision of the API. If no value is provided, default
     revision 1 is created.
    :vartype api_revision: str
    :ivar api_version: Indicates the version identifier of the API if the API is versioned.
    :vartype api_version: str
    :ivar is_current: Indicates if API revision is current api revision.
    :vartype is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :ivar api_revision_description: Description of the API Revision.
    :vartype api_revision_description: str
    :ivar api_version_description: Description of the API Version.
    :vartype api_version_description: str
    :ivar api_version_set_id: A resource identifier for the related ApiVersionSet.
    :vartype api_version_set_id: str
    :ivar subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :vartype subscription_required: bool
    :ivar terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format of
     a URL.
    :vartype terms_of_service_url: str
    :ivar contact: Contact information for the API.
    :vartype contact: ~api_management_client.models.ApiContactInformation
    :ivar license: License information for the API.
    :vartype license: ~api_management_client.models.ApiLicenseInformation
    :ivar source_api_id: API identifier of the source API.
    :vartype source_api_id: str
    :ivar display_name: API name. Must be 1 to 300 characters long.
    :vartype display_name: str
    :ivar service_url: Absolute URL of the backend service implementing this API. Cannot be more
     than 2000 characters long.
    :vartype service_url: str
    :ivar path: Relative URL uniquely identifying this API and all of its resource paths within the
     API Management service instance. It is appended to the API endpoint base URL specified during
     the service instance creation to form a public URL for this API.
    :vartype path: str
    :ivar protocols: Describes on which protocols the operations in this API can be invoked.
    :vartype protocols: list[str or ~api_management_client.models.Protocol]
    :ivar api_version_set: Version set details.
    :vartype api_version_set: ~api_management_client.models.ApiVersionSetContractDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 0},
        'path': {'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'authentication_settings': {'key': 'properties.authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'properties.subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'properties.type', 'type': 'str'},
        'api_revision': {'key': 'properties.apiRevision', 'type': 'str'},
        'api_version': {'key': 'properties.apiVersion', 'type': 'str'},
        'is_current': {'key': 'properties.isCurrent', 'type': 'bool'},
        'is_online': {'key': 'properties.isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'properties.apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'properties.apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'properties.apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'properties.subscriptionRequired', 'type': 'bool'},
        'terms_of_service_url': {'key': 'properties.termsOfServiceUrl', 'type': 'str'},
        'contact': {'key': 'properties.contact', 'type': 'ApiContactInformation'},
        'license': {'key': 'properties.license', 'type': 'ApiLicenseInformation'},
        'source_api_id': {'key': 'properties.sourceApiId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'service_url': {'key': 'properties.serviceUrl', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'protocols': {'key': 'properties.protocols', 'type': '[str]'},
        'api_version_set': {'key': 'properties.apiVersionSet', 'type': 'ApiVersionSetContractDetails'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authentication_settings: Optional["AuthenticationSettingsContract"] = None,
        subscription_key_parameter_names: Optional["SubscriptionKeyParameterNamesContract"] = None,
        api_type: Optional[Union[str, "ApiType"]] = None,
        api_revision: Optional[str] = None,
        api_version: Optional[str] = None,
        is_current: Optional[bool] = None,
        api_revision_description: Optional[str] = None,
        api_version_description: Optional[str] = None,
        api_version_set_id: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        terms_of_service_url: Optional[str] = None,
        contact: Optional["ApiContactInformation"] = None,
        license: Optional["ApiLicenseInformation"] = None,
        source_api_id: Optional[str] = None,
        display_name: Optional[str] = None,
        service_url: Optional[str] = None,
        path: Optional[str] = None,
        protocols: Optional[List[Union[str, "Protocol"]]] = None,
        api_version_set: Optional["ApiVersionSetContractDetails"] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the API. May include HTML formatting tags.
        :paramtype description: str
        :keyword authentication_settings: Collection of authentication settings included into this API.
        :paramtype authentication_settings:
         ~api_management_client.models.AuthenticationSettingsContract
        :keyword subscription_key_parameter_names: Protocols over which API is made available.
        :paramtype subscription_key_parameter_names:
         ~api_management_client.models.SubscriptionKeyParameterNamesContract
        :keyword api_type: Type of API. Possible values include: "http", "soap", "websocket",
         "graphql".
        :paramtype api_type: str or ~api_management_client.models.ApiType
        :keyword api_revision: Describes the revision of the API. If no value is provided, default
         revision 1 is created.
        :paramtype api_revision: str
        :keyword api_version: Indicates the version identifier of the API if the API is versioned.
        :paramtype api_version: str
        :keyword is_current: Indicates if API revision is current api revision.
        :paramtype is_current: bool
        :keyword api_revision_description: Description of the API Revision.
        :paramtype api_revision_description: str
        :keyword api_version_description: Description of the API Version.
        :paramtype api_version_description: str
        :keyword api_version_set_id: A resource identifier for the related ApiVersionSet.
        :paramtype api_version_set_id: str
        :keyword subscription_required: Specifies whether an API or Product subscription is required
         for accessing the API.
        :paramtype subscription_required: bool
        :keyword terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format
         of a URL.
        :paramtype terms_of_service_url: str
        :keyword contact: Contact information for the API.
        :paramtype contact: ~api_management_client.models.ApiContactInformation
        :keyword license: License information for the API.
        :paramtype license: ~api_management_client.models.ApiLicenseInformation
        :keyword source_api_id: API identifier of the source API.
        :paramtype source_api_id: str
        :keyword display_name: API name. Must be 1 to 300 characters long.
        :paramtype display_name: str
        :keyword service_url: Absolute URL of the backend service implementing this API. Cannot be more
         than 2000 characters long.
        :paramtype service_url: str
        :keyword path: Relative URL uniquely identifying this API and all of its resource paths within
         the API Management service instance. It is appended to the API endpoint base URL specified
         during the service instance creation to form a public URL for this API.
        :paramtype path: str
        :keyword protocols: Describes on which protocols the operations in this API can be invoked.
        :paramtype protocols: list[str or ~api_management_client.models.Protocol]
        :keyword api_version_set: Version set details.
        :paramtype api_version_set: ~api_management_client.models.ApiVersionSetContractDetails
        """
        super(ApiContract, self).__init__(**kwargs)
        self.description = description
        self.authentication_settings = authentication_settings
        self.subscription_key_parameter_names = subscription_key_parameter_names
        self.api_type = api_type
        self.api_revision = api_revision
        self.api_version = api_version
        self.is_current = is_current
        self.is_online = None
        self.api_revision_description = api_revision_description
        self.api_version_description = api_version_description
        self.api_version_set_id = api_version_set_id
        self.subscription_required = subscription_required
        self.terms_of_service_url = terms_of_service_url
        self.contact = contact
        self.license = license
        self.source_api_id = source_api_id
        self.display_name = display_name
        self.service_url = service_url
        self.path = path
        self.protocols = protocols
        self.api_version_set = api_version_set


class ApiEntityBaseContract(msrest.serialization.Model):
    """API base contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the API. May include HTML formatting tags.
    :vartype description: str
    :ivar authentication_settings: Collection of authentication settings included into this API.
    :vartype authentication_settings: ~api_management_client.models.AuthenticationSettingsContract
    :ivar subscription_key_parameter_names: Protocols over which API is made available.
    :vartype subscription_key_parameter_names:
     ~api_management_client.models.SubscriptionKeyParameterNamesContract
    :ivar api_type: Type of API. Possible values include: "http", "soap", "websocket", "graphql".
    :vartype api_type: str or ~api_management_client.models.ApiType
    :ivar api_revision: Describes the revision of the API. If no value is provided, default
     revision 1 is created.
    :vartype api_revision: str
    :ivar api_version: Indicates the version identifier of the API if the API is versioned.
    :vartype api_version: str
    :ivar is_current: Indicates if API revision is current api revision.
    :vartype is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :ivar api_revision_description: Description of the API Revision.
    :vartype api_revision_description: str
    :ivar api_version_description: Description of the API Version.
    :vartype api_version_description: str
    :ivar api_version_set_id: A resource identifier for the related ApiVersionSet.
    :vartype api_version_set_id: str
    :ivar subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :vartype subscription_required: bool
    :ivar terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format of
     a URL.
    :vartype terms_of_service_url: str
    :ivar contact: Contact information for the API.
    :vartype contact: ~api_management_client.models.ApiContactInformation
    :ivar license: License information for the API.
    :vartype license: ~api_management_client.models.ApiLicenseInformation
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authentication_settings': {'key': 'authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'type', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'terms_of_service_url': {'key': 'termsOfServiceUrl', 'type': 'str'},
        'contact': {'key': 'contact', 'type': 'ApiContactInformation'},
        'license': {'key': 'license', 'type': 'ApiLicenseInformation'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authentication_settings: Optional["AuthenticationSettingsContract"] = None,
        subscription_key_parameter_names: Optional["SubscriptionKeyParameterNamesContract"] = None,
        api_type: Optional[Union[str, "ApiType"]] = None,
        api_revision: Optional[str] = None,
        api_version: Optional[str] = None,
        is_current: Optional[bool] = None,
        api_revision_description: Optional[str] = None,
        api_version_description: Optional[str] = None,
        api_version_set_id: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        terms_of_service_url: Optional[str] = None,
        contact: Optional["ApiContactInformation"] = None,
        license: Optional["ApiLicenseInformation"] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the API. May include HTML formatting tags.
        :paramtype description: str
        :keyword authentication_settings: Collection of authentication settings included into this API.
        :paramtype authentication_settings:
         ~api_management_client.models.AuthenticationSettingsContract
        :keyword subscription_key_parameter_names: Protocols over which API is made available.
        :paramtype subscription_key_parameter_names:
         ~api_management_client.models.SubscriptionKeyParameterNamesContract
        :keyword api_type: Type of API. Possible values include: "http", "soap", "websocket",
         "graphql".
        :paramtype api_type: str or ~api_management_client.models.ApiType
        :keyword api_revision: Describes the revision of the API. If no value is provided, default
         revision 1 is created.
        :paramtype api_revision: str
        :keyword api_version: Indicates the version identifier of the API if the API is versioned.
        :paramtype api_version: str
        :keyword is_current: Indicates if API revision is current api revision.
        :paramtype is_current: bool
        :keyword api_revision_description: Description of the API Revision.
        :paramtype api_revision_description: str
        :keyword api_version_description: Description of the API Version.
        :paramtype api_version_description: str
        :keyword api_version_set_id: A resource identifier for the related ApiVersionSet.
        :paramtype api_version_set_id: str
        :keyword subscription_required: Specifies whether an API or Product subscription is required
         for accessing the API.
        :paramtype subscription_required: bool
        :keyword terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format
         of a URL.
        :paramtype terms_of_service_url: str
        :keyword contact: Contact information for the API.
        :paramtype contact: ~api_management_client.models.ApiContactInformation
        :keyword license: License information for the API.
        :paramtype license: ~api_management_client.models.ApiLicenseInformation
        """
        super(ApiEntityBaseContract, self).__init__(**kwargs)
        self.description = description
        self.authentication_settings = authentication_settings
        self.subscription_key_parameter_names = subscription_key_parameter_names
        self.api_type = api_type
        self.api_revision = api_revision
        self.api_version = api_version
        self.is_current = is_current
        self.is_online = None
        self.api_revision_description = api_revision_description
        self.api_version_description = api_version_description
        self.api_version_set_id = api_version_set_id
        self.subscription_required = subscription_required
        self.terms_of_service_url = terms_of_service_url
        self.contact = contact
        self.license = license


class ApiContractProperties(ApiEntityBaseContract):
    """API Entity Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description of the API. May include HTML formatting tags.
    :vartype description: str
    :ivar authentication_settings: Collection of authentication settings included into this API.
    :vartype authentication_settings: ~api_management_client.models.AuthenticationSettingsContract
    :ivar subscription_key_parameter_names: Protocols over which API is made available.
    :vartype subscription_key_parameter_names:
     ~api_management_client.models.SubscriptionKeyParameterNamesContract
    :ivar api_type: Type of API. Possible values include: "http", "soap", "websocket", "graphql".
    :vartype api_type: str or ~api_management_client.models.ApiType
    :ivar api_revision: Describes the revision of the API. If no value is provided, default
     revision 1 is created.
    :vartype api_revision: str
    :ivar api_version: Indicates the version identifier of the API if the API is versioned.
    :vartype api_version: str
    :ivar is_current: Indicates if API revision is current api revision.
    :vartype is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :ivar api_revision_description: Description of the API Revision.
    :vartype api_revision_description: str
    :ivar api_version_description: Description of the API Version.
    :vartype api_version_description: str
    :ivar api_version_set_id: A resource identifier for the related ApiVersionSet.
    :vartype api_version_set_id: str
    :ivar subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :vartype subscription_required: bool
    :ivar terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format of
     a URL.
    :vartype terms_of_service_url: str
    :ivar contact: Contact information for the API.
    :vartype contact: ~api_management_client.models.ApiContactInformation
    :ivar license: License information for the API.
    :vartype license: ~api_management_client.models.ApiLicenseInformation
    :ivar source_api_id: API identifier of the source API.
    :vartype source_api_id: str
    :ivar display_name: API name. Must be 1 to 300 characters long.
    :vartype display_name: str
    :ivar service_url: Absolute URL of the backend service implementing this API. Cannot be more
     than 2000 characters long.
    :vartype service_url: str
    :ivar path: Required. Relative URL uniquely identifying this API and all of its resource paths
     within the API Management service instance. It is appended to the API endpoint base URL
     specified during the service instance creation to form a public URL for this API.
    :vartype path: str
    :ivar protocols: Describes on which protocols the operations in this API can be invoked.
    :vartype protocols: list[str or ~api_management_client.models.Protocol]
    :ivar api_version_set: Version set details.
    :vartype api_version_set: ~api_management_client.models.ApiVersionSetContractDetails
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 0},
        'path': {'required': True, 'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authentication_settings': {'key': 'authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'type', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'terms_of_service_url': {'key': 'termsOfServiceUrl', 'type': 'str'},
        'contact': {'key': 'contact', 'type': 'ApiContactInformation'},
        'license': {'key': 'license', 'type': 'ApiLicenseInformation'},
        'source_api_id': {'key': 'sourceApiId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
        'api_version_set': {'key': 'apiVersionSet', 'type': 'ApiVersionSetContractDetails'},
    }

    def __init__(
        self,
        *,
        path: str,
        description: Optional[str] = None,
        authentication_settings: Optional["AuthenticationSettingsContract"] = None,
        subscription_key_parameter_names: Optional["SubscriptionKeyParameterNamesContract"] = None,
        api_type: Optional[Union[str, "ApiType"]] = None,
        api_revision: Optional[str] = None,
        api_version: Optional[str] = None,
        is_current: Optional[bool] = None,
        api_revision_description: Optional[str] = None,
        api_version_description: Optional[str] = None,
        api_version_set_id: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        terms_of_service_url: Optional[str] = None,
        contact: Optional["ApiContactInformation"] = None,
        license: Optional["ApiLicenseInformation"] = None,
        source_api_id: Optional[str] = None,
        display_name: Optional[str] = None,
        service_url: Optional[str] = None,
        protocols: Optional[List[Union[str, "Protocol"]]] = None,
        api_version_set: Optional["ApiVersionSetContractDetails"] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the API. May include HTML formatting tags.
        :paramtype description: str
        :keyword authentication_settings: Collection of authentication settings included into this API.
        :paramtype authentication_settings:
         ~api_management_client.models.AuthenticationSettingsContract
        :keyword subscription_key_parameter_names: Protocols over which API is made available.
        :paramtype subscription_key_parameter_names:
         ~api_management_client.models.SubscriptionKeyParameterNamesContract
        :keyword api_type: Type of API. Possible values include: "http", "soap", "websocket",
         "graphql".
        :paramtype api_type: str or ~api_management_client.models.ApiType
        :keyword api_revision: Describes the revision of the API. If no value is provided, default
         revision 1 is created.
        :paramtype api_revision: str
        :keyword api_version: Indicates the version identifier of the API if the API is versioned.
        :paramtype api_version: str
        :keyword is_current: Indicates if API revision is current api revision.
        :paramtype is_current: bool
        :keyword api_revision_description: Description of the API Revision.
        :paramtype api_revision_description: str
        :keyword api_version_description: Description of the API Version.
        :paramtype api_version_description: str
        :keyword api_version_set_id: A resource identifier for the related ApiVersionSet.
        :paramtype api_version_set_id: str
        :keyword subscription_required: Specifies whether an API or Product subscription is required
         for accessing the API.
        :paramtype subscription_required: bool
        :keyword terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format
         of a URL.
        :paramtype terms_of_service_url: str
        :keyword contact: Contact information for the API.
        :paramtype contact: ~api_management_client.models.ApiContactInformation
        :keyword license: License information for the API.
        :paramtype license: ~api_management_client.models.ApiLicenseInformation
        :keyword source_api_id: API identifier of the source API.
        :paramtype source_api_id: str
        :keyword display_name: API name. Must be 1 to 300 characters long.
        :paramtype display_name: str
        :keyword service_url: Absolute URL of the backend service implementing this API. Cannot be more
         than 2000 characters long.
        :paramtype service_url: str
        :keyword path: Required. Relative URL uniquely identifying this API and all of its resource
         paths within the API Management service instance. It is appended to the API endpoint base URL
         specified during the service instance creation to form a public URL for this API.
        :paramtype path: str
        :keyword protocols: Describes on which protocols the operations in this API can be invoked.
        :paramtype protocols: list[str or ~api_management_client.models.Protocol]
        :keyword api_version_set: Version set details.
        :paramtype api_version_set: ~api_management_client.models.ApiVersionSetContractDetails
        """
        super(ApiContractProperties, self).__init__(description=description, authentication_settings=authentication_settings, subscription_key_parameter_names=subscription_key_parameter_names, api_type=api_type, api_revision=api_revision, api_version=api_version, is_current=is_current, api_revision_description=api_revision_description, api_version_description=api_version_description, api_version_set_id=api_version_set_id, subscription_required=subscription_required, terms_of_service_url=terms_of_service_url, contact=contact, license=license, **kwargs)
        self.source_api_id = source_api_id
        self.display_name = display_name
        self.service_url = service_url
        self.path = path
        self.protocols = protocols
        self.api_version_set = api_version_set


class ApiContractUpdateProperties(ApiEntityBaseContract):
    """API update contract properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the API. May include HTML formatting tags.
    :vartype description: str
    :ivar authentication_settings: Collection of authentication settings included into this API.
    :vartype authentication_settings: ~api_management_client.models.AuthenticationSettingsContract
    :ivar subscription_key_parameter_names: Protocols over which API is made available.
    :vartype subscription_key_parameter_names:
     ~api_management_client.models.SubscriptionKeyParameterNamesContract
    :ivar api_type: Type of API. Possible values include: "http", "soap", "websocket", "graphql".
    :vartype api_type: str or ~api_management_client.models.ApiType
    :ivar api_revision: Describes the revision of the API. If no value is provided, default
     revision 1 is created.
    :vartype api_revision: str
    :ivar api_version: Indicates the version identifier of the API if the API is versioned.
    :vartype api_version: str
    :ivar is_current: Indicates if API revision is current api revision.
    :vartype is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :ivar api_revision_description: Description of the API Revision.
    :vartype api_revision_description: str
    :ivar api_version_description: Description of the API Version.
    :vartype api_version_description: str
    :ivar api_version_set_id: A resource identifier for the related ApiVersionSet.
    :vartype api_version_set_id: str
    :ivar subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :vartype subscription_required: bool
    :ivar terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format of
     a URL.
    :vartype terms_of_service_url: str
    :ivar contact: Contact information for the API.
    :vartype contact: ~api_management_client.models.ApiContactInformation
    :ivar license: License information for the API.
    :vartype license: ~api_management_client.models.ApiLicenseInformation
    :ivar display_name: API name.
    :vartype display_name: str
    :ivar service_url: Absolute URL of the backend service implementing this API.
    :vartype service_url: str
    :ivar path: Relative URL uniquely identifying this API and all of its resource paths within the
     API Management service instance. It is appended to the API endpoint base URL specified during
     the service instance creation to form a public URL for this API.
    :vartype path: str
    :ivar protocols: Describes on which protocols the operations in this API can be invoked.
    :vartype protocols: list[str or ~api_management_client.models.Protocol]
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 1},
        'path': {'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authentication_settings': {'key': 'authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'type', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'terms_of_service_url': {'key': 'termsOfServiceUrl', 'type': 'str'},
        'contact': {'key': 'contact', 'type': 'ApiContactInformation'},
        'license': {'key': 'license', 'type': 'ApiLicenseInformation'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authentication_settings: Optional["AuthenticationSettingsContract"] = None,
        subscription_key_parameter_names: Optional["SubscriptionKeyParameterNamesContract"] = None,
        api_type: Optional[Union[str, "ApiType"]] = None,
        api_revision: Optional[str] = None,
        api_version: Optional[str] = None,
        is_current: Optional[bool] = None,
        api_revision_description: Optional[str] = None,
        api_version_description: Optional[str] = None,
        api_version_set_id: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        terms_of_service_url: Optional[str] = None,
        contact: Optional["ApiContactInformation"] = None,
        license: Optional["ApiLicenseInformation"] = None,
        display_name: Optional[str] = None,
        service_url: Optional[str] = None,
        path: Optional[str] = None,
        protocols: Optional[List[Union[str, "Protocol"]]] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the API. May include HTML formatting tags.
        :paramtype description: str
        :keyword authentication_settings: Collection of authentication settings included into this API.
        :paramtype authentication_settings:
         ~api_management_client.models.AuthenticationSettingsContract
        :keyword subscription_key_parameter_names: Protocols over which API is made available.
        :paramtype subscription_key_parameter_names:
         ~api_management_client.models.SubscriptionKeyParameterNamesContract
        :keyword api_type: Type of API. Possible values include: "http", "soap", "websocket",
         "graphql".
        :paramtype api_type: str or ~api_management_client.models.ApiType
        :keyword api_revision: Describes the revision of the API. If no value is provided, default
         revision 1 is created.
        :paramtype api_revision: str
        :keyword api_version: Indicates the version identifier of the API if the API is versioned.
        :paramtype api_version: str
        :keyword is_current: Indicates if API revision is current api revision.
        :paramtype is_current: bool
        :keyword api_revision_description: Description of the API Revision.
        :paramtype api_revision_description: str
        :keyword api_version_description: Description of the API Version.
        :paramtype api_version_description: str
        :keyword api_version_set_id: A resource identifier for the related ApiVersionSet.
        :paramtype api_version_set_id: str
        :keyword subscription_required: Specifies whether an API or Product subscription is required
         for accessing the API.
        :paramtype subscription_required: bool
        :keyword terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format
         of a URL.
        :paramtype terms_of_service_url: str
        :keyword contact: Contact information for the API.
        :paramtype contact: ~api_management_client.models.ApiContactInformation
        :keyword license: License information for the API.
        :paramtype license: ~api_management_client.models.ApiLicenseInformation
        :keyword display_name: API name.
        :paramtype display_name: str
        :keyword service_url: Absolute URL of the backend service implementing this API.
        :paramtype service_url: str
        :keyword path: Relative URL uniquely identifying this API and all of its resource paths within
         the API Management service instance. It is appended to the API endpoint base URL specified
         during the service instance creation to form a public URL for this API.
        :paramtype path: str
        :keyword protocols: Describes on which protocols the operations in this API can be invoked.
        :paramtype protocols: list[str or ~api_management_client.models.Protocol]
        """
        super(ApiContractUpdateProperties, self).__init__(description=description, authentication_settings=authentication_settings, subscription_key_parameter_names=subscription_key_parameter_names, api_type=api_type, api_revision=api_revision, api_version=api_version, is_current=is_current, api_revision_description=api_revision_description, api_version_description=api_version_description, api_version_set_id=api_version_set_id, subscription_required=subscription_required, terms_of_service_url=terms_of_service_url, contact=contact, license=license, **kwargs)
        self.display_name = display_name
        self.service_url = service_url
        self.path = path
        self.protocols = protocols


class ApiCreateOrUpdateParameter(msrest.serialization.Model):
    """API Create or Update Parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the API. May include HTML formatting tags.
    :vartype description: str
    :ivar authentication_settings: Collection of authentication settings included into this API.
    :vartype authentication_settings: ~api_management_client.models.AuthenticationSettingsContract
    :ivar subscription_key_parameter_names: Protocols over which API is made available.
    :vartype subscription_key_parameter_names:
     ~api_management_client.models.SubscriptionKeyParameterNamesContract
    :ivar api_type: Type of API. Possible values include: "http", "soap", "websocket", "graphql".
    :vartype api_type: str or ~api_management_client.models.ApiType
    :ivar api_revision: Describes the revision of the API. If no value is provided, default
     revision 1 is created.
    :vartype api_revision: str
    :ivar api_version: Indicates the version identifier of the API if the API is versioned.
    :vartype api_version: str
    :ivar is_current: Indicates if API revision is current api revision.
    :vartype is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :ivar api_revision_description: Description of the API Revision.
    :vartype api_revision_description: str
    :ivar api_version_description: Description of the API Version.
    :vartype api_version_description: str
    :ivar api_version_set_id: A resource identifier for the related ApiVersionSet.
    :vartype api_version_set_id: str
    :ivar subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :vartype subscription_required: bool
    :ivar terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format of
     a URL.
    :vartype terms_of_service_url: str
    :ivar contact: Contact information for the API.
    :vartype contact: ~api_management_client.models.ApiContactInformation
    :ivar license: License information for the API.
    :vartype license: ~api_management_client.models.ApiLicenseInformation
    :ivar source_api_id: API identifier of the source API.
    :vartype source_api_id: str
    :ivar display_name: API name. Must be 1 to 300 characters long.
    :vartype display_name: str
    :ivar service_url: Absolute URL of the backend service implementing this API. Cannot be more
     than 2000 characters long.
    :vartype service_url: str
    :ivar path: Relative URL uniquely identifying this API and all of its resource paths within the
     API Management service instance. It is appended to the API endpoint base URL specified during
     the service instance creation to form a public URL for this API.
    :vartype path: str
    :ivar protocols: Describes on which protocols the operations in this API can be invoked.
    :vartype protocols: list[str or ~api_management_client.models.Protocol]
    :ivar api_version_set: Version set details.
    :vartype api_version_set: ~api_management_client.models.ApiVersionSetContractDetails
    :ivar value: Content value when Importing an API.
    :vartype value: str
    :ivar format: Format of the Content in which the API is getting imported. Possible values
     include: "wadl-xml", "wadl-link-json", "swagger-json", "swagger-link-json", "wsdl",
     "wsdl-link", "openapi", "openapi+json", "openapi-link", "openapi+json-link", "graphql-link".
    :vartype format: str or ~api_management_client.models.ContentFormat
    :ivar wsdl_selector: Criteria to limit import of WSDL to a subset of the document.
    :vartype wsdl_selector: ~api_management_client.models.ApiCreateOrUpdatePropertiesWsdlSelector
    :ivar soap_api_type: Type of API to create.
    
    
     * ``http`` creates a REST API
     * ``soap`` creates a SOAP pass-through API
     * ``websocket`` creates websocket API
     * ``graphql`` creates GraphQL API. Possible values include: "http", "soap", "websocket",
     "graphql".
    :vartype soap_api_type: str or ~api_management_client.models.SoapApiType
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 0},
        'path': {'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'authentication_settings': {'key': 'properties.authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'properties.subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'properties.type', 'type': 'str'},
        'api_revision': {'key': 'properties.apiRevision', 'type': 'str'},
        'api_version': {'key': 'properties.apiVersion', 'type': 'str'},
        'is_current': {'key': 'properties.isCurrent', 'type': 'bool'},
        'is_online': {'key': 'properties.isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'properties.apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'properties.apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'properties.apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'properties.subscriptionRequired', 'type': 'bool'},
        'terms_of_service_url': {'key': 'properties.termsOfServiceUrl', 'type': 'str'},
        'contact': {'key': 'properties.contact', 'type': 'ApiContactInformation'},
        'license': {'key': 'properties.license', 'type': 'ApiLicenseInformation'},
        'source_api_id': {'key': 'properties.sourceApiId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'service_url': {'key': 'properties.serviceUrl', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'protocols': {'key': 'properties.protocols', 'type': '[str]'},
        'api_version_set': {'key': 'properties.apiVersionSet', 'type': 'ApiVersionSetContractDetails'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'wsdl_selector': {'key': 'properties.wsdlSelector', 'type': 'ApiCreateOrUpdatePropertiesWsdlSelector'},
        'soap_api_type': {'key': 'properties.apiType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authentication_settings: Optional["AuthenticationSettingsContract"] = None,
        subscription_key_parameter_names: Optional["SubscriptionKeyParameterNamesContract"] = None,
        api_type: Optional[Union[str, "ApiType"]] = None,
        api_revision: Optional[str] = None,
        api_version: Optional[str] = None,
        is_current: Optional[bool] = None,
        api_revision_description: Optional[str] = None,
        api_version_description: Optional[str] = None,
        api_version_set_id: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        terms_of_service_url: Optional[str] = None,
        contact: Optional["ApiContactInformation"] = None,
        license: Optional["ApiLicenseInformation"] = None,
        source_api_id: Optional[str] = None,
        display_name: Optional[str] = None,
        service_url: Optional[str] = None,
        path: Optional[str] = None,
        protocols: Optional[List[Union[str, "Protocol"]]] = None,
        api_version_set: Optional["ApiVersionSetContractDetails"] = None,
        value: Optional[str] = None,
        format: Optional[Union[str, "ContentFormat"]] = None,
        wsdl_selector: Optional["ApiCreateOrUpdatePropertiesWsdlSelector"] = None,
        soap_api_type: Optional[Union[str, "SoapApiType"]] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the API. May include HTML formatting tags.
        :paramtype description: str
        :keyword authentication_settings: Collection of authentication settings included into this API.
        :paramtype authentication_settings:
         ~api_management_client.models.AuthenticationSettingsContract
        :keyword subscription_key_parameter_names: Protocols over which API is made available.
        :paramtype subscription_key_parameter_names:
         ~api_management_client.models.SubscriptionKeyParameterNamesContract
        :keyword api_type: Type of API. Possible values include: "http", "soap", "websocket",
         "graphql".
        :paramtype api_type: str or ~api_management_client.models.ApiType
        :keyword api_revision: Describes the revision of the API. If no value is provided, default
         revision 1 is created.
        :paramtype api_revision: str
        :keyword api_version: Indicates the version identifier of the API if the API is versioned.
        :paramtype api_version: str
        :keyword is_current: Indicates if API revision is current api revision.
        :paramtype is_current: bool
        :keyword api_revision_description: Description of the API Revision.
        :paramtype api_revision_description: str
        :keyword api_version_description: Description of the API Version.
        :paramtype api_version_description: str
        :keyword api_version_set_id: A resource identifier for the related ApiVersionSet.
        :paramtype api_version_set_id: str
        :keyword subscription_required: Specifies whether an API or Product subscription is required
         for accessing the API.
        :paramtype subscription_required: bool
        :keyword terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format
         of a URL.
        :paramtype terms_of_service_url: str
        :keyword contact: Contact information for the API.
        :paramtype contact: ~api_management_client.models.ApiContactInformation
        :keyword license: License information for the API.
        :paramtype license: ~api_management_client.models.ApiLicenseInformation
        :keyword source_api_id: API identifier of the source API.
        :paramtype source_api_id: str
        :keyword display_name: API name. Must be 1 to 300 characters long.
        :paramtype display_name: str
        :keyword service_url: Absolute URL of the backend service implementing this API. Cannot be more
         than 2000 characters long.
        :paramtype service_url: str
        :keyword path: Relative URL uniquely identifying this API and all of its resource paths within
         the API Management service instance. It is appended to the API endpoint base URL specified
         during the service instance creation to form a public URL for this API.
        :paramtype path: str
        :keyword protocols: Describes on which protocols the operations in this API can be invoked.
        :paramtype protocols: list[str or ~api_management_client.models.Protocol]
        :keyword api_version_set: Version set details.
        :paramtype api_version_set: ~api_management_client.models.ApiVersionSetContractDetails
        :keyword value: Content value when Importing an API.
        :paramtype value: str
        :keyword format: Format of the Content in which the API is getting imported. Possible values
         include: "wadl-xml", "wadl-link-json", "swagger-json", "swagger-link-json", "wsdl",
         "wsdl-link", "openapi", "openapi+json", "openapi-link", "openapi+json-link", "graphql-link".
        :paramtype format: str or ~api_management_client.models.ContentFormat
        :keyword wsdl_selector: Criteria to limit import of WSDL to a subset of the document.
        :paramtype wsdl_selector: ~api_management_client.models.ApiCreateOrUpdatePropertiesWsdlSelector
        :keyword soap_api_type: Type of API to create.
        
        
         * ``http`` creates a REST API
         * ``soap`` creates a SOAP pass-through API
         * ``websocket`` creates websocket API
         * ``graphql`` creates GraphQL API. Possible values include: "http", "soap", "websocket",
         "graphql".
        :paramtype soap_api_type: str or ~api_management_client.models.SoapApiType
        """
        super(ApiCreateOrUpdateParameter, self).__init__(**kwargs)
        self.description = description
        self.authentication_settings = authentication_settings
        self.subscription_key_parameter_names = subscription_key_parameter_names
        self.api_type = api_type
        self.api_revision = api_revision
        self.api_version = api_version
        self.is_current = is_current
        self.is_online = None
        self.api_revision_description = api_revision_description
        self.api_version_description = api_version_description
        self.api_version_set_id = api_version_set_id
        self.subscription_required = subscription_required
        self.terms_of_service_url = terms_of_service_url
        self.contact = contact
        self.license = license
        self.source_api_id = source_api_id
        self.display_name = display_name
        self.service_url = service_url
        self.path = path
        self.protocols = protocols
        self.api_version_set = api_version_set
        self.value = value
        self.format = format
        self.wsdl_selector = wsdl_selector
        self.soap_api_type = soap_api_type


class ApiCreateOrUpdateProperties(ApiContractProperties):
    """API Create or Update Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description of the API. May include HTML formatting tags.
    :vartype description: str
    :ivar authentication_settings: Collection of authentication settings included into this API.
    :vartype authentication_settings: ~api_management_client.models.AuthenticationSettingsContract
    :ivar subscription_key_parameter_names: Protocols over which API is made available.
    :vartype subscription_key_parameter_names:
     ~api_management_client.models.SubscriptionKeyParameterNamesContract
    :ivar api_type: Type of API. Possible values include: "http", "soap", "websocket", "graphql".
    :vartype api_type: str or ~api_management_client.models.ApiType
    :ivar api_revision: Describes the revision of the API. If no value is provided, default
     revision 1 is created.
    :vartype api_revision: str
    :ivar api_version: Indicates the version identifier of the API if the API is versioned.
    :vartype api_version: str
    :ivar is_current: Indicates if API revision is current api revision.
    :vartype is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :ivar api_revision_description: Description of the API Revision.
    :vartype api_revision_description: str
    :ivar api_version_description: Description of the API Version.
    :vartype api_version_description: str
    :ivar api_version_set_id: A resource identifier for the related ApiVersionSet.
    :vartype api_version_set_id: str
    :ivar subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :vartype subscription_required: bool
    :ivar terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format of
     a URL.
    :vartype terms_of_service_url: str
    :ivar contact: Contact information for the API.
    :vartype contact: ~api_management_client.models.ApiContactInformation
    :ivar license: License information for the API.
    :vartype license: ~api_management_client.models.ApiLicenseInformation
    :ivar source_api_id: API identifier of the source API.
    :vartype source_api_id: str
    :ivar display_name: API name. Must be 1 to 300 characters long.
    :vartype display_name: str
    :ivar service_url: Absolute URL of the backend service implementing this API. Cannot be more
     than 2000 characters long.
    :vartype service_url: str
    :ivar path: Required. Relative URL uniquely identifying this API and all of its resource paths
     within the API Management service instance. It is appended to the API endpoint base URL
     specified during the service instance creation to form a public URL for this API.
    :vartype path: str
    :ivar protocols: Describes on which protocols the operations in this API can be invoked.
    :vartype protocols: list[str or ~api_management_client.models.Protocol]
    :ivar api_version_set: Version set details.
    :vartype api_version_set: ~api_management_client.models.ApiVersionSetContractDetails
    :ivar value: Content value when Importing an API.
    :vartype value: str
    :ivar format: Format of the Content in which the API is getting imported. Possible values
     include: "wadl-xml", "wadl-link-json", "swagger-json", "swagger-link-json", "wsdl",
     "wsdl-link", "openapi", "openapi+json", "openapi-link", "openapi+json-link", "graphql-link".
    :vartype format: str or ~api_management_client.models.ContentFormat
    :ivar wsdl_selector: Criteria to limit import of WSDL to a subset of the document.
    :vartype wsdl_selector: ~api_management_client.models.ApiCreateOrUpdatePropertiesWsdlSelector
    :ivar soap_api_type: Type of API to create.
    
    
     * ``http`` creates a REST API
     * ``soap`` creates a SOAP pass-through API
     * ``websocket`` creates websocket API
     * ``graphql`` creates GraphQL API. Possible values include: "http", "soap", "websocket",
     "graphql".
    :vartype soap_api_type: str or ~api_management_client.models.SoapApiType
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 0},
        'path': {'required': True, 'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authentication_settings': {'key': 'authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'type', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'terms_of_service_url': {'key': 'termsOfServiceUrl', 'type': 'str'},
        'contact': {'key': 'contact', 'type': 'ApiContactInformation'},
        'license': {'key': 'license', 'type': 'ApiLicenseInformation'},
        'source_api_id': {'key': 'sourceApiId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
        'api_version_set': {'key': 'apiVersionSet', 'type': 'ApiVersionSetContractDetails'},
        'value': {'key': 'value', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
        'wsdl_selector': {'key': 'wsdlSelector', 'type': 'ApiCreateOrUpdatePropertiesWsdlSelector'},
        'soap_api_type': {'key': 'apiType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: str,
        description: Optional[str] = None,
        authentication_settings: Optional["AuthenticationSettingsContract"] = None,
        subscription_key_parameter_names: Optional["SubscriptionKeyParameterNamesContract"] = None,
        api_type: Optional[Union[str, "ApiType"]] = None,
        api_revision: Optional[str] = None,
        api_version: Optional[str] = None,
        is_current: Optional[bool] = None,
        api_revision_description: Optional[str] = None,
        api_version_description: Optional[str] = None,
        api_version_set_id: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        terms_of_service_url: Optional[str] = None,
        contact: Optional["ApiContactInformation"] = None,
        license: Optional["ApiLicenseInformation"] = None,
        source_api_id: Optional[str] = None,
        display_name: Optional[str] = None,
        service_url: Optional[str] = None,
        protocols: Optional[List[Union[str, "Protocol"]]] = None,
        api_version_set: Optional["ApiVersionSetContractDetails"] = None,
        value: Optional[str] = None,
        format: Optional[Union[str, "ContentFormat"]] = None,
        wsdl_selector: Optional["ApiCreateOrUpdatePropertiesWsdlSelector"] = None,
        soap_api_type: Optional[Union[str, "SoapApiType"]] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the API. May include HTML formatting tags.
        :paramtype description: str
        :keyword authentication_settings: Collection of authentication settings included into this API.
        :paramtype authentication_settings:
         ~api_management_client.models.AuthenticationSettingsContract
        :keyword subscription_key_parameter_names: Protocols over which API is made available.
        :paramtype subscription_key_parameter_names:
         ~api_management_client.models.SubscriptionKeyParameterNamesContract
        :keyword api_type: Type of API. Possible values include: "http", "soap", "websocket",
         "graphql".
        :paramtype api_type: str or ~api_management_client.models.ApiType
        :keyword api_revision: Describes the revision of the API. If no value is provided, default
         revision 1 is created.
        :paramtype api_revision: str
        :keyword api_version: Indicates the version identifier of the API if the API is versioned.
        :paramtype api_version: str
        :keyword is_current: Indicates if API revision is current api revision.
        :paramtype is_current: bool
        :keyword api_revision_description: Description of the API Revision.
        :paramtype api_revision_description: str
        :keyword api_version_description: Description of the API Version.
        :paramtype api_version_description: str
        :keyword api_version_set_id: A resource identifier for the related ApiVersionSet.
        :paramtype api_version_set_id: str
        :keyword subscription_required: Specifies whether an API or Product subscription is required
         for accessing the API.
        :paramtype subscription_required: bool
        :keyword terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format
         of a URL.
        :paramtype terms_of_service_url: str
        :keyword contact: Contact information for the API.
        :paramtype contact: ~api_management_client.models.ApiContactInformation
        :keyword license: License information for the API.
        :paramtype license: ~api_management_client.models.ApiLicenseInformation
        :keyword source_api_id: API identifier of the source API.
        :paramtype source_api_id: str
        :keyword display_name: API name. Must be 1 to 300 characters long.
        :paramtype display_name: str
        :keyword service_url: Absolute URL of the backend service implementing this API. Cannot be more
         than 2000 characters long.
        :paramtype service_url: str
        :keyword path: Required. Relative URL uniquely identifying this API and all of its resource
         paths within the API Management service instance. It is appended to the API endpoint base URL
         specified during the service instance creation to form a public URL for this API.
        :paramtype path: str
        :keyword protocols: Describes on which protocols the operations in this API can be invoked.
        :paramtype protocols: list[str or ~api_management_client.models.Protocol]
        :keyword api_version_set: Version set details.
        :paramtype api_version_set: ~api_management_client.models.ApiVersionSetContractDetails
        :keyword value: Content value when Importing an API.
        :paramtype value: str
        :keyword format: Format of the Content in which the API is getting imported. Possible values
         include: "wadl-xml", "wadl-link-json", "swagger-json", "swagger-link-json", "wsdl",
         "wsdl-link", "openapi", "openapi+json", "openapi-link", "openapi+json-link", "graphql-link".
        :paramtype format: str or ~api_management_client.models.ContentFormat
        :keyword wsdl_selector: Criteria to limit import of WSDL to a subset of the document.
        :paramtype wsdl_selector: ~api_management_client.models.ApiCreateOrUpdatePropertiesWsdlSelector
        :keyword soap_api_type: Type of API to create.
        
        
         * ``http`` creates a REST API
         * ``soap`` creates a SOAP pass-through API
         * ``websocket`` creates websocket API
         * ``graphql`` creates GraphQL API. Possible values include: "http", "soap", "websocket",
         "graphql".
        :paramtype soap_api_type: str or ~api_management_client.models.SoapApiType
        """
        super(ApiCreateOrUpdateProperties, self).__init__(description=description, authentication_settings=authentication_settings, subscription_key_parameter_names=subscription_key_parameter_names, api_type=api_type, api_revision=api_revision, api_version=api_version, is_current=is_current, api_revision_description=api_revision_description, api_version_description=api_version_description, api_version_set_id=api_version_set_id, subscription_required=subscription_required, terms_of_service_url=terms_of_service_url, contact=contact, license=license, source_api_id=source_api_id, display_name=display_name, service_url=service_url, path=path, protocols=protocols, api_version_set=api_version_set, **kwargs)
        self.value = value
        self.format = format
        self.wsdl_selector = wsdl_selector
        self.soap_api_type = soap_api_type


class ApiCreateOrUpdatePropertiesWsdlSelector(msrest.serialization.Model):
    """Criteria to limit import of WSDL to a subset of the document.

    :ivar wsdl_service_name: Name of service to import from WSDL.
    :vartype wsdl_service_name: str
    :ivar wsdl_endpoint_name: Name of endpoint(port) to import from WSDL.
    :vartype wsdl_endpoint_name: str
    """

    _attribute_map = {
        'wsdl_service_name': {'key': 'wsdlServiceName', 'type': 'str'},
        'wsdl_endpoint_name': {'key': 'wsdlEndpointName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        wsdl_service_name: Optional[str] = None,
        wsdl_endpoint_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword wsdl_service_name: Name of service to import from WSDL.
        :paramtype wsdl_service_name: str
        :keyword wsdl_endpoint_name: Name of endpoint(port) to import from WSDL.
        :paramtype wsdl_endpoint_name: str
        """
        super(ApiCreateOrUpdatePropertiesWsdlSelector, self).__init__(**kwargs)
        self.wsdl_service_name = wsdl_service_name
        self.wsdl_endpoint_name = wsdl_endpoint_name


class ApiExportResult(msrest.serialization.Model):
    """API Export result.

    :ivar id: ResourceId of the API which was exported.
    :vartype id: str
    :ivar export_result_format: Format in which the API Details are exported to the Storage Blob
     with Sas Key valid for 5 minutes. Possible values include: "swagger-link-json",
     "wsdl-link+xml", "wadl-link-json", "openapi-link".
    :vartype export_result_format: str or ~api_management_client.models.ExportResultFormat
    :ivar value: The object defining the schema of the exported API Detail.
    :vartype value: ~api_management_client.models.ApiExportResultValue
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'export_result_format': {'key': 'format', 'type': 'str'},
        'value': {'key': 'value', 'type': 'ApiExportResultValue'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        export_result_format: Optional[Union[str, "ExportResultFormat"]] = None,
        value: Optional["ApiExportResultValue"] = None,
        **kwargs
    ):
        """
        :keyword id: ResourceId of the API which was exported.
        :paramtype id: str
        :keyword export_result_format: Format in which the API Details are exported to the Storage Blob
         with Sas Key valid for 5 minutes. Possible values include: "swagger-link-json",
         "wsdl-link+xml", "wadl-link-json", "openapi-link".
        :paramtype export_result_format: str or ~api_management_client.models.ExportResultFormat
        :keyword value: The object defining the schema of the exported API Detail.
        :paramtype value: ~api_management_client.models.ApiExportResultValue
        """
        super(ApiExportResult, self).__init__(**kwargs)
        self.id = id
        self.export_result_format = export_result_format
        self.value = value


class ApiExportResultValue(msrest.serialization.Model):
    """The object defining the schema of the exported API Detail.

    :ivar link: Link to the Storage Blob containing the result of the export operation. The Blob
     Uri is only valid for 5 minutes.
    :vartype link: str
    """

    _attribute_map = {
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword link: Link to the Storage Blob containing the result of the export operation. The Blob
         Uri is only valid for 5 minutes.
        :paramtype link: str
        """
        super(ApiExportResultValue, self).__init__(**kwargs)
        self.link = link


class ApiLicenseInformation(msrest.serialization.Model):
    """API license information.

    :ivar name: The license name used for the API.
    :vartype name: str
    :ivar url: A URL to the license used for the API. MUST be in the format of a URL.
    :vartype url: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The license name used for the API.
        :paramtype name: str
        :keyword url: A URL to the license used for the API. MUST be in the format of a URL.
        :paramtype url: str
        """
        super(ApiLicenseInformation, self).__init__(**kwargs)
        self.name = name
        self.url = url


class ApiManagementServiceApplyNetworkConfigurationParameters(msrest.serialization.Model):
    """Parameter supplied to the Apply Network configuration operation.

    :ivar location: Location of the Api Management service to update for a multi-region service.
     For a service deployed in a single region, this parameter is not required.
    :vartype location: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the Api Management service to update for a multi-region service.
         For a service deployed in a single region, this parameter is not required.
        :paramtype location: str
        """
        super(ApiManagementServiceApplyNetworkConfigurationParameters, self).__init__(**kwargs)
        self.location = location


class ApiManagementServiceBackupRestoreParameters(msrest.serialization.Model):
    """Parameters supplied to the Backup/Restore of an API Management service operation.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_account: Required. The name of the Azure storage account (used to place/retrieve
     the backup).
    :vartype storage_account: str
    :ivar container_name: Required. The name of the blob container (used to place/retrieve the
     backup).
    :vartype container_name: str
    :ivar backup_name: Required. The name of the backup file to create/retrieve.
    :vartype backup_name: str
    :ivar access_type: The type of access to be used for the storage account. Possible values
     include: "AccessKey", "SystemAssignedManagedIdentity", "UserAssignedManagedIdentity". Default
     value: "AccessKey".
    :vartype access_type: str or ~api_management_client.models.AccessType
    :ivar access_key: Storage account access key. Required only if ``accessType`` is set to
     ``AccessKey``.
    :vartype access_key: str
    :ivar client_id: The Client ID of user assigned managed identity. Required only if
     ``accessType`` is set to ``UserAssignedManagedIdentity``.
    :vartype client_id: str
    """

    _validation = {
        'storage_account': {'required': True},
        'container_name': {'required': True},
        'backup_name': {'required': True},
    }

    _attribute_map = {
        'storage_account': {'key': 'storageAccount', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'backup_name': {'key': 'backupName', 'type': 'str'},
        'access_type': {'key': 'accessType', 'type': 'str'},
        'access_key': {'key': 'accessKey', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_account: str,
        container_name: str,
        backup_name: str,
        access_type: Optional[Union[str, "AccessType"]] = "AccessKey",
        access_key: Optional[str] = None,
        client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword storage_account: Required. The name of the Azure storage account (used to
         place/retrieve the backup).
        :paramtype storage_account: str
        :keyword container_name: Required. The name of the blob container (used to place/retrieve the
         backup).
        :paramtype container_name: str
        :keyword backup_name: Required. The name of the backup file to create/retrieve.
        :paramtype backup_name: str
        :keyword access_type: The type of access to be used for the storage account. Possible values
         include: "AccessKey", "SystemAssignedManagedIdentity", "UserAssignedManagedIdentity". Default
         value: "AccessKey".
        :paramtype access_type: str or ~api_management_client.models.AccessType
        :keyword access_key: Storage account access key. Required only if ``accessType`` is set to
         ``AccessKey``.
        :paramtype access_key: str
        :keyword client_id: The Client ID of user assigned managed identity. Required only if
         ``accessType`` is set to ``UserAssignedManagedIdentity``.
        :paramtype client_id: str
        """
        super(ApiManagementServiceBackupRestoreParameters, self).__init__(**kwargs)
        self.storage_account = storage_account
        self.container_name = container_name
        self.backup_name = backup_name
        self.access_type = access_type
        self.access_key = access_key
        self.client_id = client_id


class ApiManagementServiceBaseProperties(msrest.serialization.Model):
    """Base Properties of an API Management service resource description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar notification_sender_email: Email address from which the notification will be sent.
    :vartype notification_sender_email: str
    :ivar provisioning_state: The current provisioning state of the API Management service which
     can be one of the following:
     Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
    :vartype provisioning_state: str
    :ivar target_provisioning_state: The provisioning state of the API Management service, which is
     targeted by the long running operation started on the service.
    :vartype target_provisioning_state: str
    :ivar created_at_utc: Creation UTC date of the API Management service.The date conforms to the
     following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_at_utc: ~datetime.datetime
    :ivar gateway_url: Gateway URL of the API Management service.
    :vartype gateway_url: str
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Default Region.
    :vartype gateway_regional_url: str
    :ivar portal_url: Publisher portal endpoint Url of the API Management service.
    :vartype portal_url: str
    :ivar management_api_url: Management API endpoint URL of the API Management service.
    :vartype management_api_url: str
    :ivar scm_url: SCM endpoint URL of the API Management service.
    :vartype scm_url: str
    :ivar developer_portal_url: DEveloper Portal endpoint URL of the API Management service.
    :vartype developer_portal_url: str
    :ivar hostname_configurations: Custom hostname configuration of the API Management service.
    :vartype hostname_configurations: list[~api_management_client.models.HostnameConfiguration]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service in Primary region which is deployed in an Internal Virtual Network. Available only for
     Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :ivar public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
     Virtual Network deployed service in the region. Supported only for Developer and Premium SKU
     being deployed in Virtual Network.
    :vartype public_ip_address_id: str
    :ivar public_network_access: Whether or not public endpoint access is allowed for this API
     Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If
     'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'.
     Possible values include: "Enabled", "Disabled".
    :vartype public_network_access: str or ~api_management_client.models.PublicNetworkAccess
    :ivar virtual_network_configuration: Virtual network configuration of the API Management
     service.
    :vartype virtual_network_configuration:
     ~api_management_client.models.VirtualNetworkConfiguration
    :ivar additional_locations: Additional datacenter locations of the API Management service.
    :vartype additional_locations: list[~api_management_client.models.AdditionalLocation]
    :ivar custom_properties: Custom properties of the API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
     cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
     disable just TLS 1.1.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
     disable TLS 1.0 on an API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
     to disable just TLS 1.1 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
     to disable TLS 1.0 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
     HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
     PATCH operation will reset omitted properties' values to their defaults. For all the settings
     except Http2 the default value is ``True`` if the service was created on or before April 1st
     2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
     disable any of next ciphers by using settings
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
     TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
     TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
     For example,
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
     ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
     they are required by Azure CloudService internal components:
     TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
    :vartype custom_properties: dict[str, str]
    :ivar certificates: List of Certificates that need to be installed in the API Management
     service. Max supported certificates that can be installed is 10.
    :vartype certificates: list[~api_management_client.models.CertificateConfiguration]
    :ivar enable_client_certificate: Property only meant to be used for Consumption SKU Service.
     This enforces a client certificate to be presented on each request to the gateway. This also
     enables the ability to authenticate the certificate in the policy on the gateway.
    :vartype enable_client_certificate: bool
    :ivar disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in master region.
    :vartype disable_gateway: bool
    :ivar virtual_network_type: The type of VPN in which API Management service needs to be
     configured in. None (Default Value) means the API Management service is not part of any Virtual
     Network, External means the API Management deployment is set up inside a Virtual Network having
     an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
     a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
     "External", "Internal". Default value: "None".
    :vartype virtual_network_type: str or ~api_management_client.models.VirtualNetworkType
    :ivar api_version_constraint: Control Plane Apis version constraint for the API Management
     service.
    :vartype api_version_constraint: ~api_management_client.models.ApiVersionConstraint
    :ivar restore: Undelete Api Management Service if it was previously soft-deleted. If this flag
     is specified and set to True all other properties will be ignored.
    :vartype restore: bool
    :ivar private_endpoint_connections: List of Private Endpoint Connections of this service.
    :vartype private_endpoint_connections:
     list[~api_management_client.models.RemotePrivateEndpointConnectionWrapper]
    :ivar platform_version: Compute Platform Version running the service in this location. Possible
     values include: "undetermined", "stv1", "stv2", "mtv1".
    :vartype platform_version: str or ~api_management_client.models.PlatformVersion
    """

    _validation = {
        'notification_sender_email': {'max_length': 100, 'min_length': 0},
        'provisioning_state': {'readonly': True},
        'target_provisioning_state': {'readonly': True},
        'created_at_utc': {'readonly': True},
        'gateway_url': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'portal_url': {'readonly': True},
        'management_api_url': {'readonly': True},
        'scm_url': {'readonly': True},
        'developer_portal_url': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'platform_version': {'readonly': True},
    }

    _attribute_map = {
        'notification_sender_email': {'key': 'notificationSenderEmail', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'target_provisioning_state': {'key': 'targetProvisioningState', 'type': 'str'},
        'created_at_utc': {'key': 'createdAtUtc', 'type': 'iso-8601'},
        'gateway_url': {'key': 'gatewayUrl', 'type': 'str'},
        'gateway_regional_url': {'key': 'gatewayRegionalUrl', 'type': 'str'},
        'portal_url': {'key': 'portalUrl', 'type': 'str'},
        'management_api_url': {'key': 'managementApiUrl', 'type': 'str'},
        'scm_url': {'key': 'scmUrl', 'type': 'str'},
        'developer_portal_url': {'key': 'developerPortalUrl', 'type': 'str'},
        'hostname_configurations': {'key': 'hostnameConfigurations', 'type': '[HostnameConfiguration]'},
        'public_ip_addresses': {'key': 'publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'privateIPAddresses', 'type': '[str]'},
        'public_ip_address_id': {'key': 'publicIpAddressId', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'virtual_network_configuration': {'key': 'virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'additional_locations': {'key': 'additionalLocations', 'type': '[AdditionalLocation]'},
        'custom_properties': {'key': 'customProperties', 'type': '{str}'},
        'certificates': {'key': 'certificates', 'type': '[CertificateConfiguration]'},
        'enable_client_certificate': {'key': 'enableClientCertificate', 'type': 'bool'},
        'disable_gateway': {'key': 'disableGateway', 'type': 'bool'},
        'virtual_network_type': {'key': 'virtualNetworkType', 'type': 'str'},
        'api_version_constraint': {'key': 'apiVersionConstraint', 'type': 'ApiVersionConstraint'},
        'restore': {'key': 'restore', 'type': 'bool'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[RemotePrivateEndpointConnectionWrapper]'},
        'platform_version': {'key': 'platformVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        notification_sender_email: Optional[str] = None,
        hostname_configurations: Optional[List["HostnameConfiguration"]] = None,
        public_ip_address_id: Optional[str] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        virtual_network_configuration: Optional["VirtualNetworkConfiguration"] = None,
        additional_locations: Optional[List["AdditionalLocation"]] = None,
        custom_properties: Optional[Dict[str, str]] = None,
        certificates: Optional[List["CertificateConfiguration"]] = None,
        enable_client_certificate: Optional[bool] = False,
        disable_gateway: Optional[bool] = False,
        virtual_network_type: Optional[Union[str, "VirtualNetworkType"]] = "None",
        api_version_constraint: Optional["ApiVersionConstraint"] = None,
        restore: Optional[bool] = False,
        private_endpoint_connections: Optional[List["RemotePrivateEndpointConnectionWrapper"]] = None,
        **kwargs
    ):
        """
        :keyword notification_sender_email: Email address from which the notification will be sent.
        :paramtype notification_sender_email: str
        :keyword hostname_configurations: Custom hostname configuration of the API Management service.
        :paramtype hostname_configurations: list[~api_management_client.models.HostnameConfiguration]
        :keyword public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
         Virtual Network deployed service in the region. Supported only for Developer and Premium SKU
         being deployed in Virtual Network.
        :paramtype public_ip_address_id: str
        :keyword public_network_access: Whether or not public endpoint access is allowed for this API
         Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If
         'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'.
         Possible values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or ~api_management_client.models.PublicNetworkAccess
        :keyword virtual_network_configuration: Virtual network configuration of the API Management
         service.
        :paramtype virtual_network_configuration:
         ~api_management_client.models.VirtualNetworkConfiguration
        :keyword additional_locations: Additional datacenter locations of the API Management service.
        :paramtype additional_locations: list[~api_management_client.models.AdditionalLocation]
        :keyword custom_properties: Custom properties of the API Management service.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
         cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
         disable just TLS 1.1.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
         disable TLS 1.0 on an API Management service.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
         to disable just TLS 1.1 for communications with backends.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
         to disable TLS 1.0 for communications with backends.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
         HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
         PATCH operation will reset omitted properties' values to their defaults. For all the settings
         except Http2 the default value is ``True`` if the service was created on or before April 1st
         2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
         disable any of next ciphers by using settings
         `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
         TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
         TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
         TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
         TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
         For example,
         `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
         ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
         they are required by Azure CloudService internal components:
         TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
        :paramtype custom_properties: dict[str, str]
        :keyword certificates: List of Certificates that need to be installed in the API Management
         service. Max supported certificates that can be installed is 10.
        :paramtype certificates: list[~api_management_client.models.CertificateConfiguration]
        :keyword enable_client_certificate: Property only meant to be used for Consumption SKU Service.
         This enforces a client certificate to be presented on each request to the gateway. This also
         enables the ability to authenticate the certificate in the policy on the gateway.
        :paramtype enable_client_certificate: bool
        :keyword disable_gateway: Property only valid for an Api Management service deployed in
         multiple locations. This can be used to disable the gateway in master region.
        :paramtype disable_gateway: bool
        :keyword virtual_network_type: The type of VPN in which API Management service needs to be
         configured in. None (Default Value) means the API Management service is not part of any Virtual
         Network, External means the API Management deployment is set up inside a Virtual Network having
         an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
         a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
         "External", "Internal". Default value: "None".
        :paramtype virtual_network_type: str or ~api_management_client.models.VirtualNetworkType
        :keyword api_version_constraint: Control Plane Apis version constraint for the API Management
         service.
        :paramtype api_version_constraint: ~api_management_client.models.ApiVersionConstraint
        :keyword restore: Undelete Api Management Service if it was previously soft-deleted. If this
         flag is specified and set to True all other properties will be ignored.
        :paramtype restore: bool
        :keyword private_endpoint_connections: List of Private Endpoint Connections of this service.
        :paramtype private_endpoint_connections:
         list[~api_management_client.models.RemotePrivateEndpointConnectionWrapper]
        """
        super(ApiManagementServiceBaseProperties, self).__init__(**kwargs)
        self.notification_sender_email = notification_sender_email
        self.provisioning_state = None
        self.target_provisioning_state = None
        self.created_at_utc = None
        self.gateway_url = None
        self.gateway_regional_url = None
        self.portal_url = None
        self.management_api_url = None
        self.scm_url = None
        self.developer_portal_url = None
        self.hostname_configurations = hostname_configurations
        self.public_ip_addresses = None
        self.private_ip_addresses = None
        self.public_ip_address_id = public_ip_address_id
        self.public_network_access = public_network_access
        self.virtual_network_configuration = virtual_network_configuration
        self.additional_locations = additional_locations
        self.custom_properties = custom_properties
        self.certificates = certificates
        self.enable_client_certificate = enable_client_certificate
        self.disable_gateway = disable_gateway
        self.virtual_network_type = virtual_network_type
        self.api_version_constraint = api_version_constraint
        self.restore = restore
        self.private_endpoint_connections = private_endpoint_connections
        self.platform_version = None


class ApiManagementServiceCheckNameAvailabilityParameters(msrest.serialization.Model):
    """Parameters supplied to the CheckNameAvailability operation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name to check for availability.
    :vartype name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        """
        :keyword name: Required. The name to check for availability.
        :paramtype name: str
        """
        super(ApiManagementServiceCheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name


class ApiManagementServiceGetDomainOwnershipIdentifierResult(msrest.serialization.Model):
    """Response of the GetDomainOwnershipIdentifier operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar domain_ownership_identifier: The domain ownership identifier value.
    :vartype domain_ownership_identifier: str
    """

    _validation = {
        'domain_ownership_identifier': {'readonly': True},
    }

    _attribute_map = {
        'domain_ownership_identifier': {'key': 'domainOwnershipIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiManagementServiceGetDomainOwnershipIdentifierResult, self).__init__(**kwargs)
        self.domain_ownership_identifier = None


class ApiManagementServiceGetSsoTokenResult(msrest.serialization.Model):
    """The response of the GetSsoToken operation.

    :ivar redirect_uri: Redirect URL to the Publisher Portal containing the SSO token.
    :vartype redirect_uri: str
    """

    _attribute_map = {
        'redirect_uri': {'key': 'redirectUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        redirect_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword redirect_uri: Redirect URL to the Publisher Portal containing the SSO token.
        :paramtype redirect_uri: str
        """
        super(ApiManagementServiceGetSsoTokenResult, self).__init__(**kwargs)
        self.redirect_uri = redirect_uri


class ApiManagementServiceIdentity(msrest.serialization.Model):
    """Identity properties of the Api Management service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of identity used for the resource. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user assigned
     identities. The type 'None' will remove any identities from the service. Possible values
     include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :vartype type: str or ~api_management_client.models.ApimIdentityType
    :ivar principal_id: The principal id of the identity.
    :vartype principal_id: str
    :ivar tenant_id: The client tenant id of the identity.
    :vartype tenant_id: str
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
         providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~api_management_client.models.UserIdentityProperties]
    """

    _validation = {
        'type': {'required': True},
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentityProperties}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ApimIdentityType"],
        user_assigned_identities: Optional[Dict[str, "UserIdentityProperties"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. The type of identity used for the resource. The type 'SystemAssigned,
         UserAssigned' includes both an implicitly created identity and a set of user assigned
         identities. The type 'None' will remove any identities from the service. Possible values
         include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
        :paramtype type: str or ~api_management_client.models.ApimIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity
         dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
             providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~api_management_client.models.UserIdentityProperties]
        """
        super(ApiManagementServiceIdentity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None
        self.user_assigned_identities = user_assigned_identities


class ApiManagementServiceListResult(msrest.serialization.Model):
    """The response of the List API Management services operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Result of the List API Management services operation.
    :vartype value: list[~api_management_client.models.ApiManagementServiceResource]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of API Management services.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiManagementServiceResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ApiManagementServiceResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. Result of the List API Management services operation.
        :paramtype value: list[~api_management_client.models.ApiManagementServiceResource]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of API Management services.
        :paramtype next_link: str
        """
        super(ApiManagementServiceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApiManagementServiceNameAvailabilityResult(msrest.serialization.Model):
    """Response of the CheckNameAvailability operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: True if the name is available and can be used to create a new API
     Management service; otherwise false.
    :vartype name_available: bool
    :ivar message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that :code:`<resourceName>` is already in use, and direct
     them to select a different name.
    :vartype message: str
    :ivar reason: Invalid indicates the name provided does not match the resource provider’s naming
     requirements (incorrect length, unsupported characters, etc.)  AlreadyExists indicates that the
     name is already in use and is therefore unavailable. Possible values include: "Valid",
     "Invalid", "AlreadyExists".
    :vartype reason: str or ~api_management_client.models.NameAvailabilityReason
    """

    _validation = {
        'name_available': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'message': {'key': 'message', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[Union[str, "NameAvailabilityReason"]] = None,
        **kwargs
    ):
        """
        :keyword reason: Invalid indicates the name provided does not match the resource provider’s
         naming requirements (incorrect length, unsupported characters, etc.)  AlreadyExists indicates
         that the name is already in use and is therefore unavailable. Possible values include: "Valid",
         "Invalid", "AlreadyExists".
        :paramtype reason: str or ~api_management_client.models.NameAvailabilityReason
        """
        super(ApiManagementServiceNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.message = None
        self.reason = reason


class ApiManagementServiceProperties(ApiManagementServiceBaseProperties):
    """Properties of an API Management service resource description.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_sender_email: Email address from which the notification will be sent.
    :vartype notification_sender_email: str
    :ivar provisioning_state: The current provisioning state of the API Management service which
     can be one of the following:
     Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
    :vartype provisioning_state: str
    :ivar target_provisioning_state: The provisioning state of the API Management service, which is
     targeted by the long running operation started on the service.
    :vartype target_provisioning_state: str
    :ivar created_at_utc: Creation UTC date of the API Management service.The date conforms to the
     following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_at_utc: ~datetime.datetime
    :ivar gateway_url: Gateway URL of the API Management service.
    :vartype gateway_url: str
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Default Region.
    :vartype gateway_regional_url: str
    :ivar portal_url: Publisher portal endpoint Url of the API Management service.
    :vartype portal_url: str
    :ivar management_api_url: Management API endpoint URL of the API Management service.
    :vartype management_api_url: str
    :ivar scm_url: SCM endpoint URL of the API Management service.
    :vartype scm_url: str
    :ivar developer_portal_url: DEveloper Portal endpoint URL of the API Management service.
    :vartype developer_portal_url: str
    :ivar hostname_configurations: Custom hostname configuration of the API Management service.
    :vartype hostname_configurations: list[~api_management_client.models.HostnameConfiguration]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service in Primary region which is deployed in an Internal Virtual Network. Available only for
     Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :ivar public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
     Virtual Network deployed service in the region. Supported only for Developer and Premium SKU
     being deployed in Virtual Network.
    :vartype public_ip_address_id: str
    :ivar public_network_access: Whether or not public endpoint access is allowed for this API
     Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If
     'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'.
     Possible values include: "Enabled", "Disabled".
    :vartype public_network_access: str or ~api_management_client.models.PublicNetworkAccess
    :ivar virtual_network_configuration: Virtual network configuration of the API Management
     service.
    :vartype virtual_network_configuration:
     ~api_management_client.models.VirtualNetworkConfiguration
    :ivar additional_locations: Additional datacenter locations of the API Management service.
    :vartype additional_locations: list[~api_management_client.models.AdditionalLocation]
    :ivar custom_properties: Custom properties of the API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
     cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
     disable just TLS 1.1.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
     disable TLS 1.0 on an API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
     to disable just TLS 1.1 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
     to disable TLS 1.0 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
     HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
     PATCH operation will reset omitted properties' values to their defaults. For all the settings
     except Http2 the default value is ``True`` if the service was created on or before April 1st
     2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
     disable any of next ciphers by using settings
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
     TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
     TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
     For example,
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
     ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
     they are required by Azure CloudService internal components:
     TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
    :vartype custom_properties: dict[str, str]
    :ivar certificates: List of Certificates that need to be installed in the API Management
     service. Max supported certificates that can be installed is 10.
    :vartype certificates: list[~api_management_client.models.CertificateConfiguration]
    :ivar enable_client_certificate: Property only meant to be used for Consumption SKU Service.
     This enforces a client certificate to be presented on each request to the gateway. This also
     enables the ability to authenticate the certificate in the policy on the gateway.
    :vartype enable_client_certificate: bool
    :ivar disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in master region.
    :vartype disable_gateway: bool
    :ivar virtual_network_type: The type of VPN in which API Management service needs to be
     configured in. None (Default Value) means the API Management service is not part of any Virtual
     Network, External means the API Management deployment is set up inside a Virtual Network having
     an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
     a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
     "External", "Internal". Default value: "None".
    :vartype virtual_network_type: str or ~api_management_client.models.VirtualNetworkType
    :ivar api_version_constraint: Control Plane Apis version constraint for the API Management
     service.
    :vartype api_version_constraint: ~api_management_client.models.ApiVersionConstraint
    :ivar restore: Undelete Api Management Service if it was previously soft-deleted. If this flag
     is specified and set to True all other properties will be ignored.
    :vartype restore: bool
    :ivar private_endpoint_connections: List of Private Endpoint Connections of this service.
    :vartype private_endpoint_connections:
     list[~api_management_client.models.RemotePrivateEndpointConnectionWrapper]
    :ivar platform_version: Compute Platform Version running the service in this location. Possible
     values include: "undetermined", "stv1", "stv2", "mtv1".
    :vartype platform_version: str or ~api_management_client.models.PlatformVersion
    :ivar publisher_email: Required. Publisher email.
    :vartype publisher_email: str
    :ivar publisher_name: Required. Publisher name.
    :vartype publisher_name: str
    """

    _validation = {
        'notification_sender_email': {'max_length': 100, 'min_length': 0},
        'provisioning_state': {'readonly': True},
        'target_provisioning_state': {'readonly': True},
        'created_at_utc': {'readonly': True},
        'gateway_url': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'portal_url': {'readonly': True},
        'management_api_url': {'readonly': True},
        'scm_url': {'readonly': True},
        'developer_portal_url': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'platform_version': {'readonly': True},
        'publisher_email': {'required': True, 'max_length': 100, 'min_length': 0},
        'publisher_name': {'required': True, 'max_length': 100, 'min_length': 0},
    }

    _attribute_map = {
        'notification_sender_email': {'key': 'notificationSenderEmail', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'target_provisioning_state': {'key': 'targetProvisioningState', 'type': 'str'},
        'created_at_utc': {'key': 'createdAtUtc', 'type': 'iso-8601'},
        'gateway_url': {'key': 'gatewayUrl', 'type': 'str'},
        'gateway_regional_url': {'key': 'gatewayRegionalUrl', 'type': 'str'},
        'portal_url': {'key': 'portalUrl', 'type': 'str'},
        'management_api_url': {'key': 'managementApiUrl', 'type': 'str'},
        'scm_url': {'key': 'scmUrl', 'type': 'str'},
        'developer_portal_url': {'key': 'developerPortalUrl', 'type': 'str'},
        'hostname_configurations': {'key': 'hostnameConfigurations', 'type': '[HostnameConfiguration]'},
        'public_ip_addresses': {'key': 'publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'privateIPAddresses', 'type': '[str]'},
        'public_ip_address_id': {'key': 'publicIpAddressId', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'virtual_network_configuration': {'key': 'virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'additional_locations': {'key': 'additionalLocations', 'type': '[AdditionalLocation]'},
        'custom_properties': {'key': 'customProperties', 'type': '{str}'},
        'certificates': {'key': 'certificates', 'type': '[CertificateConfiguration]'},
        'enable_client_certificate': {'key': 'enableClientCertificate', 'type': 'bool'},
        'disable_gateway': {'key': 'disableGateway', 'type': 'bool'},
        'virtual_network_type': {'key': 'virtualNetworkType', 'type': 'str'},
        'api_version_constraint': {'key': 'apiVersionConstraint', 'type': 'ApiVersionConstraint'},
        'restore': {'key': 'restore', 'type': 'bool'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[RemotePrivateEndpointConnectionWrapper]'},
        'platform_version': {'key': 'platformVersion', 'type': 'str'},
        'publisher_email': {'key': 'publisherEmail', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        publisher_email: str,
        publisher_name: str,
        notification_sender_email: Optional[str] = None,
        hostname_configurations: Optional[List["HostnameConfiguration"]] = None,
        public_ip_address_id: Optional[str] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        virtual_network_configuration: Optional["VirtualNetworkConfiguration"] = None,
        additional_locations: Optional[List["AdditionalLocation"]] = None,
        custom_properties: Optional[Dict[str, str]] = None,
        certificates: Optional[List["CertificateConfiguration"]] = None,
        enable_client_certificate: Optional[bool] = False,
        disable_gateway: Optional[bool] = False,
        virtual_network_type: Optional[Union[str, "VirtualNetworkType"]] = "None",
        api_version_constraint: Optional["ApiVersionConstraint"] = None,
        restore: Optional[bool] = False,
        private_endpoint_connections: Optional[List["RemotePrivateEndpointConnectionWrapper"]] = None,
        **kwargs
    ):
        """
        :keyword notification_sender_email: Email address from which the notification will be sent.
        :paramtype notification_sender_email: str
        :keyword hostname_configurations: Custom hostname configuration of the API Management service.
        :paramtype hostname_configurations: list[~api_management_client.models.HostnameConfiguration]
        :keyword public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
         Virtual Network deployed service in the region. Supported only for Developer and Premium SKU
         being deployed in Virtual Network.
        :paramtype public_ip_address_id: str
        :keyword public_network_access: Whether or not public endpoint access is allowed for this API
         Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If
         'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'.
         Possible values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or ~api_management_client.models.PublicNetworkAccess
        :keyword virtual_network_configuration: Virtual network configuration of the API Management
         service.
        :paramtype virtual_network_configuration:
         ~api_management_client.models.VirtualNetworkConfiguration
        :keyword additional_locations: Additional datacenter locations of the API Management service.
        :paramtype additional_locations: list[~api_management_client.models.AdditionalLocation]
        :keyword custom_properties: Custom properties of the API Management service.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
         cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
         disable just TLS 1.1.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
         disable TLS 1.0 on an API Management service.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
         to disable just TLS 1.1 for communications with backends.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
         to disable TLS 1.0 for communications with backends.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
         HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
         PATCH operation will reset omitted properties' values to their defaults. For all the settings
         except Http2 the default value is ``True`` if the service was created on or before April 1st
         2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
         disable any of next ciphers by using settings
         `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
         TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
         TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
         TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
         TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
         For example,
         `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
         ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
         they are required by Azure CloudService internal components:
         TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
        :paramtype custom_properties: dict[str, str]
        :keyword certificates: List of Certificates that need to be installed in the API Management
         service. Max supported certificates that can be installed is 10.
        :paramtype certificates: list[~api_management_client.models.CertificateConfiguration]
        :keyword enable_client_certificate: Property only meant to be used for Consumption SKU Service.
         This enforces a client certificate to be presented on each request to the gateway. This also
         enables the ability to authenticate the certificate in the policy on the gateway.
        :paramtype enable_client_certificate: bool
        :keyword disable_gateway: Property only valid for an Api Management service deployed in
         multiple locations. This can be used to disable the gateway in master region.
        :paramtype disable_gateway: bool
        :keyword virtual_network_type: The type of VPN in which API Management service needs to be
         configured in. None (Default Value) means the API Management service is not part of any Virtual
         Network, External means the API Management deployment is set up inside a Virtual Network having
         an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
         a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
         "External", "Internal". Default value: "None".
        :paramtype virtual_network_type: str or ~api_management_client.models.VirtualNetworkType
        :keyword api_version_constraint: Control Plane Apis version constraint for the API Management
         service.
        :paramtype api_version_constraint: ~api_management_client.models.ApiVersionConstraint
        :keyword restore: Undelete Api Management Service if it was previously soft-deleted. If this
         flag is specified and set to True all other properties will be ignored.
        :paramtype restore: bool
        :keyword private_endpoint_connections: List of Private Endpoint Connections of this service.
        :paramtype private_endpoint_connections:
         list[~api_management_client.models.RemotePrivateEndpointConnectionWrapper]
        :keyword publisher_email: Required. Publisher email.
        :paramtype publisher_email: str
        :keyword publisher_name: Required. Publisher name.
        :paramtype publisher_name: str
        """
        super(ApiManagementServiceProperties, self).__init__(notification_sender_email=notification_sender_email, hostname_configurations=hostname_configurations, public_ip_address_id=public_ip_address_id, public_network_access=public_network_access, virtual_network_configuration=virtual_network_configuration, additional_locations=additional_locations, custom_properties=custom_properties, certificates=certificates, enable_client_certificate=enable_client_certificate, disable_gateway=disable_gateway, virtual_network_type=virtual_network_type, api_version_constraint=api_version_constraint, restore=restore, private_endpoint_connections=private_endpoint_connections, **kwargs)
        self.publisher_email = publisher_email
        self.publisher_name = publisher_name


class ApimResource(msrest.serialization.Model):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource is set to Microsoft.ApiManagement.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(ApimResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags


class ApiManagementServiceResource(ApimResource):
    """A single API Management service resource in List or Get response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource is set to Microsoft.ApiManagement.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Required. SKU properties of the API Management service.
    :vartype sku: ~api_management_client.models.ApiManagementServiceSkuProperties
    :ivar identity: Managed service identity of the Api Management service.
    :vartype identity: ~api_management_client.models.ApiManagementServiceIdentity
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~api_management_client.models.SystemData
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar etag: ETag of the resource.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar notification_sender_email: Email address from which the notification will be sent.
    :vartype notification_sender_email: str
    :ivar provisioning_state: The current provisioning state of the API Management service which
     can be one of the following:
     Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
    :vartype provisioning_state: str
    :ivar target_provisioning_state: The provisioning state of the API Management service, which is
     targeted by the long running operation started on the service.
    :vartype target_provisioning_state: str
    :ivar created_at_utc: Creation UTC date of the API Management service.The date conforms to the
     following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_at_utc: ~datetime.datetime
    :ivar gateway_url: Gateway URL of the API Management service.
    :vartype gateway_url: str
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Default Region.
    :vartype gateway_regional_url: str
    :ivar portal_url: Publisher portal endpoint Url of the API Management service.
    :vartype portal_url: str
    :ivar management_api_url: Management API endpoint URL of the API Management service.
    :vartype management_api_url: str
    :ivar scm_url: SCM endpoint URL of the API Management service.
    :vartype scm_url: str
    :ivar developer_portal_url: DEveloper Portal endpoint URL of the API Management service.
    :vartype developer_portal_url: str
    :ivar hostname_configurations: Custom hostname configuration of the API Management service.
    :vartype hostname_configurations: list[~api_management_client.models.HostnameConfiguration]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service in Primary region which is deployed in an Internal Virtual Network. Available only for
     Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :ivar public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
     Virtual Network deployed service in the region. Supported only for Developer and Premium SKU
     being deployed in Virtual Network.
    :vartype public_ip_address_id: str
    :ivar public_network_access: Whether or not public endpoint access is allowed for this API
     Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If
     'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'.
     Possible values include: "Enabled", "Disabled".
    :vartype public_network_access: str or ~api_management_client.models.PublicNetworkAccess
    :ivar virtual_network_configuration: Virtual network configuration of the API Management
     service.
    :vartype virtual_network_configuration:
     ~api_management_client.models.VirtualNetworkConfiguration
    :ivar additional_locations: Additional datacenter locations of the API Management service.
    :vartype additional_locations: list[~api_management_client.models.AdditionalLocation]
    :ivar custom_properties: Custom properties of the API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
     cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
     disable just TLS 1.1.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
     disable TLS 1.0 on an API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
     to disable just TLS 1.1 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
     to disable TLS 1.0 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
     HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
     PATCH operation will reset omitted properties' values to their defaults. For all the settings
     except Http2 the default value is ``True`` if the service was created on or before April 1st
     2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
     disable any of next ciphers by using settings
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
     TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
     TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
     For example,
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
     ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
     they are required by Azure CloudService internal components:
     TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
    :vartype custom_properties: dict[str, str]
    :ivar certificates: List of Certificates that need to be installed in the API Management
     service. Max supported certificates that can be installed is 10.
    :vartype certificates: list[~api_management_client.models.CertificateConfiguration]
    :ivar enable_client_certificate: Property only meant to be used for Consumption SKU Service.
     This enforces a client certificate to be presented on each request to the gateway. This also
     enables the ability to authenticate the certificate in the policy on the gateway.
    :vartype enable_client_certificate: bool
    :ivar disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in master region.
    :vartype disable_gateway: bool
    :ivar virtual_network_type: The type of VPN in which API Management service needs to be
     configured in. None (Default Value) means the API Management service is not part of any Virtual
     Network, External means the API Management deployment is set up inside a Virtual Network having
     an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
     a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
     "External", "Internal". Default value: "None".
    :vartype virtual_network_type: str or ~api_management_client.models.VirtualNetworkType
    :ivar api_version_constraint: Control Plane Apis version constraint for the API Management
     service.
    :vartype api_version_constraint: ~api_management_client.models.ApiVersionConstraint
    :ivar restore: Undelete Api Management Service if it was previously soft-deleted. If this flag
     is specified and set to True all other properties will be ignored.
    :vartype restore: bool
    :ivar private_endpoint_connections: List of Private Endpoint Connections of this service.
    :vartype private_endpoint_connections:
     list[~api_management_client.models.RemotePrivateEndpointConnectionWrapper]
    :ivar platform_version: Compute Platform Version running the service in this location. Possible
     values include: "undetermined", "stv1", "stv2", "mtv1".
    :vartype platform_version: str or ~api_management_client.models.PlatformVersion
    :ivar publisher_email: Required. Publisher email.
    :vartype publisher_email: str
    :ivar publisher_name: Required. Publisher name.
    :vartype publisher_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'required': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'notification_sender_email': {'max_length': 100, 'min_length': 0},
        'provisioning_state': {'readonly': True},
        'target_provisioning_state': {'readonly': True},
        'created_at_utc': {'readonly': True},
        'gateway_url': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'portal_url': {'readonly': True},
        'management_api_url': {'readonly': True},
        'scm_url': {'readonly': True},
        'developer_portal_url': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'platform_version': {'readonly': True},
        'publisher_email': {'required': True, 'max_length': 100, 'min_length': 0},
        'publisher_name': {'required': True, 'max_length': 100, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ApiManagementServiceSkuProperties'},
        'identity': {'key': 'identity', 'type': 'ApiManagementServiceIdentity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'notification_sender_email': {'key': 'properties.notificationSenderEmail', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'target_provisioning_state': {'key': 'properties.targetProvisioningState', 'type': 'str'},
        'created_at_utc': {'key': 'properties.createdAtUtc', 'type': 'iso-8601'},
        'gateway_url': {'key': 'properties.gatewayUrl', 'type': 'str'},
        'gateway_regional_url': {'key': 'properties.gatewayRegionalUrl', 'type': 'str'},
        'portal_url': {'key': 'properties.portalUrl', 'type': 'str'},
        'management_api_url': {'key': 'properties.managementApiUrl', 'type': 'str'},
        'scm_url': {'key': 'properties.scmUrl', 'type': 'str'},
        'developer_portal_url': {'key': 'properties.developerPortalUrl', 'type': 'str'},
        'hostname_configurations': {'key': 'properties.hostnameConfigurations', 'type': '[HostnameConfiguration]'},
        'public_ip_addresses': {'key': 'properties.publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'properties.privateIPAddresses', 'type': '[str]'},
        'public_ip_address_id': {'key': 'properties.publicIpAddressId', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'virtual_network_configuration': {'key': 'properties.virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'additional_locations': {'key': 'properties.additionalLocations', 'type': '[AdditionalLocation]'},
        'custom_properties': {'key': 'properties.customProperties', 'type': '{str}'},
        'certificates': {'key': 'properties.certificates', 'type': '[CertificateConfiguration]'},
        'enable_client_certificate': {'key': 'properties.enableClientCertificate', 'type': 'bool'},
        'disable_gateway': {'key': 'properties.disableGateway', 'type': 'bool'},
        'virtual_network_type': {'key': 'properties.virtualNetworkType', 'type': 'str'},
        'api_version_constraint': {'key': 'properties.apiVersionConstraint', 'type': 'ApiVersionConstraint'},
        'restore': {'key': 'properties.restore', 'type': 'bool'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[RemotePrivateEndpointConnectionWrapper]'},
        'platform_version': {'key': 'properties.platformVersion', 'type': 'str'},
        'publisher_email': {'key': 'properties.publisherEmail', 'type': 'str'},
        'publisher_name': {'key': 'properties.publisherName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sku: "ApiManagementServiceSkuProperties",
        location: str,
        publisher_email: str,
        publisher_name: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ApiManagementServiceIdentity"] = None,
        zones: Optional[List[str]] = None,
        notification_sender_email: Optional[str] = None,
        hostname_configurations: Optional[List["HostnameConfiguration"]] = None,
        public_ip_address_id: Optional[str] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        virtual_network_configuration: Optional["VirtualNetworkConfiguration"] = None,
        additional_locations: Optional[List["AdditionalLocation"]] = None,
        custom_properties: Optional[Dict[str, str]] = None,
        certificates: Optional[List["CertificateConfiguration"]] = None,
        enable_client_certificate: Optional[bool] = False,
        disable_gateway: Optional[bool] = False,
        virtual_network_type: Optional[Union[str, "VirtualNetworkType"]] = "None",
        api_version_constraint: Optional["ApiVersionConstraint"] = None,
        restore: Optional[bool] = False,
        private_endpoint_connections: Optional[List["RemotePrivateEndpointConnectionWrapper"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Required. SKU properties of the API Management service.
        :paramtype sku: ~api_management_client.models.ApiManagementServiceSkuProperties
        :keyword identity: Managed service identity of the Api Management service.
        :paramtype identity: ~api_management_client.models.ApiManagementServiceIdentity
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword notification_sender_email: Email address from which the notification will be sent.
        :paramtype notification_sender_email: str
        :keyword hostname_configurations: Custom hostname configuration of the API Management service.
        :paramtype hostname_configurations: list[~api_management_client.models.HostnameConfiguration]
        :keyword public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
         Virtual Network deployed service in the region. Supported only for Developer and Premium SKU
         being deployed in Virtual Network.
        :paramtype public_ip_address_id: str
        :keyword public_network_access: Whether or not public endpoint access is allowed for this API
         Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If
         'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'.
         Possible values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or ~api_management_client.models.PublicNetworkAccess
        :keyword virtual_network_configuration: Virtual network configuration of the API Management
         service.
        :paramtype virtual_network_configuration:
         ~api_management_client.models.VirtualNetworkConfiguration
        :keyword additional_locations: Additional datacenter locations of the API Management service.
        :paramtype additional_locations: list[~api_management_client.models.AdditionalLocation]
        :keyword custom_properties: Custom properties of the API Management service.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
         cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
         disable just TLS 1.1.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
         disable TLS 1.0 on an API Management service.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
         to disable just TLS 1.1 for communications with backends.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
         to disable TLS 1.0 for communications with backends.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
         HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
         PATCH operation will reset omitted properties' values to their defaults. For all the settings
         except Http2 the default value is ``True`` if the service was created on or before April 1st
         2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
         disable any of next ciphers by using settings
         `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
         TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
         TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
         TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
         TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
         For example,
         `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
         ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
         they are required by Azure CloudService internal components:
         TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
        :paramtype custom_properties: dict[str, str]
        :keyword certificates: List of Certificates that need to be installed in the API Management
         service. Max supported certificates that can be installed is 10.
        :paramtype certificates: list[~api_management_client.models.CertificateConfiguration]
        :keyword enable_client_certificate: Property only meant to be used for Consumption SKU Service.
         This enforces a client certificate to be presented on each request to the gateway. This also
         enables the ability to authenticate the certificate in the policy on the gateway.
        :paramtype enable_client_certificate: bool
        :keyword disable_gateway: Property only valid for an Api Management service deployed in
         multiple locations. This can be used to disable the gateway in master region.
        :paramtype disable_gateway: bool
        :keyword virtual_network_type: The type of VPN in which API Management service needs to be
         configured in. None (Default Value) means the API Management service is not part of any Virtual
         Network, External means the API Management deployment is set up inside a Virtual Network having
         an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
         a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
         "External", "Internal". Default value: "None".
        :paramtype virtual_network_type: str or ~api_management_client.models.VirtualNetworkType
        :keyword api_version_constraint: Control Plane Apis version constraint for the API Management
         service.
        :paramtype api_version_constraint: ~api_management_client.models.ApiVersionConstraint
        :keyword restore: Undelete Api Management Service if it was previously soft-deleted. If this
         flag is specified and set to True all other properties will be ignored.
        :paramtype restore: bool
        :keyword private_endpoint_connections: List of Private Endpoint Connections of this service.
        :paramtype private_endpoint_connections:
         list[~api_management_client.models.RemotePrivateEndpointConnectionWrapper]
        :keyword publisher_email: Required. Publisher email.
        :paramtype publisher_email: str
        :keyword publisher_name: Required. Publisher name.
        :paramtype publisher_name: str
        """
        super(ApiManagementServiceResource, self).__init__(tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.system_data = None
        self.location = location
        self.etag = None
        self.zones = zones
        self.notification_sender_email = notification_sender_email
        self.provisioning_state = None
        self.target_provisioning_state = None
        self.created_at_utc = None
        self.gateway_url = None
        self.gateway_regional_url = None
        self.portal_url = None
        self.management_api_url = None
        self.scm_url = None
        self.developer_portal_url = None
        self.hostname_configurations = hostname_configurations
        self.public_ip_addresses = None
        self.private_ip_addresses = None
        self.public_ip_address_id = public_ip_address_id
        self.public_network_access = public_network_access
        self.virtual_network_configuration = virtual_network_configuration
        self.additional_locations = additional_locations
        self.custom_properties = custom_properties
        self.certificates = certificates
        self.enable_client_certificate = enable_client_certificate
        self.disable_gateway = disable_gateway
        self.virtual_network_type = virtual_network_type
        self.api_version_constraint = api_version_constraint
        self.restore = restore
        self.private_endpoint_connections = private_endpoint_connections
        self.platform_version = None
        self.publisher_email = publisher_email
        self.publisher_name = publisher_name


class ApiManagementServiceSkuProperties(msrest.serialization.Model):
    """API Management service resource SKU properties.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Name of the Sku. Possible values include: "Developer", "Standard",
     "Premium", "Basic", "Consumption", "Isolated".
    :vartype name: str or ~api_management_client.models.SkuType
    :ivar capacity: Required. Capacity of the SKU (number of deployed units of the SKU). For
     Consumption SKU capacity must be specified as 0.
    :vartype capacity: int
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuType"],
        capacity: int,
        **kwargs
    ):
        """
        :keyword name: Required. Name of the Sku. Possible values include: "Developer", "Standard",
         "Premium", "Basic", "Consumption", "Isolated".
        :paramtype name: str or ~api_management_client.models.SkuType
        :keyword capacity: Required. Capacity of the SKU (number of deployed units of the SKU). For
         Consumption SKU capacity must be specified as 0.
        :paramtype capacity: int
        """
        super(ApiManagementServiceSkuProperties, self).__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class ApiManagementServiceUpdateParameters(ApimResource):
    """Parameter supplied to Update Api Management Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource is set to Microsoft.ApiManagement.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: SKU properties of the API Management service.
    :vartype sku: ~api_management_client.models.ApiManagementServiceSkuProperties
    :ivar identity: Managed service identity of the Api Management service.
    :vartype identity: ~api_management_client.models.ApiManagementServiceIdentity
    :ivar etag: ETag of the resource.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar notification_sender_email: Email address from which the notification will be sent.
    :vartype notification_sender_email: str
    :ivar provisioning_state: The current provisioning state of the API Management service which
     can be one of the following:
     Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
    :vartype provisioning_state: str
    :ivar target_provisioning_state: The provisioning state of the API Management service, which is
     targeted by the long running operation started on the service.
    :vartype target_provisioning_state: str
    :ivar created_at_utc: Creation UTC date of the API Management service.The date conforms to the
     following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_at_utc: ~datetime.datetime
    :ivar gateway_url: Gateway URL of the API Management service.
    :vartype gateway_url: str
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Default Region.
    :vartype gateway_regional_url: str
    :ivar portal_url: Publisher portal endpoint Url of the API Management service.
    :vartype portal_url: str
    :ivar management_api_url: Management API endpoint URL of the API Management service.
    :vartype management_api_url: str
    :ivar scm_url: SCM endpoint URL of the API Management service.
    :vartype scm_url: str
    :ivar developer_portal_url: DEveloper Portal endpoint URL of the API Management service.
    :vartype developer_portal_url: str
    :ivar hostname_configurations: Custom hostname configuration of the API Management service.
    :vartype hostname_configurations: list[~api_management_client.models.HostnameConfiguration]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service in Primary region which is deployed in an Internal Virtual Network. Available only for
     Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :ivar public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
     Virtual Network deployed service in the region. Supported only for Developer and Premium SKU
     being deployed in Virtual Network.
    :vartype public_ip_address_id: str
    :ivar public_network_access: Whether or not public endpoint access is allowed for this API
     Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If
     'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'.
     Possible values include: "Enabled", "Disabled".
    :vartype public_network_access: str or ~api_management_client.models.PublicNetworkAccess
    :ivar virtual_network_configuration: Virtual network configuration of the API Management
     service.
    :vartype virtual_network_configuration:
     ~api_management_client.models.VirtualNetworkConfiguration
    :ivar additional_locations: Additional datacenter locations of the API Management service.
    :vartype additional_locations: list[~api_management_client.models.AdditionalLocation]
    :ivar custom_properties: Custom properties of the API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
     cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
     disable just TLS 1.1.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
     disable TLS 1.0 on an API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
     to disable just TLS 1.1 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
     to disable TLS 1.0 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
     HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
     PATCH operation will reset omitted properties' values to their defaults. For all the settings
     except Http2 the default value is ``True`` if the service was created on or before April 1st
     2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
     disable any of next ciphers by using settings
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
     TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
     TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
     For example,
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
     ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
     they are required by Azure CloudService internal components:
     TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
    :vartype custom_properties: dict[str, str]
    :ivar certificates: List of Certificates that need to be installed in the API Management
     service. Max supported certificates that can be installed is 10.
    :vartype certificates: list[~api_management_client.models.CertificateConfiguration]
    :ivar enable_client_certificate: Property only meant to be used for Consumption SKU Service.
     This enforces a client certificate to be presented on each request to the gateway. This also
     enables the ability to authenticate the certificate in the policy on the gateway.
    :vartype enable_client_certificate: bool
    :ivar disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in master region.
    :vartype disable_gateway: bool
    :ivar virtual_network_type: The type of VPN in which API Management service needs to be
     configured in. None (Default Value) means the API Management service is not part of any Virtual
     Network, External means the API Management deployment is set up inside a Virtual Network having
     an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
     a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
     "External", "Internal". Default value: "None".
    :vartype virtual_network_type: str or ~api_management_client.models.VirtualNetworkType
    :ivar api_version_constraint: Control Plane Apis version constraint for the API Management
     service.
    :vartype api_version_constraint: ~api_management_client.models.ApiVersionConstraint
    :ivar restore: Undelete Api Management Service if it was previously soft-deleted. If this flag
     is specified and set to True all other properties will be ignored.
    :vartype restore: bool
    :ivar private_endpoint_connections: List of Private Endpoint Connections of this service.
    :vartype private_endpoint_connections:
     list[~api_management_client.models.RemotePrivateEndpointConnectionWrapper]
    :ivar platform_version: Compute Platform Version running the service in this location. Possible
     values include: "undetermined", "stv1", "stv2", "mtv1".
    :vartype platform_version: str or ~api_management_client.models.PlatformVersion
    :ivar publisher_email: Publisher email.
    :vartype publisher_email: str
    :ivar publisher_name: Publisher name.
    :vartype publisher_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'notification_sender_email': {'max_length': 100, 'min_length': 0},
        'provisioning_state': {'readonly': True},
        'target_provisioning_state': {'readonly': True},
        'created_at_utc': {'readonly': True},
        'gateway_url': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'portal_url': {'readonly': True},
        'management_api_url': {'readonly': True},
        'scm_url': {'readonly': True},
        'developer_portal_url': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'platform_version': {'readonly': True},
        'publisher_email': {'max_length': 100, 'min_length': 0},
        'publisher_name': {'max_length': 100, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ApiManagementServiceSkuProperties'},
        'identity': {'key': 'identity', 'type': 'ApiManagementServiceIdentity'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'notification_sender_email': {'key': 'properties.notificationSenderEmail', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'target_provisioning_state': {'key': 'properties.targetProvisioningState', 'type': 'str'},
        'created_at_utc': {'key': 'properties.createdAtUtc', 'type': 'iso-8601'},
        'gateway_url': {'key': 'properties.gatewayUrl', 'type': 'str'},
        'gateway_regional_url': {'key': 'properties.gatewayRegionalUrl', 'type': 'str'},
        'portal_url': {'key': 'properties.portalUrl', 'type': 'str'},
        'management_api_url': {'key': 'properties.managementApiUrl', 'type': 'str'},
        'scm_url': {'key': 'properties.scmUrl', 'type': 'str'},
        'developer_portal_url': {'key': 'properties.developerPortalUrl', 'type': 'str'},
        'hostname_configurations': {'key': 'properties.hostnameConfigurations', 'type': '[HostnameConfiguration]'},
        'public_ip_addresses': {'key': 'properties.publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'properties.privateIPAddresses', 'type': '[str]'},
        'public_ip_address_id': {'key': 'properties.publicIpAddressId', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'virtual_network_configuration': {'key': 'properties.virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'additional_locations': {'key': 'properties.additionalLocations', 'type': '[AdditionalLocation]'},
        'custom_properties': {'key': 'properties.customProperties', 'type': '{str}'},
        'certificates': {'key': 'properties.certificates', 'type': '[CertificateConfiguration]'},
        'enable_client_certificate': {'key': 'properties.enableClientCertificate', 'type': 'bool'},
        'disable_gateway': {'key': 'properties.disableGateway', 'type': 'bool'},
        'virtual_network_type': {'key': 'properties.virtualNetworkType', 'type': 'str'},
        'api_version_constraint': {'key': 'properties.apiVersionConstraint', 'type': 'ApiVersionConstraint'},
        'restore': {'key': 'properties.restore', 'type': 'bool'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[RemotePrivateEndpointConnectionWrapper]'},
        'platform_version': {'key': 'properties.platformVersion', 'type': 'str'},
        'publisher_email': {'key': 'properties.publisherEmail', 'type': 'str'},
        'publisher_name': {'key': 'properties.publisherName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["ApiManagementServiceSkuProperties"] = None,
        identity: Optional["ApiManagementServiceIdentity"] = None,
        zones: Optional[List[str]] = None,
        notification_sender_email: Optional[str] = None,
        hostname_configurations: Optional[List["HostnameConfiguration"]] = None,
        public_ip_address_id: Optional[str] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        virtual_network_configuration: Optional["VirtualNetworkConfiguration"] = None,
        additional_locations: Optional[List["AdditionalLocation"]] = None,
        custom_properties: Optional[Dict[str, str]] = None,
        certificates: Optional[List["CertificateConfiguration"]] = None,
        enable_client_certificate: Optional[bool] = False,
        disable_gateway: Optional[bool] = False,
        virtual_network_type: Optional[Union[str, "VirtualNetworkType"]] = "None",
        api_version_constraint: Optional["ApiVersionConstraint"] = None,
        restore: Optional[bool] = False,
        private_endpoint_connections: Optional[List["RemotePrivateEndpointConnectionWrapper"]] = None,
        publisher_email: Optional[str] = None,
        publisher_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: SKU properties of the API Management service.
        :paramtype sku: ~api_management_client.models.ApiManagementServiceSkuProperties
        :keyword identity: Managed service identity of the Api Management service.
        :paramtype identity: ~api_management_client.models.ApiManagementServiceIdentity
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword notification_sender_email: Email address from which the notification will be sent.
        :paramtype notification_sender_email: str
        :keyword hostname_configurations: Custom hostname configuration of the API Management service.
        :paramtype hostname_configurations: list[~api_management_client.models.HostnameConfiguration]
        :keyword public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
         Virtual Network deployed service in the region. Supported only for Developer and Premium SKU
         being deployed in Virtual Network.
        :paramtype public_ip_address_id: str
        :keyword public_network_access: Whether or not public endpoint access is allowed for this API
         Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If
         'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'.
         Possible values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or ~api_management_client.models.PublicNetworkAccess
        :keyword virtual_network_configuration: Virtual network configuration of the API Management
         service.
        :paramtype virtual_network_configuration:
         ~api_management_client.models.VirtualNetworkConfiguration
        :keyword additional_locations: Additional datacenter locations of the API Management service.
        :paramtype additional_locations: list[~api_management_client.models.AdditionalLocation]
        :keyword custom_properties: Custom properties of the API Management service.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
         cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
         disable just TLS 1.1.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
         disable TLS 1.0 on an API Management service.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
         to disable just TLS 1.1 for communications with backends.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
         to disable TLS 1.0 for communications with backends.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
         HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
         PATCH operation will reset omitted properties' values to their defaults. For all the settings
         except Http2 the default value is ``True`` if the service was created on or before April 1st
         2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
         disable any of next ciphers by using settings
         `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
         TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
         TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
         TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
         TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
         For example,
         `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
         ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
         they are required by Azure CloudService internal components:
         TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
        :paramtype custom_properties: dict[str, str]
        :keyword certificates: List of Certificates that need to be installed in the API Management
         service. Max supported certificates that can be installed is 10.
        :paramtype certificates: list[~api_management_client.models.CertificateConfiguration]
        :keyword enable_client_certificate: Property only meant to be used for Consumption SKU Service.
         This enforces a client certificate to be presented on each request to the gateway. This also
         enables the ability to authenticate the certificate in the policy on the gateway.
        :paramtype enable_client_certificate: bool
        :keyword disable_gateway: Property only valid for an Api Management service deployed in
         multiple locations. This can be used to disable the gateway in master region.
        :paramtype disable_gateway: bool
        :keyword virtual_network_type: The type of VPN in which API Management service needs to be
         configured in. None (Default Value) means the API Management service is not part of any Virtual
         Network, External means the API Management deployment is set up inside a Virtual Network having
         an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
         a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
         "External", "Internal". Default value: "None".
        :paramtype virtual_network_type: str or ~api_management_client.models.VirtualNetworkType
        :keyword api_version_constraint: Control Plane Apis version constraint for the API Management
         service.
        :paramtype api_version_constraint: ~api_management_client.models.ApiVersionConstraint
        :keyword restore: Undelete Api Management Service if it was previously soft-deleted. If this
         flag is specified and set to True all other properties will be ignored.
        :paramtype restore: bool
        :keyword private_endpoint_connections: List of Private Endpoint Connections of this service.
        :paramtype private_endpoint_connections:
         list[~api_management_client.models.RemotePrivateEndpointConnectionWrapper]
        :keyword publisher_email: Publisher email.
        :paramtype publisher_email: str
        :keyword publisher_name: Publisher name.
        :paramtype publisher_name: str
        """
        super(ApiManagementServiceUpdateParameters, self).__init__(tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.etag = None
        self.zones = zones
        self.notification_sender_email = notification_sender_email
        self.provisioning_state = None
        self.target_provisioning_state = None
        self.created_at_utc = None
        self.gateway_url = None
        self.gateway_regional_url = None
        self.portal_url = None
        self.management_api_url = None
        self.scm_url = None
        self.developer_portal_url = None
        self.hostname_configurations = hostname_configurations
        self.public_ip_addresses = None
        self.private_ip_addresses = None
        self.public_ip_address_id = public_ip_address_id
        self.public_network_access = public_network_access
        self.virtual_network_configuration = virtual_network_configuration
        self.additional_locations = additional_locations
        self.custom_properties = custom_properties
        self.certificates = certificates
        self.enable_client_certificate = enable_client_certificate
        self.disable_gateway = disable_gateway
        self.virtual_network_type = virtual_network_type
        self.api_version_constraint = api_version_constraint
        self.restore = restore
        self.private_endpoint_connections = private_endpoint_connections
        self.platform_version = None
        self.publisher_email = publisher_email
        self.publisher_name = publisher_name


class ApiManagementServiceUpdateProperties(ApiManagementServiceBaseProperties):
    """Properties of an API Management service resource description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar notification_sender_email: Email address from which the notification will be sent.
    :vartype notification_sender_email: str
    :ivar provisioning_state: The current provisioning state of the API Management service which
     can be one of the following:
     Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
    :vartype provisioning_state: str
    :ivar target_provisioning_state: The provisioning state of the API Management service, which is
     targeted by the long running operation started on the service.
    :vartype target_provisioning_state: str
    :ivar created_at_utc: Creation UTC date of the API Management service.The date conforms to the
     following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_at_utc: ~datetime.datetime
    :ivar gateway_url: Gateway URL of the API Management service.
    :vartype gateway_url: str
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Default Region.
    :vartype gateway_regional_url: str
    :ivar portal_url: Publisher portal endpoint Url of the API Management service.
    :vartype portal_url: str
    :ivar management_api_url: Management API endpoint URL of the API Management service.
    :vartype management_api_url: str
    :ivar scm_url: SCM endpoint URL of the API Management service.
    :vartype scm_url: str
    :ivar developer_portal_url: DEveloper Portal endpoint URL of the API Management service.
    :vartype developer_portal_url: str
    :ivar hostname_configurations: Custom hostname configuration of the API Management service.
    :vartype hostname_configurations: list[~api_management_client.models.HostnameConfiguration]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service in Primary region which is deployed in an Internal Virtual Network. Available only for
     Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :ivar public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
     Virtual Network deployed service in the region. Supported only for Developer and Premium SKU
     being deployed in Virtual Network.
    :vartype public_ip_address_id: str
    :ivar public_network_access: Whether or not public endpoint access is allowed for this API
     Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If
     'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'.
     Possible values include: "Enabled", "Disabled".
    :vartype public_network_access: str or ~api_management_client.models.PublicNetworkAccess
    :ivar virtual_network_configuration: Virtual network configuration of the API Management
     service.
    :vartype virtual_network_configuration:
     ~api_management_client.models.VirtualNetworkConfiguration
    :ivar additional_locations: Additional datacenter locations of the API Management service.
    :vartype additional_locations: list[~api_management_client.models.AdditionalLocation]
    :ivar custom_properties: Custom properties of the API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
     cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
     disable just TLS 1.1.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
     disable TLS 1.0 on an API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
     to disable just TLS 1.1 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
     to disable TLS 1.0 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
     HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
     PATCH operation will reset omitted properties' values to their defaults. For all the settings
     except Http2 the default value is ``True`` if the service was created on or before April 1st
     2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
     disable any of next ciphers by using settings
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
     TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
     TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
     For example,
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
     ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
     they are required by Azure CloudService internal components:
     TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
    :vartype custom_properties: dict[str, str]
    :ivar certificates: List of Certificates that need to be installed in the API Management
     service. Max supported certificates that can be installed is 10.
    :vartype certificates: list[~api_management_client.models.CertificateConfiguration]
    :ivar enable_client_certificate: Property only meant to be used for Consumption SKU Service.
     This enforces a client certificate to be presented on each request to the gateway. This also
     enables the ability to authenticate the certificate in the policy on the gateway.
    :vartype enable_client_certificate: bool
    :ivar disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in master region.
    :vartype disable_gateway: bool
    :ivar virtual_network_type: The type of VPN in which API Management service needs to be
     configured in. None (Default Value) means the API Management service is not part of any Virtual
     Network, External means the API Management deployment is set up inside a Virtual Network having
     an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
     a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
     "External", "Internal". Default value: "None".
    :vartype virtual_network_type: str or ~api_management_client.models.VirtualNetworkType
    :ivar api_version_constraint: Control Plane Apis version constraint for the API Management
     service.
    :vartype api_version_constraint: ~api_management_client.models.ApiVersionConstraint
    :ivar restore: Undelete Api Management Service if it was previously soft-deleted. If this flag
     is specified and set to True all other properties will be ignored.
    :vartype restore: bool
    :ivar private_endpoint_connections: List of Private Endpoint Connections of this service.
    :vartype private_endpoint_connections:
     list[~api_management_client.models.RemotePrivateEndpointConnectionWrapper]
    :ivar platform_version: Compute Platform Version running the service in this location. Possible
     values include: "undetermined", "stv1", "stv2", "mtv1".
    :vartype platform_version: str or ~api_management_client.models.PlatformVersion
    :ivar publisher_email: Publisher email.
    :vartype publisher_email: str
    :ivar publisher_name: Publisher name.
    :vartype publisher_name: str
    """

    _validation = {
        'notification_sender_email': {'max_length': 100, 'min_length': 0},
        'provisioning_state': {'readonly': True},
        'target_provisioning_state': {'readonly': True},
        'created_at_utc': {'readonly': True},
        'gateway_url': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'portal_url': {'readonly': True},
        'management_api_url': {'readonly': True},
        'scm_url': {'readonly': True},
        'developer_portal_url': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'platform_version': {'readonly': True},
        'publisher_email': {'max_length': 100, 'min_length': 0},
        'publisher_name': {'max_length': 100, 'min_length': 0},
    }

    _attribute_map = {
        'notification_sender_email': {'key': 'notificationSenderEmail', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'target_provisioning_state': {'key': 'targetProvisioningState', 'type': 'str'},
        'created_at_utc': {'key': 'createdAtUtc', 'type': 'iso-8601'},
        'gateway_url': {'key': 'gatewayUrl', 'type': 'str'},
        'gateway_regional_url': {'key': 'gatewayRegionalUrl', 'type': 'str'},
        'portal_url': {'key': 'portalUrl', 'type': 'str'},
        'management_api_url': {'key': 'managementApiUrl', 'type': 'str'},
        'scm_url': {'key': 'scmUrl', 'type': 'str'},
        'developer_portal_url': {'key': 'developerPortalUrl', 'type': 'str'},
        'hostname_configurations': {'key': 'hostnameConfigurations', 'type': '[HostnameConfiguration]'},
        'public_ip_addresses': {'key': 'publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'privateIPAddresses', 'type': '[str]'},
        'public_ip_address_id': {'key': 'publicIpAddressId', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'virtual_network_configuration': {'key': 'virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'additional_locations': {'key': 'additionalLocations', 'type': '[AdditionalLocation]'},
        'custom_properties': {'key': 'customProperties', 'type': '{str}'},
        'certificates': {'key': 'certificates', 'type': '[CertificateConfiguration]'},
        'enable_client_certificate': {'key': 'enableClientCertificate', 'type': 'bool'},
        'disable_gateway': {'key': 'disableGateway', 'type': 'bool'},
        'virtual_network_type': {'key': 'virtualNetworkType', 'type': 'str'},
        'api_version_constraint': {'key': 'apiVersionConstraint', 'type': 'ApiVersionConstraint'},
        'restore': {'key': 'restore', 'type': 'bool'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[RemotePrivateEndpointConnectionWrapper]'},
        'platform_version': {'key': 'platformVersion', 'type': 'str'},
        'publisher_email': {'key': 'publisherEmail', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        notification_sender_email: Optional[str] = None,
        hostname_configurations: Optional[List["HostnameConfiguration"]] = None,
        public_ip_address_id: Optional[str] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        virtual_network_configuration: Optional["VirtualNetworkConfiguration"] = None,
        additional_locations: Optional[List["AdditionalLocation"]] = None,
        custom_properties: Optional[Dict[str, str]] = None,
        certificates: Optional[List["CertificateConfiguration"]] = None,
        enable_client_certificate: Optional[bool] = False,
        disable_gateway: Optional[bool] = False,
        virtual_network_type: Optional[Union[str, "VirtualNetworkType"]] = "None",
        api_version_constraint: Optional["ApiVersionConstraint"] = None,
        restore: Optional[bool] = False,
        private_endpoint_connections: Optional[List["RemotePrivateEndpointConnectionWrapper"]] = None,
        publisher_email: Optional[str] = None,
        publisher_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword notification_sender_email: Email address from which the notification will be sent.
        :paramtype notification_sender_email: str
        :keyword hostname_configurations: Custom hostname configuration of the API Management service.
        :paramtype hostname_configurations: list[~api_management_client.models.HostnameConfiguration]
        :keyword public_ip_address_id: Public Standard SKU IP V4 based IP address to be associated with
         Virtual Network deployed service in the region. Supported only for Developer and Premium SKU
         being deployed in Virtual Network.
        :paramtype public_ip_address_id: str
        :keyword public_network_access: Whether or not public endpoint access is allowed for this API
         Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If
         'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'.
         Possible values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or ~api_management_client.models.PublicNetworkAccess
        :keyword virtual_network_configuration: Virtual network configuration of the API Management
         service.
        :paramtype virtual_network_configuration:
         ~api_management_client.models.VirtualNetworkConfiguration
        :keyword additional_locations: Additional datacenter locations of the API Management service.
        :paramtype additional_locations: list[~api_management_client.models.AdditionalLocation]
        :keyword custom_properties: Custom properties of the API Management service.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
         cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
         disable just TLS 1.1.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
         disable TLS 1.0 on an API Management service.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
         to disable just TLS 1.1 for communications with backends.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
         to disable TLS 1.0 for communications with backends.</br>Setting
         ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
         HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
         PATCH operation will reset omitted properties' values to their defaults. For all the settings
         except Http2 the default value is ``True`` if the service was created on or before April 1st
         2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
         disable any of next ciphers by using settings
         `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
         TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
         TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
         TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
         TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
         For example,
         `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
         ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
         they are required by Azure CloudService internal components:
         TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
        :paramtype custom_properties: dict[str, str]
        :keyword certificates: List of Certificates that need to be installed in the API Management
         service. Max supported certificates that can be installed is 10.
        :paramtype certificates: list[~api_management_client.models.CertificateConfiguration]
        :keyword enable_client_certificate: Property only meant to be used for Consumption SKU Service.
         This enforces a client certificate to be presented on each request to the gateway. This also
         enables the ability to authenticate the certificate in the policy on the gateway.
        :paramtype enable_client_certificate: bool
        :keyword disable_gateway: Property only valid for an Api Management service deployed in
         multiple locations. This can be used to disable the gateway in master region.
        :paramtype disable_gateway: bool
        :keyword virtual_network_type: The type of VPN in which API Management service needs to be
         configured in. None (Default Value) means the API Management service is not part of any Virtual
         Network, External means the API Management deployment is set up inside a Virtual Network having
         an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
         a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
         "External", "Internal". Default value: "None".
        :paramtype virtual_network_type: str or ~api_management_client.models.VirtualNetworkType
        :keyword api_version_constraint: Control Plane Apis version constraint for the API Management
         service.
        :paramtype api_version_constraint: ~api_management_client.models.ApiVersionConstraint
        :keyword restore: Undelete Api Management Service if it was previously soft-deleted. If this
         flag is specified and set to True all other properties will be ignored.
        :paramtype restore: bool
        :keyword private_endpoint_connections: List of Private Endpoint Connections of this service.
        :paramtype private_endpoint_connections:
         list[~api_management_client.models.RemotePrivateEndpointConnectionWrapper]
        :keyword publisher_email: Publisher email.
        :paramtype publisher_email: str
        :keyword publisher_name: Publisher name.
        :paramtype publisher_name: str
        """
        super(ApiManagementServiceUpdateProperties, self).__init__(notification_sender_email=notification_sender_email, hostname_configurations=hostname_configurations, public_ip_address_id=public_ip_address_id, public_network_access=public_network_access, virtual_network_configuration=virtual_network_configuration, additional_locations=additional_locations, custom_properties=custom_properties, certificates=certificates, enable_client_certificate=enable_client_certificate, disable_gateway=disable_gateway, virtual_network_type=virtual_network_type, api_version_constraint=api_version_constraint, restore=restore, private_endpoint_connections=private_endpoint_connections, **kwargs)
        self.publisher_email = publisher_email
        self.publisher_name = publisher_name


class ApiManagementSku(msrest.serialization.Model):
    """Describes an available ApiManagement SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU.
    :vartype name: str
    :ivar tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br />`
     Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
     **Basic**.
    :vartype tier: str
    :ivar size: The Size of the SKU.
    :vartype size: str
    :ivar family: The Family of this particular SKU.
    :vartype family: str
    :ivar kind: The Kind of resources that are supported in this SKU.
    :vartype kind: str
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: ~api_management_client.models.ApiManagementSkuCapacity
    :ivar locations: The set of locations that the SKU is available.
    :vartype locations: list[str]
    :ivar location_info: A list of locations and availability zones in those locations where the
     SKU is available.
    :vartype location_info: list[~api_management_client.models.ApiManagementSkuLocationInfo]
    :ivar api_versions: The api versions that support this SKU.
    :vartype api_versions: list[str]
    :ivar costs: Metadata for retrieving price info.
    :vartype costs: list[~api_management_client.models.ApiManagementSkuCosts]
    :ivar capabilities: A name value pair to describe the capability.
    :vartype capabilities: list[~api_management_client.models.ApiManagementSkuCapabilities]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~api_management_client.models.ApiManagementSkuRestrictions]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'tier': {'readonly': True},
        'size': {'readonly': True},
        'family': {'readonly': True},
        'kind': {'readonly': True},
        'capacity': {'readonly': True},
        'locations': {'readonly': True},
        'location_info': {'readonly': True},
        'api_versions': {'readonly': True},
        'costs': {'readonly': True},
        'capabilities': {'readonly': True},
        'restrictions': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'ApiManagementSkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'location_info': {'key': 'locationInfo', 'type': '[ApiManagementSkuLocationInfo]'},
        'api_versions': {'key': 'apiVersions', 'type': '[str]'},
        'costs': {'key': 'costs', 'type': '[ApiManagementSkuCosts]'},
        'capabilities': {'key': 'capabilities', 'type': '[ApiManagementSkuCapabilities]'},
        'restrictions': {'key': 'restrictions', 'type': '[ApiManagementSkuRestrictions]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiManagementSku, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.tier = None
        self.size = None
        self.family = None
        self.kind = None
        self.capacity = None
        self.locations = None
        self.location_info = None
        self.api_versions = None
        self.costs = None
        self.capabilities = None
        self.restrictions = None


class ApiManagementSkuCapabilities(msrest.serialization.Model):
    """Describes The SKU capabilities object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: An invariant to describe the feature.
    :vartype name: str
    :ivar value: An invariant if the feature is measured by quantity.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiManagementSkuCapabilities, self).__init__(**kwargs)
        self.name = None
        self.value = None


class ApiManagementSkuCapacity(msrest.serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar scale_type: The scale type applicable to the sku. Possible values include: "Automatic",
     "Manual", "None".
    :vartype scale_type: str or ~api_management_client.models.ApiManagementSkuCapacityScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiManagementSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class ApiManagementSkuCosts(msrest.serialization.Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Used for querying price from commerce.
    :vartype meter_id: str
    :ivar quantity: The multiplier is needed to extend the base metered cost.
    :vartype quantity: long
    :ivar extended_unit: An invariant to show the extended unit.
    :vartype extended_unit: str
    """

    _validation = {
        'meter_id': {'readonly': True},
        'quantity': {'readonly': True},
        'extended_unit': {'readonly': True},
    }

    _attribute_map = {
        'meter_id': {'key': 'meterID', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'long'},
        'extended_unit': {'key': 'extendedUnit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiManagementSkuCosts, self).__init__(**kwargs)
        self.meter_id = None
        self.quantity = None
        self.extended_unit = None


class ApiManagementSkuLocationInfo(msrest.serialization.Model):
    """ApiManagementSkuLocationInfo.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location of the SKU.
    :vartype location: str
    :ivar zones: List of availability zones where the SKU is supported.
    :vartype zones: list[str]
    :ivar zone_details: Details of capabilities available to a SKU in specific zones.
    :vartype zone_details: list[~api_management_client.models.ApiManagementSkuZoneDetails]
    """

    _validation = {
        'location': {'readonly': True},
        'zones': {'readonly': True},
        'zone_details': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'zone_details': {'key': 'zoneDetails', 'type': '[ApiManagementSkuZoneDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiManagementSkuLocationInfo, self).__init__(**kwargs)
        self.location = None
        self.zones = None
        self.zone_details = None


class ApiManagementSkuRestrictionInfo(msrest.serialization.Model):
    """ApiManagementSkuRestrictionInfo.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar locations: Locations where the SKU is restricted.
    :vartype locations: list[str]
    :ivar zones: List of availability zones where the SKU is restricted.
    :vartype zones: list[str]
    """

    _validation = {
        'locations': {'readonly': True},
        'zones': {'readonly': True},
    }

    _attribute_map = {
        'locations': {'key': 'locations', 'type': '[str]'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiManagementSkuRestrictionInfo, self).__init__(**kwargs)
        self.locations = None
        self.zones = None


class ApiManagementSkuRestrictions(msrest.serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. Possible values include: "Location", "Zone".
    :vartype type: str or ~api_management_client.models.ApiManagementSkuRestrictionsType
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar restriction_info: The information about the restriction where the SKU cannot be used.
    :vartype restriction_info: ~api_management_client.models.ApiManagementSkuRestrictionInfo
    :ivar reason_code: The reason for restriction. Possible values include: "QuotaId",
     "NotAvailableForSubscription".
    :vartype reason_code: str or
     ~api_management_client.models.ApiManagementSkuRestrictionsReasonCode
    """

    _validation = {
        'type': {'readonly': True},
        'values': {'readonly': True},
        'restriction_info': {'readonly': True},
        'reason_code': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'restriction_info': {'key': 'restrictionInfo', 'type': 'ApiManagementSkuRestrictionInfo'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiManagementSkuRestrictions, self).__init__(**kwargs)
        self.type = None
        self.values = None
        self.restriction_info = None
        self.reason_code = None


class ApiManagementSkusResult(msrest.serialization.Model):
    """The List Resource Skus operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The list of skus available for the subscription.
    :vartype value: list[~api_management_client.models.ApiManagementSku]
    :ivar next_link: The URI to fetch the next page of Resource Skus. Call ListNext() with this URI
     to fetch the next page of Resource Skus.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiManagementSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ApiManagementSku"],
        **kwargs
    ):
        """
        :keyword value: Required. The list of skus available for the subscription.
        :paramtype value: list[~api_management_client.models.ApiManagementSku]
        """
        super(ApiManagementSkusResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApiManagementSkuZoneDetails(msrest.serialization.Model):
    """Describes The zonal capabilities of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The set of zones that the SKU is available in with the specified capabilities.
    :vartype name: list[str]
    :ivar capabilities: A list of capabilities that are available for the SKU in the specified list
     of zones.
    :vartype capabilities: list[~api_management_client.models.ApiManagementSkuCapabilities]
    """

    _validation = {
        'name': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[ApiManagementSkuCapabilities]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiManagementSkuZoneDetails, self).__init__(**kwargs)
        self.name = None
        self.capabilities = None


class ApiReleaseCollection(msrest.serialization.Model):
    """Paged ApiRelease list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.ApiReleaseContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiReleaseContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        """
        super(ApiReleaseCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class ApiReleaseContract(Resource):
    """ApiRelease details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar api_id: Identifier of the API the release belongs to.
    :vartype api_id: str
    :ivar created_date_time: The time the API was released. The date conforms to the following
     format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype created_date_time: ~datetime.datetime
    :ivar updated_date_time: The time the API release was updated.
    :vartype updated_date_time: ~datetime.datetime
    :ivar notes: Release Notes.
    :vartype notes: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date_time': {'readonly': True},
        'updated_date_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'api_id': {'key': 'properties.apiId', 'type': 'str'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'updated_date_time': {'key': 'properties.updatedDateTime', 'type': 'iso-8601'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        api_id: Optional[str] = None,
        notes: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword api_id: Identifier of the API the release belongs to.
        :paramtype api_id: str
        :keyword notes: Release Notes.
        :paramtype notes: str
        """
        super(ApiReleaseContract, self).__init__(**kwargs)
        self.api_id = api_id
        self.created_date_time = None
        self.updated_date_time = None
        self.notes = notes


class ApiRevisionCollection(msrest.serialization.Model):
    """Paged API Revision list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.ApiRevisionContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiRevisionContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        """
        super(ApiRevisionCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class ApiRevisionContract(msrest.serialization.Model):
    """Summary of revision metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar api_id: Identifier of the API Revision.
    :vartype api_id: str
    :ivar api_revision: Revision number of API.
    :vartype api_revision: str
    :ivar created_date_time: The time the API Revision was created. The date conforms to the
     following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype created_date_time: ~datetime.datetime
    :ivar updated_date_time: The time the API Revision were updated. The date conforms to the
     following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype updated_date_time: ~datetime.datetime
    :ivar description: Description of the API Revision.
    :vartype description: str
    :ivar private_url: Gateway URL for accessing the non-current API Revision.
    :vartype private_url: str
    :ivar is_online: Indicates if API revision is the current api revision.
    :vartype is_online: bool
    :ivar is_current: Indicates if API revision is accessible via the gateway.
    :vartype is_current: bool
    """

    _validation = {
        'api_id': {'readonly': True},
        'api_revision': {'readonly': True, 'max_length': 100, 'min_length': 1},
        'created_date_time': {'readonly': True},
        'updated_date_time': {'readonly': True},
        'description': {'readonly': True, 'max_length': 256, 'min_length': 0},
        'private_url': {'readonly': True},
        'is_online': {'readonly': True},
        'is_current': {'readonly': True},
    }

    _attribute_map = {
        'api_id': {'key': 'apiId', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'updated_date_time': {'key': 'updatedDateTime', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'private_url': {'key': 'privateUrl', 'type': 'str'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiRevisionContract, self).__init__(**kwargs)
        self.api_id = None
        self.api_revision = None
        self.created_date_time = None
        self.updated_date_time = None
        self.description = None
        self.private_url = None
        self.is_online = None
        self.is_current = None


class ApiRevisionInfoContract(msrest.serialization.Model):
    """Object used to create an API Revision or Version based on an existing API Revision.

    :ivar source_api_id: Resource identifier of API to be used to create the revision from.
    :vartype source_api_id: str
    :ivar api_version_name: Version identifier for the new API Version.
    :vartype api_version_name: str
    :ivar api_revision_description: Description of new API Revision.
    :vartype api_revision_description: str
    :ivar api_version_set: Version set details.
    :vartype api_version_set: ~api_management_client.models.ApiVersionSetContractDetails
    """

    _validation = {
        'api_version_name': {'max_length': 100, 'min_length': 0},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
    }

    _attribute_map = {
        'source_api_id': {'key': 'sourceApiId', 'type': 'str'},
        'api_version_name': {'key': 'apiVersionName', 'type': 'str'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_set': {'key': 'apiVersionSet', 'type': 'ApiVersionSetContractDetails'},
    }

    def __init__(
        self,
        *,
        source_api_id: Optional[str] = None,
        api_version_name: Optional[str] = None,
        api_revision_description: Optional[str] = None,
        api_version_set: Optional["ApiVersionSetContractDetails"] = None,
        **kwargs
    ):
        """
        :keyword source_api_id: Resource identifier of API to be used to create the revision from.
        :paramtype source_api_id: str
        :keyword api_version_name: Version identifier for the new API Version.
        :paramtype api_version_name: str
        :keyword api_revision_description: Description of new API Revision.
        :paramtype api_revision_description: str
        :keyword api_version_set: Version set details.
        :paramtype api_version_set: ~api_management_client.models.ApiVersionSetContractDetails
        """
        super(ApiRevisionInfoContract, self).__init__(**kwargs)
        self.source_api_id = source_api_id
        self.api_version_name = api_version_name
        self.api_revision_description = api_revision_description
        self.api_version_set = api_version_set


class ApiTagResourceContractProperties(ApiEntityBaseContract):
    """API contract properties for the Tag Resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the API. May include HTML formatting tags.
    :vartype description: str
    :ivar authentication_settings: Collection of authentication settings included into this API.
    :vartype authentication_settings: ~api_management_client.models.AuthenticationSettingsContract
    :ivar subscription_key_parameter_names: Protocols over which API is made available.
    :vartype subscription_key_parameter_names:
     ~api_management_client.models.SubscriptionKeyParameterNamesContract
    :ivar api_type: Type of API. Possible values include: "http", "soap", "websocket", "graphql".
    :vartype api_type: str or ~api_management_client.models.ApiType
    :ivar api_revision: Describes the revision of the API. If no value is provided, default
     revision 1 is created.
    :vartype api_revision: str
    :ivar api_version: Indicates the version identifier of the API if the API is versioned.
    :vartype api_version: str
    :ivar is_current: Indicates if API revision is current api revision.
    :vartype is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :ivar api_revision_description: Description of the API Revision.
    :vartype api_revision_description: str
    :ivar api_version_description: Description of the API Version.
    :vartype api_version_description: str
    :ivar api_version_set_id: A resource identifier for the related ApiVersionSet.
    :vartype api_version_set_id: str
    :ivar subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :vartype subscription_required: bool
    :ivar terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format of
     a URL.
    :vartype terms_of_service_url: str
    :ivar contact: Contact information for the API.
    :vartype contact: ~api_management_client.models.ApiContactInformation
    :ivar license: License information for the API.
    :vartype license: ~api_management_client.models.ApiLicenseInformation
    :ivar id: API identifier in the form /apis/{apiId}.
    :vartype id: str
    :ivar name: API name.
    :vartype name: str
    :ivar service_url: Absolute URL of the backend service implementing this API.
    :vartype service_url: str
    :ivar path: Relative URL uniquely identifying this API and all of its resource paths within the
     API Management service instance. It is appended to the API endpoint base URL specified during
     the service instance creation to form a public URL for this API.
    :vartype path: str
    :ivar protocols: Describes on which protocols the operations in this API can be invoked.
    :vartype protocols: list[str or ~api_management_client.models.Protocol]
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 1},
        'path': {'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authentication_settings': {'key': 'authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'type', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'terms_of_service_url': {'key': 'termsOfServiceUrl', 'type': 'str'},
        'contact': {'key': 'contact', 'type': 'ApiContactInformation'},
        'license': {'key': 'license', 'type': 'ApiLicenseInformation'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authentication_settings: Optional["AuthenticationSettingsContract"] = None,
        subscription_key_parameter_names: Optional["SubscriptionKeyParameterNamesContract"] = None,
        api_type: Optional[Union[str, "ApiType"]] = None,
        api_revision: Optional[str] = None,
        api_version: Optional[str] = None,
        is_current: Optional[bool] = None,
        api_revision_description: Optional[str] = None,
        api_version_description: Optional[str] = None,
        api_version_set_id: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        terms_of_service_url: Optional[str] = None,
        contact: Optional["ApiContactInformation"] = None,
        license: Optional["ApiLicenseInformation"] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        service_url: Optional[str] = None,
        path: Optional[str] = None,
        protocols: Optional[List[Union[str, "Protocol"]]] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the API. May include HTML formatting tags.
        :paramtype description: str
        :keyword authentication_settings: Collection of authentication settings included into this API.
        :paramtype authentication_settings:
         ~api_management_client.models.AuthenticationSettingsContract
        :keyword subscription_key_parameter_names: Protocols over which API is made available.
        :paramtype subscription_key_parameter_names:
         ~api_management_client.models.SubscriptionKeyParameterNamesContract
        :keyword api_type: Type of API. Possible values include: "http", "soap", "websocket",
         "graphql".
        :paramtype api_type: str or ~api_management_client.models.ApiType
        :keyword api_revision: Describes the revision of the API. If no value is provided, default
         revision 1 is created.
        :paramtype api_revision: str
        :keyword api_version: Indicates the version identifier of the API if the API is versioned.
        :paramtype api_version: str
        :keyword is_current: Indicates if API revision is current api revision.
        :paramtype is_current: bool
        :keyword api_revision_description: Description of the API Revision.
        :paramtype api_revision_description: str
        :keyword api_version_description: Description of the API Version.
        :paramtype api_version_description: str
        :keyword api_version_set_id: A resource identifier for the related ApiVersionSet.
        :paramtype api_version_set_id: str
        :keyword subscription_required: Specifies whether an API or Product subscription is required
         for accessing the API.
        :paramtype subscription_required: bool
        :keyword terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format
         of a URL.
        :paramtype terms_of_service_url: str
        :keyword contact: Contact information for the API.
        :paramtype contact: ~api_management_client.models.ApiContactInformation
        :keyword license: License information for the API.
        :paramtype license: ~api_management_client.models.ApiLicenseInformation
        :keyword id: API identifier in the form /apis/{apiId}.
        :paramtype id: str
        :keyword name: API name.
        :paramtype name: str
        :keyword service_url: Absolute URL of the backend service implementing this API.
        :paramtype service_url: str
        :keyword path: Relative URL uniquely identifying this API and all of its resource paths within
         the API Management service instance. It is appended to the API endpoint base URL specified
         during the service instance creation to form a public URL for this API.
        :paramtype path: str
        :keyword protocols: Describes on which protocols the operations in this API can be invoked.
        :paramtype protocols: list[str or ~api_management_client.models.Protocol]
        """
        super(ApiTagResourceContractProperties, self).__init__(description=description, authentication_settings=authentication_settings, subscription_key_parameter_names=subscription_key_parameter_names, api_type=api_type, api_revision=api_revision, api_version=api_version, is_current=is_current, api_revision_description=api_revision_description, api_version_description=api_version_description, api_version_set_id=api_version_set_id, subscription_required=subscription_required, terms_of_service_url=terms_of_service_url, contact=contact, license=license, **kwargs)
        self.id = id
        self.name = name
        self.service_url = service_url
        self.path = path
        self.protocols = protocols


class ApiUpdateContract(msrest.serialization.Model):
    """API update contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the API. May include HTML formatting tags.
    :vartype description: str
    :ivar authentication_settings: Collection of authentication settings included into this API.
    :vartype authentication_settings: ~api_management_client.models.AuthenticationSettingsContract
    :ivar subscription_key_parameter_names: Protocols over which API is made available.
    :vartype subscription_key_parameter_names:
     ~api_management_client.models.SubscriptionKeyParameterNamesContract
    :ivar api_type: Type of API. Possible values include: "http", "soap", "websocket", "graphql".
    :vartype api_type: str or ~api_management_client.models.ApiType
    :ivar api_revision: Describes the revision of the API. If no value is provided, default
     revision 1 is created.
    :vartype api_revision: str
    :ivar api_version: Indicates the version identifier of the API if the API is versioned.
    :vartype api_version: str
    :ivar is_current: Indicates if API revision is current api revision.
    :vartype is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :ivar api_revision_description: Description of the API Revision.
    :vartype api_revision_description: str
    :ivar api_version_description: Description of the API Version.
    :vartype api_version_description: str
    :ivar api_version_set_id: A resource identifier for the related ApiVersionSet.
    :vartype api_version_set_id: str
    :ivar subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :vartype subscription_required: bool
    :ivar terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format of
     a URL.
    :vartype terms_of_service_url: str
    :ivar contact: Contact information for the API.
    :vartype contact: ~api_management_client.models.ApiContactInformation
    :ivar license: License information for the API.
    :vartype license: ~api_management_client.models.ApiLicenseInformation
    :ivar display_name: API name.
    :vartype display_name: str
    :ivar service_url: Absolute URL of the backend service implementing this API.
    :vartype service_url: str
    :ivar path: Relative URL uniquely identifying this API and all of its resource paths within the
     API Management service instance. It is appended to the API endpoint base URL specified during
     the service instance creation to form a public URL for this API.
    :vartype path: str
    :ivar protocols: Describes on which protocols the operations in this API can be invoked.
    :vartype protocols: list[str or ~api_management_client.models.Protocol]
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 1},
        'path': {'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'authentication_settings': {'key': 'properties.authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'properties.subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'properties.type', 'type': 'str'},
        'api_revision': {'key': 'properties.apiRevision', 'type': 'str'},
        'api_version': {'key': 'properties.apiVersion', 'type': 'str'},
        'is_current': {'key': 'properties.isCurrent', 'type': 'bool'},
        'is_online': {'key': 'properties.isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'properties.apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'properties.apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'properties.apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'properties.subscriptionRequired', 'type': 'bool'},
        'terms_of_service_url': {'key': 'properties.termsOfServiceUrl', 'type': 'str'},
        'contact': {'key': 'properties.contact', 'type': 'ApiContactInformation'},
        'license': {'key': 'properties.license', 'type': 'ApiLicenseInformation'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'service_url': {'key': 'properties.serviceUrl', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'protocols': {'key': 'properties.protocols', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authentication_settings: Optional["AuthenticationSettingsContract"] = None,
        subscription_key_parameter_names: Optional["SubscriptionKeyParameterNamesContract"] = None,
        api_type: Optional[Union[str, "ApiType"]] = None,
        api_revision: Optional[str] = None,
        api_version: Optional[str] = None,
        is_current: Optional[bool] = None,
        api_revision_description: Optional[str] = None,
        api_version_description: Optional[str] = None,
        api_version_set_id: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        terms_of_service_url: Optional[str] = None,
        contact: Optional["ApiContactInformation"] = None,
        license: Optional["ApiLicenseInformation"] = None,
        display_name: Optional[str] = None,
        service_url: Optional[str] = None,
        path: Optional[str] = None,
        protocols: Optional[List[Union[str, "Protocol"]]] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the API. May include HTML formatting tags.
        :paramtype description: str
        :keyword authentication_settings: Collection of authentication settings included into this API.
        :paramtype authentication_settings:
         ~api_management_client.models.AuthenticationSettingsContract
        :keyword subscription_key_parameter_names: Protocols over which API is made available.
        :paramtype subscription_key_parameter_names:
         ~api_management_client.models.SubscriptionKeyParameterNamesContract
        :keyword api_type: Type of API. Possible values include: "http", "soap", "websocket",
         "graphql".
        :paramtype api_type: str or ~api_management_client.models.ApiType
        :keyword api_revision: Describes the revision of the API. If no value is provided, default
         revision 1 is created.
        :paramtype api_revision: str
        :keyword api_version: Indicates the version identifier of the API if the API is versioned.
        :paramtype api_version: str
        :keyword is_current: Indicates if API revision is current api revision.
        :paramtype is_current: bool
        :keyword api_revision_description: Description of the API Revision.
        :paramtype api_revision_description: str
        :keyword api_version_description: Description of the API Version.
        :paramtype api_version_description: str
        :keyword api_version_set_id: A resource identifier for the related ApiVersionSet.
        :paramtype api_version_set_id: str
        :keyword subscription_required: Specifies whether an API or Product subscription is required
         for accessing the API.
        :paramtype subscription_required: bool
        :keyword terms_of_service_url: A URL to the Terms of Service for the API. MUST be in the format
         of a URL.
        :paramtype terms_of_service_url: str
        :keyword contact: Contact information for the API.
        :paramtype contact: ~api_management_client.models.ApiContactInformation
        :keyword license: License information for the API.
        :paramtype license: ~api_management_client.models.ApiLicenseInformation
        :keyword display_name: API name.
        :paramtype display_name: str
        :keyword service_url: Absolute URL of the backend service implementing this API.
        :paramtype service_url: str
        :keyword path: Relative URL uniquely identifying this API and all of its resource paths within
         the API Management service instance. It is appended to the API endpoint base URL specified
         during the service instance creation to form a public URL for this API.
        :paramtype path: str
        :keyword protocols: Describes on which protocols the operations in this API can be invoked.
        :paramtype protocols: list[str or ~api_management_client.models.Protocol]
        """
        super(ApiUpdateContract, self).__init__(**kwargs)
        self.description = description
        self.authentication_settings = authentication_settings
        self.subscription_key_parameter_names = subscription_key_parameter_names
        self.api_type = api_type
        self.api_revision = api_revision
        self.api_version = api_version
        self.is_current = is_current
        self.is_online = None
        self.api_revision_description = api_revision_description
        self.api_version_description = api_version_description
        self.api_version_set_id = api_version_set_id
        self.subscription_required = subscription_required
        self.terms_of_service_url = terms_of_service_url
        self.contact = contact
        self.license = license
        self.display_name = display_name
        self.service_url = service_url
        self.path = path
        self.protocols = protocols


class ApiVersionConstraint(msrest.serialization.Model):
    """Control Plane Apis version constraint for the API Management service.

    :ivar min_api_version: Limit control plane API calls to API Management service with version
     equal to or newer than this value.
    :vartype min_api_version: str
    """

    _attribute_map = {
        'min_api_version': {'key': 'minApiVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        min_api_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword min_api_version: Limit control plane API calls to API Management service with version
         equal to or newer than this value.
        :paramtype min_api_version: str
        """
        super(ApiVersionConstraint, self).__init__(**kwargs)
        self.min_api_version = min_api_version


class ApiVersionSetCollection(msrest.serialization.Model):
    """Paged API Version Set list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.ApiVersionSetContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiVersionSetContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApiVersionSetContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.ApiVersionSetContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(ApiVersionSetCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class ApiVersionSetContract(Resource):
    """API Version Set Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar description: Description of API Version Set.
    :vartype description: str
    :ivar version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :vartype version_query_name: str
    :ivar version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :vartype version_header_name: str
    :ivar display_name: Name of API Version Set.
    :vartype display_name: str
    :ivar versioning_scheme: An value that determines where the API Version identifier will be
     located in a HTTP request. Possible values include: "Segment", "Query", "Header".
    :vartype versioning_scheme: str or ~api_management_client.models.VersioningScheme
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
        'display_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version_query_name': {'key': 'properties.versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'properties.versionHeaderName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'versioning_scheme': {'key': 'properties.versioningScheme', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        version_query_name: Optional[str] = None,
        version_header_name: Optional[str] = None,
        display_name: Optional[str] = None,
        versioning_scheme: Optional[Union[str, "VersioningScheme"]] = None,
        **kwargs
    ):
        """
        :keyword description: Description of API Version Set.
        :paramtype description: str
        :keyword version_query_name: Name of query parameter that indicates the API Version if
         versioningScheme is set to ``query``.
        :paramtype version_query_name: str
        :keyword version_header_name: Name of HTTP header parameter that indicates the API Version if
         versioningScheme is set to ``header``.
        :paramtype version_header_name: str
        :keyword display_name: Name of API Version Set.
        :paramtype display_name: str
        :keyword versioning_scheme: An value that determines where the API Version identifier will be
         located in a HTTP request. Possible values include: "Segment", "Query", "Header".
        :paramtype versioning_scheme: str or ~api_management_client.models.VersioningScheme
        """
        super(ApiVersionSetContract, self).__init__(**kwargs)
        self.description = description
        self.version_query_name = version_query_name
        self.version_header_name = version_header_name
        self.display_name = display_name
        self.versioning_scheme = versioning_scheme


class ApiVersionSetContractDetails(msrest.serialization.Model):
    """An API Version Set contains the common configuration for a set of API Versions relating.

    :ivar id: Identifier for existing API Version Set. Omit this value to create a new Version Set.
    :vartype id: str
    :ivar name: The display Name of the API Version Set.
    :vartype name: str
    :ivar description: Description of API Version Set.
    :vartype description: str
    :ivar versioning_scheme: An value that determines where the API Version identifier will be
     located in a HTTP request. Possible values include: "Segment", "Query", "Header".
    :vartype versioning_scheme: str or
     ~api_management_client.models.ApiVersionSetContractDetailsVersioningScheme
    :ivar version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :vartype version_query_name: str
    :ivar version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :vartype version_header_name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'versioning_scheme': {'key': 'versioningScheme', 'type': 'str'},
        'version_query_name': {'key': 'versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'versionHeaderName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        versioning_scheme: Optional[Union[str, "ApiVersionSetContractDetailsVersioningScheme"]] = None,
        version_query_name: Optional[str] = None,
        version_header_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Identifier for existing API Version Set. Omit this value to create a new Version
         Set.
        :paramtype id: str
        :keyword name: The display Name of the API Version Set.
        :paramtype name: str
        :keyword description: Description of API Version Set.
        :paramtype description: str
        :keyword versioning_scheme: An value that determines where the API Version identifier will be
         located in a HTTP request. Possible values include: "Segment", "Query", "Header".
        :paramtype versioning_scheme: str or
         ~api_management_client.models.ApiVersionSetContractDetailsVersioningScheme
        :keyword version_query_name: Name of query parameter that indicates the API Version if
         versioningScheme is set to ``query``.
        :paramtype version_query_name: str
        :keyword version_header_name: Name of HTTP header parameter that indicates the API Version if
         versioningScheme is set to ``header``.
        :paramtype version_header_name: str
        """
        super(ApiVersionSetContractDetails, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.versioning_scheme = versioning_scheme
        self.version_query_name = version_query_name
        self.version_header_name = version_header_name


class ApiVersionSetEntityBase(msrest.serialization.Model):
    """API Version set base parameters.

    :ivar description: Description of API Version Set.
    :vartype description: str
    :ivar version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :vartype version_query_name: str
    :ivar version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :vartype version_header_name: str
    """

    _validation = {
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'version_query_name': {'key': 'versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'versionHeaderName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        version_query_name: Optional[str] = None,
        version_header_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of API Version Set.
        :paramtype description: str
        :keyword version_query_name: Name of query parameter that indicates the API Version if
         versioningScheme is set to ``query``.
        :paramtype version_query_name: str
        :keyword version_header_name: Name of HTTP header parameter that indicates the API Version if
         versioningScheme is set to ``header``.
        :paramtype version_header_name: str
        """
        super(ApiVersionSetEntityBase, self).__init__(**kwargs)
        self.description = description
        self.version_query_name = version_query_name
        self.version_header_name = version_header_name


class ApiVersionSetContractProperties(ApiVersionSetEntityBase):
    """Properties of an API Version Set.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description of API Version Set.
    :vartype description: str
    :ivar version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :vartype version_query_name: str
    :ivar version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :vartype version_header_name: str
    :ivar display_name: Required. Name of API Version Set.
    :vartype display_name: str
    :ivar versioning_scheme: Required. An value that determines where the API Version identifier
     will be located in a HTTP request. Possible values include: "Segment", "Query", "Header".
    :vartype versioning_scheme: str or ~api_management_client.models.VersioningScheme
    """

    _validation = {
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
        'display_name': {'required': True, 'max_length': 100, 'min_length': 1},
        'versioning_scheme': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'version_query_name': {'key': 'versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'versionHeaderName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'versioning_scheme': {'key': 'versioningScheme', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        versioning_scheme: Union[str, "VersioningScheme"],
        description: Optional[str] = None,
        version_query_name: Optional[str] = None,
        version_header_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of API Version Set.
        :paramtype description: str
        :keyword version_query_name: Name of query parameter that indicates the API Version if
         versioningScheme is set to ``query``.
        :paramtype version_query_name: str
        :keyword version_header_name: Name of HTTP header parameter that indicates the API Version if
         versioningScheme is set to ``header``.
        :paramtype version_header_name: str
        :keyword display_name: Required. Name of API Version Set.
        :paramtype display_name: str
        :keyword versioning_scheme: Required. An value that determines where the API Version identifier
         will be located in a HTTP request. Possible values include: "Segment", "Query", "Header".
        :paramtype versioning_scheme: str or ~api_management_client.models.VersioningScheme
        """
        super(ApiVersionSetContractProperties, self).__init__(description=description, version_query_name=version_query_name, version_header_name=version_header_name, **kwargs)
        self.display_name = display_name
        self.versioning_scheme = versioning_scheme


class ApiVersionSetUpdateParameters(msrest.serialization.Model):
    """Parameters to update or create an API Version Set Contract.

    :ivar description: Description of API Version Set.
    :vartype description: str
    :ivar version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :vartype version_query_name: str
    :ivar version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :vartype version_header_name: str
    :ivar display_name: Name of API Version Set.
    :vartype display_name: str
    :ivar versioning_scheme: An value that determines where the API Version identifier will be
     located in a HTTP request. Possible values include: "Segment", "Query", "Header".
    :vartype versioning_scheme: str or ~api_management_client.models.VersioningScheme
    """

    _validation = {
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
        'display_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'version_query_name': {'key': 'properties.versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'properties.versionHeaderName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'versioning_scheme': {'key': 'properties.versioningScheme', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        version_query_name: Optional[str] = None,
        version_header_name: Optional[str] = None,
        display_name: Optional[str] = None,
        versioning_scheme: Optional[Union[str, "VersioningScheme"]] = None,
        **kwargs
    ):
        """
        :keyword description: Description of API Version Set.
        :paramtype description: str
        :keyword version_query_name: Name of query parameter that indicates the API Version if
         versioningScheme is set to ``query``.
        :paramtype version_query_name: str
        :keyword version_header_name: Name of HTTP header parameter that indicates the API Version if
         versioningScheme is set to ``header``.
        :paramtype version_header_name: str
        :keyword display_name: Name of API Version Set.
        :paramtype display_name: str
        :keyword versioning_scheme: An value that determines where the API Version identifier will be
         located in a HTTP request. Possible values include: "Segment", "Query", "Header".
        :paramtype versioning_scheme: str or ~api_management_client.models.VersioningScheme
        """
        super(ApiVersionSetUpdateParameters, self).__init__(**kwargs)
        self.description = description
        self.version_query_name = version_query_name
        self.version_header_name = version_header_name
        self.display_name = display_name
        self.versioning_scheme = versioning_scheme


class ApiVersionSetUpdateParametersProperties(ApiVersionSetEntityBase):
    """Properties used to create or update an API Version Set.

    :ivar description: Description of API Version Set.
    :vartype description: str
    :ivar version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :vartype version_query_name: str
    :ivar version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :vartype version_header_name: str
    :ivar display_name: Name of API Version Set.
    :vartype display_name: str
    :ivar versioning_scheme: An value that determines where the API Version identifier will be
     located in a HTTP request. Possible values include: "Segment", "Query", "Header".
    :vartype versioning_scheme: str or ~api_management_client.models.VersioningScheme
    """

    _validation = {
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
        'display_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'version_query_name': {'key': 'versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'versionHeaderName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'versioning_scheme': {'key': 'versioningScheme', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        version_query_name: Optional[str] = None,
        version_header_name: Optional[str] = None,
        display_name: Optional[str] = None,
        versioning_scheme: Optional[Union[str, "VersioningScheme"]] = None,
        **kwargs
    ):
        """
        :keyword description: Description of API Version Set.
        :paramtype description: str
        :keyword version_query_name: Name of query parameter that indicates the API Version if
         versioningScheme is set to ``query``.
        :paramtype version_query_name: str
        :keyword version_header_name: Name of HTTP header parameter that indicates the API Version if
         versioningScheme is set to ``header``.
        :paramtype version_header_name: str
        :keyword display_name: Name of API Version Set.
        :paramtype display_name: str
        :keyword versioning_scheme: An value that determines where the API Version identifier will be
         located in a HTTP request. Possible values include: "Segment", "Query", "Header".
        :paramtype versioning_scheme: str or ~api_management_client.models.VersioningScheme
        """
        super(ApiVersionSetUpdateParametersProperties, self).__init__(description=description, version_query_name=version_query_name, version_header_name=version_header_name, **kwargs)
        self.display_name = display_name
        self.versioning_scheme = versioning_scheme


class ArmIdWrapper(msrest.serialization.Model):
    """A wrapper for an ARM resource id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ArmIdWrapper, self).__init__(**kwargs)
        self.id = None


class AssociationContract(Resource):
    """Association entity details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar provisioning_state: Provisioning state. The only acceptable values to pass in are None
     and "created". The default value is None.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Provisioning state. The only acceptable values to pass in are None
         and "created". The default value is None.
        :paramtype provisioning_state: str
        """
        super(AssociationContract, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state


class AuthenticationSettingsContract(msrest.serialization.Model):
    """API Authentication Settings.

    :ivar o_auth2: OAuth2 Authentication settings.
    :vartype o_auth2: ~api_management_client.models.OAuth2AuthenticationSettingsContract
    :ivar openid: OpenID Connect Authentication Settings.
    :vartype openid: ~api_management_client.models.OpenIdAuthenticationSettingsContract
    """

    _attribute_map = {
        'o_auth2': {'key': 'oAuth2', 'type': 'OAuth2AuthenticationSettingsContract'},
        'openid': {'key': 'openid', 'type': 'OpenIdAuthenticationSettingsContract'},
    }

    def __init__(
        self,
        *,
        o_auth2: Optional["OAuth2AuthenticationSettingsContract"] = None,
        openid: Optional["OpenIdAuthenticationSettingsContract"] = None,
        **kwargs
    ):
        """
        :keyword o_auth2: OAuth2 Authentication settings.
        :paramtype o_auth2: ~api_management_client.models.OAuth2AuthenticationSettingsContract
        :keyword openid: OpenID Connect Authentication Settings.
        :paramtype openid: ~api_management_client.models.OpenIdAuthenticationSettingsContract
        """
        super(AuthenticationSettingsContract, self).__init__(**kwargs)
        self.o_auth2 = o_auth2
        self.openid = openid


class AuthorizationServerCollection(msrest.serialization.Model):
    """Paged OAuth2 Authorization Servers list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.AuthorizationServerContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AuthorizationServerContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AuthorizationServerContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.AuthorizationServerContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(AuthorizationServerCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class AuthorizationServerContract(Resource):
    """External OAuth authorization server settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar description: Description of the authorization server. Can contain HTML formatting tags.
    :vartype description: str
    :ivar authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
     always present. POST is optional.
    :vartype authorization_methods: list[str or ~api_management_client.models.AuthorizationMethod]
    :ivar client_authentication_method: Method of authentication supported by the token endpoint of
     this authorization server. Possible values are Basic and/or Body. When Body is specified,
     client credentials and other parameters are passed within the request body in the
     application/x-www-form-urlencoded format.
    :vartype client_authentication_method: list[str or
     ~api_management_client.models.ClientAuthenticationMethod]
    :ivar token_body_parameters: Additional parameters required by the token endpoint of this
     authorization server represented as an array of JSON objects with name and value string
     properties, i.e. {"name" : "name value", "value": "a value"}.
    :vartype token_body_parameters: list[~api_management_client.models.TokenBodyParameterContract]
    :ivar token_endpoint: OAuth token endpoint. Contains absolute URI to entity being referenced.
    :vartype token_endpoint: str
    :ivar support_state: If true, authorization server will include state parameter from the
     authorization request to its response. Client may use state parameter to raise protocol
     security.
    :vartype support_state: bool
    :ivar default_scope: Access token scope that is going to be requested by default. Can be
     overridden at the API level. Should be provided in the form of a string containing
     space-delimited values.
    :vartype default_scope: str
    :ivar bearer_token_sending_methods: Specifies the mechanism by which access token is passed to
     the API.
    :vartype bearer_token_sending_methods: list[str or
     ~api_management_client.models.BearerTokenSendingMethod]
    :ivar resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :vartype resource_owner_username: str
    :ivar resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :vartype resource_owner_password: str
    :ivar display_name: User-friendly authorization server name.
    :vartype display_name: str
    :ivar client_registration_endpoint: Optional reference to a page where client or app
     registration for this authorization server is performed. Contains absolute URL to entity being
     referenced.
    :vartype client_registration_endpoint: str
    :ivar authorization_endpoint: OAuth authorization endpoint. See
     http://tools.ietf.org/html/rfc6749#section-3.2.
    :vartype authorization_endpoint: str
    :ivar grant_types: Form of an authorization grant, which the client uses to request the access
     token.
    :vartype grant_types: list[str or ~api_management_client.models.GrantType]
    :ivar client_id: Client or app id registered with this authorization server.
    :vartype client_id: str
    :ivar client_secret: Client or app secret registered with this authorization server. This
     property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
     value.
    :vartype client_secret: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 50, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'authorization_methods': {'key': 'properties.authorizationMethods', 'type': '[str]'},
        'client_authentication_method': {'key': 'properties.clientAuthenticationMethod', 'type': '[str]'},
        'token_body_parameters': {'key': 'properties.tokenBodyParameters', 'type': '[TokenBodyParameterContract]'},
        'token_endpoint': {'key': 'properties.tokenEndpoint', 'type': 'str'},
        'support_state': {'key': 'properties.supportState', 'type': 'bool'},
        'default_scope': {'key': 'properties.defaultScope', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'properties.bearerTokenSendingMethods', 'type': '[str]'},
        'resource_owner_username': {'key': 'properties.resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'properties.resourceOwnerPassword', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'client_registration_endpoint': {'key': 'properties.clientRegistrationEndpoint', 'type': 'str'},
        'authorization_endpoint': {'key': 'properties.authorizationEndpoint', 'type': 'str'},
        'grant_types': {'key': 'properties.grantTypes', 'type': '[str]'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authorization_methods: Optional[List[Union[str, "AuthorizationMethod"]]] = None,
        client_authentication_method: Optional[List[Union[str, "ClientAuthenticationMethod"]]] = None,
        token_body_parameters: Optional[List["TokenBodyParameterContract"]] = None,
        token_endpoint: Optional[str] = None,
        support_state: Optional[bool] = None,
        default_scope: Optional[str] = None,
        bearer_token_sending_methods: Optional[List[Union[str, "BearerTokenSendingMethod"]]] = None,
        resource_owner_username: Optional[str] = None,
        resource_owner_password: Optional[str] = None,
        display_name: Optional[str] = None,
        client_registration_endpoint: Optional[str] = None,
        authorization_endpoint: Optional[str] = None,
        grant_types: Optional[List[Union[str, "GrantType"]]] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the authorization server. Can contain HTML formatting
         tags.
        :paramtype description: str
        :keyword authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
         always present. POST is optional.
        :paramtype authorization_methods: list[str or
         ~api_management_client.models.AuthorizationMethod]
        :keyword client_authentication_method: Method of authentication supported by the token endpoint
         of this authorization server. Possible values are Basic and/or Body. When Body is specified,
         client credentials and other parameters are passed within the request body in the
         application/x-www-form-urlencoded format.
        :paramtype client_authentication_method: list[str or
         ~api_management_client.models.ClientAuthenticationMethod]
        :keyword token_body_parameters: Additional parameters required by the token endpoint of this
         authorization server represented as an array of JSON objects with name and value string
         properties, i.e. {"name" : "name value", "value": "a value"}.
        :paramtype token_body_parameters:
         list[~api_management_client.models.TokenBodyParameterContract]
        :keyword token_endpoint: OAuth token endpoint. Contains absolute URI to entity being
         referenced.
        :paramtype token_endpoint: str
        :keyword support_state: If true, authorization server will include state parameter from the
         authorization request to its response. Client may use state parameter to raise protocol
         security.
        :paramtype support_state: bool
        :keyword default_scope: Access token scope that is going to be requested by default. Can be
         overridden at the API level. Should be provided in the form of a string containing
         space-delimited values.
        :paramtype default_scope: str
        :keyword bearer_token_sending_methods: Specifies the mechanism by which access token is passed
         to the API.
        :paramtype bearer_token_sending_methods: list[str or
         ~api_management_client.models.BearerTokenSendingMethod]
        :keyword resource_owner_username: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner username.
        :paramtype resource_owner_username: str
        :keyword resource_owner_password: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner password.
        :paramtype resource_owner_password: str
        :keyword display_name: User-friendly authorization server name.
        :paramtype display_name: str
        :keyword client_registration_endpoint: Optional reference to a page where client or app
         registration for this authorization server is performed. Contains absolute URL to entity being
         referenced.
        :paramtype client_registration_endpoint: str
        :keyword authorization_endpoint: OAuth authorization endpoint. See
         http://tools.ietf.org/html/rfc6749#section-3.2.
        :paramtype authorization_endpoint: str
        :keyword grant_types: Form of an authorization grant, which the client uses to request the
         access token.
        :paramtype grant_types: list[str or ~api_management_client.models.GrantType]
        :keyword client_id: Client or app id registered with this authorization server.
        :paramtype client_id: str
        :keyword client_secret: Client or app secret registered with this authorization server. This
         property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
         value.
        :paramtype client_secret: str
        """
        super(AuthorizationServerContract, self).__init__(**kwargs)
        self.description = description
        self.authorization_methods = authorization_methods
        self.client_authentication_method = client_authentication_method
        self.token_body_parameters = token_body_parameters
        self.token_endpoint = token_endpoint
        self.support_state = support_state
        self.default_scope = default_scope
        self.bearer_token_sending_methods = bearer_token_sending_methods
        self.resource_owner_username = resource_owner_username
        self.resource_owner_password = resource_owner_password
        self.display_name = display_name
        self.client_registration_endpoint = client_registration_endpoint
        self.authorization_endpoint = authorization_endpoint
        self.grant_types = grant_types
        self.client_id = client_id
        self.client_secret = client_secret


class AuthorizationServerContractBaseProperties(msrest.serialization.Model):
    """External OAuth authorization server Update settings contract.

    :ivar description: Description of the authorization server. Can contain HTML formatting tags.
    :vartype description: str
    :ivar authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
     always present. POST is optional.
    :vartype authorization_methods: list[str or ~api_management_client.models.AuthorizationMethod]
    :ivar client_authentication_method: Method of authentication supported by the token endpoint of
     this authorization server. Possible values are Basic and/or Body. When Body is specified,
     client credentials and other parameters are passed within the request body in the
     application/x-www-form-urlencoded format.
    :vartype client_authentication_method: list[str or
     ~api_management_client.models.ClientAuthenticationMethod]
    :ivar token_body_parameters: Additional parameters required by the token endpoint of this
     authorization server represented as an array of JSON objects with name and value string
     properties, i.e. {"name" : "name value", "value": "a value"}.
    :vartype token_body_parameters: list[~api_management_client.models.TokenBodyParameterContract]
    :ivar token_endpoint: OAuth token endpoint. Contains absolute URI to entity being referenced.
    :vartype token_endpoint: str
    :ivar support_state: If true, authorization server will include state parameter from the
     authorization request to its response. Client may use state parameter to raise protocol
     security.
    :vartype support_state: bool
    :ivar default_scope: Access token scope that is going to be requested by default. Can be
     overridden at the API level. Should be provided in the form of a string containing
     space-delimited values.
    :vartype default_scope: str
    :ivar bearer_token_sending_methods: Specifies the mechanism by which access token is passed to
     the API.
    :vartype bearer_token_sending_methods: list[str or
     ~api_management_client.models.BearerTokenSendingMethod]
    :ivar resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :vartype resource_owner_username: str
    :ivar resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :vartype resource_owner_password: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authorization_methods': {'key': 'authorizationMethods', 'type': '[str]'},
        'client_authentication_method': {'key': 'clientAuthenticationMethod', 'type': '[str]'},
        'token_body_parameters': {'key': 'tokenBodyParameters', 'type': '[TokenBodyParameterContract]'},
        'token_endpoint': {'key': 'tokenEndpoint', 'type': 'str'},
        'support_state': {'key': 'supportState', 'type': 'bool'},
        'default_scope': {'key': 'defaultScope', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'bearerTokenSendingMethods', 'type': '[str]'},
        'resource_owner_username': {'key': 'resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'resourceOwnerPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authorization_methods: Optional[List[Union[str, "AuthorizationMethod"]]] = None,
        client_authentication_method: Optional[List[Union[str, "ClientAuthenticationMethod"]]] = None,
        token_body_parameters: Optional[List["TokenBodyParameterContract"]] = None,
        token_endpoint: Optional[str] = None,
        support_state: Optional[bool] = None,
        default_scope: Optional[str] = None,
        bearer_token_sending_methods: Optional[List[Union[str, "BearerTokenSendingMethod"]]] = None,
        resource_owner_username: Optional[str] = None,
        resource_owner_password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the authorization server. Can contain HTML formatting
         tags.
        :paramtype description: str
        :keyword authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
         always present. POST is optional.
        :paramtype authorization_methods: list[str or
         ~api_management_client.models.AuthorizationMethod]
        :keyword client_authentication_method: Method of authentication supported by the token endpoint
         of this authorization server. Possible values are Basic and/or Body. When Body is specified,
         client credentials and other parameters are passed within the request body in the
         application/x-www-form-urlencoded format.
        :paramtype client_authentication_method: list[str or
         ~api_management_client.models.ClientAuthenticationMethod]
        :keyword token_body_parameters: Additional parameters required by the token endpoint of this
         authorization server represented as an array of JSON objects with name and value string
         properties, i.e. {"name" : "name value", "value": "a value"}.
        :paramtype token_body_parameters:
         list[~api_management_client.models.TokenBodyParameterContract]
        :keyword token_endpoint: OAuth token endpoint. Contains absolute URI to entity being
         referenced.
        :paramtype token_endpoint: str
        :keyword support_state: If true, authorization server will include state parameter from the
         authorization request to its response. Client may use state parameter to raise protocol
         security.
        :paramtype support_state: bool
        :keyword default_scope: Access token scope that is going to be requested by default. Can be
         overridden at the API level. Should be provided in the form of a string containing
         space-delimited values.
        :paramtype default_scope: str
        :keyword bearer_token_sending_methods: Specifies the mechanism by which access token is passed
         to the API.
        :paramtype bearer_token_sending_methods: list[str or
         ~api_management_client.models.BearerTokenSendingMethod]
        :keyword resource_owner_username: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner username.
        :paramtype resource_owner_username: str
        :keyword resource_owner_password: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner password.
        :paramtype resource_owner_password: str
        """
        super(AuthorizationServerContractBaseProperties, self).__init__(**kwargs)
        self.description = description
        self.authorization_methods = authorization_methods
        self.client_authentication_method = client_authentication_method
        self.token_body_parameters = token_body_parameters
        self.token_endpoint = token_endpoint
        self.support_state = support_state
        self.default_scope = default_scope
        self.bearer_token_sending_methods = bearer_token_sending_methods
        self.resource_owner_username = resource_owner_username
        self.resource_owner_password = resource_owner_password


class AuthorizationServerContractProperties(AuthorizationServerContractBaseProperties):
    """External OAuth authorization server settings Properties.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description of the authorization server. Can contain HTML formatting tags.
    :vartype description: str
    :ivar authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
     always present. POST is optional.
    :vartype authorization_methods: list[str or ~api_management_client.models.AuthorizationMethod]
    :ivar client_authentication_method: Method of authentication supported by the token endpoint of
     this authorization server. Possible values are Basic and/or Body. When Body is specified,
     client credentials and other parameters are passed within the request body in the
     application/x-www-form-urlencoded format.
    :vartype client_authentication_method: list[str or
     ~api_management_client.models.ClientAuthenticationMethod]
    :ivar token_body_parameters: Additional parameters required by the token endpoint of this
     authorization server represented as an array of JSON objects with name and value string
     properties, i.e. {"name" : "name value", "value": "a value"}.
    :vartype token_body_parameters: list[~api_management_client.models.TokenBodyParameterContract]
    :ivar token_endpoint: OAuth token endpoint. Contains absolute URI to entity being referenced.
    :vartype token_endpoint: str
    :ivar support_state: If true, authorization server will include state parameter from the
     authorization request to its response. Client may use state parameter to raise protocol
     security.
    :vartype support_state: bool
    :ivar default_scope: Access token scope that is going to be requested by default. Can be
     overridden at the API level. Should be provided in the form of a string containing
     space-delimited values.
    :vartype default_scope: str
    :ivar bearer_token_sending_methods: Specifies the mechanism by which access token is passed to
     the API.
    :vartype bearer_token_sending_methods: list[str or
     ~api_management_client.models.BearerTokenSendingMethod]
    :ivar resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :vartype resource_owner_username: str
    :ivar resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :vartype resource_owner_password: str
    :ivar display_name: Required. User-friendly authorization server name.
    :vartype display_name: str
    :ivar client_registration_endpoint: Required. Optional reference to a page where client or app
     registration for this authorization server is performed. Contains absolute URL to entity being
     referenced.
    :vartype client_registration_endpoint: str
    :ivar authorization_endpoint: Required. OAuth authorization endpoint. See
     http://tools.ietf.org/html/rfc6749#section-3.2.
    :vartype authorization_endpoint: str
    :ivar grant_types: Required. Form of an authorization grant, which the client uses to request
     the access token.
    :vartype grant_types: list[str or ~api_management_client.models.GrantType]
    :ivar client_id: Required. Client or app id registered with this authorization server.
    :vartype client_id: str
    :ivar client_secret: Client or app secret registered with this authorization server. This
     property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
     value.
    :vartype client_secret: str
    """

    _validation = {
        'display_name': {'required': True, 'max_length': 50, 'min_length': 1},
        'client_registration_endpoint': {'required': True},
        'authorization_endpoint': {'required': True},
        'grant_types': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authorization_methods': {'key': 'authorizationMethods', 'type': '[str]'},
        'client_authentication_method': {'key': 'clientAuthenticationMethod', 'type': '[str]'},
        'token_body_parameters': {'key': 'tokenBodyParameters', 'type': '[TokenBodyParameterContract]'},
        'token_endpoint': {'key': 'tokenEndpoint', 'type': 'str'},
        'support_state': {'key': 'supportState', 'type': 'bool'},
        'default_scope': {'key': 'defaultScope', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'bearerTokenSendingMethods', 'type': '[str]'},
        'resource_owner_username': {'key': 'resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'resourceOwnerPassword', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'client_registration_endpoint': {'key': 'clientRegistrationEndpoint', 'type': 'str'},
        'authorization_endpoint': {'key': 'authorizationEndpoint', 'type': 'str'},
        'grant_types': {'key': 'grantTypes', 'type': '[str]'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        client_registration_endpoint: str,
        authorization_endpoint: str,
        grant_types: List[Union[str, "GrantType"]],
        client_id: str,
        description: Optional[str] = None,
        authorization_methods: Optional[List[Union[str, "AuthorizationMethod"]]] = None,
        client_authentication_method: Optional[List[Union[str, "ClientAuthenticationMethod"]]] = None,
        token_body_parameters: Optional[List["TokenBodyParameterContract"]] = None,
        token_endpoint: Optional[str] = None,
        support_state: Optional[bool] = None,
        default_scope: Optional[str] = None,
        bearer_token_sending_methods: Optional[List[Union[str, "BearerTokenSendingMethod"]]] = None,
        resource_owner_username: Optional[str] = None,
        resource_owner_password: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the authorization server. Can contain HTML formatting
         tags.
        :paramtype description: str
        :keyword authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
         always present. POST is optional.
        :paramtype authorization_methods: list[str or
         ~api_management_client.models.AuthorizationMethod]
        :keyword client_authentication_method: Method of authentication supported by the token endpoint
         of this authorization server. Possible values are Basic and/or Body. When Body is specified,
         client credentials and other parameters are passed within the request body in the
         application/x-www-form-urlencoded format.
        :paramtype client_authentication_method: list[str or
         ~api_management_client.models.ClientAuthenticationMethod]
        :keyword token_body_parameters: Additional parameters required by the token endpoint of this
         authorization server represented as an array of JSON objects with name and value string
         properties, i.e. {"name" : "name value", "value": "a value"}.
        :paramtype token_body_parameters:
         list[~api_management_client.models.TokenBodyParameterContract]
        :keyword token_endpoint: OAuth token endpoint. Contains absolute URI to entity being
         referenced.
        :paramtype token_endpoint: str
        :keyword support_state: If true, authorization server will include state parameter from the
         authorization request to its response. Client may use state parameter to raise protocol
         security.
        :paramtype support_state: bool
        :keyword default_scope: Access token scope that is going to be requested by default. Can be
         overridden at the API level. Should be provided in the form of a string containing
         space-delimited values.
        :paramtype default_scope: str
        :keyword bearer_token_sending_methods: Specifies the mechanism by which access token is passed
         to the API.
        :paramtype bearer_token_sending_methods: list[str or
         ~api_management_client.models.BearerTokenSendingMethod]
        :keyword resource_owner_username: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner username.
        :paramtype resource_owner_username: str
        :keyword resource_owner_password: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner password.
        :paramtype resource_owner_password: str
        :keyword display_name: Required. User-friendly authorization server name.
        :paramtype display_name: str
        :keyword client_registration_endpoint: Required. Optional reference to a page where client or
         app registration for this authorization server is performed. Contains absolute URL to entity
         being referenced.
        :paramtype client_registration_endpoint: str
        :keyword authorization_endpoint: Required. OAuth authorization endpoint. See
         http://tools.ietf.org/html/rfc6749#section-3.2.
        :paramtype authorization_endpoint: str
        :keyword grant_types: Required. Form of an authorization grant, which the client uses to
         request the access token.
        :paramtype grant_types: list[str or ~api_management_client.models.GrantType]
        :keyword client_id: Required. Client or app id registered with this authorization server.
        :paramtype client_id: str
        :keyword client_secret: Client or app secret registered with this authorization server. This
         property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
         value.
        :paramtype client_secret: str
        """
        super(AuthorizationServerContractProperties, self).__init__(description=description, authorization_methods=authorization_methods, client_authentication_method=client_authentication_method, token_body_parameters=token_body_parameters, token_endpoint=token_endpoint, support_state=support_state, default_scope=default_scope, bearer_token_sending_methods=bearer_token_sending_methods, resource_owner_username=resource_owner_username, resource_owner_password=resource_owner_password, **kwargs)
        self.display_name = display_name
        self.client_registration_endpoint = client_registration_endpoint
        self.authorization_endpoint = authorization_endpoint
        self.grant_types = grant_types
        self.client_id = client_id
        self.client_secret = client_secret


class AuthorizationServerSecretsContract(msrest.serialization.Model):
    """OAuth Server Secrets Contract.

    :ivar client_secret: oAuth Authorization Server Secrets.
    :vartype client_secret: str
    :ivar resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :vartype resource_owner_username: str
    :ivar resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :vartype resource_owner_password: str
    """

    _attribute_map = {
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
        'resource_owner_username': {'key': 'resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'resourceOwnerPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_secret: Optional[str] = None,
        resource_owner_username: Optional[str] = None,
        resource_owner_password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_secret: oAuth Authorization Server Secrets.
        :paramtype client_secret: str
        :keyword resource_owner_username: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner username.
        :paramtype resource_owner_username: str
        :keyword resource_owner_password: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner password.
        :paramtype resource_owner_password: str
        """
        super(AuthorizationServerSecretsContract, self).__init__(**kwargs)
        self.client_secret = client_secret
        self.resource_owner_username = resource_owner_username
        self.resource_owner_password = resource_owner_password


class AuthorizationServerUpdateContract(Resource):
    """External OAuth authorization server settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar description: Description of the authorization server. Can contain HTML formatting tags.
    :vartype description: str
    :ivar authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
     always present. POST is optional.
    :vartype authorization_methods: list[str or ~api_management_client.models.AuthorizationMethod]
    :ivar client_authentication_method: Method of authentication supported by the token endpoint of
     this authorization server. Possible values are Basic and/or Body. When Body is specified,
     client credentials and other parameters are passed within the request body in the
     application/x-www-form-urlencoded format.
    :vartype client_authentication_method: list[str or
     ~api_management_client.models.ClientAuthenticationMethod]
    :ivar token_body_parameters: Additional parameters required by the token endpoint of this
     authorization server represented as an array of JSON objects with name and value string
     properties, i.e. {"name" : "name value", "value": "a value"}.
    :vartype token_body_parameters: list[~api_management_client.models.TokenBodyParameterContract]
    :ivar token_endpoint: OAuth token endpoint. Contains absolute URI to entity being referenced.
    :vartype token_endpoint: str
    :ivar support_state: If true, authorization server will include state parameter from the
     authorization request to its response. Client may use state parameter to raise protocol
     security.
    :vartype support_state: bool
    :ivar default_scope: Access token scope that is going to be requested by default. Can be
     overridden at the API level. Should be provided in the form of a string containing
     space-delimited values.
    :vartype default_scope: str
    :ivar bearer_token_sending_methods: Specifies the mechanism by which access token is passed to
     the API.
    :vartype bearer_token_sending_methods: list[str or
     ~api_management_client.models.BearerTokenSendingMethod]
    :ivar resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :vartype resource_owner_username: str
    :ivar resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :vartype resource_owner_password: str
    :ivar display_name: User-friendly authorization server name.
    :vartype display_name: str
    :ivar client_registration_endpoint: Optional reference to a page where client or app
     registration for this authorization server is performed. Contains absolute URL to entity being
     referenced.
    :vartype client_registration_endpoint: str
    :ivar authorization_endpoint: OAuth authorization endpoint. See
     http://tools.ietf.org/html/rfc6749#section-3.2.
    :vartype authorization_endpoint: str
    :ivar grant_types: Form of an authorization grant, which the client uses to request the access
     token.
    :vartype grant_types: list[str or ~api_management_client.models.GrantType]
    :ivar client_id: Client or app id registered with this authorization server.
    :vartype client_id: str
    :ivar client_secret: Client or app secret registered with this authorization server. This
     property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
     value.
    :vartype client_secret: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 50, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'authorization_methods': {'key': 'properties.authorizationMethods', 'type': '[str]'},
        'client_authentication_method': {'key': 'properties.clientAuthenticationMethod', 'type': '[str]'},
        'token_body_parameters': {'key': 'properties.tokenBodyParameters', 'type': '[TokenBodyParameterContract]'},
        'token_endpoint': {'key': 'properties.tokenEndpoint', 'type': 'str'},
        'support_state': {'key': 'properties.supportState', 'type': 'bool'},
        'default_scope': {'key': 'properties.defaultScope', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'properties.bearerTokenSendingMethods', 'type': '[str]'},
        'resource_owner_username': {'key': 'properties.resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'properties.resourceOwnerPassword', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'client_registration_endpoint': {'key': 'properties.clientRegistrationEndpoint', 'type': 'str'},
        'authorization_endpoint': {'key': 'properties.authorizationEndpoint', 'type': 'str'},
        'grant_types': {'key': 'properties.grantTypes', 'type': '[str]'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authorization_methods: Optional[List[Union[str, "AuthorizationMethod"]]] = None,
        client_authentication_method: Optional[List[Union[str, "ClientAuthenticationMethod"]]] = None,
        token_body_parameters: Optional[List["TokenBodyParameterContract"]] = None,
        token_endpoint: Optional[str] = None,
        support_state: Optional[bool] = None,
        default_scope: Optional[str] = None,
        bearer_token_sending_methods: Optional[List[Union[str, "BearerTokenSendingMethod"]]] = None,
        resource_owner_username: Optional[str] = None,
        resource_owner_password: Optional[str] = None,
        display_name: Optional[str] = None,
        client_registration_endpoint: Optional[str] = None,
        authorization_endpoint: Optional[str] = None,
        grant_types: Optional[List[Union[str, "GrantType"]]] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the authorization server. Can contain HTML formatting
         tags.
        :paramtype description: str
        :keyword authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
         always present. POST is optional.
        :paramtype authorization_methods: list[str or
         ~api_management_client.models.AuthorizationMethod]
        :keyword client_authentication_method: Method of authentication supported by the token endpoint
         of this authorization server. Possible values are Basic and/or Body. When Body is specified,
         client credentials and other parameters are passed within the request body in the
         application/x-www-form-urlencoded format.
        :paramtype client_authentication_method: list[str or
         ~api_management_client.models.ClientAuthenticationMethod]
        :keyword token_body_parameters: Additional parameters required by the token endpoint of this
         authorization server represented as an array of JSON objects with name and value string
         properties, i.e. {"name" : "name value", "value": "a value"}.
        :paramtype token_body_parameters:
         list[~api_management_client.models.TokenBodyParameterContract]
        :keyword token_endpoint: OAuth token endpoint. Contains absolute URI to entity being
         referenced.
        :paramtype token_endpoint: str
        :keyword support_state: If true, authorization server will include state parameter from the
         authorization request to its response. Client may use state parameter to raise protocol
         security.
        :paramtype support_state: bool
        :keyword default_scope: Access token scope that is going to be requested by default. Can be
         overridden at the API level. Should be provided in the form of a string containing
         space-delimited values.
        :paramtype default_scope: str
        :keyword bearer_token_sending_methods: Specifies the mechanism by which access token is passed
         to the API.
        :paramtype bearer_token_sending_methods: list[str or
         ~api_management_client.models.BearerTokenSendingMethod]
        :keyword resource_owner_username: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner username.
        :paramtype resource_owner_username: str
        :keyword resource_owner_password: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner password.
        :paramtype resource_owner_password: str
        :keyword display_name: User-friendly authorization server name.
        :paramtype display_name: str
        :keyword client_registration_endpoint: Optional reference to a page where client or app
         registration for this authorization server is performed. Contains absolute URL to entity being
         referenced.
        :paramtype client_registration_endpoint: str
        :keyword authorization_endpoint: OAuth authorization endpoint. See
         http://tools.ietf.org/html/rfc6749#section-3.2.
        :paramtype authorization_endpoint: str
        :keyword grant_types: Form of an authorization grant, which the client uses to request the
         access token.
        :paramtype grant_types: list[str or ~api_management_client.models.GrantType]
        :keyword client_id: Client or app id registered with this authorization server.
        :paramtype client_id: str
        :keyword client_secret: Client or app secret registered with this authorization server. This
         property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
         value.
        :paramtype client_secret: str
        """
        super(AuthorizationServerUpdateContract, self).__init__(**kwargs)
        self.description = description
        self.authorization_methods = authorization_methods
        self.client_authentication_method = client_authentication_method
        self.token_body_parameters = token_body_parameters
        self.token_endpoint = token_endpoint
        self.support_state = support_state
        self.default_scope = default_scope
        self.bearer_token_sending_methods = bearer_token_sending_methods
        self.resource_owner_username = resource_owner_username
        self.resource_owner_password = resource_owner_password
        self.display_name = display_name
        self.client_registration_endpoint = client_registration_endpoint
        self.authorization_endpoint = authorization_endpoint
        self.grant_types = grant_types
        self.client_id = client_id
        self.client_secret = client_secret


class AuthorizationServerUpdateContractProperties(AuthorizationServerContractBaseProperties):
    """External OAuth authorization server Update settings contract.

    :ivar description: Description of the authorization server. Can contain HTML formatting tags.
    :vartype description: str
    :ivar authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
     always present. POST is optional.
    :vartype authorization_methods: list[str or ~api_management_client.models.AuthorizationMethod]
    :ivar client_authentication_method: Method of authentication supported by the token endpoint of
     this authorization server. Possible values are Basic and/or Body. When Body is specified,
     client credentials and other parameters are passed within the request body in the
     application/x-www-form-urlencoded format.
    :vartype client_authentication_method: list[str or
     ~api_management_client.models.ClientAuthenticationMethod]
    :ivar token_body_parameters: Additional parameters required by the token endpoint of this
     authorization server represented as an array of JSON objects with name and value string
     properties, i.e. {"name" : "name value", "value": "a value"}.
    :vartype token_body_parameters: list[~api_management_client.models.TokenBodyParameterContract]
    :ivar token_endpoint: OAuth token endpoint. Contains absolute URI to entity being referenced.
    :vartype token_endpoint: str
    :ivar support_state: If true, authorization server will include state parameter from the
     authorization request to its response. Client may use state parameter to raise protocol
     security.
    :vartype support_state: bool
    :ivar default_scope: Access token scope that is going to be requested by default. Can be
     overridden at the API level. Should be provided in the form of a string containing
     space-delimited values.
    :vartype default_scope: str
    :ivar bearer_token_sending_methods: Specifies the mechanism by which access token is passed to
     the API.
    :vartype bearer_token_sending_methods: list[str or
     ~api_management_client.models.BearerTokenSendingMethod]
    :ivar resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :vartype resource_owner_username: str
    :ivar resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :vartype resource_owner_password: str
    :ivar display_name: User-friendly authorization server name.
    :vartype display_name: str
    :ivar client_registration_endpoint: Optional reference to a page where client or app
     registration for this authorization server is performed. Contains absolute URL to entity being
     referenced.
    :vartype client_registration_endpoint: str
    :ivar authorization_endpoint: OAuth authorization endpoint. See
     http://tools.ietf.org/html/rfc6749#section-3.2.
    :vartype authorization_endpoint: str
    :ivar grant_types: Form of an authorization grant, which the client uses to request the access
     token.
    :vartype grant_types: list[str or ~api_management_client.models.GrantType]
    :ivar client_id: Client or app id registered with this authorization server.
    :vartype client_id: str
    :ivar client_secret: Client or app secret registered with this authorization server. This
     property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
     value.
    :vartype client_secret: str
    """

    _validation = {
        'display_name': {'max_length': 50, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authorization_methods': {'key': 'authorizationMethods', 'type': '[str]'},
        'client_authentication_method': {'key': 'clientAuthenticationMethod', 'type': '[str]'},
        'token_body_parameters': {'key': 'tokenBodyParameters', 'type': '[TokenBodyParameterContract]'},
        'token_endpoint': {'key': 'tokenEndpoint', 'type': 'str'},
        'support_state': {'key': 'supportState', 'type': 'bool'},
        'default_scope': {'key': 'defaultScope', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'bearerTokenSendingMethods', 'type': '[str]'},
        'resource_owner_username': {'key': 'resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'resourceOwnerPassword', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'client_registration_endpoint': {'key': 'clientRegistrationEndpoint', 'type': 'str'},
        'authorization_endpoint': {'key': 'authorizationEndpoint', 'type': 'str'},
        'grant_types': {'key': 'grantTypes', 'type': '[str]'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authorization_methods: Optional[List[Union[str, "AuthorizationMethod"]]] = None,
        client_authentication_method: Optional[List[Union[str, "ClientAuthenticationMethod"]]] = None,
        token_body_parameters: Optional[List["TokenBodyParameterContract"]] = None,
        token_endpoint: Optional[str] = None,
        support_state: Optional[bool] = None,
        default_scope: Optional[str] = None,
        bearer_token_sending_methods: Optional[List[Union[str, "BearerTokenSendingMethod"]]] = None,
        resource_owner_username: Optional[str] = None,
        resource_owner_password: Optional[str] = None,
        display_name: Optional[str] = None,
        client_registration_endpoint: Optional[str] = None,
        authorization_endpoint: Optional[str] = None,
        grant_types: Optional[List[Union[str, "GrantType"]]] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the authorization server. Can contain HTML formatting
         tags.
        :paramtype description: str
        :keyword authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
         always present. POST is optional.
        :paramtype authorization_methods: list[str or
         ~api_management_client.models.AuthorizationMethod]
        :keyword client_authentication_method: Method of authentication supported by the token endpoint
         of this authorization server. Possible values are Basic and/or Body. When Body is specified,
         client credentials and other parameters are passed within the request body in the
         application/x-www-form-urlencoded format.
        :paramtype client_authentication_method: list[str or
         ~api_management_client.models.ClientAuthenticationMethod]
        :keyword token_body_parameters: Additional parameters required by the token endpoint of this
         authorization server represented as an array of JSON objects with name and value string
         properties, i.e. {"name" : "name value", "value": "a value"}.
        :paramtype token_body_parameters:
         list[~api_management_client.models.TokenBodyParameterContract]
        :keyword token_endpoint: OAuth token endpoint. Contains absolute URI to entity being
         referenced.
        :paramtype token_endpoint: str
        :keyword support_state: If true, authorization server will include state parameter from the
         authorization request to its response. Client may use state parameter to raise protocol
         security.
        :paramtype support_state: bool
        :keyword default_scope: Access token scope that is going to be requested by default. Can be
         overridden at the API level. Should be provided in the form of a string containing
         space-delimited values.
        :paramtype default_scope: str
        :keyword bearer_token_sending_methods: Specifies the mechanism by which access token is passed
         to the API.
        :paramtype bearer_token_sending_methods: list[str or
         ~api_management_client.models.BearerTokenSendingMethod]
        :keyword resource_owner_username: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner username.
        :paramtype resource_owner_username: str
        :keyword resource_owner_password: Can be optionally specified when resource owner password
         grant type is supported by this authorization server. Default resource owner password.
        :paramtype resource_owner_password: str
        :keyword display_name: User-friendly authorization server name.
        :paramtype display_name: str
        :keyword client_registration_endpoint: Optional reference to a page where client or app
         registration for this authorization server is performed. Contains absolute URL to entity being
         referenced.
        :paramtype client_registration_endpoint: str
        :keyword authorization_endpoint: OAuth authorization endpoint. See
         http://tools.ietf.org/html/rfc6749#section-3.2.
        :paramtype authorization_endpoint: str
        :keyword grant_types: Form of an authorization grant, which the client uses to request the
         access token.
        :paramtype grant_types: list[str or ~api_management_client.models.GrantType]
        :keyword client_id: Client or app id registered with this authorization server.
        :paramtype client_id: str
        :keyword client_secret: Client or app secret registered with this authorization server. This
         property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
         value.
        :paramtype client_secret: str
        """
        super(AuthorizationServerUpdateContractProperties, self).__init__(description=description, authorization_methods=authorization_methods, client_authentication_method=client_authentication_method, token_body_parameters=token_body_parameters, token_endpoint=token_endpoint, support_state=support_state, default_scope=default_scope, bearer_token_sending_methods=bearer_token_sending_methods, resource_owner_username=resource_owner_username, resource_owner_password=resource_owner_password, **kwargs)
        self.display_name = display_name
        self.client_registration_endpoint = client_registration_endpoint
        self.authorization_endpoint = authorization_endpoint
        self.grant_types = grant_types
        self.client_id = client_id
        self.client_secret = client_secret


class BackendAuthorizationHeaderCredentials(msrest.serialization.Model):
    """Authorization header information.

    All required parameters must be populated in order to send to Azure.

    :ivar scheme: Required. Authentication Scheme name.
    :vartype scheme: str
    :ivar parameter: Required. Authentication Parameter value.
    :vartype parameter: str
    """

    _validation = {
        'scheme': {'required': True, 'max_length': 100, 'min_length': 1},
        'parameter': {'required': True, 'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'scheme': {'key': 'scheme', 'type': 'str'},
        'parameter': {'key': 'parameter', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        scheme: str,
        parameter: str,
        **kwargs
    ):
        """
        :keyword scheme: Required. Authentication Scheme name.
        :paramtype scheme: str
        :keyword parameter: Required. Authentication Parameter value.
        :paramtype parameter: str
        """
        super(BackendAuthorizationHeaderCredentials, self).__init__(**kwargs)
        self.scheme = scheme
        self.parameter = parameter


class BackendBaseParameters(msrest.serialization.Model):
    """Backend entity base Parameter set.

    :ivar title: Backend Title.
    :vartype title: str
    :ivar description: Backend Description.
    :vartype description: str
    :ivar resource_id: Management Uri of the Resource in External System. This url can be the Arm
     Resource Id of Logic Apps, Function Apps or API Apps.
    :vartype resource_id: str
    :ivar properties: Backend Properties contract.
    :vartype properties: ~api_management_client.models.BackendProperties
    :ivar credentials: Backend Credentials Contract Properties.
    :vartype credentials: ~api_management_client.models.BackendCredentialsContract
    :ivar proxy: Backend Proxy Contract Properties.
    :vartype proxy: ~api_management_client.models.BackendProxyContract
    :ivar tls: Backend TLS Properties.
    :vartype tls: ~api_management_client.models.BackendTlsProperties
    """

    _validation = {
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'tls', 'type': 'BackendTlsProperties'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        properties: Optional["BackendProperties"] = None,
        credentials: Optional["BackendCredentialsContract"] = None,
        proxy: Optional["BackendProxyContract"] = None,
        tls: Optional["BackendTlsProperties"] = None,
        **kwargs
    ):
        """
        :keyword title: Backend Title.
        :paramtype title: str
        :keyword description: Backend Description.
        :paramtype description: str
        :keyword resource_id: Management Uri of the Resource in External System. This url can be the
         Arm Resource Id of Logic Apps, Function Apps or API Apps.
        :paramtype resource_id: str
        :keyword properties: Backend Properties contract.
        :paramtype properties: ~api_management_client.models.BackendProperties
        :keyword credentials: Backend Credentials Contract Properties.
        :paramtype credentials: ~api_management_client.models.BackendCredentialsContract
        :keyword proxy: Backend Proxy Contract Properties.
        :paramtype proxy: ~api_management_client.models.BackendProxyContract
        :keyword tls: Backend TLS Properties.
        :paramtype tls: ~api_management_client.models.BackendTlsProperties
        """
        super(BackendBaseParameters, self).__init__(**kwargs)
        self.title = title
        self.description = description
        self.resource_id = resource_id
        self.properties = properties
        self.credentials = credentials
        self.proxy = proxy
        self.tls = tls


class BackendCollection(msrest.serialization.Model):
    """Paged Backend list representation.

    :ivar value: Backend values.
    :vartype value: list[~api_management_client.models.BackendContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackendContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BackendContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Backend values.
        :paramtype value: list[~api_management_client.models.BackendContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(BackendCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class BackendContract(Resource):
    """Backend details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar title: Backend Title.
    :vartype title: str
    :ivar description: Backend Description.
    :vartype description: str
    :ivar resource_id: Management Uri of the Resource in External System. This url can be the Arm
     Resource Id of Logic Apps, Function Apps or API Apps.
    :vartype resource_id: str
    :ivar properties: Backend Properties contract.
    :vartype properties: ~api_management_client.models.BackendProperties
    :ivar credentials: Backend Credentials Contract Properties.
    :vartype credentials: ~api_management_client.models.BackendCredentialsContract
    :ivar proxy: Backend Proxy Contract Properties.
    :vartype proxy: ~api_management_client.models.BackendProxyContract
    :ivar tls: Backend TLS Properties.
    :vartype tls: ~api_management_client.models.BackendTlsProperties
    :ivar url: Runtime Url of the Backend.
    :vartype url: str
    :ivar protocol: Backend communication protocol. Possible values include: "http", "soap".
    :vartype protocol: str or ~api_management_client.models.BackendProtocol
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
        'url': {'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'properties.credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'properties.proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'properties.tls', 'type': 'BackendTlsProperties'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        properties: Optional["BackendProperties"] = None,
        credentials: Optional["BackendCredentialsContract"] = None,
        proxy: Optional["BackendProxyContract"] = None,
        tls: Optional["BackendTlsProperties"] = None,
        url: Optional[str] = None,
        protocol: Optional[Union[str, "BackendProtocol"]] = None,
        **kwargs
    ):
        """
        :keyword title: Backend Title.
        :paramtype title: str
        :keyword description: Backend Description.
        :paramtype description: str
        :keyword resource_id: Management Uri of the Resource in External System. This url can be the
         Arm Resource Id of Logic Apps, Function Apps or API Apps.
        :paramtype resource_id: str
        :keyword properties: Backend Properties contract.
        :paramtype properties: ~api_management_client.models.BackendProperties
        :keyword credentials: Backend Credentials Contract Properties.
        :paramtype credentials: ~api_management_client.models.BackendCredentialsContract
        :keyword proxy: Backend Proxy Contract Properties.
        :paramtype proxy: ~api_management_client.models.BackendProxyContract
        :keyword tls: Backend TLS Properties.
        :paramtype tls: ~api_management_client.models.BackendTlsProperties
        :keyword url: Runtime Url of the Backend.
        :paramtype url: str
        :keyword protocol: Backend communication protocol. Possible values include: "http", "soap".
        :paramtype protocol: str or ~api_management_client.models.BackendProtocol
        """
        super(BackendContract, self).__init__(**kwargs)
        self.title = title
        self.description = description
        self.resource_id = resource_id
        self.properties = properties
        self.credentials = credentials
        self.proxy = proxy
        self.tls = tls
        self.url = url
        self.protocol = protocol


class BackendContractProperties(BackendBaseParameters):
    """Parameters supplied to the Create Backend operation.

    All required parameters must be populated in order to send to Azure.

    :ivar title: Backend Title.
    :vartype title: str
    :ivar description: Backend Description.
    :vartype description: str
    :ivar resource_id: Management Uri of the Resource in External System. This url can be the Arm
     Resource Id of Logic Apps, Function Apps or API Apps.
    :vartype resource_id: str
    :ivar properties: Backend Properties contract.
    :vartype properties: ~api_management_client.models.BackendProperties
    :ivar credentials: Backend Credentials Contract Properties.
    :vartype credentials: ~api_management_client.models.BackendCredentialsContract
    :ivar proxy: Backend Proxy Contract Properties.
    :vartype proxy: ~api_management_client.models.BackendProxyContract
    :ivar tls: Backend TLS Properties.
    :vartype tls: ~api_management_client.models.BackendTlsProperties
    :ivar url: Required. Runtime Url of the Backend.
    :vartype url: str
    :ivar protocol: Required. Backend communication protocol. Possible values include: "http",
     "soap".
    :vartype protocol: str or ~api_management_client.models.BackendProtocol
    """

    _validation = {
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
        'url': {'required': True, 'max_length': 2000, 'min_length': 1},
        'protocol': {'required': True},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'tls', 'type': 'BackendTlsProperties'},
        'url': {'key': 'url', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: str,
        protocol: Union[str, "BackendProtocol"],
        title: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        properties: Optional["BackendProperties"] = None,
        credentials: Optional["BackendCredentialsContract"] = None,
        proxy: Optional["BackendProxyContract"] = None,
        tls: Optional["BackendTlsProperties"] = None,
        **kwargs
    ):
        """
        :keyword title: Backend Title.
        :paramtype title: str
        :keyword description: Backend Description.
        :paramtype description: str
        :keyword resource_id: Management Uri of the Resource in External System. This url can be the
         Arm Resource Id of Logic Apps, Function Apps or API Apps.
        :paramtype resource_id: str
        :keyword properties: Backend Properties contract.
        :paramtype properties: ~api_management_client.models.BackendProperties
        :keyword credentials: Backend Credentials Contract Properties.
        :paramtype credentials: ~api_management_client.models.BackendCredentialsContract
        :keyword proxy: Backend Proxy Contract Properties.
        :paramtype proxy: ~api_management_client.models.BackendProxyContract
        :keyword tls: Backend TLS Properties.
        :paramtype tls: ~api_management_client.models.BackendTlsProperties
        :keyword url: Required. Runtime Url of the Backend.
        :paramtype url: str
        :keyword protocol: Required. Backend communication protocol. Possible values include: "http",
         "soap".
        :paramtype protocol: str or ~api_management_client.models.BackendProtocol
        """
        super(BackendContractProperties, self).__init__(title=title, description=description, resource_id=resource_id, properties=properties, credentials=credentials, proxy=proxy, tls=tls, **kwargs)
        self.url = url
        self.protocol = protocol


class BackendCredentialsContract(msrest.serialization.Model):
    """Details of the Credentials used to connect to Backend.

    :ivar certificate_ids: List of Client Certificate Ids.
    :vartype certificate_ids: list[str]
    :ivar certificate: List of Client Certificate Thumbprints. Will be ignored if certificatesIds
     are provided.
    :vartype certificate: list[str]
    :ivar query: Query Parameter description.
    :vartype query: dict[str, list[str]]
    :ivar header: Header Parameter description.
    :vartype header: dict[str, list[str]]
    :ivar authorization: Authorization header authentication.
    :vartype authorization: ~api_management_client.models.BackendAuthorizationHeaderCredentials
    """

    _validation = {
        'certificate_ids': {'max_items': 32, 'min_items': 0},
        'certificate': {'max_items': 32, 'min_items': 0},
    }

    _attribute_map = {
        'certificate_ids': {'key': 'certificateIds', 'type': '[str]'},
        'certificate': {'key': 'certificate', 'type': '[str]'},
        'query': {'key': 'query', 'type': '{[str]}'},
        'header': {'key': 'header', 'type': '{[str]}'},
        'authorization': {'key': 'authorization', 'type': 'BackendAuthorizationHeaderCredentials'},
    }

    def __init__(
        self,
        *,
        certificate_ids: Optional[List[str]] = None,
        certificate: Optional[List[str]] = None,
        query: Optional[Dict[str, List[str]]] = None,
        header: Optional[Dict[str, List[str]]] = None,
        authorization: Optional["BackendAuthorizationHeaderCredentials"] = None,
        **kwargs
    ):
        """
        :keyword certificate_ids: List of Client Certificate Ids.
        :paramtype certificate_ids: list[str]
        :keyword certificate: List of Client Certificate Thumbprints. Will be ignored if
         certificatesIds are provided.
        :paramtype certificate: list[str]
        :keyword query: Query Parameter description.
        :paramtype query: dict[str, list[str]]
        :keyword header: Header Parameter description.
        :paramtype header: dict[str, list[str]]
        :keyword authorization: Authorization header authentication.
        :paramtype authorization: ~api_management_client.models.BackendAuthorizationHeaderCredentials
        """
        super(BackendCredentialsContract, self).__init__(**kwargs)
        self.certificate_ids = certificate_ids
        self.certificate = certificate
        self.query = query
        self.header = header
        self.authorization = authorization


class BackendProperties(msrest.serialization.Model):
    """Properties specific to the Backend Type.

    :ivar service_fabric_cluster: Backend Service Fabric Cluster Properties.
    :vartype service_fabric_cluster:
     ~api_management_client.models.BackendServiceFabricClusterProperties
    """

    _attribute_map = {
        'service_fabric_cluster': {'key': 'serviceFabricCluster', 'type': 'BackendServiceFabricClusterProperties'},
    }

    def __init__(
        self,
        *,
        service_fabric_cluster: Optional["BackendServiceFabricClusterProperties"] = None,
        **kwargs
    ):
        """
        :keyword service_fabric_cluster: Backend Service Fabric Cluster Properties.
        :paramtype service_fabric_cluster:
         ~api_management_client.models.BackendServiceFabricClusterProperties
        """
        super(BackendProperties, self).__init__(**kwargs)
        self.service_fabric_cluster = service_fabric_cluster


class BackendProxyContract(msrest.serialization.Model):
    """Details of the Backend WebProxy Server to use in the Request to Backend.

    All required parameters must be populated in order to send to Azure.

    :ivar url: Required. WebProxy Server AbsoluteUri property which includes the entire URI stored
     in the Uri instance, including all fragments and query strings.
    :vartype url: str
    :ivar username: Username to connect to the WebProxy server.
    :vartype username: str
    :ivar password: Password to connect to the WebProxy Server.
    :vartype password: str
    """

    _validation = {
        'url': {'required': True, 'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: str,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword url: Required. WebProxy Server AbsoluteUri property which includes the entire URI
         stored in the Uri instance, including all fragments and query strings.
        :paramtype url: str
        :keyword username: Username to connect to the WebProxy server.
        :paramtype username: str
        :keyword password: Password to connect to the WebProxy Server.
        :paramtype password: str
        """
        super(BackendProxyContract, self).__init__(**kwargs)
        self.url = url
        self.username = username
        self.password = password


class BackendReconnectContract(Resource):
    """Reconnect request parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar after: Duration in ISO8601 format after which reconnect will be initiated. Minimum
     duration of the Reconnect is PT2M.
    :vartype after: ~datetime.timedelta
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'after': {'key': 'properties.after', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        after: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword after: Duration in ISO8601 format after which reconnect will be initiated. Minimum
         duration of the Reconnect is PT2M.
        :paramtype after: ~datetime.timedelta
        """
        super(BackendReconnectContract, self).__init__(**kwargs)
        self.after = after


class BackendServiceFabricClusterProperties(msrest.serialization.Model):
    """Properties of the Service Fabric Type Backend.

    All required parameters must be populated in order to send to Azure.

    :ivar client_certificate_id: The client certificate id for the management endpoint.
    :vartype client_certificate_id: str
    :ivar client_certificatethumbprint: The client certificate thumbprint for the management
     endpoint. Will be ignored if certificatesIds are provided.
    :vartype client_certificatethumbprint: str
    :ivar max_partition_resolution_retries: Maximum number of retries while attempting resolve the
     partition.
    :vartype max_partition_resolution_retries: int
    :ivar management_endpoints: Required. The cluster management endpoint.
    :vartype management_endpoints: list[str]
    :ivar server_certificate_thumbprints: Thumbprints of certificates cluster management service
     uses for tls communication.
    :vartype server_certificate_thumbprints: list[str]
    :ivar server_x509_names: Server X509 Certificate Names Collection.
    :vartype server_x509_names: list[~api_management_client.models.X509CertificateName]
    """

    _validation = {
        'management_endpoints': {'required': True},
    }

    _attribute_map = {
        'client_certificate_id': {'key': 'clientCertificateId', 'type': 'str'},
        'client_certificatethumbprint': {'key': 'clientCertificatethumbprint', 'type': 'str'},
        'max_partition_resolution_retries': {'key': 'maxPartitionResolutionRetries', 'type': 'int'},
        'management_endpoints': {'key': 'managementEndpoints', 'type': '[str]'},
        'server_certificate_thumbprints': {'key': 'serverCertificateThumbprints', 'type': '[str]'},
        'server_x509_names': {'key': 'serverX509Names', 'type': '[X509CertificateName]'},
    }

    def __init__(
        self,
        *,
        management_endpoints: List[str],
        client_certificate_id: Optional[str] = None,
        client_certificatethumbprint: Optional[str] = None,
        max_partition_resolution_retries: Optional[int] = None,
        server_certificate_thumbprints: Optional[List[str]] = None,
        server_x509_names: Optional[List["X509CertificateName"]] = None,
        **kwargs
    ):
        """
        :keyword client_certificate_id: The client certificate id for the management endpoint.
        :paramtype client_certificate_id: str
        :keyword client_certificatethumbprint: The client certificate thumbprint for the management
         endpoint. Will be ignored if certificatesIds are provided.
        :paramtype client_certificatethumbprint: str
        :keyword max_partition_resolution_retries: Maximum number of retries while attempting resolve
         the partition.
        :paramtype max_partition_resolution_retries: int
        :keyword management_endpoints: Required. The cluster management endpoint.
        :paramtype management_endpoints: list[str]
        :keyword server_certificate_thumbprints: Thumbprints of certificates cluster management service
         uses for tls communication.
        :paramtype server_certificate_thumbprints: list[str]
        :keyword server_x509_names: Server X509 Certificate Names Collection.
        :paramtype server_x509_names: list[~api_management_client.models.X509CertificateName]
        """
        super(BackendServiceFabricClusterProperties, self).__init__(**kwargs)
        self.client_certificate_id = client_certificate_id
        self.client_certificatethumbprint = client_certificatethumbprint
        self.max_partition_resolution_retries = max_partition_resolution_retries
        self.management_endpoints = management_endpoints
        self.server_certificate_thumbprints = server_certificate_thumbprints
        self.server_x509_names = server_x509_names


class BackendTlsProperties(msrest.serialization.Model):
    """Properties controlling TLS Certificate Validation.

    :ivar validate_certificate_chain: Flag indicating whether SSL certificate chain validation
     should be done when using self-signed certificates for this backend host.
    :vartype validate_certificate_chain: bool
    :ivar validate_certificate_name: Flag indicating whether SSL certificate name validation should
     be done when using self-signed certificates for this backend host.
    :vartype validate_certificate_name: bool
    """

    _attribute_map = {
        'validate_certificate_chain': {'key': 'validateCertificateChain', 'type': 'bool'},
        'validate_certificate_name': {'key': 'validateCertificateName', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        validate_certificate_chain: Optional[bool] = True,
        validate_certificate_name: Optional[bool] = True,
        **kwargs
    ):
        """
        :keyword validate_certificate_chain: Flag indicating whether SSL certificate chain validation
         should be done when using self-signed certificates for this backend host.
        :paramtype validate_certificate_chain: bool
        :keyword validate_certificate_name: Flag indicating whether SSL certificate name validation
         should be done when using self-signed certificates for this backend host.
        :paramtype validate_certificate_name: bool
        """
        super(BackendTlsProperties, self).__init__(**kwargs)
        self.validate_certificate_chain = validate_certificate_chain
        self.validate_certificate_name = validate_certificate_name


class BackendUpdateParameterProperties(BackendBaseParameters):
    """Parameters supplied to the Update Backend operation.

    :ivar title: Backend Title.
    :vartype title: str
    :ivar description: Backend Description.
    :vartype description: str
    :ivar resource_id: Management Uri of the Resource in External System. This url can be the Arm
     Resource Id of Logic Apps, Function Apps or API Apps.
    :vartype resource_id: str
    :ivar properties: Backend Properties contract.
    :vartype properties: ~api_management_client.models.BackendProperties
    :ivar credentials: Backend Credentials Contract Properties.
    :vartype credentials: ~api_management_client.models.BackendCredentialsContract
    :ivar proxy: Backend Proxy Contract Properties.
    :vartype proxy: ~api_management_client.models.BackendProxyContract
    :ivar tls: Backend TLS Properties.
    :vartype tls: ~api_management_client.models.BackendTlsProperties
    :ivar url: Runtime Url of the Backend.
    :vartype url: str
    :ivar protocol: Backend communication protocol. Possible values include: "http", "soap".
    :vartype protocol: str or ~api_management_client.models.BackendProtocol
    """

    _validation = {
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
        'url': {'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'tls', 'type': 'BackendTlsProperties'},
        'url': {'key': 'url', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        properties: Optional["BackendProperties"] = None,
        credentials: Optional["BackendCredentialsContract"] = None,
        proxy: Optional["BackendProxyContract"] = None,
        tls: Optional["BackendTlsProperties"] = None,
        url: Optional[str] = None,
        protocol: Optional[Union[str, "BackendProtocol"]] = None,
        **kwargs
    ):
        """
        :keyword title: Backend Title.
        :paramtype title: str
        :keyword description: Backend Description.
        :paramtype description: str
        :keyword resource_id: Management Uri of the Resource in External System. This url can be the
         Arm Resource Id of Logic Apps, Function Apps or API Apps.
        :paramtype resource_id: str
        :keyword properties: Backend Properties contract.
        :paramtype properties: ~api_management_client.models.BackendProperties
        :keyword credentials: Backend Credentials Contract Properties.
        :paramtype credentials: ~api_management_client.models.BackendCredentialsContract
        :keyword proxy: Backend Proxy Contract Properties.
        :paramtype proxy: ~api_management_client.models.BackendProxyContract
        :keyword tls: Backend TLS Properties.
        :paramtype tls: ~api_management_client.models.BackendTlsProperties
        :keyword url: Runtime Url of the Backend.
        :paramtype url: str
        :keyword protocol: Backend communication protocol. Possible values include: "http", "soap".
        :paramtype protocol: str or ~api_management_client.models.BackendProtocol
        """
        super(BackendUpdateParameterProperties, self).__init__(title=title, description=description, resource_id=resource_id, properties=properties, credentials=credentials, proxy=proxy, tls=tls, **kwargs)
        self.url = url
        self.protocol = protocol


class BackendUpdateParameters(msrest.serialization.Model):
    """Backend update parameters.

    :ivar title: Backend Title.
    :vartype title: str
    :ivar description: Backend Description.
    :vartype description: str
    :ivar resource_id: Management Uri of the Resource in External System. This url can be the Arm
     Resource Id of Logic Apps, Function Apps or API Apps.
    :vartype resource_id: str
    :ivar properties: Backend Properties contract.
    :vartype properties: ~api_management_client.models.BackendProperties
    :ivar credentials: Backend Credentials Contract Properties.
    :vartype credentials: ~api_management_client.models.BackendCredentialsContract
    :ivar proxy: Backend Proxy Contract Properties.
    :vartype proxy: ~api_management_client.models.BackendProxyContract
    :ivar tls: Backend TLS Properties.
    :vartype tls: ~api_management_client.models.BackendTlsProperties
    :ivar url: Runtime Url of the Backend.
    :vartype url: str
    :ivar protocol: Backend communication protocol. Possible values include: "http", "soap".
    :vartype protocol: str or ~api_management_client.models.BackendProtocol
    """

    _validation = {
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
        'url': {'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'properties.credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'properties.proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'properties.tls', 'type': 'BackendTlsProperties'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        properties: Optional["BackendProperties"] = None,
        credentials: Optional["BackendCredentialsContract"] = None,
        proxy: Optional["BackendProxyContract"] = None,
        tls: Optional["BackendTlsProperties"] = None,
        url: Optional[str] = None,
        protocol: Optional[Union[str, "BackendProtocol"]] = None,
        **kwargs
    ):
        """
        :keyword title: Backend Title.
        :paramtype title: str
        :keyword description: Backend Description.
        :paramtype description: str
        :keyword resource_id: Management Uri of the Resource in External System. This url can be the
         Arm Resource Id of Logic Apps, Function Apps or API Apps.
        :paramtype resource_id: str
        :keyword properties: Backend Properties contract.
        :paramtype properties: ~api_management_client.models.BackendProperties
        :keyword credentials: Backend Credentials Contract Properties.
        :paramtype credentials: ~api_management_client.models.BackendCredentialsContract
        :keyword proxy: Backend Proxy Contract Properties.
        :paramtype proxy: ~api_management_client.models.BackendProxyContract
        :keyword tls: Backend TLS Properties.
        :paramtype tls: ~api_management_client.models.BackendTlsProperties
        :keyword url: Runtime Url of the Backend.
        :paramtype url: str
        :keyword protocol: Backend communication protocol. Possible values include: "http", "soap".
        :paramtype protocol: str or ~api_management_client.models.BackendProtocol
        """
        super(BackendUpdateParameters, self).__init__(**kwargs)
        self.title = title
        self.description = description
        self.resource_id = resource_id
        self.properties = properties
        self.credentials = credentials
        self.proxy = proxy
        self.tls = tls
        self.url = url
        self.protocol = protocol


class BodyDiagnosticSettings(msrest.serialization.Model):
    """Body logging settings.

    :ivar bytes: Number of request body bytes to log.
    :vartype bytes: int
    """

    _validation = {
        'bytes': {'maximum': 8192},
    }

    _attribute_map = {
        'bytes': {'key': 'bytes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        bytes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword bytes: Number of request body bytes to log.
        :paramtype bytes: int
        """
        super(BodyDiagnosticSettings, self).__init__(**kwargs)
        self.bytes = bytes


class CacheCollection(msrest.serialization.Model):
    """Paged Caches list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.CacheContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CacheContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["CacheContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.CacheContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(CacheCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class CacheContract(Resource):
    """Cache details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar description: Cache description.
    :vartype description: str
    :ivar connection_string: Runtime connection string to cache.
    :vartype connection_string: str
    :ivar use_from_location: Location identifier to use cache from (should be either 'default' or
     valid Azure region identifier).
    :vartype use_from_location: str
    :ivar resource_id: Original uri of entity in external system cache points to.
    :vartype resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 2000, 'min_length': 0},
        'connection_string': {'max_length': 300, 'min_length': 0},
        'use_from_location': {'max_length': 256, 'min_length': 0},
        'resource_id': {'max_length': 2000, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'use_from_location': {'key': 'properties.useFromLocation', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        connection_string: Optional[str] = None,
        use_from_location: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Cache description.
        :paramtype description: str
        :keyword connection_string: Runtime connection string to cache.
        :paramtype connection_string: str
        :keyword use_from_location: Location identifier to use cache from (should be either 'default'
         or valid Azure region identifier).
        :paramtype use_from_location: str
        :keyword resource_id: Original uri of entity in external system cache points to.
        :paramtype resource_id: str
        """
        super(CacheContract, self).__init__(**kwargs)
        self.description = description
        self.connection_string = connection_string
        self.use_from_location = use_from_location
        self.resource_id = resource_id


class CacheUpdateParameters(msrest.serialization.Model):
    """Cache update details.

    :ivar description: Cache description.
    :vartype description: str
    :ivar connection_string: Runtime connection string to cache.
    :vartype connection_string: str
    :ivar use_from_location: Location identifier to use cache from (should be either 'default' or
     valid Azure region identifier).
    :vartype use_from_location: str
    :ivar resource_id: Original uri of entity in external system cache points to.
    :vartype resource_id: str
    """

    _validation = {
        'description': {'max_length': 2000, 'min_length': 0},
        'connection_string': {'max_length': 300, 'min_length': 0},
        'use_from_location': {'max_length': 256, 'min_length': 0},
        'resource_id': {'max_length': 2000, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'use_from_location': {'key': 'properties.useFromLocation', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        connection_string: Optional[str] = None,
        use_from_location: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Cache description.
        :paramtype description: str
        :keyword connection_string: Runtime connection string to cache.
        :paramtype connection_string: str
        :keyword use_from_location: Location identifier to use cache from (should be either 'default'
         or valid Azure region identifier).
        :paramtype use_from_location: str
        :keyword resource_id: Original uri of entity in external system cache points to.
        :paramtype resource_id: str
        """
        super(CacheUpdateParameters, self).__init__(**kwargs)
        self.description = description
        self.connection_string = connection_string
        self.use_from_location = use_from_location
        self.resource_id = resource_id


class CertificateCollection(msrest.serialization.Model):
    """Paged Certificates list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.CertificateContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CertificateContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["CertificateContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.CertificateContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(CertificateCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class CertificateConfiguration(msrest.serialization.Model):
    """Certificate configuration which consist of non-trusted intermediates and root certificates.

    All required parameters must be populated in order to send to Azure.

    :ivar encoded_certificate: Base64 Encoded certificate.
    :vartype encoded_certificate: str
    :ivar certificate_password: Certificate Password.
    :vartype certificate_password: str
    :ivar store_name: Required. The System.Security.Cryptography.x509certificates.StoreName
     certificate store location. Only Root and CertificateAuthority are valid locations. Possible
     values include: "CertificateAuthority", "Root".
    :vartype store_name: str or ~api_management_client.models.CertificateConfigurationStoreName
    :ivar certificate: Certificate information.
    :vartype certificate: ~api_management_client.models.CertificateInformation
    """

    _validation = {
        'store_name': {'required': True},
    }

    _attribute_map = {
        'encoded_certificate': {'key': 'encodedCertificate', 'type': 'str'},
        'certificate_password': {'key': 'certificatePassword', 'type': 'str'},
        'store_name': {'key': 'storeName', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'CertificateInformation'},
    }

    def __init__(
        self,
        *,
        store_name: Union[str, "CertificateConfigurationStoreName"],
        encoded_certificate: Optional[str] = None,
        certificate_password: Optional[str] = None,
        certificate: Optional["CertificateInformation"] = None,
        **kwargs
    ):
        """
        :keyword encoded_certificate: Base64 Encoded certificate.
        :paramtype encoded_certificate: str
        :keyword certificate_password: Certificate Password.
        :paramtype certificate_password: str
        :keyword store_name: Required. The System.Security.Cryptography.x509certificates.StoreName
         certificate store location. Only Root and CertificateAuthority are valid locations. Possible
         values include: "CertificateAuthority", "Root".
        :paramtype store_name: str or ~api_management_client.models.CertificateConfigurationStoreName
        :keyword certificate: Certificate information.
        :paramtype certificate: ~api_management_client.models.CertificateInformation
        """
        super(CertificateConfiguration, self).__init__(**kwargs)
        self.encoded_certificate = encoded_certificate
        self.certificate_password = certificate_password
        self.store_name = store_name
        self.certificate = certificate


class CertificateContract(Resource):
    """Certificate details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar subject: Subject attribute of the certificate.
    :vartype subject: str
    :ivar thumbprint: Thumbprint of the certificate.
    :vartype thumbprint: str
    :ivar expiration_date: Expiration date of the certificate. The date conforms to the following
     format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype expiration_date: ~datetime.datetime
    :ivar key_vault: KeyVault location details of the certificate.
    :vartype key_vault: ~api_management_client.models.KeyVaultContractProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subject': {'key': 'properties.subject', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'KeyVaultContractProperties'},
    }

    def __init__(
        self,
        *,
        subject: Optional[str] = None,
        thumbprint: Optional[str] = None,
        expiration_date: Optional[datetime.datetime] = None,
        key_vault: Optional["KeyVaultContractProperties"] = None,
        **kwargs
    ):
        """
        :keyword subject: Subject attribute of the certificate.
        :paramtype subject: str
        :keyword thumbprint: Thumbprint of the certificate.
        :paramtype thumbprint: str
        :keyword expiration_date: Expiration date of the certificate. The date conforms to the
         following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype expiration_date: ~datetime.datetime
        :keyword key_vault: KeyVault location details of the certificate.
        :paramtype key_vault: ~api_management_client.models.KeyVaultContractProperties
        """
        super(CertificateContract, self).__init__(**kwargs)
        self.subject = subject
        self.thumbprint = thumbprint
        self.expiration_date = expiration_date
        self.key_vault = key_vault


class CertificateCreateOrUpdateParameters(msrest.serialization.Model):
    """Certificate create or update details.

    :ivar data: Base 64 encoded certificate using the application/x-pkcs12 representation.
    :vartype data: str
    :ivar password: Password for the Certificate.
    :vartype password: str
    :ivar key_vault: KeyVault location details of the certificate.
    :vartype key_vault: ~api_management_client.models.KeyVaultContractCreateProperties
    """

    _attribute_map = {
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'KeyVaultContractCreateProperties'},
    }

    def __init__(
        self,
        *,
        data: Optional[str] = None,
        password: Optional[str] = None,
        key_vault: Optional["KeyVaultContractCreateProperties"] = None,
        **kwargs
    ):
        """
        :keyword data: Base 64 encoded certificate using the application/x-pkcs12 representation.
        :paramtype data: str
        :keyword password: Password for the Certificate.
        :paramtype password: str
        :keyword key_vault: KeyVault location details of the certificate.
        :paramtype key_vault: ~api_management_client.models.KeyVaultContractCreateProperties
        """
        super(CertificateCreateOrUpdateParameters, self).__init__(**kwargs)
        self.data = data
        self.password = password
        self.key_vault = key_vault


class CertificateInformation(msrest.serialization.Model):
    """SSL certificate information.

    All required parameters must be populated in order to send to Azure.

    :ivar expiry: Required. Expiration date of the certificate. The date conforms to the following
     format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: Required. Thumbprint of the certificate.
    :vartype thumbprint: str
    :ivar subject: Required. Subject of the certificate.
    :vartype subject: str
    """

    _validation = {
        'expiry': {'required': True},
        'thumbprint': {'required': True},
        'subject': {'required': True},
    }

    _attribute_map = {
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        expiry: datetime.datetime,
        thumbprint: str,
        subject: str,
        **kwargs
    ):
        """
        :keyword expiry: Required. Expiration date of the certificate. The date conforms to the
         following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype expiry: ~datetime.datetime
        :keyword thumbprint: Required. Thumbprint of the certificate.
        :paramtype thumbprint: str
        :keyword subject: Required. Subject of the certificate.
        :paramtype subject: str
        """
        super(CertificateInformation, self).__init__(**kwargs)
        self.expiry = expiry
        self.thumbprint = thumbprint
        self.subject = subject


class ClientSecretContract(msrest.serialization.Model):
    """Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.

    :ivar client_secret: Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
    :vartype client_secret: str
    """

    _attribute_map = {
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_secret: Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
        :paramtype client_secret: str
        """
        super(ClientSecretContract, self).__init__(**kwargs)
        self.client_secret = client_secret


class ConnectivityCheckRequest(msrest.serialization.Model):
    """A request to perform the connectivity check operation on a API Management service.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Required. Definitions about the connectivity check origin.
    :vartype source: ~api_management_client.models.ConnectivityCheckRequestSource
    :ivar destination: Required. The connectivity check operation destination.
    :vartype destination: ~api_management_client.models.ConnectivityCheckRequestDestination
    :ivar preferred_ip_version: The IP version to be used. Only IPv4 is supported for now. Possible
     values include: "IPv4".
    :vartype preferred_ip_version: str or ~api_management_client.models.PreferredIPVersion
    :ivar protocol: The request's protocol. Specific protocol configuration can be available based
     on this selection. The specified destination address must be coherent with this value. Possible
     values include: "TCP", "HTTP", "HTTPS".
    :vartype protocol: str or ~api_management_client.models.ConnectivityCheckProtocol
    :ivar protocol_configuration: Protocol-specific configuration.
    :vartype protocol_configuration:
     ~api_management_client.models.ConnectivityCheckRequestProtocolConfiguration
    """

    _validation = {
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ConnectivityCheckRequestSource'},
        'destination': {'key': 'destination', 'type': 'ConnectivityCheckRequestDestination'},
        'preferred_ip_version': {'key': 'preferredIPVersion', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'protocol_configuration': {'key': 'protocolConfiguration', 'type': 'ConnectivityCheckRequestProtocolConfiguration'},
    }

    def __init__(
        self,
        *,
        source: "ConnectivityCheckRequestSource",
        destination: "ConnectivityCheckRequestDestination",
        preferred_ip_version: Optional[Union[str, "PreferredIPVersion"]] = None,
        protocol: Optional[Union[str, "ConnectivityCheckProtocol"]] = None,
        protocol_configuration: Optional["ConnectivityCheckRequestProtocolConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword source: Required. Definitions about the connectivity check origin.
        :paramtype source: ~api_management_client.models.ConnectivityCheckRequestSource
        :keyword destination: Required. The connectivity check operation destination.
        :paramtype destination: ~api_management_client.models.ConnectivityCheckRequestDestination
        :keyword preferred_ip_version: The IP version to be used. Only IPv4 is supported for now.
         Possible values include: "IPv4".
        :paramtype preferred_ip_version: str or ~api_management_client.models.PreferredIPVersion
        :keyword protocol: The request's protocol. Specific protocol configuration can be available
         based on this selection. The specified destination address must be coherent with this value.
         Possible values include: "TCP", "HTTP", "HTTPS".
        :paramtype protocol: str or ~api_management_client.models.ConnectivityCheckProtocol
        :keyword protocol_configuration: Protocol-specific configuration.
        :paramtype protocol_configuration:
         ~api_management_client.models.ConnectivityCheckRequestProtocolConfiguration
        """
        super(ConnectivityCheckRequest, self).__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.preferred_ip_version = preferred_ip_version
        self.protocol = protocol
        self.protocol_configuration = protocol_configuration


class ConnectivityCheckRequestDestination(msrest.serialization.Model):
    """The connectivity check operation destination.

    All required parameters must be populated in order to send to Azure.

    :ivar address: Required. Destination address. Can either be an IP address or a FQDN.
    :vartype address: str
    :ivar port: Required. Destination port.
    :vartype port: long
    """

    _validation = {
        'address': {'required': True},
        'port': {'required': True},
    }

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
        'port': {'key': 'port', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        address: str,
        port: int,
        **kwargs
    ):
        """
        :keyword address: Required. Destination address. Can either be an IP address or a FQDN.
        :paramtype address: str
        :keyword port: Required. Destination port.
        :paramtype port: long
        """
        super(ConnectivityCheckRequestDestination, self).__init__(**kwargs)
        self.address = address
        self.port = port


class ConnectivityCheckRequestProtocolConfiguration(msrest.serialization.Model):
    """Protocol-specific configuration.

    :ivar http_configuration: Configuration for HTTP or HTTPS requests.
    :vartype http_configuration:
     ~api_management_client.models.ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration
    """

    _attribute_map = {
        'http_configuration': {'key': 'HTTPConfiguration', 'type': 'ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration'},
    }

    def __init__(
        self,
        *,
        http_configuration: Optional["ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword http_configuration: Configuration for HTTP or HTTPS requests.
        :paramtype http_configuration:
         ~api_management_client.models.ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration
        """
        super(ConnectivityCheckRequestProtocolConfiguration, self).__init__(**kwargs)
        self.http_configuration = http_configuration


class ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration(msrest.serialization.Model):
    """Configuration for HTTP or HTTPS requests.

    :ivar method: The HTTP method to be used. Possible values include: "GET", "POST".
    :vartype method: str or ~api_management_client.models.Method
    :ivar valid_status_codes: List of HTTP status codes considered valid for the request response.
    :vartype valid_status_codes: list[long]
    :ivar headers: List of headers to be included in the request.
    :vartype headers: list[~api_management_client.models.HTTPHeader]
    """

    _attribute_map = {
        'method': {'key': 'method', 'type': 'str'},
        'valid_status_codes': {'key': 'validStatusCodes', 'type': '[long]'},
        'headers': {'key': 'headers', 'type': '[HTTPHeader]'},
    }

    def __init__(
        self,
        *,
        method: Optional[Union[str, "Method"]] = None,
        valid_status_codes: Optional[List[int]] = None,
        headers: Optional[List["HTTPHeader"]] = None,
        **kwargs
    ):
        """
        :keyword method: The HTTP method to be used. Possible values include: "GET", "POST".
        :paramtype method: str or ~api_management_client.models.Method
        :keyword valid_status_codes: List of HTTP status codes considered valid for the request
         response.
        :paramtype valid_status_codes: list[long]
        :keyword headers: List of headers to be included in the request.
        :paramtype headers: list[~api_management_client.models.HTTPHeader]
        """
        super(ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration, self).__init__(**kwargs)
        self.method = method
        self.valid_status_codes = valid_status_codes
        self.headers = headers


class ConnectivityCheckRequestSource(msrest.serialization.Model):
    """Definitions about the connectivity check origin.

    All required parameters must be populated in order to send to Azure.

    :ivar region: Required. The API Management service region from where to start the connectivity
     check operation.
    :vartype region: str
    :ivar instance: The particular VMSS instance from which to fire the request.
    :vartype instance: long
    """

    _validation = {
        'region': {'required': True},
    }

    _attribute_map = {
        'region': {'key': 'region', 'type': 'str'},
        'instance': {'key': 'instance', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        region: str,
        instance: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword region: Required. The API Management service region from where to start the
         connectivity check operation.
        :paramtype region: str
        :keyword instance: The particular VMSS instance from which to fire the request.
        :paramtype instance: long
        """
        super(ConnectivityCheckRequestSource, self).__init__(**kwargs)
        self.region = region
        self.instance = instance


class ConnectivityCheckResponse(msrest.serialization.Model):
    """Information on the connectivity status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~api_management_client.models.ConnectivityHop]
    :ivar connection_status: The connection status. Possible values include: "Unknown",
     "Connected", "Disconnected", "Degraded".
    :vartype connection_status: str or ~api_management_client.models.ConnectionStatus
    :ivar avg_latency_in_ms: Average latency in milliseconds.
    :vartype avg_latency_in_ms: long
    :ivar min_latency_in_ms: Minimum latency in milliseconds.
    :vartype min_latency_in_ms: long
    :ivar max_latency_in_ms: Maximum latency in milliseconds.
    :vartype max_latency_in_ms: long
    :ivar probes_sent: Total number of probes sent.
    :vartype probes_sent: long
    :ivar probes_failed: Number of failed probes.
    :vartype probes_failed: long
    """

    _validation = {
        'hops': {'readonly': True},
        'connection_status': {'readonly': True},
        'avg_latency_in_ms': {'readonly': True},
        'min_latency_in_ms': {'readonly': True},
        'max_latency_in_ms': {'readonly': True},
        'probes_sent': {'readonly': True},
        'probes_failed': {'readonly': True},
    }

    _attribute_map = {
        'hops': {'key': 'hops', 'type': '[ConnectivityHop]'},
        'connection_status': {'key': 'connectionStatus', 'type': 'str'},
        'avg_latency_in_ms': {'key': 'avgLatencyInMs', 'type': 'long'},
        'min_latency_in_ms': {'key': 'minLatencyInMs', 'type': 'long'},
        'max_latency_in_ms': {'key': 'maxLatencyInMs', 'type': 'long'},
        'probes_sent': {'key': 'probesSent', 'type': 'long'},
        'probes_failed': {'key': 'probesFailed', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ConnectivityCheckResponse, self).__init__(**kwargs)
        self.hops = None
        self.connection_status = None
        self.avg_latency_in_ms = None
        self.min_latency_in_ms = None
        self.max_latency_in_ms = None
        self.probes_sent = None
        self.probes_failed = None


class ConnectivityHop(msrest.serialization.Model):
    """Information about a hop between the source and the destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the hop.
    :vartype type: str
    :ivar id: The ID of the hop.
    :vartype id: str
    :ivar address: The IP address of the hop.
    :vartype address: str
    :ivar resource_id: The ID of the resource corresponding to this hop.
    :vartype resource_id: str
    :ivar next_hop_ids: List of next hop identifiers.
    :vartype next_hop_ids: list[str]
    :ivar issues: List of issues.
    :vartype issues: list[~api_management_client.models.ConnectivityIssue]
    """

    _validation = {
        'type': {'readonly': True},
        'id': {'readonly': True},
        'address': {'readonly': True},
        'resource_id': {'readonly': True},
        'next_hop_ids': {'readonly': True},
        'issues': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'next_hop_ids': {'key': 'nextHopIds', 'type': '[str]'},
        'issues': {'key': 'issues', 'type': '[ConnectivityIssue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ConnectivityHop, self).__init__(**kwargs)
        self.type = None
        self.id = None
        self.address = None
        self.resource_id = None
        self.next_hop_ids = None
        self.issues = None


class ConnectivityIssue(msrest.serialization.Model):
    """Information about an issue encountered in the process of checking for connectivity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the issue. Possible values include: "Local", "Inbound", "Outbound".
    :vartype origin: str or ~api_management_client.models.Origin
    :ivar severity: The severity of the issue. Possible values include: "Error", "Warning".
    :vartype severity: str or ~api_management_client.models.Severity
    :ivar type: The type of issue. Possible values include: "Unknown", "AgentStopped",
     "GuestFirewall", "DnsResolution", "SocketBind", "NetworkSecurityRule", "UserDefinedRoute",
     "PortThrottled", "Platform".
    :vartype type: str or ~api_management_client.models.IssueType
    :ivar context: Provides additional context on the issue.
    :vartype context: list[dict[str, str]]
    """

    _validation = {
        'origin': {'readonly': True},
        'severity': {'readonly': True},
        'type': {'readonly': True},
        'context': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'context': {'key': 'context', 'type': '[{str}]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ConnectivityIssue, self).__init__(**kwargs)
        self.origin = None
        self.severity = None
        self.type = None
        self.context = None


class ConnectivityStatusContract(msrest.serialization.Model):
    """Details about connectivity to a resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The hostname of the resource which the service depends on. This can be
     the database, storage or any other azure resource on which the service depends upon.
    :vartype name: str
    :ivar status: Required. Resource Connectivity Status Type identifier. Possible values include:
     "initializing", "success", "failure".
    :vartype status: str or ~api_management_client.models.ConnectivityStatusType
    :ivar error: Error details of the connectivity to the resource.
    :vartype error: str
    :ivar last_updated: Required. The date when the resource connectivity status was last updated.
     This status should be updated every 15 minutes. If this status has not been updated, then it
     means that the service has lost network connectivity to the resource, from inside the Virtual
     Network.The date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the
     ISO 8601 standard.
    :vartype last_updated: ~datetime.datetime
    :ivar last_status_change: Required. The date when the resource connectivity status last Changed
     from success to failure or vice-versa. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype last_status_change: ~datetime.datetime
    :ivar resource_type: Required. Resource Type.
    :vartype resource_type: str
    :ivar is_optional: Required. Whether this is optional.
    :vartype is_optional: bool
    """

    _validation = {
        'name': {'required': True, 'min_length': 1},
        'status': {'required': True},
        'last_updated': {'required': True},
        'last_status_change': {'required': True},
        'resource_type': {'required': True},
        'is_optional': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'str'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'last_status_change': {'key': 'lastStatusChange', 'type': 'iso-8601'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'is_optional': {'key': 'isOptional', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        status: Union[str, "ConnectivityStatusType"],
        last_updated: datetime.datetime,
        last_status_change: datetime.datetime,
        resource_type: str,
        is_optional: bool,
        error: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The hostname of the resource which the service depends on. This can be
         the database, storage or any other azure resource on which the service depends upon.
        :paramtype name: str
        :keyword status: Required. Resource Connectivity Status Type identifier. Possible values
         include: "initializing", "success", "failure".
        :paramtype status: str or ~api_management_client.models.ConnectivityStatusType
        :keyword error: Error details of the connectivity to the resource.
        :paramtype error: str
        :keyword last_updated: Required. The date when the resource connectivity status was last
         updated. This status should be updated every 15 minutes. If this status has not been updated,
         then it means that the service has lost network connectivity to the resource, from inside the
         Virtual Network.The date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as
         specified by the ISO 8601 standard.
        :paramtype last_updated: ~datetime.datetime
        :keyword last_status_change: Required. The date when the resource connectivity status last
         Changed from success to failure or vice-versa. The date conforms to the following format:
         ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype last_status_change: ~datetime.datetime
        :keyword resource_type: Required. Resource Type.
        :paramtype resource_type: str
        :keyword is_optional: Required. Whether this is optional.
        :paramtype is_optional: bool
        """
        super(ConnectivityStatusContract, self).__init__(**kwargs)
        self.name = name
        self.status = status
        self.error = error
        self.last_updated = last_updated
        self.last_status_change = last_status_change
        self.resource_type = resource_type
        self.is_optional = is_optional


class ContentItemCollection(msrest.serialization.Model):
    """Paged list of content items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of content items.
    :vartype value: list[~api_management_client.models.ContentItemContract]
    :ivar next_link: Next page link, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContentItemContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ContentItemCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ContentItemContract(Resource):
    """Content type contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties: Properties of the content item.
    :vartype properties: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of the content item.
        :paramtype properties: dict[str, any]
        """
        super(ContentItemContract, self).__init__(**kwargs)
        self.properties = properties


class ContentTypeCollection(msrest.serialization.Model):
    """Paged list of content types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of content types.
    :vartype value: list[~api_management_client.models.ContentTypeContract]
    :ivar next_link: Next page link, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContentTypeContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ContentTypeCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ContentTypeContract(Resource):
    """Content type contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar id_properties_id: Content type identifier.
    :vartype id_properties_id: str
    :ivar name_properties_name: Content type name. Must be 1 to 250 characters long.
    :vartype name_properties_name: str
    :ivar description: Content type description.
    :vartype description: str
    :ivar schema: Content type schema.
    :vartype schema: any
    :ivar version: Content type version.
    :vartype version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'schema': {'key': 'properties.schema', 'type': 'object'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id_properties_id: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        description: Optional[str] = None,
        schema: Optional[Any] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id_properties_id: Content type identifier.
        :paramtype id_properties_id: str
        :keyword name_properties_name: Content type name. Must be 1 to 250 characters long.
        :paramtype name_properties_name: str
        :keyword description: Content type description.
        :paramtype description: str
        :keyword schema: Content type schema.
        :paramtype schema: any
        :keyword version: Content type version.
        :paramtype version: str
        """
        super(ContentTypeContract, self).__init__(**kwargs)
        self.id_properties_id = id_properties_id
        self.name_properties_name = name_properties_name
        self.description = description
        self.schema = schema
        self.version = version


class DataMasking(msrest.serialization.Model):
    """DataMasking.

    :ivar query_params: Masking settings for Url query parameters.
    :vartype query_params: list[~api_management_client.models.DataMaskingEntity]
    :ivar headers: Masking settings for headers.
    :vartype headers: list[~api_management_client.models.DataMaskingEntity]
    """

    _attribute_map = {
        'query_params': {'key': 'queryParams', 'type': '[DataMaskingEntity]'},
        'headers': {'key': 'headers', 'type': '[DataMaskingEntity]'},
    }

    def __init__(
        self,
        *,
        query_params: Optional[List["DataMaskingEntity"]] = None,
        headers: Optional[List["DataMaskingEntity"]] = None,
        **kwargs
    ):
        """
        :keyword query_params: Masking settings for Url query parameters.
        :paramtype query_params: list[~api_management_client.models.DataMaskingEntity]
        :keyword headers: Masking settings for headers.
        :paramtype headers: list[~api_management_client.models.DataMaskingEntity]
        """
        super(DataMasking, self).__init__(**kwargs)
        self.query_params = query_params
        self.headers = headers


class DataMaskingEntity(msrest.serialization.Model):
    """DataMaskingEntity.

    :ivar value: The name of an entity to mask (e.g. a name of a header or a query parameter).
    :vartype value: str
    :ivar mode: Data masking mode. Possible values include: "Mask", "Hide".
    :vartype mode: str or ~api_management_client.models.DataMaskingMode
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        mode: Optional[Union[str, "DataMaskingMode"]] = None,
        **kwargs
    ):
        """
        :keyword value: The name of an entity to mask (e.g. a name of a header or a query parameter).
        :paramtype value: str
        :keyword mode: Data masking mode. Possible values include: "Mask", "Hide".
        :paramtype mode: str or ~api_management_client.models.DataMaskingMode
        """
        super(DataMaskingEntity, self).__init__(**kwargs)
        self.value = value
        self.mode = mode


class DeletedServiceContract(Resource):
    """Deleted API Management Service information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: API Management Service Master Location.
    :vartype location: str
    :ivar service_id: Fully-qualified API Management Service Resource ID.
    :vartype service_id: str
    :ivar scheduled_purge_date: UTC Date and Time when the service will be automatically purged.
     The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
     standard.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deletion_date: UTC Timestamp when the service was soft-deleted. The date conforms to the
     following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype deletion_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'service_id': {'key': 'properties.serviceId', 'type': 'str'},
        'scheduled_purge_date': {'key': 'properties.scheduledPurgeDate', 'type': 'iso-8601'},
        'deletion_date': {'key': 'properties.deletionDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        service_id: Optional[str] = None,
        scheduled_purge_date: Optional[datetime.datetime] = None,
        deletion_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword service_id: Fully-qualified API Management Service Resource ID.
        :paramtype service_id: str
        :keyword scheduled_purge_date: UTC Date and Time when the service will be automatically purged.
         The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
         standard.
        :paramtype scheduled_purge_date: ~datetime.datetime
        :keyword deletion_date: UTC Timestamp when the service was soft-deleted. The date conforms to
         the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
        :paramtype deletion_date: ~datetime.datetime
        """
        super(DeletedServiceContract, self).__init__(**kwargs)
        self.location = None
        self.service_id = service_id
        self.scheduled_purge_date = scheduled_purge_date
        self.deletion_date = deletion_date


class DeletedServicesCollection(msrest.serialization.Model):
    """Paged deleted API Management Services List Representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.DeletedServiceContract]
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeletedServiceContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DeletedServicesCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DeployConfigurationParameters(msrest.serialization.Model):
    """Deploy Tenant Configuration Contract.

    :ivar branch: The name of the Git branch from which the configuration is to be deployed to the
     configuration database.
    :vartype branch: str
    :ivar force: The value enforcing deleting subscriptions to products that are deleted in this
     update.
    :vartype force: bool
    """

    _attribute_map = {
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'force': {'key': 'properties.force', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        force: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword branch: The name of the Git branch from which the configuration is to be deployed to
         the configuration database.
        :paramtype branch: str
        :keyword force: The value enforcing deleting subscriptions to products that are deleted in this
         update.
        :paramtype force: bool
        """
        super(DeployConfigurationParameters, self).__init__(**kwargs)
        self.branch = branch
        self.force = force


class DiagnosticCollection(msrest.serialization.Model):
    """Paged Diagnostic list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.DiagnosticContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiagnosticContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DiagnosticContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.DiagnosticContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(DiagnosticCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class DiagnosticContract(Resource):
    """Diagnostic details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar always_log: Specifies for what type of messages sampling settings should not apply.
     Possible values include: "allErrors".
    :vartype always_log: str or ~api_management_client.models.AlwaysLog
    :ivar logger_id: Resource Id of a target logger.
    :vartype logger_id: str
    :ivar sampling: Sampling settings for Diagnostic.
    :vartype sampling: ~api_management_client.models.SamplingSettings
    :ivar frontend: Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
    :vartype frontend: ~api_management_client.models.PipelineDiagnosticSettings
    :ivar backend: Diagnostic settings for incoming/outgoing HTTP messages to the Backend.
    :vartype backend: ~api_management_client.models.PipelineDiagnosticSettings
    :ivar log_client_ip: Log the ClientIP. Default is false.
    :vartype log_client_ip: bool
    :ivar http_correlation_protocol: Sets correlation protocol to use for Application Insights
     diagnostics. Possible values include: "None", "Legacy", "W3C".
    :vartype http_correlation_protocol: str or
     ~api_management_client.models.HttpCorrelationProtocol
    :ivar verbosity: The verbosity level applied to traces emitted by trace policies. Possible
     values include: "verbose", "information", "error".
    :vartype verbosity: str or ~api_management_client.models.Verbosity
    :ivar operation_name_format: The format of the Operation Name for Application Insights
     telemetries. Default is Name. Possible values include: "Name", "Url".
    :vartype operation_name_format: str or ~api_management_client.models.OperationNameFormat
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'always_log': {'key': 'properties.alwaysLog', 'type': 'str'},
        'logger_id': {'key': 'properties.loggerId', 'type': 'str'},
        'sampling': {'key': 'properties.sampling', 'type': 'SamplingSettings'},
        'frontend': {'key': 'properties.frontend', 'type': 'PipelineDiagnosticSettings'},
        'backend': {'key': 'properties.backend', 'type': 'PipelineDiagnosticSettings'},
        'log_client_ip': {'key': 'properties.logClientIp', 'type': 'bool'},
        'http_correlation_protocol': {'key': 'properties.httpCorrelationProtocol', 'type': 'str'},
        'verbosity': {'key': 'properties.verbosity', 'type': 'str'},
        'operation_name_format': {'key': 'properties.operationNameFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        always_log: Optional[Union[str, "AlwaysLog"]] = None,
        logger_id: Optional[str] = None,
        sampling: Optional["SamplingSettings"] = None,
        frontend: Optional["PipelineDiagnosticSettings"] = None,
        backend: Optional["PipelineDiagnosticSettings"] = None,
        log_client_ip: Optional[bool] = None,
        http_correlation_protocol: Optional[Union[str, "HttpCorrelationProtocol"]] = None,
        verbosity: Optional[Union[str, "Verbosity"]] = None,
        operation_name_format: Optional[Union[str, "OperationNameFormat"]] = None,
        **kwargs
    ):
        """
        :keyword always_log: Specifies for what type of messages sampling settings should not apply.
         Possible values include: "allErrors".
        :paramtype always_log: str or ~api_management_client.models.AlwaysLog
        :keyword logger_id: Resource Id of a target logger.
        :paramtype logger_id: str
        :keyword sampling: Sampling settings for Diagnostic.
        :paramtype sampling: ~api_management_client.models.SamplingSettings
        :keyword frontend: Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
        :paramtype frontend: ~api_management_client.models.PipelineDiagnosticSettings
        :keyword backend: Diagnostic settings for incoming/outgoing HTTP messages to the Backend.
        :paramtype backend: ~api_management_client.models.PipelineDiagnosticSettings
        :keyword log_client_ip: Log the ClientIP. Default is false.
        :paramtype log_client_ip: bool
        :keyword http_correlation_protocol: Sets correlation protocol to use for Application Insights
         diagnostics. Possible values include: "None", "Legacy", "W3C".
        :paramtype http_correlation_protocol: str or
         ~api_management_client.models.HttpCorrelationProtocol
        :keyword verbosity: The verbosity level applied to traces emitted by trace policies. Possible
         values include: "verbose", "information", "error".
        :paramtype verbosity: str or ~api_management_client.models.Verbosity
        :keyword operation_name_format: The format of the Operation Name for Application Insights
         telemetries. Default is Name. Possible values include: "Name", "Url".
        :paramtype operation_name_format: str or ~api_management_client.models.OperationNameFormat
        """
        super(DiagnosticContract, self).__init__(**kwargs)
        self.always_log = always_log
        self.logger_id = logger_id
        self.sampling = sampling
        self.frontend = frontend
        self.backend = backend
        self.log_client_ip = log_client_ip
        self.http_correlation_protocol = http_correlation_protocol
        self.verbosity = verbosity
        self.operation_name_format = operation_name_format


class EmailTemplateCollection(msrest.serialization.Model):
    """Paged email template list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.EmailTemplateContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EmailTemplateContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EmailTemplateContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.EmailTemplateContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(EmailTemplateCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class EmailTemplateContract(Resource):
    """Email Template details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar subject: Subject of the Template.
    :vartype subject: str
    :ivar body: Email Template Body. This should be a valid XDocument.
    :vartype body: str
    :ivar title: Title of the Template.
    :vartype title: str
    :ivar description: Description of the Email Template.
    :vartype description: str
    :ivar is_default: Whether the template is the default template provided by API Management or
     has been edited.
    :vartype is_default: bool
    :ivar parameters: Email Template Parameter values.
    :vartype parameters:
     list[~api_management_client.models.EmailTemplateParametersContractProperties]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'subject': {'max_length': 1000, 'min_length': 1},
        'body': {'min_length': 1},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subject': {'key': 'properties.subject', 'type': 'str'},
        'body': {'key': 'properties.body', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_default': {'key': 'properties.isDefault', 'type': 'bool'},
        'parameters': {'key': 'properties.parameters', 'type': '[EmailTemplateParametersContractProperties]'},
    }

    def __init__(
        self,
        *,
        subject: Optional[str] = None,
        body: Optional[str] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        parameters: Optional[List["EmailTemplateParametersContractProperties"]] = None,
        **kwargs
    ):
        """
        :keyword subject: Subject of the Template.
        :paramtype subject: str
        :keyword body: Email Template Body. This should be a valid XDocument.
        :paramtype body: str
        :keyword title: Title of the Template.
        :paramtype title: str
        :keyword description: Description of the Email Template.
        :paramtype description: str
        :keyword parameters: Email Template Parameter values.
        :paramtype parameters:
         list[~api_management_client.models.EmailTemplateParametersContractProperties]
        """
        super(EmailTemplateContract, self).__init__(**kwargs)
        self.subject = subject
        self.body = body
        self.title = title
        self.description = description
        self.is_default = None
        self.parameters = parameters


class EmailTemplateParametersContractProperties(msrest.serialization.Model):
    """Email Template Parameter contract.

    :ivar name: Template parameter name.
    :vartype name: str
    :ivar title: Template parameter title.
    :vartype title: str
    :ivar description: Template parameter description.
    :vartype description: str
    """

    _validation = {
        'name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'title': {'max_length': 4096, 'min_length': 1},
        'description': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Template parameter name.
        :paramtype name: str
        :keyword title: Template parameter title.
        :paramtype title: str
        :keyword description: Template parameter description.
        :paramtype description: str
        """
        super(EmailTemplateParametersContractProperties, self).__init__(**kwargs)
        self.name = name
        self.title = title
        self.description = description


class EmailTemplateUpdateParameters(msrest.serialization.Model):
    """Email Template update Parameters.

    :ivar subject: Subject of the Template.
    :vartype subject: str
    :ivar title: Title of the Template.
    :vartype title: str
    :ivar description: Description of the Email Template.
    :vartype description: str
    :ivar body: Email Template Body. This should be a valid XDocument.
    :vartype body: str
    :ivar parameters: Email Template Parameter values.
    :vartype parameters:
     list[~api_management_client.models.EmailTemplateParametersContractProperties]
    """

    _validation = {
        'subject': {'max_length': 1000, 'min_length': 1},
        'body': {'min_length': 1},
    }

    _attribute_map = {
        'subject': {'key': 'properties.subject', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'body': {'key': 'properties.body', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '[EmailTemplateParametersContractProperties]'},
    }

    def __init__(
        self,
        *,
        subject: Optional[str] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        body: Optional[str] = None,
        parameters: Optional[List["EmailTemplateParametersContractProperties"]] = None,
        **kwargs
    ):
        """
        :keyword subject: Subject of the Template.
        :paramtype subject: str
        :keyword title: Title of the Template.
        :paramtype title: str
        :keyword description: Description of the Email Template.
        :paramtype description: str
        :keyword body: Email Template Body. This should be a valid XDocument.
        :paramtype body: str
        :keyword parameters: Email Template Parameter values.
        :paramtype parameters:
         list[~api_management_client.models.EmailTemplateParametersContractProperties]
        """
        super(EmailTemplateUpdateParameters, self).__init__(**kwargs)
        self.subject = subject
        self.title = title
        self.description = description
        self.body = body
        self.parameters = parameters


class EndpointDependency(msrest.serialization.Model):
    """A domain name that a service is reached at.

    :ivar domain_name: The domain name of the dependency.
    :vartype domain_name: str
    :ivar endpoint_details: The Ports used when connecting to DomainName.
    :vartype endpoint_details: list[~api_management_client.models.EndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[EndpointDetail]'},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["EndpointDetail"]] = None,
        **kwargs
    ):
        """
        :keyword domain_name: The domain name of the dependency.
        :paramtype domain_name: str
        :keyword endpoint_details: The Ports used when connecting to DomainName.
        :paramtype endpoint_details: list[~api_management_client.models.EndpointDetail]
        """
        super(EndpointDependency, self).__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class EndpointDetail(msrest.serialization.Model):
    """Current TCP connectivity information from the Api Management Service to a single endpoint.

    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    :ivar region: The region of the dependency.
    :vartype region: str
    """

    _attribute_map = {
        'port': {'key': 'port', 'type': 'int'},
        'region': {'key': 'region', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        port: Optional[int] = None,
        region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword port: The port an endpoint is connected to.
        :paramtype port: int
        :keyword region: The region of the dependency.
        :paramtype region: str
        """
        super(EndpointDetail, self).__init__(**kwargs)
        self.port = port
        self.region = region


class ErrorFieldContract(msrest.serialization.Model):
    """Error Field contract.

    :ivar code: Property level error code.
    :vartype code: str
    :ivar message: Human-readable representation of property-level error.
    :vartype message: str
    :ivar target: Property name.
    :vartype target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Property level error code.
        :paramtype code: str
        :keyword message: Human-readable representation of property-level error.
        :paramtype message: str
        :keyword target: Property name.
        :paramtype target: str
        """
        super(ErrorFieldContract, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class ErrorResponse(msrest.serialization.Model):
    """Error Response.

    :ivar code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :vartype code: str
    :ivar message: Human-readable representation of the error.
    :vartype message: str
    :ivar details: The list of invalid fields send in request, in case of validation error.
    :vartype details: list[~api_management_client.models.ErrorFieldContract]
    """

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
        'details': {'key': 'error.details', 'type': '[ErrorFieldContract]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["ErrorFieldContract"]] = None,
        **kwargs
    ):
        """
        :keyword code: Service-defined error code. This code serves as a sub-status for the HTTP error
         code specified in the response.
        :paramtype code: str
        :keyword message: Human-readable representation of the error.
        :paramtype message: str
        :keyword details: The list of invalid fields send in request, in case of validation error.
        :paramtype details: list[~api_management_client.models.ErrorFieldContract]
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class ErrorResponseBody(msrest.serialization.Model):
    """Error Body contract.

    :ivar code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :vartype code: str
    :ivar message: Human-readable representation of the error.
    :vartype message: str
    :ivar details: The list of invalid fields send in request, in case of validation error.
    :vartype details: list[~api_management_client.models.ErrorFieldContract]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorFieldContract]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["ErrorFieldContract"]] = None,
        **kwargs
    ):
        """
        :keyword code: Service-defined error code. This code serves as a sub-status for the HTTP error
         code specified in the response.
        :paramtype code: str
        :keyword message: Human-readable representation of the error.
        :paramtype message: str
        :keyword details: The list of invalid fields send in request, in case of validation error.
        :paramtype details: list[~api_management_client.models.ErrorFieldContract]
        """
        super(ErrorResponseBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class GatewayCertificateAuthorityCollection(msrest.serialization.Model):
    """Paged Gateway certificate authority list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.GatewayCertificateAuthorityContract]
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GatewayCertificateAuthorityContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GatewayCertificateAuthorityCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GatewayCertificateAuthorityContract(Resource):
    """Gateway certificate authority details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar is_trusted: Determines whether certificate authority is trusted.
    :vartype is_trusted: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_trusted': {'key': 'properties.isTrusted', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_trusted: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword is_trusted: Determines whether certificate authority is trusted.
        :paramtype is_trusted: bool
        """
        super(GatewayCertificateAuthorityContract, self).__init__(**kwargs)
        self.is_trusted = is_trusted


class GatewayCollection(msrest.serialization.Model):
    """Paged Gateway list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.GatewayContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GatewayContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        """
        super(GatewayCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class GatewayContract(Resource):
    """Gateway details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location_data: Gateway location.
    :vartype location_data: ~api_management_client.models.ResourceLocationDataContract
    :ivar description: Gateway description.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location_data': {'key': 'properties.locationData', 'type': 'ResourceLocationDataContract'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location_data: Optional["ResourceLocationDataContract"] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location_data: Gateway location.
        :paramtype location_data: ~api_management_client.models.ResourceLocationDataContract
        :keyword description: Gateway description.
        :paramtype description: str
        """
        super(GatewayContract, self).__init__(**kwargs)
        self.location_data = location_data
        self.description = description


class GatewayHostnameConfigurationCollection(msrest.serialization.Model):
    """Paged Gateway hostname configuration list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.GatewayHostnameConfigurationContract]
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GatewayHostnameConfigurationContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GatewayHostnameConfigurationCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GatewayHostnameConfigurationContract(Resource):
    """Gateway hostname configuration details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar hostname: Hostname value. Supports valid domain name, partial or full wildcard.
    :vartype hostname: str
    :ivar certificate_id: Identifier of Certificate entity that will be used for TLS connection
     establishment.
    :vartype certificate_id: str
    :ivar negotiate_client_certificate: Determines whether gateway requests client certificate.
    :vartype negotiate_client_certificate: bool
    :ivar tls10_enabled: Specifies if TLS 1.0 is supported.
    :vartype tls10_enabled: bool
    :ivar tls11_enabled: Specifies if TLS 1.1 is supported.
    :vartype tls11_enabled: bool
    :ivar http2_enabled: Specifies if HTTP/2.0 is supported.
    :vartype http2_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'certificate_id': {'key': 'properties.certificateId', 'type': 'str'},
        'negotiate_client_certificate': {'key': 'properties.negotiateClientCertificate', 'type': 'bool'},
        'tls10_enabled': {'key': 'properties.tls10Enabled', 'type': 'bool'},
        'tls11_enabled': {'key': 'properties.tls11Enabled', 'type': 'bool'},
        'http2_enabled': {'key': 'properties.http2Enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        hostname: Optional[str] = None,
        certificate_id: Optional[str] = None,
        negotiate_client_certificate: Optional[bool] = None,
        tls10_enabled: Optional[bool] = None,
        tls11_enabled: Optional[bool] = None,
        http2_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword hostname: Hostname value. Supports valid domain name, partial or full wildcard.
        :paramtype hostname: str
        :keyword certificate_id: Identifier of Certificate entity that will be used for TLS connection
         establishment.
        :paramtype certificate_id: str
        :keyword negotiate_client_certificate: Determines whether gateway requests client certificate.
        :paramtype negotiate_client_certificate: bool
        :keyword tls10_enabled: Specifies if TLS 1.0 is supported.
        :paramtype tls10_enabled: bool
        :keyword tls11_enabled: Specifies if TLS 1.1 is supported.
        :paramtype tls11_enabled: bool
        :keyword http2_enabled: Specifies if HTTP/2.0 is supported.
        :paramtype http2_enabled: bool
        """
        super(GatewayHostnameConfigurationContract, self).__init__(**kwargs)
        self.hostname = hostname
        self.certificate_id = certificate_id
        self.negotiate_client_certificate = negotiate_client_certificate
        self.tls10_enabled = tls10_enabled
        self.tls11_enabled = tls11_enabled
        self.http2_enabled = http2_enabled


class GatewayKeyRegenerationRequestContract(msrest.serialization.Model):
    """Gateway key regeneration request contract properties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_type: Required. The Key being regenerated. Possible values include: "primary",
     "secondary".
    :vartype key_type: str or ~api_management_client.models.KeyType
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_type: Union[str, "KeyType"],
        **kwargs
    ):
        """
        :keyword key_type: Required. The Key being regenerated. Possible values include: "primary",
         "secondary".
        :paramtype key_type: str or ~api_management_client.models.KeyType
        """
        super(GatewayKeyRegenerationRequestContract, self).__init__(**kwargs)
        self.key_type = key_type


class GatewayKeysContract(msrest.serialization.Model):
    """Gateway authentication keys.

    :ivar primary: Primary gateway key.
    :vartype primary: str
    :ivar secondary: Secondary gateway key.
    :vartype secondary: str
    """

    _attribute_map = {
        'primary': {'key': 'primary', 'type': 'str'},
        'secondary': {'key': 'secondary', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary: Optional[str] = None,
        secondary: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword primary: Primary gateway key.
        :paramtype primary: str
        :keyword secondary: Secondary gateway key.
        :paramtype secondary: str
        """
        super(GatewayKeysContract, self).__init__(**kwargs)
        self.primary = primary
        self.secondary = secondary


class GatewayTokenContract(msrest.serialization.Model):
    """Gateway access token.

    :ivar value: Shared Access Authentication token value for the Gateway.
    :vartype value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Shared Access Authentication token value for the Gateway.
        :paramtype value: str
        """
        super(GatewayTokenContract, self).__init__(**kwargs)
        self.value = value


class GatewayTokenRequestContract(msrest.serialization.Model):
    """Gateway token request contract properties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_type: Required. The Key to be used to generate gateway token. Possible values
     include: "primary", "secondary".
    :vartype key_type: str or ~api_management_client.models.KeyType
    :ivar expiry: Required. The Expiry time of the Token. Maximum token expiry time is set to 30
     days. The date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the
     ISO 8601 standard.
    :vartype expiry: ~datetime.datetime
    """

    _validation = {
        'key_type': {'required': True},
        'expiry': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        key_type: Union[str, "KeyType"],
        expiry: datetime.datetime,
        **kwargs
    ):
        """
        :keyword key_type: Required. The Key to be used to generate gateway token. Possible values
         include: "primary", "secondary".
        :paramtype key_type: str or ~api_management_client.models.KeyType
        :keyword expiry: Required. The Expiry time of the Token. Maximum token expiry time is set to 30
         days. The date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the
         ISO 8601 standard.
        :paramtype expiry: ~datetime.datetime
        """
        super(GatewayTokenRequestContract, self).__init__(**kwargs)
        self.key_type = key_type
        self.expiry = expiry


class GenerateSsoUrlResult(msrest.serialization.Model):
    """Generate SSO Url operations response details.

    :ivar value: Redirect Url containing the SSO URL value.
    :vartype value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Redirect Url containing the SSO URL value.
        :paramtype value: str
        """
        super(GenerateSsoUrlResult, self).__init__(**kwargs)
        self.value = value


class GlobalSchemaCollection(msrest.serialization.Model):
    """The response of the list schema operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Global Schema Contract value.
    :vartype value: list[~api_management_client.models.GlobalSchemaContract]
    :ivar count: Total record count number.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GlobalSchemaContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number.
        :paramtype count: long
        """
        super(GlobalSchemaCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class GlobalSchemaContract(Resource):
    """Global Schema Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar schema_type: Schema Type. Immutable. Possible values include: "xml", "json".
    :vartype schema_type: str or ~api_management_client.models.SchemaType
    :ivar description: Free-form schema entity description.
    :vartype description: str
    :ivar value: Json-encoded string for non json-based schema.
    :vartype value: any
    :ivar document: Global Schema document object for json-based schema formats(e.g. json schema).
    :vartype document: any
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'schema_type': {'key': 'properties.schemaType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'object'},
        'document': {'key': 'properties.document', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        schema_type: Optional[Union[str, "SchemaType"]] = None,
        description: Optional[str] = None,
        value: Optional[Any] = None,
        document: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword schema_type: Schema Type. Immutable. Possible values include: "xml", "json".
        :paramtype schema_type: str or ~api_management_client.models.SchemaType
        :keyword description: Free-form schema entity description.
        :paramtype description: str
        :keyword value: Json-encoded string for non json-based schema.
        :paramtype value: any
        :keyword document: Global Schema document object for json-based schema formats(e.g. json
         schema).
        :paramtype document: any
        """
        super(GlobalSchemaContract, self).__init__(**kwargs)
        self.schema_type = schema_type
        self.description = description
        self.value = value
        self.document = document


class GroupCollection(msrest.serialization.Model):
    """Paged Group list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.GroupContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GroupContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["GroupContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.GroupContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(GroupCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class GroupContract(Resource):
    """Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar display_name: Group name.
    :vartype display_name: str
    :ivar description: Group description. Can contain HTML formatting tags.
    :vartype description: str
    :ivar built_in: true if the group is one of the three system groups (Administrators,
     Developers, or Guests); otherwise false.
    :vartype built_in: bool
    :ivar type_properties_type: Group type. Possible values include: "custom", "system",
     "external".
    :vartype type_properties_type: str or ~api_management_client.models.GroupType
    :ivar external_id: For external groups, this property contains the id of the group from the
     external identity provider, e.g. for Azure Active Directory
     ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
    :vartype external_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 1000, 'min_length': 0},
        'built_in': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'built_in': {'key': 'properties.builtIn', 'type': 'bool'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'external_id': {'key': 'properties.externalId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        type_properties_type: Optional[Union[str, "GroupType"]] = None,
        external_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Group name.
        :paramtype display_name: str
        :keyword description: Group description. Can contain HTML formatting tags.
        :paramtype description: str
        :keyword type_properties_type: Group type. Possible values include: "custom", "system",
         "external".
        :paramtype type_properties_type: str or ~api_management_client.models.GroupType
        :keyword external_id: For external groups, this property contains the id of the group from the
         external identity provider, e.g. for Azure Active Directory
         ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
        :paramtype external_id: str
        """
        super(GroupContract, self).__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.built_in = None
        self.type_properties_type = type_properties_type
        self.external_id = external_id


class GroupContractProperties(msrest.serialization.Model):
    """Group contract Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: Required. Group name.
    :vartype display_name: str
    :ivar description: Group description. Can contain HTML formatting tags.
    :vartype description: str
    :ivar built_in: true if the group is one of the three system groups (Administrators,
     Developers, or Guests); otherwise false.
    :vartype built_in: bool
    :ivar type: Group type. Possible values include: "custom", "system", "external".
    :vartype type: str or ~api_management_client.models.GroupType
    :ivar external_id: For external groups, this property contains the id of the group from the
     external identity provider, e.g. for Azure Active Directory
     ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
    :vartype external_id: str
    """

    _validation = {
        'display_name': {'required': True, 'max_length': 300, 'min_length': 1},
        'description': {'max_length': 1000, 'min_length': 0},
        'built_in': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'built_in': {'key': 'builtIn', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'external_id': {'key': 'externalId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        description: Optional[str] = None,
        type: Optional[Union[str, "GroupType"]] = None,
        external_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Required. Group name.
        :paramtype display_name: str
        :keyword description: Group description. Can contain HTML formatting tags.
        :paramtype description: str
        :keyword type: Group type. Possible values include: "custom", "system", "external".
        :paramtype type: str or ~api_management_client.models.GroupType
        :keyword external_id: For external groups, this property contains the id of the group from the
         external identity provider, e.g. for Azure Active Directory
         ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
        :paramtype external_id: str
        """
        super(GroupContractProperties, self).__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.built_in = None
        self.type = type
        self.external_id = external_id


class GroupCreateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create Group operation.

    :ivar display_name: Group name.
    :vartype display_name: str
    :ivar description: Group description.
    :vartype description: str
    :ivar type: Group type. Possible values include: "custom", "system", "external".
    :vartype type: str or ~api_management_client.models.GroupType
    :ivar external_id: Identifier of the external groups, this property contains the id of the
     group from the external identity provider, e.g. for Azure Active Directory
     ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
    :vartype external_id: str
    """

    _validation = {
        'display_name': {'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'external_id': {'key': 'properties.externalId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        type: Optional[Union[str, "GroupType"]] = None,
        external_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Group name.
        :paramtype display_name: str
        :keyword description: Group description.
        :paramtype description: str
        :keyword type: Group type. Possible values include: "custom", "system", "external".
        :paramtype type: str or ~api_management_client.models.GroupType
        :keyword external_id: Identifier of the external groups, this property contains the id of the
         group from the external identity provider, e.g. for Azure Active Directory
         ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
        :paramtype external_id: str
        """
        super(GroupCreateParameters, self).__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.type = type
        self.external_id = external_id


class GroupUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the Update Group operation.

    :ivar display_name: Group name.
    :vartype display_name: str
    :ivar description: Group description.
    :vartype description: str
    :ivar type: Group type. Possible values include: "custom", "system", "external".
    :vartype type: str or ~api_management_client.models.GroupType
    :ivar external_id: Identifier of the external groups, this property contains the id of the
     group from the external identity provider, e.g. for Azure Active Directory
     ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
    :vartype external_id: str
    """

    _validation = {
        'display_name': {'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'external_id': {'key': 'properties.externalId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        type: Optional[Union[str, "GroupType"]] = None,
        external_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Group name.
        :paramtype display_name: str
        :keyword description: Group description.
        :paramtype description: str
        :keyword type: Group type. Possible values include: "custom", "system", "external".
        :paramtype type: str or ~api_management_client.models.GroupType
        :keyword external_id: Identifier of the external groups, this property contains the id of the
         group from the external identity provider, e.g. for Azure Active Directory
         ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
        :paramtype external_id: str
        """
        super(GroupUpdateParameters, self).__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.type = type
        self.external_id = external_id


class HostnameConfiguration(msrest.serialization.Model):
    """Custom hostname configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Hostname type. Possible values include: "Proxy", "Portal", "Management",
     "Scm", "DeveloperPortal".
    :vartype type: str or ~api_management_client.models.HostnameType
    :ivar host_name: Required. Hostname to configure on the Api Management service.
    :vartype host_name: str
    :ivar key_vault_id: Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url
     containing version is provided, auto-update of ssl certificate will not work. This requires Api
     Management service to be configured with aka.ms/apimmsi. The secret should be of type
     *application/x-pkcs12*.
    :vartype key_vault_id: str
    :ivar identity_client_id: System or User Assigned Managed identity clientId as generated by
     Azure AD, which has GET access to the keyVault containing the SSL certificate.
    :vartype identity_client_id: str
    :ivar encoded_certificate: Base64 Encoded certificate.
    :vartype encoded_certificate: str
    :ivar certificate_password: Certificate Password.
    :vartype certificate_password: str
    :ivar default_ssl_binding: Specify true to setup the certificate associated with this Hostname
     as the Default SSL Certificate. If a client does not send the SNI header, then this will be the
     certificate that will be challenged. The property is useful if a service has multiple custom
     hostname enabled and it needs to decide on the default ssl certificate. The setting only
     applied to Proxy Hostname Type.
    :vartype default_ssl_binding: bool
    :ivar negotiate_client_certificate: Specify true to always negotiate client certificate on the
     hostname. Default Value is false.
    :vartype negotiate_client_certificate: bool
    :ivar certificate: Certificate information.
    :vartype certificate: ~api_management_client.models.CertificateInformation
    :ivar certificate_source: Certificate Source. Possible values include: "Managed", "KeyVault",
     "Custom", "BuiltIn".
    :vartype certificate_source: str or ~api_management_client.models.CertificateSource
    :ivar certificate_status: Certificate Status. Possible values include: "Completed", "Failed",
     "InProgress".
    :vartype certificate_status: str or ~api_management_client.models.CertificateStatus
    """

    _validation = {
        'type': {'required': True},
        'host_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'identity_client_id': {'key': 'identityClientId', 'type': 'str'},
        'encoded_certificate': {'key': 'encodedCertificate', 'type': 'str'},
        'certificate_password': {'key': 'certificatePassword', 'type': 'str'},
        'default_ssl_binding': {'key': 'defaultSslBinding', 'type': 'bool'},
        'negotiate_client_certificate': {'key': 'negotiateClientCertificate', 'type': 'bool'},
        'certificate': {'key': 'certificate', 'type': 'CertificateInformation'},
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'certificate_status': {'key': 'certificateStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "HostnameType"],
        host_name: str,
        key_vault_id: Optional[str] = None,
        identity_client_id: Optional[str] = None,
        encoded_certificate: Optional[str] = None,
        certificate_password: Optional[str] = None,
        default_ssl_binding: Optional[bool] = False,
        negotiate_client_certificate: Optional[bool] = False,
        certificate: Optional["CertificateInformation"] = None,
        certificate_source: Optional[Union[str, "CertificateSource"]] = None,
        certificate_status: Optional[Union[str, "CertificateStatus"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. Hostname type. Possible values include: "Proxy", "Portal",
         "Management", "Scm", "DeveloperPortal".
        :paramtype type: str or ~api_management_client.models.HostnameType
        :keyword host_name: Required. Hostname to configure on the Api Management service.
        :paramtype host_name: str
        :keyword key_vault_id: Url to the KeyVault Secret containing the Ssl Certificate. If absolute
         Url containing version is provided, auto-update of ssl certificate will not work. This requires
         Api Management service to be configured with aka.ms/apimmsi. The secret should be of type
         *application/x-pkcs12*.
        :paramtype key_vault_id: str
        :keyword identity_client_id: System or User Assigned Managed identity clientId as generated by
         Azure AD, which has GET access to the keyVault containing the SSL certificate.
        :paramtype identity_client_id: str
        :keyword encoded_certificate: Base64 Encoded certificate.
        :paramtype encoded_certificate: str
        :keyword certificate_password: Certificate Password.
        :paramtype certificate_password: str
        :keyword default_ssl_binding: Specify true to setup the certificate associated with this
         Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this
         will be the certificate that will be challenged. The property is useful if a service has
         multiple custom hostname enabled and it needs to decide on the default ssl certificate. The
         setting only applied to Proxy Hostname Type.
        :paramtype default_ssl_binding: bool
        :keyword negotiate_client_certificate: Specify true to always negotiate client certificate on
         the hostname. Default Value is false.
        :paramtype negotiate_client_certificate: bool
        :keyword certificate: Certificate information.
        :paramtype certificate: ~api_management_client.models.CertificateInformation
        :keyword certificate_source: Certificate Source. Possible values include: "Managed",
         "KeyVault", "Custom", "BuiltIn".
        :paramtype certificate_source: str or ~api_management_client.models.CertificateSource
        :keyword certificate_status: Certificate Status. Possible values include: "Completed",
         "Failed", "InProgress".
        :paramtype certificate_status: str or ~api_management_client.models.CertificateStatus
        """
        super(HostnameConfiguration, self).__init__(**kwargs)
        self.type = type
        self.host_name = host_name
        self.key_vault_id = key_vault_id
        self.identity_client_id = identity_client_id
        self.encoded_certificate = encoded_certificate
        self.certificate_password = certificate_password
        self.default_ssl_binding = default_ssl_binding
        self.negotiate_client_certificate = negotiate_client_certificate
        self.certificate = certificate
        self.certificate_source = certificate_source
        self.certificate_status = certificate_status


class HTTPHeader(msrest.serialization.Model):
    """HTTP header and it's value.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Header name.
    :vartype name: str
    :ivar value: Required. Header value.
    :vartype value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        """
        :keyword name: Required. Header name.
        :paramtype name: str
        :keyword value: Required. Header value.
        :paramtype value: str
        """
        super(HTTPHeader, self).__init__(**kwargs)
        self.name = name
        self.value = value


class HttpMessageDiagnostic(msrest.serialization.Model):
    """Http message diagnostic settings.

    :ivar headers: Array of HTTP Headers to log.
    :vartype headers: list[str]
    :ivar body: Body logging settings.
    :vartype body: ~api_management_client.models.BodyDiagnosticSettings
    :ivar data_masking: Data masking settings.
    :vartype data_masking: ~api_management_client.models.DataMasking
    """

    _attribute_map = {
        'headers': {'key': 'headers', 'type': '[str]'},
        'body': {'key': 'body', 'type': 'BodyDiagnosticSettings'},
        'data_masking': {'key': 'dataMasking', 'type': 'DataMasking'},
    }

    def __init__(
        self,
        *,
        headers: Optional[List[str]] = None,
        body: Optional["BodyDiagnosticSettings"] = None,
        data_masking: Optional["DataMasking"] = None,
        **kwargs
    ):
        """
        :keyword headers: Array of HTTP Headers to log.
        :paramtype headers: list[str]
        :keyword body: Body logging settings.
        :paramtype body: ~api_management_client.models.BodyDiagnosticSettings
        :keyword data_masking: Data masking settings.
        :paramtype data_masking: ~api_management_client.models.DataMasking
        """
        super(HttpMessageDiagnostic, self).__init__(**kwargs)
        self.headers = headers
        self.body = body
        self.data_masking = data_masking


class IdentityProviderBaseParameters(msrest.serialization.Model):
    """Identity Provider Base Parameter Properties.

    :ivar type: Identity Provider Type identifier. Possible values include: "facebook", "google",
     "microsoft", "twitter", "aad", "aadB2C".
    :vartype type: str or ~api_management_client.models.IdentityProviderType
    :ivar signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :vartype signin_tenant: str
    :ivar allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :vartype allowed_tenants: list[str]
    :ivar authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :vartype authority: str
    :ivar signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signup_policy_name: str
    :ivar signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signin_policy_name: str
    :ivar profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :vartype profile_editing_policy_name: str
    :ivar password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :vartype password_reset_policy_name: str
    """

    _validation = {
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'signin_tenant': {'key': 'signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'allowedTenants', 'type': '[str]'},
        'authority': {'key': 'authority', 'type': 'str'},
        'signup_policy_name': {'key': 'signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'passwordResetPolicyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "IdentityProviderType"]] = None,
        signin_tenant: Optional[str] = None,
        allowed_tenants: Optional[List[str]] = None,
        authority: Optional[str] = None,
        signup_policy_name: Optional[str] = None,
        signin_policy_name: Optional[str] = None,
        profile_editing_policy_name: Optional[str] = None,
        password_reset_policy_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: Identity Provider Type identifier. Possible values include: "facebook",
         "google", "microsoft", "twitter", "aad", "aadB2C".
        :paramtype type: str or ~api_management_client.models.IdentityProviderType
        :keyword signin_tenant: The TenantId to use instead of Common when logging into Active
         Directory.
        :paramtype signin_tenant: str
        :keyword allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory
         login.
        :paramtype allowed_tenants: list[str]
        :keyword authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
        :paramtype authority: str
        :keyword signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signup_policy_name: str
        :keyword signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signin_policy_name: str
        :keyword profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype profile_editing_policy_name: str
        :keyword password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype password_reset_policy_name: str
        """
        super(IdentityProviderBaseParameters, self).__init__(**kwargs)
        self.type = type
        self.signin_tenant = signin_tenant
        self.allowed_tenants = allowed_tenants
        self.authority = authority
        self.signup_policy_name = signup_policy_name
        self.signin_policy_name = signin_policy_name
        self.profile_editing_policy_name = profile_editing_policy_name
        self.password_reset_policy_name = password_reset_policy_name


class IdentityProviderContract(Resource):
    """Identity Provider details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar type_properties_type: Identity Provider Type identifier. Possible values include:
     "facebook", "google", "microsoft", "twitter", "aad", "aadB2C".
    :vartype type_properties_type: str or ~api_management_client.models.IdentityProviderType
    :ivar signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :vartype signin_tenant: str
    :ivar allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :vartype allowed_tenants: list[str]
    :ivar authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :vartype authority: str
    :ivar signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signup_policy_name: str
    :ivar signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signin_policy_name: str
    :ivar profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :vartype profile_editing_policy_name: str
    :ivar password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :vartype password_reset_policy_name: str
    :ivar client_id: Client Id of the Application in the external Identity Provider. It is App ID
     for Facebook login, Client ID for Google login, App ID for Microsoft.
    :vartype client_id: str
    :ivar client_secret: Client secret of the Application in external Identity Provider, used to
     authenticate login request. For example, it is App Secret for Facebook login, API Key for
     Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations!
     Use '/listSecrets' POST request to get the value.
    :vartype client_secret: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'min_length': 1},
        'client_secret': {'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'signin_tenant': {'key': 'properties.signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'properties.allowedTenants', 'type': '[str]'},
        'authority': {'key': 'properties.authority', 'type': 'str'},
        'signup_policy_name': {'key': 'properties.signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'properties.signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'properties.profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'properties.passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type_properties_type: Optional[Union[str, "IdentityProviderType"]] = None,
        signin_tenant: Optional[str] = None,
        allowed_tenants: Optional[List[str]] = None,
        authority: Optional[str] = None,
        signup_policy_name: Optional[str] = None,
        signin_policy_name: Optional[str] = None,
        profile_editing_policy_name: Optional[str] = None,
        password_reset_policy_name: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type_properties_type: Identity Provider Type identifier. Possible values include:
         "facebook", "google", "microsoft", "twitter", "aad", "aadB2C".
        :paramtype type_properties_type: str or ~api_management_client.models.IdentityProviderType
        :keyword signin_tenant: The TenantId to use instead of Common when logging into Active
         Directory.
        :paramtype signin_tenant: str
        :keyword allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory
         login.
        :paramtype allowed_tenants: list[str]
        :keyword authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
        :paramtype authority: str
        :keyword signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signup_policy_name: str
        :keyword signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signin_policy_name: str
        :keyword profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype profile_editing_policy_name: str
        :keyword password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype password_reset_policy_name: str
        :keyword client_id: Client Id of the Application in the external Identity Provider. It is App
         ID for Facebook login, Client ID for Google login, App ID for Microsoft.
        :paramtype client_id: str
        :keyword client_secret: Client secret of the Application in external Identity Provider, used to
         authenticate login request. For example, it is App Secret for Facebook login, API Key for
         Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations!
         Use '/listSecrets' POST request to get the value.
        :paramtype client_secret: str
        """
        super(IdentityProviderContract, self).__init__(**kwargs)
        self.type_properties_type = type_properties_type
        self.signin_tenant = signin_tenant
        self.allowed_tenants = allowed_tenants
        self.authority = authority
        self.signup_policy_name = signup_policy_name
        self.signin_policy_name = signin_policy_name
        self.profile_editing_policy_name = profile_editing_policy_name
        self.password_reset_policy_name = password_reset_policy_name
        self.client_id = client_id
        self.client_secret = client_secret


class IdentityProviderContractProperties(IdentityProviderBaseParameters):
    """The external Identity Providers like Facebook, Google, Microsoft, Twitter or Azure Active Directory which can be used to enable access to the API Management service developer portal for all users.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Identity Provider Type identifier. Possible values include: "facebook", "google",
     "microsoft", "twitter", "aad", "aadB2C".
    :vartype type: str or ~api_management_client.models.IdentityProviderType
    :ivar signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :vartype signin_tenant: str
    :ivar allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :vartype allowed_tenants: list[str]
    :ivar authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :vartype authority: str
    :ivar signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signup_policy_name: str
    :ivar signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signin_policy_name: str
    :ivar profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :vartype profile_editing_policy_name: str
    :ivar password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :vartype password_reset_policy_name: str
    :ivar client_id: Required. Client Id of the Application in the external Identity Provider. It
     is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
    :vartype client_id: str
    :ivar client_secret: Client secret of the Application in external Identity Provider, used to
     authenticate login request. For example, it is App Secret for Facebook login, API Key for
     Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations!
     Use '/listSecrets' POST request to get the value.
    :vartype client_secret: str
    """

    _validation = {
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'required': True, 'min_length': 1},
        'client_secret': {'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'signin_tenant': {'key': 'signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'allowedTenants', 'type': '[str]'},
        'authority': {'key': 'authority', 'type': 'str'},
        'signup_policy_name': {'key': 'signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        type: Optional[Union[str, "IdentityProviderType"]] = None,
        signin_tenant: Optional[str] = None,
        allowed_tenants: Optional[List[str]] = None,
        authority: Optional[str] = None,
        signup_policy_name: Optional[str] = None,
        signin_policy_name: Optional[str] = None,
        profile_editing_policy_name: Optional[str] = None,
        password_reset_policy_name: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: Identity Provider Type identifier. Possible values include: "facebook",
         "google", "microsoft", "twitter", "aad", "aadB2C".
        :paramtype type: str or ~api_management_client.models.IdentityProviderType
        :keyword signin_tenant: The TenantId to use instead of Common when logging into Active
         Directory.
        :paramtype signin_tenant: str
        :keyword allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory
         login.
        :paramtype allowed_tenants: list[str]
        :keyword authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
        :paramtype authority: str
        :keyword signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signup_policy_name: str
        :keyword signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signin_policy_name: str
        :keyword profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype profile_editing_policy_name: str
        :keyword password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype password_reset_policy_name: str
        :keyword client_id: Required. Client Id of the Application in the external Identity Provider.
         It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
        :paramtype client_id: str
        :keyword client_secret: Client secret of the Application in external Identity Provider, used to
         authenticate login request. For example, it is App Secret for Facebook login, API Key for
         Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations!
         Use '/listSecrets' POST request to get the value.
        :paramtype client_secret: str
        """
        super(IdentityProviderContractProperties, self).__init__(type=type, signin_tenant=signin_tenant, allowed_tenants=allowed_tenants, authority=authority, signup_policy_name=signup_policy_name, signin_policy_name=signin_policy_name, profile_editing_policy_name=profile_editing_policy_name, password_reset_policy_name=password_reset_policy_name, **kwargs)
        self.client_id = client_id
        self.client_secret = client_secret


class IdentityProviderCreateContract(Resource):
    """Identity Provider details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar type_properties_type: Identity Provider Type identifier. Possible values include:
     "facebook", "google", "microsoft", "twitter", "aad", "aadB2C".
    :vartype type_properties_type: str or ~api_management_client.models.IdentityProviderType
    :ivar signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :vartype signin_tenant: str
    :ivar allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :vartype allowed_tenants: list[str]
    :ivar authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :vartype authority: str
    :ivar signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signup_policy_name: str
    :ivar signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signin_policy_name: str
    :ivar profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :vartype profile_editing_policy_name: str
    :ivar password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :vartype password_reset_policy_name: str
    :ivar client_id: Client Id of the Application in the external Identity Provider. It is App ID
     for Facebook login, Client ID for Google login, App ID for Microsoft.
    :vartype client_id: str
    :ivar client_secret: Client secret of the Application in external Identity Provider, used to
     authenticate login request. For example, it is App Secret for Facebook login, API Key for
     Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations!
     Use '/listSecrets' POST request to get the value.
    :vartype client_secret: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'min_length': 1},
        'client_secret': {'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'signin_tenant': {'key': 'properties.signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'properties.allowedTenants', 'type': '[str]'},
        'authority': {'key': 'properties.authority', 'type': 'str'},
        'signup_policy_name': {'key': 'properties.signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'properties.signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'properties.profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'properties.passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type_properties_type: Optional[Union[str, "IdentityProviderType"]] = None,
        signin_tenant: Optional[str] = None,
        allowed_tenants: Optional[List[str]] = None,
        authority: Optional[str] = None,
        signup_policy_name: Optional[str] = None,
        signin_policy_name: Optional[str] = None,
        profile_editing_policy_name: Optional[str] = None,
        password_reset_policy_name: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type_properties_type: Identity Provider Type identifier. Possible values include:
         "facebook", "google", "microsoft", "twitter", "aad", "aadB2C".
        :paramtype type_properties_type: str or ~api_management_client.models.IdentityProviderType
        :keyword signin_tenant: The TenantId to use instead of Common when logging into Active
         Directory.
        :paramtype signin_tenant: str
        :keyword allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory
         login.
        :paramtype allowed_tenants: list[str]
        :keyword authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
        :paramtype authority: str
        :keyword signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signup_policy_name: str
        :keyword signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signin_policy_name: str
        :keyword profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype profile_editing_policy_name: str
        :keyword password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype password_reset_policy_name: str
        :keyword client_id: Client Id of the Application in the external Identity Provider. It is App
         ID for Facebook login, Client ID for Google login, App ID for Microsoft.
        :paramtype client_id: str
        :keyword client_secret: Client secret of the Application in external Identity Provider, used to
         authenticate login request. For example, it is App Secret for Facebook login, API Key for
         Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations!
         Use '/listSecrets' POST request to get the value.
        :paramtype client_secret: str
        """
        super(IdentityProviderCreateContract, self).__init__(**kwargs)
        self.type_properties_type = type_properties_type
        self.signin_tenant = signin_tenant
        self.allowed_tenants = allowed_tenants
        self.authority = authority
        self.signup_policy_name = signup_policy_name
        self.signin_policy_name = signin_policy_name
        self.profile_editing_policy_name = profile_editing_policy_name
        self.password_reset_policy_name = password_reset_policy_name
        self.client_id = client_id
        self.client_secret = client_secret


class IdentityProviderCreateContractProperties(IdentityProviderBaseParameters):
    """The external Identity Providers like Facebook, Google, Microsoft, Twitter or Azure Active Directory which can be used to enable access to the API Management service developer portal for all users.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Identity Provider Type identifier. Possible values include: "facebook", "google",
     "microsoft", "twitter", "aad", "aadB2C".
    :vartype type: str or ~api_management_client.models.IdentityProviderType
    :ivar signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :vartype signin_tenant: str
    :ivar allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :vartype allowed_tenants: list[str]
    :ivar authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :vartype authority: str
    :ivar signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signup_policy_name: str
    :ivar signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signin_policy_name: str
    :ivar profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :vartype profile_editing_policy_name: str
    :ivar password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :vartype password_reset_policy_name: str
    :ivar client_id: Required. Client Id of the Application in the external Identity Provider. It
     is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
    :vartype client_id: str
    :ivar client_secret: Required. Client secret of the Application in external Identity Provider,
     used to authenticate login request. For example, it is App Secret for Facebook login, API Key
     for Google login, Public Key for Microsoft. This property will not be filled on 'GET'
     operations! Use '/listSecrets' POST request to get the value.
    :vartype client_secret: str
    """

    _validation = {
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'required': True, 'min_length': 1},
        'client_secret': {'required': True, 'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'signin_tenant': {'key': 'signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'allowedTenants', 'type': '[str]'},
        'authority': {'key': 'authority', 'type': 'str'},
        'signup_policy_name': {'key': 'signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        client_secret: str,
        type: Optional[Union[str, "IdentityProviderType"]] = None,
        signin_tenant: Optional[str] = None,
        allowed_tenants: Optional[List[str]] = None,
        authority: Optional[str] = None,
        signup_policy_name: Optional[str] = None,
        signin_policy_name: Optional[str] = None,
        profile_editing_policy_name: Optional[str] = None,
        password_reset_policy_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: Identity Provider Type identifier. Possible values include: "facebook",
         "google", "microsoft", "twitter", "aad", "aadB2C".
        :paramtype type: str or ~api_management_client.models.IdentityProviderType
        :keyword signin_tenant: The TenantId to use instead of Common when logging into Active
         Directory.
        :paramtype signin_tenant: str
        :keyword allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory
         login.
        :paramtype allowed_tenants: list[str]
        :keyword authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
        :paramtype authority: str
        :keyword signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signup_policy_name: str
        :keyword signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signin_policy_name: str
        :keyword profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype profile_editing_policy_name: str
        :keyword password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype password_reset_policy_name: str
        :keyword client_id: Required. Client Id of the Application in the external Identity Provider.
         It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
        :paramtype client_id: str
        :keyword client_secret: Required. Client secret of the Application in external Identity
         Provider, used to authenticate login request. For example, it is App Secret for Facebook login,
         API Key for Google login, Public Key for Microsoft. This property will not be filled on 'GET'
         operations! Use '/listSecrets' POST request to get the value.
        :paramtype client_secret: str
        """
        super(IdentityProviderCreateContractProperties, self).__init__(type=type, signin_tenant=signin_tenant, allowed_tenants=allowed_tenants, authority=authority, signup_policy_name=signup_policy_name, signin_policy_name=signin_policy_name, profile_editing_policy_name=profile_editing_policy_name, password_reset_policy_name=password_reset_policy_name, **kwargs)
        self.client_id = client_id
        self.client_secret = client_secret


class IdentityProviderList(msrest.serialization.Model):
    """List of all the Identity Providers configured on the service instance.

    :ivar value: Identity Provider configuration values.
    :vartype value: list[~api_management_client.models.IdentityProviderContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IdentityProviderContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IdentityProviderContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Identity Provider configuration values.
        :paramtype value: list[~api_management_client.models.IdentityProviderContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(IdentityProviderList, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class IdentityProviderUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to update Identity Provider.

    :ivar type: Identity Provider Type identifier. Possible values include: "facebook", "google",
     "microsoft", "twitter", "aad", "aadB2C".
    :vartype type: str or ~api_management_client.models.IdentityProviderType
    :ivar signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :vartype signin_tenant: str
    :ivar allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :vartype allowed_tenants: list[str]
    :ivar authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :vartype authority: str
    :ivar signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signup_policy_name: str
    :ivar signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signin_policy_name: str
    :ivar profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :vartype profile_editing_policy_name: str
    :ivar password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :vartype password_reset_policy_name: str
    :ivar client_id: Client Id of the Application in the external Identity Provider. It is App ID
     for Facebook login, Client ID for Google login, App ID for Microsoft.
    :vartype client_id: str
    :ivar client_secret: Client secret of the Application in external Identity Provider, used to
     authenticate login request. For example, it is App Secret for Facebook login, API Key for
     Google login, Public Key for Microsoft.
    :vartype client_secret: str
    """

    _validation = {
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'min_length': 1},
        'client_secret': {'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'properties.type', 'type': 'str'},
        'signin_tenant': {'key': 'properties.signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'properties.allowedTenants', 'type': '[str]'},
        'authority': {'key': 'properties.authority', 'type': 'str'},
        'signup_policy_name': {'key': 'properties.signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'properties.signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'properties.profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'properties.passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "IdentityProviderType"]] = None,
        signin_tenant: Optional[str] = None,
        allowed_tenants: Optional[List[str]] = None,
        authority: Optional[str] = None,
        signup_policy_name: Optional[str] = None,
        signin_policy_name: Optional[str] = None,
        profile_editing_policy_name: Optional[str] = None,
        password_reset_policy_name: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: Identity Provider Type identifier. Possible values include: "facebook",
         "google", "microsoft", "twitter", "aad", "aadB2C".
        :paramtype type: str or ~api_management_client.models.IdentityProviderType
        :keyword signin_tenant: The TenantId to use instead of Common when logging into Active
         Directory.
        :paramtype signin_tenant: str
        :keyword allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory
         login.
        :paramtype allowed_tenants: list[str]
        :keyword authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
        :paramtype authority: str
        :keyword signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signup_policy_name: str
        :keyword signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signin_policy_name: str
        :keyword profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype profile_editing_policy_name: str
        :keyword password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype password_reset_policy_name: str
        :keyword client_id: Client Id of the Application in the external Identity Provider. It is App
         ID for Facebook login, Client ID for Google login, App ID for Microsoft.
        :paramtype client_id: str
        :keyword client_secret: Client secret of the Application in external Identity Provider, used to
         authenticate login request. For example, it is App Secret for Facebook login, API Key for
         Google login, Public Key for Microsoft.
        :paramtype client_secret: str
        """
        super(IdentityProviderUpdateParameters, self).__init__(**kwargs)
        self.type = type
        self.signin_tenant = signin_tenant
        self.allowed_tenants = allowed_tenants
        self.authority = authority
        self.signup_policy_name = signup_policy_name
        self.signin_policy_name = signin_policy_name
        self.profile_editing_policy_name = profile_editing_policy_name
        self.password_reset_policy_name = password_reset_policy_name
        self.client_id = client_id
        self.client_secret = client_secret


class IdentityProviderUpdateProperties(IdentityProviderBaseParameters):
    """Parameters supplied to the Update Identity Provider operation.

    :ivar type: Identity Provider Type identifier. Possible values include: "facebook", "google",
     "microsoft", "twitter", "aad", "aadB2C".
    :vartype type: str or ~api_management_client.models.IdentityProviderType
    :ivar signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :vartype signin_tenant: str
    :ivar allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :vartype allowed_tenants: list[str]
    :ivar authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :vartype authority: str
    :ivar signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signup_policy_name: str
    :ivar signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :vartype signin_policy_name: str
    :ivar profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :vartype profile_editing_policy_name: str
    :ivar password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :vartype password_reset_policy_name: str
    :ivar client_id: Client Id of the Application in the external Identity Provider. It is App ID
     for Facebook login, Client ID for Google login, App ID for Microsoft.
    :vartype client_id: str
    :ivar client_secret: Client secret of the Application in external Identity Provider, used to
     authenticate login request. For example, it is App Secret for Facebook login, API Key for
     Google login, Public Key for Microsoft.
    :vartype client_secret: str
    """

    _validation = {
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'min_length': 1},
        'client_secret': {'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'signin_tenant': {'key': 'signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'allowedTenants', 'type': '[str]'},
        'authority': {'key': 'authority', 'type': 'str'},
        'signup_policy_name': {'key': 'signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "IdentityProviderType"]] = None,
        signin_tenant: Optional[str] = None,
        allowed_tenants: Optional[List[str]] = None,
        authority: Optional[str] = None,
        signup_policy_name: Optional[str] = None,
        signin_policy_name: Optional[str] = None,
        profile_editing_policy_name: Optional[str] = None,
        password_reset_policy_name: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: Identity Provider Type identifier. Possible values include: "facebook",
         "google", "microsoft", "twitter", "aad", "aadB2C".
        :paramtype type: str or ~api_management_client.models.IdentityProviderType
        :keyword signin_tenant: The TenantId to use instead of Common when logging into Active
         Directory.
        :paramtype signin_tenant: str
        :keyword allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory
         login.
        :paramtype allowed_tenants: list[str]
        :keyword authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
        :paramtype authority: str
        :keyword signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signup_policy_name: str
        :keyword signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
        :paramtype signin_policy_name: str
        :keyword profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype profile_editing_policy_name: str
        :keyword password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C
         Identity Provider.
        :paramtype password_reset_policy_name: str
        :keyword client_id: Client Id of the Application in the external Identity Provider. It is App
         ID for Facebook login, Client ID for Google login, App ID for Microsoft.
        :paramtype client_id: str
        :keyword client_secret: Client secret of the Application in external Identity Provider, used to
         authenticate login request. For example, it is App Secret for Facebook login, API Key for
         Google login, Public Key for Microsoft.
        :paramtype client_secret: str
        """
        super(IdentityProviderUpdateProperties, self).__init__(type=type, signin_tenant=signin_tenant, allowed_tenants=allowed_tenants, authority=authority, signup_policy_name=signup_policy_name, signin_policy_name=signin_policy_name, profile_editing_policy_name=profile_editing_policy_name, password_reset_policy_name=password_reset_policy_name, **kwargs)
        self.client_id = client_id
        self.client_secret = client_secret


class IssueAttachmentCollection(msrest.serialization.Model):
    """Paged Issue Attachment list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Issue Attachment values.
    :vartype value: list[~api_management_client.models.IssueAttachmentContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IssueAttachmentContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        """
        super(IssueAttachmentCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class IssueAttachmentContract(Resource):
    """Issue Attachment Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar title: Filename by which the binary data will be saved.
    :vartype title: str
    :ivar content_format: Either 'link' if content is provided via an HTTP link or the MIME type of
     the Base64-encoded binary data provided in the 'content' property.
    :vartype content_format: str
    :ivar content: An HTTP link or Base64-encoded binary data.
    :vartype content: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'content_format': {'key': 'properties.contentFormat', 'type': 'str'},
        'content': {'key': 'properties.content', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        content_format: Optional[str] = None,
        content: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword title: Filename by which the binary data will be saved.
        :paramtype title: str
        :keyword content_format: Either 'link' if content is provided via an HTTP link or the MIME type
         of the Base64-encoded binary data provided in the 'content' property.
        :paramtype content_format: str
        :keyword content: An HTTP link or Base64-encoded binary data.
        :paramtype content: str
        """
        super(IssueAttachmentContract, self).__init__(**kwargs)
        self.title = title
        self.content_format = content_format
        self.content = content


class IssueCollection(msrest.serialization.Model):
    """Paged Issue list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Issue values.
    :vartype value: list[~api_management_client.models.IssueContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IssueContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        """
        super(IssueCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class IssueCommentCollection(msrest.serialization.Model):
    """Paged Issue Comment list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Issue Comment values.
    :vartype value: list[~api_management_client.models.IssueCommentContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IssueCommentContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        """
        super(IssueCommentCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class IssueCommentContract(Resource):
    """Issue Comment Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar text: Comment text.
    :vartype text: str
    :ivar created_date: Date and time when the comment was created.
    :vartype created_date: ~datetime.datetime
    :ivar user_id: A resource identifier for the user who left the comment.
    :vartype user_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'text': {'key': 'properties.text', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        created_date: Optional[datetime.datetime] = None,
        user_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword text: Comment text.
        :paramtype text: str
        :keyword created_date: Date and time when the comment was created.
        :paramtype created_date: ~datetime.datetime
        :keyword user_id: A resource identifier for the user who left the comment.
        :paramtype user_id: str
        """
        super(IssueCommentContract, self).__init__(**kwargs)
        self.text = text
        self.created_date = created_date
        self.user_id = user_id


class IssueContract(Resource):
    """Issue Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar created_date: Date and time when the issue was created.
    :vartype created_date: ~datetime.datetime
    :ivar state: Status of the issue. Possible values include: "proposed", "open", "removed",
     "resolved", "closed".
    :vartype state: str or ~api_management_client.models.State
    :ivar api_id: A resource identifier for the API the issue was created for.
    :vartype api_id: str
    :ivar title: The issue title.
    :vartype title: str
    :ivar description: Text describing the issue.
    :vartype description: str
    :ivar user_id: A resource identifier for the user created the issue.
    :vartype user_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'api_id': {'key': 'properties.apiId', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        created_date: Optional[datetime.datetime] = None,
        state: Optional[Union[str, "State"]] = None,
        api_id: Optional[str] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        user_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword created_date: Date and time when the issue was created.
        :paramtype created_date: ~datetime.datetime
        :keyword state: Status of the issue. Possible values include: "proposed", "open", "removed",
         "resolved", "closed".
        :paramtype state: str or ~api_management_client.models.State
        :keyword api_id: A resource identifier for the API the issue was created for.
        :paramtype api_id: str
        :keyword title: The issue title.
        :paramtype title: str
        :keyword description: Text describing the issue.
        :paramtype description: str
        :keyword user_id: A resource identifier for the user created the issue.
        :paramtype user_id: str
        """
        super(IssueContract, self).__init__(**kwargs)
        self.created_date = created_date
        self.state = state
        self.api_id = api_id
        self.title = title
        self.description = description
        self.user_id = user_id


class IssueContractBaseProperties(msrest.serialization.Model):
    """Issue contract Base Properties.

    :ivar created_date: Date and time when the issue was created.
    :vartype created_date: ~datetime.datetime
    :ivar state: Status of the issue. Possible values include: "proposed", "open", "removed",
     "resolved", "closed".
    :vartype state: str or ~api_management_client.models.State
    :ivar api_id: A resource identifier for the API the issue was created for.
    :vartype api_id: str
    """

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'api_id': {'key': 'apiId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        created_date: Optional[datetime.datetime] = None,
        state: Optional[Union[str, "State"]] = None,
        api_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword created_date: Date and time when the issue was created.
        :paramtype created_date: ~datetime.datetime
        :keyword state: Status of the issue. Possible values include: "proposed", "open", "removed",
         "resolved", "closed".
        :paramtype state: str or ~api_management_client.models.State
        :keyword api_id: A resource identifier for the API the issue was created for.
        :paramtype api_id: str
        """
        super(IssueContractBaseProperties, self).__init__(**kwargs)
        self.created_date = created_date
        self.state = state
        self.api_id = api_id


class IssueContractProperties(IssueContractBaseProperties):
    """Issue contract Properties.

    All required parameters must be populated in order to send to Azure.

    :ivar created_date: Date and time when the issue was created.
    :vartype created_date: ~datetime.datetime
    :ivar state: Status of the issue. Possible values include: "proposed", "open", "removed",
     "resolved", "closed".
    :vartype state: str or ~api_management_client.models.State
    :ivar api_id: A resource identifier for the API the issue was created for.
    :vartype api_id: str
    :ivar title: Required. The issue title.
    :vartype title: str
    :ivar description: Required. Text describing the issue.
    :vartype description: str
    :ivar user_id: Required. A resource identifier for the user created the issue.
    :vartype user_id: str
    """

    _validation = {
        'title': {'required': True},
        'description': {'required': True},
        'user_id': {'required': True},
    }

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'api_id': {'key': 'apiId', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        title: str,
        description: str,
        user_id: str,
        created_date: Optional[datetime.datetime] = None,
        state: Optional[Union[str, "State"]] = None,
        api_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword created_date: Date and time when the issue was created.
        :paramtype created_date: ~datetime.datetime
        :keyword state: Status of the issue. Possible values include: "proposed", "open", "removed",
         "resolved", "closed".
        :paramtype state: str or ~api_management_client.models.State
        :keyword api_id: A resource identifier for the API the issue was created for.
        :paramtype api_id: str
        :keyword title: Required. The issue title.
        :paramtype title: str
        :keyword description: Required. Text describing the issue.
        :paramtype description: str
        :keyword user_id: Required. A resource identifier for the user created the issue.
        :paramtype user_id: str
        """
        super(IssueContractProperties, self).__init__(created_date=created_date, state=state, api_id=api_id, **kwargs)
        self.title = title
        self.description = description
        self.user_id = user_id


class IssueUpdateContract(msrest.serialization.Model):
    """Issue update Parameters.

    :ivar created_date: Date and time when the issue was created.
    :vartype created_date: ~datetime.datetime
    :ivar state: Status of the issue. Possible values include: "proposed", "open", "removed",
     "resolved", "closed".
    :vartype state: str or ~api_management_client.models.State
    :ivar api_id: A resource identifier for the API the issue was created for.
    :vartype api_id: str
    :ivar title: The issue title.
    :vartype title: str
    :ivar description: Text describing the issue.
    :vartype description: str
    :ivar user_id: A resource identifier for the user created the issue.
    :vartype user_id: str
    """

    _attribute_map = {
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'api_id': {'key': 'properties.apiId', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        created_date: Optional[datetime.datetime] = None,
        state: Optional[Union[str, "State"]] = None,
        api_id: Optional[str] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        user_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword created_date: Date and time when the issue was created.
        :paramtype created_date: ~datetime.datetime
        :keyword state: Status of the issue. Possible values include: "proposed", "open", "removed",
         "resolved", "closed".
        :paramtype state: str or ~api_management_client.models.State
        :keyword api_id: A resource identifier for the API the issue was created for.
        :paramtype api_id: str
        :keyword title: The issue title.
        :paramtype title: str
        :keyword description: Text describing the issue.
        :paramtype description: str
        :keyword user_id: A resource identifier for the user created the issue.
        :paramtype user_id: str
        """
        super(IssueUpdateContract, self).__init__(**kwargs)
        self.created_date = created_date
        self.state = state
        self.api_id = api_id
        self.title = title
        self.description = description
        self.user_id = user_id


class IssueUpdateContractProperties(IssueContractBaseProperties):
    """Issue contract Update Properties.

    :ivar created_date: Date and time when the issue was created.
    :vartype created_date: ~datetime.datetime
    :ivar state: Status of the issue. Possible values include: "proposed", "open", "removed",
     "resolved", "closed".
    :vartype state: str or ~api_management_client.models.State
    :ivar api_id: A resource identifier for the API the issue was created for.
    :vartype api_id: str
    :ivar title: The issue title.
    :vartype title: str
    :ivar description: Text describing the issue.
    :vartype description: str
    :ivar user_id: A resource identifier for the user created the issue.
    :vartype user_id: str
    """

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'api_id': {'key': 'apiId', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        created_date: Optional[datetime.datetime] = None,
        state: Optional[Union[str, "State"]] = None,
        api_id: Optional[str] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        user_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword created_date: Date and time when the issue was created.
        :paramtype created_date: ~datetime.datetime
        :keyword state: Status of the issue. Possible values include: "proposed", "open", "removed",
         "resolved", "closed".
        :paramtype state: str or ~api_management_client.models.State
        :keyword api_id: A resource identifier for the API the issue was created for.
        :paramtype api_id: str
        :keyword title: The issue title.
        :paramtype title: str
        :keyword description: Text describing the issue.
        :paramtype description: str
        :keyword user_id: A resource identifier for the user created the issue.
        :paramtype user_id: str
        """
        super(IssueUpdateContractProperties, self).__init__(created_date=created_date, state=state, api_id=api_id, **kwargs)
        self.title = title
        self.description = description
        self.user_id = user_id


class KeyVaultContractCreateProperties(msrest.serialization.Model):
    """Create keyVault contract details.

    :ivar secret_identifier: Key vault secret identifier for fetching secret. Providing a versioned
     secret will prevent auto-refresh. This requires API Management service to be configured with
     aka.ms/apimmsi.
    :vartype secret_identifier: str
    :ivar identity_client_id: SystemAssignedIdentity or UserAssignedIdentity Client Id which will
     be used to access key vault secret.
    :vartype identity_client_id: str
    """

    _attribute_map = {
        'secret_identifier': {'key': 'secretIdentifier', 'type': 'str'},
        'identity_client_id': {'key': 'identityClientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        secret_identifier: Optional[str] = None,
        identity_client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword secret_identifier: Key vault secret identifier for fetching secret. Providing a
         versioned secret will prevent auto-refresh. This requires API Management service to be
         configured with aka.ms/apimmsi.
        :paramtype secret_identifier: str
        :keyword identity_client_id: SystemAssignedIdentity or UserAssignedIdentity Client Id which
         will be used to access key vault secret.
        :paramtype identity_client_id: str
        """
        super(KeyVaultContractCreateProperties, self).__init__(**kwargs)
        self.secret_identifier = secret_identifier
        self.identity_client_id = identity_client_id


class KeyVaultContractProperties(KeyVaultContractCreateProperties):
    """KeyVault contract details.

    :ivar secret_identifier: Key vault secret identifier for fetching secret. Providing a versioned
     secret will prevent auto-refresh. This requires API Management service to be configured with
     aka.ms/apimmsi.
    :vartype secret_identifier: str
    :ivar identity_client_id: SystemAssignedIdentity or UserAssignedIdentity Client Id which will
     be used to access key vault secret.
    :vartype identity_client_id: str
    :ivar last_status: Last time sync and refresh status of secret from key vault.
    :vartype last_status: ~api_management_client.models.KeyVaultLastAccessStatusContractProperties
    """

    _attribute_map = {
        'secret_identifier': {'key': 'secretIdentifier', 'type': 'str'},
        'identity_client_id': {'key': 'identityClientId', 'type': 'str'},
        'last_status': {'key': 'lastStatus', 'type': 'KeyVaultLastAccessStatusContractProperties'},
    }

    def __init__(
        self,
        *,
        secret_identifier: Optional[str] = None,
        identity_client_id: Optional[str] = None,
        last_status: Optional["KeyVaultLastAccessStatusContractProperties"] = None,
        **kwargs
    ):
        """
        :keyword secret_identifier: Key vault secret identifier for fetching secret. Providing a
         versioned secret will prevent auto-refresh. This requires API Management service to be
         configured with aka.ms/apimmsi.
        :paramtype secret_identifier: str
        :keyword identity_client_id: SystemAssignedIdentity or UserAssignedIdentity Client Id which
         will be used to access key vault secret.
        :paramtype identity_client_id: str
        :keyword last_status: Last time sync and refresh status of secret from key vault.
        :paramtype last_status:
         ~api_management_client.models.KeyVaultLastAccessStatusContractProperties
        """
        super(KeyVaultContractProperties, self).__init__(secret_identifier=secret_identifier, identity_client_id=identity_client_id, **kwargs)
        self.last_status = last_status


class KeyVaultLastAccessStatusContractProperties(msrest.serialization.Model):
    """Issue contract Update Properties.

    :ivar code: Last status code for sync and refresh of secret from key vault.
    :vartype code: str
    :ivar message: Details of the error else empty.
    :vartype message: str
    :ivar time_stamp_utc: Last time secret was accessed. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype time_stamp_utc: ~datetime.datetime
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time_stamp_utc': {'key': 'timeStampUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        time_stamp_utc: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword code: Last status code for sync and refresh of secret from key vault.
        :paramtype code: str
        :keyword message: Details of the error else empty.
        :paramtype message: str
        :keyword time_stamp_utc: Last time secret was accessed. The date conforms to the following
         format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype time_stamp_utc: ~datetime.datetime
        """
        super(KeyVaultLastAccessStatusContractProperties, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.time_stamp_utc = time_stamp_utc


class LoggerCollection(msrest.serialization.Model):
    """Paged Logger list representation.

    :ivar value: Logger values.
    :vartype value: list[~api_management_client.models.LoggerContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoggerContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LoggerContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Logger values.
        :paramtype value: list[~api_management_client.models.LoggerContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(LoggerCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class LoggerContract(Resource):
    """Logger details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar logger_type: Logger type. Possible values include: "azureEventHub",
     "applicationInsights", "azureMonitor".
    :vartype logger_type: str or ~api_management_client.models.LoggerType
    :ivar description: Logger description.
    :vartype description: str
    :ivar credentials: The name and SendRule connection string of the event hub for azureEventHub
     logger.
     Instrumentation key for applicationInsights logger.
    :vartype credentials: dict[str, str]
    :ivar is_buffered: Whether records are buffered in the logger before publishing. Default is
     assumed to be true.
    :vartype is_buffered: bool
    :ivar resource_id: Azure Resource Id of a log target (either Azure Event Hub resource or Azure
     Application Insights resource).
    :vartype resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 256, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'logger_type': {'key': 'properties.loggerType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': '{str}'},
        'is_buffered': {'key': 'properties.isBuffered', 'type': 'bool'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logger_type: Optional[Union[str, "LoggerType"]] = None,
        description: Optional[str] = None,
        credentials: Optional[Dict[str, str]] = None,
        is_buffered: Optional[bool] = None,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword logger_type: Logger type. Possible values include: "azureEventHub",
         "applicationInsights", "azureMonitor".
        :paramtype logger_type: str or ~api_management_client.models.LoggerType
        :keyword description: Logger description.
        :paramtype description: str
        :keyword credentials: The name and SendRule connection string of the event hub for
         azureEventHub logger.
         Instrumentation key for applicationInsights logger.
        :paramtype credentials: dict[str, str]
        :keyword is_buffered: Whether records are buffered in the logger before publishing. Default is
         assumed to be true.
        :paramtype is_buffered: bool
        :keyword resource_id: Azure Resource Id of a log target (either Azure Event Hub resource or
         Azure Application Insights resource).
        :paramtype resource_id: str
        """
        super(LoggerContract, self).__init__(**kwargs)
        self.logger_type = logger_type
        self.description = description
        self.credentials = credentials
        self.is_buffered = is_buffered
        self.resource_id = resource_id


class LoggerUpdateContract(msrest.serialization.Model):
    """Logger update contract.

    :ivar logger_type: Logger type. Possible values include: "azureEventHub",
     "applicationInsights", "azureMonitor".
    :vartype logger_type: str or ~api_management_client.models.LoggerType
    :ivar description: Logger description.
    :vartype description: str
    :ivar credentials: Logger credentials.
    :vartype credentials: dict[str, str]
    :ivar is_buffered: Whether records are buffered in the logger before publishing. Default is
     assumed to be true.
    :vartype is_buffered: bool
    """

    _attribute_map = {
        'logger_type': {'key': 'properties.loggerType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': '{str}'},
        'is_buffered': {'key': 'properties.isBuffered', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        logger_type: Optional[Union[str, "LoggerType"]] = None,
        description: Optional[str] = None,
        credentials: Optional[Dict[str, str]] = None,
        is_buffered: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword logger_type: Logger type. Possible values include: "azureEventHub",
         "applicationInsights", "azureMonitor".
        :paramtype logger_type: str or ~api_management_client.models.LoggerType
        :keyword description: Logger description.
        :paramtype description: str
        :keyword credentials: Logger credentials.
        :paramtype credentials: dict[str, str]
        :keyword is_buffered: Whether records are buffered in the logger before publishing. Default is
         assumed to be true.
        :paramtype is_buffered: bool
        """
        super(LoggerUpdateContract, self).__init__(**kwargs)
        self.logger_type = logger_type
        self.description = description
        self.credentials = credentials
        self.is_buffered = is_buffered


class NamedValueCollection(msrest.serialization.Model):
    """Paged NamedValue list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.NamedValueContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NamedValueContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NamedValueContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.NamedValueContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(NamedValueCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class NamedValueContract(Resource):
    """NamedValue details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :vartype tags: list[str]
    :ivar secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :vartype secret: bool
    :ivar display_name: Unique name of NamedValue. It may contain only letters, digits, period,
     dash, and underscore characters.
    :vartype display_name: str
    :ivar value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace. This property will not be filled on 'GET' operations! Use
     '/listSecrets' POST request to get the value.
    :vartype value: str
    :ivar key_vault: KeyVault location details of the namedValue.
    :vartype key_vault: ~api_management_client.models.KeyVaultContractProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'properties.tags', 'type': '[str]'},
        'secret': {'key': 'properties.secret', 'type': 'bool'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'KeyVaultContractProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[List[str]] = None,
        secret: Optional[bool] = None,
        display_name: Optional[str] = None,
        value: Optional[str] = None,
        key_vault: Optional["KeyVaultContractProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Optional tags that when provided can be used to filter the
         NamedValue list.
        :paramtype tags: list[str]
        :keyword secret: Determines whether the value is a secret and should be encrypted or not.
         Default value is false.
        :paramtype secret: bool
        :keyword display_name: Unique name of NamedValue. It may contain only letters, digits, period,
         dash, and underscore characters.
        :paramtype display_name: str
        :keyword value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
         consist only of whitespace. This property will not be filled on 'GET' operations! Use
         '/listSecrets' POST request to get the value.
        :paramtype value: str
        :keyword key_vault: KeyVault location details of the namedValue.
        :paramtype key_vault: ~api_management_client.models.KeyVaultContractProperties
        """
        super(NamedValueContract, self).__init__(**kwargs)
        self.tags = tags
        self.secret = secret
        self.display_name = display_name
        self.value = value
        self.key_vault = key_vault


class NamedValueEntityBaseParameters(msrest.serialization.Model):
    """NamedValue Entity Base Parameters set.

    :ivar tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :vartype tags: list[str]
    :ivar secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :vartype secret: bool
    """

    _validation = {
        'tags': {'max_items': 32, 'min_items': 0},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '[str]'},
        'secret': {'key': 'secret', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        tags: Optional[List[str]] = None,
        secret: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Optional tags that when provided can be used to filter the
         NamedValue list.
        :paramtype tags: list[str]
        :keyword secret: Determines whether the value is a secret and should be encrypted or not.
         Default value is false.
        :paramtype secret: bool
        """
        super(NamedValueEntityBaseParameters, self).__init__(**kwargs)
        self.tags = tags
        self.secret = secret


class NamedValueContractProperties(NamedValueEntityBaseParameters):
    """NamedValue Contract properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :vartype tags: list[str]
    :ivar secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :vartype secret: bool
    :ivar display_name: Required. Unique name of NamedValue. It may contain only letters, digits,
     period, dash, and underscore characters.
    :vartype display_name: str
    :ivar value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace. This property will not be filled on 'GET' operations! Use
     '/listSecrets' POST request to get the value.
    :vartype value: str
    :ivar key_vault: KeyVault location details of the namedValue.
    :vartype key_vault: ~api_management_client.models.KeyVaultContractProperties
    """

    _validation = {
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'required': True, 'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '[str]'},
        'secret': {'key': 'secret', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'key_vault': {'key': 'keyVault', 'type': 'KeyVaultContractProperties'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        tags: Optional[List[str]] = None,
        secret: Optional[bool] = None,
        value: Optional[str] = None,
        key_vault: Optional["KeyVaultContractProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Optional tags that when provided can be used to filter the
         NamedValue list.
        :paramtype tags: list[str]
        :keyword secret: Determines whether the value is a secret and should be encrypted or not.
         Default value is false.
        :paramtype secret: bool
        :keyword display_name: Required. Unique name of NamedValue. It may contain only letters,
         digits, period, dash, and underscore characters.
        :paramtype display_name: str
        :keyword value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
         consist only of whitespace. This property will not be filled on 'GET' operations! Use
         '/listSecrets' POST request to get the value.
        :paramtype value: str
        :keyword key_vault: KeyVault location details of the namedValue.
        :paramtype key_vault: ~api_management_client.models.KeyVaultContractProperties
        """
        super(NamedValueContractProperties, self).__init__(tags=tags, secret=secret, **kwargs)
        self.display_name = display_name
        self.value = value
        self.key_vault = key_vault


class NamedValueCreateContract(Resource):
    """NamedValue details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :vartype tags: list[str]
    :ivar secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :vartype secret: bool
    :ivar display_name: Unique name of NamedValue. It may contain only letters, digits, period,
     dash, and underscore characters.
    :vartype display_name: str
    :ivar value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace. This property will not be filled on 'GET' operations! Use
     '/listSecrets' POST request to get the value.
    :vartype value: str
    :ivar key_vault: KeyVault location details of the namedValue.
    :vartype key_vault: ~api_management_client.models.KeyVaultContractCreateProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'properties.tags', 'type': '[str]'},
        'secret': {'key': 'properties.secret', 'type': 'bool'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'KeyVaultContractCreateProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[List[str]] = None,
        secret: Optional[bool] = None,
        display_name: Optional[str] = None,
        value: Optional[str] = None,
        key_vault: Optional["KeyVaultContractCreateProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Optional tags that when provided can be used to filter the
         NamedValue list.
        :paramtype tags: list[str]
        :keyword secret: Determines whether the value is a secret and should be encrypted or not.
         Default value is false.
        :paramtype secret: bool
        :keyword display_name: Unique name of NamedValue. It may contain only letters, digits, period,
         dash, and underscore characters.
        :paramtype display_name: str
        :keyword value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
         consist only of whitespace. This property will not be filled on 'GET' operations! Use
         '/listSecrets' POST request to get the value.
        :paramtype value: str
        :keyword key_vault: KeyVault location details of the namedValue.
        :paramtype key_vault: ~api_management_client.models.KeyVaultContractCreateProperties
        """
        super(NamedValueCreateContract, self).__init__(**kwargs)
        self.tags = tags
        self.secret = secret
        self.display_name = display_name
        self.value = value
        self.key_vault = key_vault


class NamedValueCreateContractProperties(NamedValueEntityBaseParameters):
    """NamedValue Contract properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :vartype tags: list[str]
    :ivar secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :vartype secret: bool
    :ivar display_name: Required. Unique name of NamedValue. It may contain only letters, digits,
     period, dash, and underscore characters.
    :vartype display_name: str
    :ivar value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace. This property will not be filled on 'GET' operations! Use
     '/listSecrets' POST request to get the value.
    :vartype value: str
    :ivar key_vault: KeyVault location details of the namedValue.
    :vartype key_vault: ~api_management_client.models.KeyVaultContractCreateProperties
    """

    _validation = {
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'required': True, 'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '[str]'},
        'secret': {'key': 'secret', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'key_vault': {'key': 'keyVault', 'type': 'KeyVaultContractCreateProperties'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        tags: Optional[List[str]] = None,
        secret: Optional[bool] = None,
        value: Optional[str] = None,
        key_vault: Optional["KeyVaultContractCreateProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Optional tags that when provided can be used to filter the
         NamedValue list.
        :paramtype tags: list[str]
        :keyword secret: Determines whether the value is a secret and should be encrypted or not.
         Default value is false.
        :paramtype secret: bool
        :keyword display_name: Required. Unique name of NamedValue. It may contain only letters,
         digits, period, dash, and underscore characters.
        :paramtype display_name: str
        :keyword value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
         consist only of whitespace. This property will not be filled on 'GET' operations! Use
         '/listSecrets' POST request to get the value.
        :paramtype value: str
        :keyword key_vault: KeyVault location details of the namedValue.
        :paramtype key_vault: ~api_management_client.models.KeyVaultContractCreateProperties
        """
        super(NamedValueCreateContractProperties, self).__init__(tags=tags, secret=secret, **kwargs)
        self.display_name = display_name
        self.value = value
        self.key_vault = key_vault


class NamedValueSecretContract(msrest.serialization.Model):
    """Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.

    :ivar value: This is secret value of the NamedValue entity.
    :vartype value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: This is secret value of the NamedValue entity.
        :paramtype value: str
        """
        super(NamedValueSecretContract, self).__init__(**kwargs)
        self.value = value


class NamedValueUpdateParameterProperties(NamedValueEntityBaseParameters):
    """NamedValue Contract properties.

    :ivar tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :vartype tags: list[str]
    :ivar secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :vartype secret: bool
    :ivar display_name: Unique name of NamedValue. It may contain only letters, digits, period,
     dash, and underscore characters.
    :vartype display_name: str
    :ivar value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace.
    :vartype value: str
    :ivar key_vault: KeyVault location details of the namedValue.
    :vartype key_vault: ~api_management_client.models.KeyVaultContractCreateProperties
    """

    _validation = {
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 1},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '[str]'},
        'secret': {'key': 'secret', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'key_vault': {'key': 'keyVault', 'type': 'KeyVaultContractCreateProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[List[str]] = None,
        secret: Optional[bool] = None,
        display_name: Optional[str] = None,
        value: Optional[str] = None,
        key_vault: Optional["KeyVaultContractCreateProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Optional tags that when provided can be used to filter the
         NamedValue list.
        :paramtype tags: list[str]
        :keyword secret: Determines whether the value is a secret and should be encrypted or not.
         Default value is false.
        :paramtype secret: bool
        :keyword display_name: Unique name of NamedValue. It may contain only letters, digits, period,
         dash, and underscore characters.
        :paramtype display_name: str
        :keyword value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
         consist only of whitespace.
        :paramtype value: str
        :keyword key_vault: KeyVault location details of the namedValue.
        :paramtype key_vault: ~api_management_client.models.KeyVaultContractCreateProperties
        """
        super(NamedValueUpdateParameterProperties, self).__init__(tags=tags, secret=secret, **kwargs)
        self.display_name = display_name
        self.value = value
        self.key_vault = key_vault


class NamedValueUpdateParameters(msrest.serialization.Model):
    """NamedValue update Parameters.

    :ivar tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :vartype tags: list[str]
    :ivar secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :vartype secret: bool
    :ivar display_name: Unique name of NamedValue. It may contain only letters, digits, period,
     dash, and underscore characters.
    :vartype display_name: str
    :ivar value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace.
    :vartype value: str
    :ivar key_vault: KeyVault location details of the namedValue.
    :vartype key_vault: ~api_management_client.models.KeyVaultContractCreateProperties
    """

    _validation = {
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 1},
    }

    _attribute_map = {
        'tags': {'key': 'properties.tags', 'type': '[str]'},
        'secret': {'key': 'properties.secret', 'type': 'bool'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'KeyVaultContractCreateProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[List[str]] = None,
        secret: Optional[bool] = None,
        display_name: Optional[str] = None,
        value: Optional[str] = None,
        key_vault: Optional["KeyVaultContractCreateProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Optional tags that when provided can be used to filter the
         NamedValue list.
        :paramtype tags: list[str]
        :keyword secret: Determines whether the value is a secret and should be encrypted or not.
         Default value is false.
        :paramtype secret: bool
        :keyword display_name: Unique name of NamedValue. It may contain only letters, digits, period,
         dash, and underscore characters.
        :paramtype display_name: str
        :keyword value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
         consist only of whitespace.
        :paramtype value: str
        :keyword key_vault: KeyVault location details of the namedValue.
        :paramtype key_vault: ~api_management_client.models.KeyVaultContractCreateProperties
        """
        super(NamedValueUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.secret = secret
        self.display_name = display_name
        self.value = value
        self.key_vault = key_vault


class NetworkStatusContract(msrest.serialization.Model):
    """Network Status details.

    All required parameters must be populated in order to send to Azure.

    :ivar dns_servers: Required. Gets the list of DNS servers IPV4 addresses.
    :vartype dns_servers: list[str]
    :ivar connectivity_status: Required. Gets the list of Connectivity Status to the Resources on
     which the service depends upon.
    :vartype connectivity_status: list[~api_management_client.models.ConnectivityStatusContract]
    """

    _validation = {
        'dns_servers': {'required': True},
        'connectivity_status': {'required': True},
    }

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'connectivity_status': {'key': 'connectivityStatus', 'type': '[ConnectivityStatusContract]'},
    }

    def __init__(
        self,
        *,
        dns_servers: List[str],
        connectivity_status: List["ConnectivityStatusContract"],
        **kwargs
    ):
        """
        :keyword dns_servers: Required. Gets the list of DNS servers IPV4 addresses.
        :paramtype dns_servers: list[str]
        :keyword connectivity_status: Required. Gets the list of Connectivity Status to the Resources
         on which the service depends upon.
        :paramtype connectivity_status: list[~api_management_client.models.ConnectivityStatusContract]
        """
        super(NetworkStatusContract, self).__init__(**kwargs)
        self.dns_servers = dns_servers
        self.connectivity_status = connectivity_status


class NetworkStatusContractByLocation(msrest.serialization.Model):
    """Network Status in the Location.

    :ivar location: Location of service.
    :vartype location: str
    :ivar network_status: Network status in Location.
    :vartype network_status: ~api_management_client.models.NetworkStatusContract
    """

    _validation = {
        'location': {'min_length': 1},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'network_status': {'key': 'networkStatus', 'type': 'NetworkStatusContract'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        network_status: Optional["NetworkStatusContract"] = None,
        **kwargs
    ):
        """
        :keyword location: Location of service.
        :paramtype location: str
        :keyword network_status: Network status in Location.
        :paramtype network_status: ~api_management_client.models.NetworkStatusContract
        """
        super(NetworkStatusContractByLocation, self).__init__(**kwargs)
        self.location = location
        self.network_status = network_status


class NotificationCollection(msrest.serialization.Model):
    """Paged Notification list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.NotificationContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NotificationContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NotificationContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.NotificationContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(NotificationCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class NotificationContract(Resource):
    """Notification details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar title: Title of the Notification.
    :vartype title: str
    :ivar description: Description of the Notification.
    :vartype description: str
    :ivar recipients: Recipient Parameter values.
    :vartype recipients: ~api_management_client.models.RecipientsContractProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'title': {'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'recipients': {'key': 'properties.recipients', 'type': 'RecipientsContractProperties'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        recipients: Optional["RecipientsContractProperties"] = None,
        **kwargs
    ):
        """
        :keyword title: Title of the Notification.
        :paramtype title: str
        :keyword description: Description of the Notification.
        :paramtype description: str
        :keyword recipients: Recipient Parameter values.
        :paramtype recipients: ~api_management_client.models.RecipientsContractProperties
        """
        super(NotificationContract, self).__init__(**kwargs)
        self.title = title
        self.description = description
        self.recipients = recipients


class OAuth2AuthenticationSettingsContract(msrest.serialization.Model):
    """API OAuth2 Authentication settings details.

    :ivar authorization_server_id: OAuth authorization server identifier.
    :vartype authorization_server_id: str
    :ivar scope: operations scope.
    :vartype scope: str
    """

    _attribute_map = {
        'authorization_server_id': {'key': 'authorizationServerId', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authorization_server_id: Optional[str] = None,
        scope: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authorization_server_id: OAuth authorization server identifier.
        :paramtype authorization_server_id: str
        :keyword scope: operations scope.
        :paramtype scope: str
        """
        super(OAuth2AuthenticationSettingsContract, self).__init__(**kwargs)
        self.authorization_server_id = authorization_server_id
        self.scope = scope


class OpenIdAuthenticationSettingsContract(msrest.serialization.Model):
    """API OAuth2 Authentication settings details.

    :ivar openid_provider_id: OAuth authorization server identifier.
    :vartype openid_provider_id: str
    :ivar bearer_token_sending_methods: How to send token to the server.
    :vartype bearer_token_sending_methods: list[str or
     ~api_management_client.models.BearerTokenSendingMethods]
    """

    _attribute_map = {
        'openid_provider_id': {'key': 'openidProviderId', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'bearerTokenSendingMethods', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        openid_provider_id: Optional[str] = None,
        bearer_token_sending_methods: Optional[List[Union[str, "BearerTokenSendingMethods"]]] = None,
        **kwargs
    ):
        """
        :keyword openid_provider_id: OAuth authorization server identifier.
        :paramtype openid_provider_id: str
        :keyword bearer_token_sending_methods: How to send token to the server.
        :paramtype bearer_token_sending_methods: list[str or
         ~api_management_client.models.BearerTokenSendingMethods]
        """
        super(OpenIdAuthenticationSettingsContract, self).__init__(**kwargs)
        self.openid_provider_id = openid_provider_id
        self.bearer_token_sending_methods = bearer_token_sending_methods


class OpenIdConnectProviderCollection(msrest.serialization.Model):
    """Paged OpenIdProviders list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.OpenidConnectProviderContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OpenidConnectProviderContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OpenidConnectProviderContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.OpenidConnectProviderContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(OpenIdConnectProviderCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class OpenidConnectProviderContract(Resource):
    """OpenId Connect Provider details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar display_name: User-friendly OpenID Connect Provider name.
    :vartype display_name: str
    :ivar description: User-friendly description of OpenID Connect Provider.
    :vartype description: str
    :ivar metadata_endpoint: Metadata endpoint URI.
    :vartype metadata_endpoint: str
    :ivar client_id: Client ID of developer console which is the client application.
    :vartype client_id: str
    :ivar client_secret: Client Secret of developer console which is the client application.
    :vartype client_secret: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'metadata_endpoint': {'key': 'properties.metadataEndpoint', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        metadata_endpoint: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: User-friendly OpenID Connect Provider name.
        :paramtype display_name: str
        :keyword description: User-friendly description of OpenID Connect Provider.
        :paramtype description: str
        :keyword metadata_endpoint: Metadata endpoint URI.
        :paramtype metadata_endpoint: str
        :keyword client_id: Client ID of developer console which is the client application.
        :paramtype client_id: str
        :keyword client_secret: Client Secret of developer console which is the client application.
        :paramtype client_secret: str
        """
        super(OpenidConnectProviderContract, self).__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.metadata_endpoint = metadata_endpoint
        self.client_id = client_id
        self.client_secret = client_secret


class OpenidConnectProviderUpdateContract(msrest.serialization.Model):
    """Parameters supplied to the Update OpenID Connect Provider operation.

    :ivar display_name: User-friendly OpenID Connect Provider name.
    :vartype display_name: str
    :ivar description: User-friendly description of OpenID Connect Provider.
    :vartype description: str
    :ivar metadata_endpoint: Metadata endpoint URI.
    :vartype metadata_endpoint: str
    :ivar client_id: Client ID of developer console which is the client application.
    :vartype client_id: str
    :ivar client_secret: Client Secret of developer console which is the client application.
    :vartype client_secret: str
    """

    _validation = {
        'display_name': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'metadata_endpoint': {'key': 'properties.metadataEndpoint', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        metadata_endpoint: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: User-friendly OpenID Connect Provider name.
        :paramtype display_name: str
        :keyword description: User-friendly description of OpenID Connect Provider.
        :paramtype description: str
        :keyword metadata_endpoint: Metadata endpoint URI.
        :paramtype metadata_endpoint: str
        :keyword client_id: Client ID of developer console which is the client application.
        :paramtype client_id: str
        :keyword client_secret: Client Secret of developer console which is the client application.
        :paramtype client_secret: str
        """
        super(OpenidConnectProviderUpdateContract, self).__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.metadata_endpoint = metadata_endpoint
        self.client_id = client_id
        self.client_secret = client_secret


class Operation(msrest.serialization.Model):
    """REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that describes the operation.
    :vartype display: ~api_management_client.models.OperationDisplay
    :ivar origin: The operation origin.
    :vartype origin: str
    :ivar properties: The operation properties.
    :vartype properties: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that describes the operation.
        :paramtype display: ~api_management_client.models.OperationDisplay
        :keyword origin: The operation origin.
        :paramtype origin: str
        :keyword properties: The operation properties.
        :paramtype properties: any
        """
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationCollection(msrest.serialization.Model):
    """Paged Operation list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.OperationContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        """
        super(OperationCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class OperationContract(Resource):
    """API Operation details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar template_parameters: Collection of URL template parameters.
    :vartype template_parameters: list[~api_management_client.models.ParameterContract]
    :ivar description: Description of the operation. May include HTML formatting tags.
    :vartype description: str
    :ivar request: An entity containing request details.
    :vartype request: ~api_management_client.models.RequestContract
    :ivar responses: Array of Operation responses.
    :vartype responses: list[~api_management_client.models.ResponseContract]
    :ivar policies: Operation Policies.
    :vartype policies: str
    :ivar display_name: Operation Name.
    :vartype display_name: str
    :ivar method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not
     limited by only them.
    :vartype method: str
    :ivar url_template: Relative URL template identifying the target resource for this operation.
     May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
    :vartype url_template: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'url_template': {'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'template_parameters': {'key': 'properties.templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'request': {'key': 'properties.request', 'type': 'RequestContract'},
        'responses': {'key': 'properties.responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'properties.policies', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'method': {'key': 'properties.method', 'type': 'str'},
        'url_template': {'key': 'properties.urlTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        template_parameters: Optional[List["ParameterContract"]] = None,
        description: Optional[str] = None,
        request: Optional["RequestContract"] = None,
        responses: Optional[List["ResponseContract"]] = None,
        policies: Optional[str] = None,
        display_name: Optional[str] = None,
        method: Optional[str] = None,
        url_template: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword template_parameters: Collection of URL template parameters.
        :paramtype template_parameters: list[~api_management_client.models.ParameterContract]
        :keyword description: Description of the operation. May include HTML formatting tags.
        :paramtype description: str
        :keyword request: An entity containing request details.
        :paramtype request: ~api_management_client.models.RequestContract
        :keyword responses: Array of Operation responses.
        :paramtype responses: list[~api_management_client.models.ResponseContract]
        :keyword policies: Operation Policies.
        :paramtype policies: str
        :keyword display_name: Operation Name.
        :paramtype display_name: str
        :keyword method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but
         not limited by only them.
        :paramtype method: str
        :keyword url_template: Relative URL template identifying the target resource for this
         operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
        :paramtype url_template: str
        """
        super(OperationContract, self).__init__(**kwargs)
        self.template_parameters = template_parameters
        self.description = description
        self.request = request
        self.responses = responses
        self.policies = policies
        self.display_name = display_name
        self.method = method
        self.url_template = url_template


class OperationEntityBaseContract(msrest.serialization.Model):
    """API Operation Entity Base Contract details.

    :ivar template_parameters: Collection of URL template parameters.
    :vartype template_parameters: list[~api_management_client.models.ParameterContract]
    :ivar description: Description of the operation. May include HTML formatting tags.
    :vartype description: str
    :ivar request: An entity containing request details.
    :vartype request: ~api_management_client.models.RequestContract
    :ivar responses: Array of Operation responses.
    :vartype responses: list[~api_management_client.models.ResponseContract]
    :ivar policies: Operation Policies.
    :vartype policies: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'template_parameters': {'key': 'templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'description', 'type': 'str'},
        'request': {'key': 'request', 'type': 'RequestContract'},
        'responses': {'key': 'responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'policies', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        template_parameters: Optional[List["ParameterContract"]] = None,
        description: Optional[str] = None,
        request: Optional["RequestContract"] = None,
        responses: Optional[List["ResponseContract"]] = None,
        policies: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword template_parameters: Collection of URL template parameters.
        :paramtype template_parameters: list[~api_management_client.models.ParameterContract]
        :keyword description: Description of the operation. May include HTML formatting tags.
        :paramtype description: str
        :keyword request: An entity containing request details.
        :paramtype request: ~api_management_client.models.RequestContract
        :keyword responses: Array of Operation responses.
        :paramtype responses: list[~api_management_client.models.ResponseContract]
        :keyword policies: Operation Policies.
        :paramtype policies: str
        """
        super(OperationEntityBaseContract, self).__init__(**kwargs)
        self.template_parameters = template_parameters
        self.description = description
        self.request = request
        self.responses = responses
        self.policies = policies


class OperationContractProperties(OperationEntityBaseContract):
    """Operation Contract Properties.

    All required parameters must be populated in order to send to Azure.

    :ivar template_parameters: Collection of URL template parameters.
    :vartype template_parameters: list[~api_management_client.models.ParameterContract]
    :ivar description: Description of the operation. May include HTML formatting tags.
    :vartype description: str
    :ivar request: An entity containing request details.
    :vartype request: ~api_management_client.models.RequestContract
    :ivar responses: Array of Operation responses.
    :vartype responses: list[~api_management_client.models.ResponseContract]
    :ivar policies: Operation Policies.
    :vartype policies: str
    :ivar display_name: Required. Operation Name.
    :vartype display_name: str
    :ivar method: Required. A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST
     but not limited by only them.
    :vartype method: str
    :ivar url_template: Required. Relative URL template identifying the target resource for this
     operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
    :vartype url_template: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'required': True, 'max_length': 300, 'min_length': 1},
        'method': {'required': True},
        'url_template': {'required': True, 'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'template_parameters': {'key': 'templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'description', 'type': 'str'},
        'request': {'key': 'request', 'type': 'RequestContract'},
        'responses': {'key': 'responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'policies', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'url_template': {'key': 'urlTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        method: str,
        url_template: str,
        template_parameters: Optional[List["ParameterContract"]] = None,
        description: Optional[str] = None,
        request: Optional["RequestContract"] = None,
        responses: Optional[List["ResponseContract"]] = None,
        policies: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword template_parameters: Collection of URL template parameters.
        :paramtype template_parameters: list[~api_management_client.models.ParameterContract]
        :keyword description: Description of the operation. May include HTML formatting tags.
        :paramtype description: str
        :keyword request: An entity containing request details.
        :paramtype request: ~api_management_client.models.RequestContract
        :keyword responses: Array of Operation responses.
        :paramtype responses: list[~api_management_client.models.ResponseContract]
        :keyword policies: Operation Policies.
        :paramtype policies: str
        :keyword display_name: Required. Operation Name.
        :paramtype display_name: str
        :keyword method: Required. A Valid HTTP Operation Method. Typical Http Methods like GET, PUT,
         POST but not limited by only them.
        :paramtype method: str
        :keyword url_template: Required. Relative URL template identifying the target resource for this
         operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
        :paramtype url_template: str
        """
        super(OperationContractProperties, self).__init__(template_parameters=template_parameters, description=description, request=request, responses=responses, policies=policies, **kwargs)
        self.display_name = display_name
        self.method = method
        self.url_template = url_template


class OperationDisplay(msrest.serialization.Model):
    """The object that describes the operation.

    :ivar provider: Friendly name of the resource provider.
    :vartype provider: str
    :ivar operation: Operation type: read, write, delete, listKeys/action, etc.
    :vartype operation: str
    :ivar resource: Resource type on which the operation is performed.
    :vartype resource: str
    :ivar description: Friendly name of the operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        operation: Optional[str] = None,
        resource: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Friendly name of the resource provider.
        :paramtype provider: str
        :keyword operation: Operation type: read, write, delete, listKeys/action, etc.
        :paramtype operation: str
        :keyword resource: Resource type on which the operation is performed.
        :paramtype resource: str
        :keyword description: Friendly name of the operation.
        :paramtype description: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.operation = operation
        self.resource = resource
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next set of results.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~api_management_client.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of operations supported by the resource provider.
        :paramtype value: list[~api_management_client.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationResultContract(Resource):
    """Long Running Git Operation Results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar id_properties_id: Operation result identifier.
    :vartype id_properties_id: str
    :ivar status: Status of an async operation. Possible values include: "Started", "InProgress",
     "Succeeded", "Failed".
    :vartype status: str or ~api_management_client.models.AsyncOperationStatus
    :ivar started: Start time of an async operation. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype started: ~datetime.datetime
    :ivar updated: Last update time of an async operation. The date conforms to the following
     format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype updated: ~datetime.datetime
    :ivar result_info: Optional result info.
    :vartype result_info: str
    :ivar error: Error Body Contract.
    :vartype error: ~api_management_client.models.ErrorResponseBody
    :ivar action_log: This property if only provided as part of the TenantConfiguration_Validate
     operation. It contains the log the entities which will be updated/created/deleted as part of
     the TenantConfiguration_Deploy operation.
    :vartype action_log: list[~api_management_client.models.OperationResultLogItemContract]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'action_log': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'started': {'key': 'properties.started', 'type': 'iso-8601'},
        'updated': {'key': 'properties.updated', 'type': 'iso-8601'},
        'result_info': {'key': 'properties.resultInfo', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'ErrorResponseBody'},
        'action_log': {'key': 'properties.actionLog', 'type': '[OperationResultLogItemContract]'},
    }

    def __init__(
        self,
        *,
        id_properties_id: Optional[str] = None,
        status: Optional[Union[str, "AsyncOperationStatus"]] = None,
        started: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        result_info: Optional[str] = None,
        error: Optional["ErrorResponseBody"] = None,
        **kwargs
    ):
        """
        :keyword id_properties_id: Operation result identifier.
        :paramtype id_properties_id: str
        :keyword status: Status of an async operation. Possible values include: "Started",
         "InProgress", "Succeeded", "Failed".
        :paramtype status: str or ~api_management_client.models.AsyncOperationStatus
        :keyword started: Start time of an async operation. The date conforms to the following format:
         ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype started: ~datetime.datetime
        :keyword updated: Last update time of an async operation. The date conforms to the following
         format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype updated: ~datetime.datetime
        :keyword result_info: Optional result info.
        :paramtype result_info: str
        :keyword error: Error Body Contract.
        :paramtype error: ~api_management_client.models.ErrorResponseBody
        """
        super(OperationResultContract, self).__init__(**kwargs)
        self.id_properties_id = id_properties_id
        self.status = status
        self.started = started
        self.updated = updated
        self.result_info = result_info
        self.error = error
        self.action_log = None


class OperationResultLogItemContract(msrest.serialization.Model):
    """Log of the entity being created, updated or deleted.

    :ivar object_type: The type of entity contract.
    :vartype object_type: str
    :ivar action: Action like create/update/delete.
    :vartype action: str
    :ivar object_key: Identifier of the entity being created/updated/deleted.
    :vartype object_key: str
    """

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'object_key': {'key': 'objectKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        object_type: Optional[str] = None,
        action: Optional[str] = None,
        object_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword object_type: The type of entity contract.
        :paramtype object_type: str
        :keyword action: Action like create/update/delete.
        :paramtype action: str
        :keyword object_key: Identifier of the entity being created/updated/deleted.
        :paramtype object_key: str
        """
        super(OperationResultLogItemContract, self).__init__(**kwargs)
        self.object_type = object_type
        self.action = action
        self.object_key = object_key


class OperationTagResourceContractProperties(msrest.serialization.Model):
    """Operation Entity contract Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Identifier of the operation in form /operations/{operationId}.
    :vartype id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar api_name: API Name.
    :vartype api_name: str
    :ivar api_revision: API Revision.
    :vartype api_revision: str
    :ivar api_version: API Version.
    :vartype api_version: str
    :ivar description: Operation Description.
    :vartype description: str
    :ivar method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not
     limited by only them.
    :vartype method: str
    :ivar url_template: Relative URL template identifying the target resource for this operation.
     May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
    :vartype url_template: str
    """

    _validation = {
        'name': {'readonly': True},
        'api_name': {'readonly': True},
        'api_revision': {'readonly': True},
        'api_version': {'readonly': True},
        'description': {'readonly': True},
        'method': {'readonly': True},
        'url_template': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'api_name': {'key': 'apiName', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'url_template': {'key': 'urlTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Identifier of the operation in form /operations/{operationId}.
        :paramtype id: str
        """
        super(OperationTagResourceContractProperties, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.api_name = None
        self.api_revision = None
        self.api_version = None
        self.description = None
        self.method = None
        self.url_template = None


class OperationUpdateContract(msrest.serialization.Model):
    """API Operation Update Contract details.

    :ivar template_parameters: Collection of URL template parameters.
    :vartype template_parameters: list[~api_management_client.models.ParameterContract]
    :ivar description: Description of the operation. May include HTML formatting tags.
    :vartype description: str
    :ivar request: An entity containing request details.
    :vartype request: ~api_management_client.models.RequestContract
    :ivar responses: Array of Operation responses.
    :vartype responses: list[~api_management_client.models.ResponseContract]
    :ivar policies: Operation Policies.
    :vartype policies: str
    :ivar display_name: Operation Name.
    :vartype display_name: str
    :ivar method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not
     limited by only them.
    :vartype method: str
    :ivar url_template: Relative URL template identifying the target resource for this operation.
     May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
    :vartype url_template: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'url_template': {'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'template_parameters': {'key': 'properties.templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'request': {'key': 'properties.request', 'type': 'RequestContract'},
        'responses': {'key': 'properties.responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'properties.policies', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'method': {'key': 'properties.method', 'type': 'str'},
        'url_template': {'key': 'properties.urlTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        template_parameters: Optional[List["ParameterContract"]] = None,
        description: Optional[str] = None,
        request: Optional["RequestContract"] = None,
        responses: Optional[List["ResponseContract"]] = None,
        policies: Optional[str] = None,
        display_name: Optional[str] = None,
        method: Optional[str] = None,
        url_template: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword template_parameters: Collection of URL template parameters.
        :paramtype template_parameters: list[~api_management_client.models.ParameterContract]
        :keyword description: Description of the operation. May include HTML formatting tags.
        :paramtype description: str
        :keyword request: An entity containing request details.
        :paramtype request: ~api_management_client.models.RequestContract
        :keyword responses: Array of Operation responses.
        :paramtype responses: list[~api_management_client.models.ResponseContract]
        :keyword policies: Operation Policies.
        :paramtype policies: str
        :keyword display_name: Operation Name.
        :paramtype display_name: str
        :keyword method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but
         not limited by only them.
        :paramtype method: str
        :keyword url_template: Relative URL template identifying the target resource for this
         operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
        :paramtype url_template: str
        """
        super(OperationUpdateContract, self).__init__(**kwargs)
        self.template_parameters = template_parameters
        self.description = description
        self.request = request
        self.responses = responses
        self.policies = policies
        self.display_name = display_name
        self.method = method
        self.url_template = url_template


class OperationUpdateContractProperties(OperationEntityBaseContract):
    """Operation Update Contract Properties.

    :ivar template_parameters: Collection of URL template parameters.
    :vartype template_parameters: list[~api_management_client.models.ParameterContract]
    :ivar description: Description of the operation. May include HTML formatting tags.
    :vartype description: str
    :ivar request: An entity containing request details.
    :vartype request: ~api_management_client.models.RequestContract
    :ivar responses: Array of Operation responses.
    :vartype responses: list[~api_management_client.models.ResponseContract]
    :ivar policies: Operation Policies.
    :vartype policies: str
    :ivar display_name: Operation Name.
    :vartype display_name: str
    :ivar method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not
     limited by only them.
    :vartype method: str
    :ivar url_template: Relative URL template identifying the target resource for this operation.
     May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
    :vartype url_template: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'url_template': {'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'template_parameters': {'key': 'templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'description', 'type': 'str'},
        'request': {'key': 'request', 'type': 'RequestContract'},
        'responses': {'key': 'responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'policies', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'url_template': {'key': 'urlTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        template_parameters: Optional[List["ParameterContract"]] = None,
        description: Optional[str] = None,
        request: Optional["RequestContract"] = None,
        responses: Optional[List["ResponseContract"]] = None,
        policies: Optional[str] = None,
        display_name: Optional[str] = None,
        method: Optional[str] = None,
        url_template: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword template_parameters: Collection of URL template parameters.
        :paramtype template_parameters: list[~api_management_client.models.ParameterContract]
        :keyword description: Description of the operation. May include HTML formatting tags.
        :paramtype description: str
        :keyword request: An entity containing request details.
        :paramtype request: ~api_management_client.models.RequestContract
        :keyword responses: Array of Operation responses.
        :paramtype responses: list[~api_management_client.models.ResponseContract]
        :keyword policies: Operation Policies.
        :paramtype policies: str
        :keyword display_name: Operation Name.
        :paramtype display_name: str
        :keyword method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but
         not limited by only them.
        :paramtype method: str
        :keyword url_template: Relative URL template identifying the target resource for this
         operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
        :paramtype url_template: str
        """
        super(OperationUpdateContractProperties, self).__init__(template_parameters=template_parameters, description=description, request=request, responses=responses, policies=policies, **kwargs)
        self.display_name = display_name
        self.method = method
        self.url_template = url_template


class OutboundEnvironmentEndpoint(msrest.serialization.Model):
    """Endpoints accessed for a common purpose that the Api Management Service requires outbound network access to.

    :ivar category: The type of service accessed by the Api Management Service, e.g., Azure
     Storage, Azure SQL Database, and Azure Active Directory.
    :vartype category: str
    :ivar endpoints: The endpoints that the Api Management Service reaches the service at.
    :vartype endpoints: list[~api_management_client.models.EndpointDependency]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointDependency]'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["EndpointDependency"]] = None,
        **kwargs
    ):
        """
        :keyword category: The type of service accessed by the Api Management Service, e.g., Azure
         Storage, Azure SQL Database, and Azure Active Directory.
        :paramtype category: str
        :keyword endpoints: The endpoints that the Api Management Service reaches the service at.
        :paramtype endpoints: list[~api_management_client.models.EndpointDependency]
        """
        super(OutboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class OutboundEnvironmentEndpointList(msrest.serialization.Model):
    """Collection of Outbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~api_management_client.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["OutboundEnvironmentEndpoint"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~api_management_client.models.OutboundEnvironmentEndpoint]
        """
        super(OutboundEnvironmentEndpointList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ParameterContract(msrest.serialization.Model):
    """Operation parameters details.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Parameter name.
    :vartype name: str
    :ivar description: Parameter description.
    :vartype description: str
    :ivar type: Required. Parameter type.
    :vartype type: str
    :ivar default_value: Default parameter value.
    :vartype default_value: str
    :ivar required: Specifies whether parameter is required or not.
    :vartype required: bool
    :ivar values: Parameter values.
    :vartype values: list[str]
    :ivar schema_id: Schema identifier.
    :vartype schema_id: str
    :ivar type_name: Type name defined by the schema.
    :vartype type_name: str
    :ivar examples: Exampled defined for the parameter.
    :vartype examples: dict[str, ~api_management_client.models.ParameterExampleContract]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
        'values': {'key': 'values', 'type': '[str]'},
        'schema_id': {'key': 'schemaId', 'type': 'str'},
        'type_name': {'key': 'typeName', 'type': 'str'},
        'examples': {'key': 'examples', 'type': '{ParameterExampleContract}'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: str,
        description: Optional[str] = None,
        default_value: Optional[str] = None,
        required: Optional[bool] = None,
        values: Optional[List[str]] = None,
        schema_id: Optional[str] = None,
        type_name: Optional[str] = None,
        examples: Optional[Dict[str, "ParameterExampleContract"]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Parameter name.
        :paramtype name: str
        :keyword description: Parameter description.
        :paramtype description: str
        :keyword type: Required. Parameter type.
        :paramtype type: str
        :keyword default_value: Default parameter value.
        :paramtype default_value: str
        :keyword required: Specifies whether parameter is required or not.
        :paramtype required: bool
        :keyword values: Parameter values.
        :paramtype values: list[str]
        :keyword schema_id: Schema identifier.
        :paramtype schema_id: str
        :keyword type_name: Type name defined by the schema.
        :paramtype type_name: str
        :keyword examples: Exampled defined for the parameter.
        :paramtype examples: dict[str, ~api_management_client.models.ParameterExampleContract]
        """
        super(ParameterContract, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.type = type
        self.default_value = default_value
        self.required = required
        self.values = values
        self.schema_id = schema_id
        self.type_name = type_name
        self.examples = examples


class ParameterExampleContract(msrest.serialization.Model):
    """Parameter example.

    :ivar summary: Short description for the example.
    :vartype summary: str
    :ivar description: Long description for the example.
    :vartype description: str
    :ivar value: Example value. May be a primitive value, or an object.
    :vartype value: any
    :ivar external_value: A URL that points to the literal example.
    :vartype external_value: str
    """

    _attribute_map = {
        'summary': {'key': 'summary', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'external_value': {'key': 'externalValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        summary: Optional[str] = None,
        description: Optional[str] = None,
        value: Optional[Any] = None,
        external_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword summary: Short description for the example.
        :paramtype summary: str
        :keyword description: Long description for the example.
        :paramtype description: str
        :keyword value: Example value. May be a primitive value, or an object.
        :paramtype value: any
        :keyword external_value: A URL that points to the literal example.
        :paramtype external_value: str
        """
        super(ParameterExampleContract, self).__init__(**kwargs)
        self.summary = summary
        self.description = description
        self.value = value
        self.external_value = external_value


class PipelineDiagnosticSettings(msrest.serialization.Model):
    """Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.

    :ivar request: Diagnostic settings for request.
    :vartype request: ~api_management_client.models.HttpMessageDiagnostic
    :ivar response: Diagnostic settings for response.
    :vartype response: ~api_management_client.models.HttpMessageDiagnostic
    """

    _attribute_map = {
        'request': {'key': 'request', 'type': 'HttpMessageDiagnostic'},
        'response': {'key': 'response', 'type': 'HttpMessageDiagnostic'},
    }

    def __init__(
        self,
        *,
        request: Optional["HttpMessageDiagnostic"] = None,
        response: Optional["HttpMessageDiagnostic"] = None,
        **kwargs
    ):
        """
        :keyword request: Diagnostic settings for request.
        :paramtype request: ~api_management_client.models.HttpMessageDiagnostic
        :keyword response: Diagnostic settings for response.
        :paramtype response: ~api_management_client.models.HttpMessageDiagnostic
        """
        super(PipelineDiagnosticSettings, self).__init__(**kwargs)
        self.request = request
        self.response = response


class PolicyCollection(msrest.serialization.Model):
    """The response of the list policy operation.

    :ivar value: Policy Contract value.
    :vartype value: list[~api_management_client.models.PolicyContract]
    :ivar count: Total record count number.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PolicyContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PolicyContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Policy Contract value.
        :paramtype value: list[~api_management_client.models.PolicyContract]
        :keyword count: Total record count number.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(PolicyCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class PolicyContract(Resource):
    """Policy Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar value: Contents of the Policy as defined by the format.
    :vartype value: str
    :ivar format: Format of the policyContent. Possible values include: "xml", "xml-link",
     "rawxml", "rawxml-link". Default value: "xml".
    :vartype format: str or ~api_management_client.models.PolicyContentFormat
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        format: Optional[Union[str, "PolicyContentFormat"]] = "xml",
        **kwargs
    ):
        """
        :keyword value: Contents of the Policy as defined by the format.
        :paramtype value: str
        :keyword format: Format of the policyContent. Possible values include: "xml", "xml-link",
         "rawxml", "rawxml-link". Default value: "xml".
        :paramtype format: str or ~api_management_client.models.PolicyContentFormat
        """
        super(PolicyContract, self).__init__(**kwargs)
        self.value = value
        self.format = format


class PolicyDescriptionCollection(msrest.serialization.Model):
    """Descriptions of APIM policies.

    :ivar value: Descriptions of APIM policies.
    :vartype value: list[~api_management_client.models.PolicyDescriptionContract]
    :ivar count: Total record count number.
    :vartype count: long
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PolicyDescriptionContract]'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PolicyDescriptionContract"]] = None,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword value: Descriptions of APIM policies.
        :paramtype value: list[~api_management_client.models.PolicyDescriptionContract]
        :keyword count: Total record count number.
        :paramtype count: long
        """
        super(PolicyDescriptionCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count


class PolicyDescriptionContract(Resource):
    """Policy description details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar description: Policy description.
    :vartype description: str
    :ivar scope: Binary OR value of the Snippet scope.
    :vartype scope: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'scope': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PolicyDescriptionContract, self).__init__(**kwargs)
        self.description = None
        self.scope = None


class PortalDelegationSettings(Resource):
    """Delegation settings for a developer portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar url: A delegation Url.
    :vartype url: str
    :ivar validation_key: A base64-encoded validation key to validate, that a request is coming
     from Azure API Management.
    :vartype validation_key: str
    :ivar subscriptions: Subscriptions delegation settings.
    :vartype subscriptions: ~api_management_client.models.SubscriptionsDelegationSettingsProperties
    :ivar user_registration: User registration delegation settings.
    :vartype user_registration:
     ~api_management_client.models.RegistrationDelegationSettingsProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'validation_key': {'key': 'properties.validationKey', 'type': 'str'},
        'subscriptions': {'key': 'properties.subscriptions', 'type': 'SubscriptionsDelegationSettingsProperties'},
        'user_registration': {'key': 'properties.userRegistration', 'type': 'RegistrationDelegationSettingsProperties'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        validation_key: Optional[str] = None,
        subscriptions: Optional["SubscriptionsDelegationSettingsProperties"] = None,
        user_registration: Optional["RegistrationDelegationSettingsProperties"] = None,
        **kwargs
    ):
        """
        :keyword url: A delegation Url.
        :paramtype url: str
        :keyword validation_key: A base64-encoded validation key to validate, that a request is coming
         from Azure API Management.
        :paramtype validation_key: str
        :keyword subscriptions: Subscriptions delegation settings.
        :paramtype subscriptions:
         ~api_management_client.models.SubscriptionsDelegationSettingsProperties
        :keyword user_registration: User registration delegation settings.
        :paramtype user_registration:
         ~api_management_client.models.RegistrationDelegationSettingsProperties
        """
        super(PortalDelegationSettings, self).__init__(**kwargs)
        self.url = url
        self.validation_key = validation_key
        self.subscriptions = subscriptions
        self.user_registration = user_registration


class PortalRevisionCollection(msrest.serialization.Model):
    """Paged list of portal revisions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of portal revisions.
    :vartype value: list[~api_management_client.models.PortalRevisionContract]
    :ivar next_link: Next page link, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PortalRevisionContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PortalRevisionCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PortalRevisionContract(Resource):
    """Portal Revision's contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar description: Portal revision description.
    :vartype description: str
    :ivar status_details: Portal revision publishing status details.
    :vartype status_details: str
    :ivar status: Status of the portal's revision. Possible values include: "pending",
     "publishing", "completed", "failed".
    :vartype status: str or ~api_management_client.models.PortalRevisionStatus
    :ivar is_current: Indicates if the portal's revision is public.
    :vartype is_current: bool
    :ivar created_date_time: Portal's revision creation date and time.
    :vartype created_date_time: ~datetime.datetime
    :ivar updated_date_time: Last updated date and time.
    :vartype updated_date_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 2000, 'min_length': 0},
        'status_details': {'readonly': True, 'max_length': 2000, 'min_length': 0},
        'status': {'readonly': True},
        'created_date_time': {'readonly': True},
        'updated_date_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'status_details': {'key': 'properties.statusDetails', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'is_current': {'key': 'properties.isCurrent', 'type': 'bool'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'updated_date_time': {'key': 'properties.updatedDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        is_current: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword description: Portal revision description.
        :paramtype description: str
        :keyword is_current: Indicates if the portal's revision is public.
        :paramtype is_current: bool
        """
        super(PortalRevisionContract, self).__init__(**kwargs)
        self.description = description
        self.status_details = None
        self.status = None
        self.is_current = is_current
        self.created_date_time = None
        self.updated_date_time = None


class PortalSettingsCollection(msrest.serialization.Model):
    """Descriptions of APIM policies.

    :ivar value: Descriptions of APIM policies.
    :vartype value: list[~api_management_client.models.PortalSettingsContract]
    :ivar count: Total record count number.
    :vartype count: long
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PortalSettingsContract]'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PortalSettingsContract"]] = None,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword value: Descriptions of APIM policies.
        :paramtype value: list[~api_management_client.models.PortalSettingsContract]
        :keyword count: Total record count number.
        :paramtype count: long
        """
        super(PortalSettingsCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count


class PortalSettingsContract(Resource):
    """Portal Settings for the Developer Portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar url: A delegation Url.
    :vartype url: str
    :ivar validation_key: A base64-encoded validation key to validate, that a request is coming
     from Azure API Management.
    :vartype validation_key: str
    :ivar subscriptions: Subscriptions delegation settings.
    :vartype subscriptions: ~api_management_client.models.SubscriptionsDelegationSettingsProperties
    :ivar user_registration: User registration delegation settings.
    :vartype user_registration:
     ~api_management_client.models.RegistrationDelegationSettingsProperties
    :ivar enabled: Redirect Anonymous users to the Sign-In page.
    :vartype enabled: bool
    :ivar terms_of_service: Terms of service contract properties.
    :vartype terms_of_service: ~api_management_client.models.TermsOfServiceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'validation_key': {'key': 'properties.validationKey', 'type': 'str'},
        'subscriptions': {'key': 'properties.subscriptions', 'type': 'SubscriptionsDelegationSettingsProperties'},
        'user_registration': {'key': 'properties.userRegistration', 'type': 'RegistrationDelegationSettingsProperties'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'terms_of_service': {'key': 'properties.termsOfService', 'type': 'TermsOfServiceProperties'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        validation_key: Optional[str] = None,
        subscriptions: Optional["SubscriptionsDelegationSettingsProperties"] = None,
        user_registration: Optional["RegistrationDelegationSettingsProperties"] = None,
        enabled: Optional[bool] = None,
        terms_of_service: Optional["TermsOfServiceProperties"] = None,
        **kwargs
    ):
        """
        :keyword url: A delegation Url.
        :paramtype url: str
        :keyword validation_key: A base64-encoded validation key to validate, that a request is coming
         from Azure API Management.
        :paramtype validation_key: str
        :keyword subscriptions: Subscriptions delegation settings.
        :paramtype subscriptions:
         ~api_management_client.models.SubscriptionsDelegationSettingsProperties
        :keyword user_registration: User registration delegation settings.
        :paramtype user_registration:
         ~api_management_client.models.RegistrationDelegationSettingsProperties
        :keyword enabled: Redirect Anonymous users to the Sign-In page.
        :paramtype enabled: bool
        :keyword terms_of_service: Terms of service contract properties.
        :paramtype terms_of_service: ~api_management_client.models.TermsOfServiceProperties
        """
        super(PortalSettingsContract, self).__init__(**kwargs)
        self.url = url
        self.validation_key = validation_key
        self.subscriptions = subscriptions
        self.user_registration = user_registration
        self.enabled = enabled
        self.terms_of_service = terms_of_service


class PortalSettingValidationKeyContract(msrest.serialization.Model):
    """Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.

    :ivar validation_key: This is secret value of the validation key in portal settings.
    :vartype validation_key: str
    """

    _attribute_map = {
        'validation_key': {'key': 'validationKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validation_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword validation_key: This is secret value of the validation key in portal settings.
        :paramtype validation_key: str
        """
        super(PortalSettingValidationKeyContract, self).__init__(**kwargs)
        self.validation_key = validation_key


class PortalSigninSettings(Resource):
    """Sign-In settings for the Developer Portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar enabled: Redirect Anonymous users to the Sign-In page.
    :vartype enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: Redirect Anonymous users to the Sign-In page.
        :paramtype enabled: bool
        """
        super(PortalSigninSettings, self).__init__(**kwargs)
        self.enabled = enabled


class PortalSignupSettings(Resource):
    """Sign-Up settings for a developer portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar enabled: Allow users to sign up on a developer portal.
    :vartype enabled: bool
    :ivar terms_of_service: Terms of service contract properties.
    :vartype terms_of_service: ~api_management_client.models.TermsOfServiceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'terms_of_service': {'key': 'properties.termsOfService', 'type': 'TermsOfServiceProperties'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        terms_of_service: Optional["TermsOfServiceProperties"] = None,
        **kwargs
    ):
        """
        :keyword enabled: Allow users to sign up on a developer portal.
        :paramtype enabled: bool
        :keyword terms_of_service: Terms of service contract properties.
        :paramtype terms_of_service: ~api_management_client.models.TermsOfServiceProperties
        """
        super(PortalSignupSettings, self).__init__(**kwargs)
        self.enabled = enabled
        self.terms_of_service = terms_of_service


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~api_management_client.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~api_management_client.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~api_management_client.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~api_management_client.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~api_management_client.models.PrivateLinkServiceConnectionState
        """
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~api_management_client.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        **kwargs
    ):
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~api_management_client.models.PrivateEndpointConnection]
        """
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value


class PrivateEndpointConnectionRequest(msrest.serialization.Model):
    """A request to approve or reject a private endpoint connection.

    :ivar id: Private Endpoint Connection Resource Id.
    :vartype id: str
    :ivar properties: The connection state of the private endpoint connection.
    :vartype properties: ~api_management_client.models.PrivateEndpointConnectionRequestProperties
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnectionRequestProperties'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        properties: Optional["PrivateEndpointConnectionRequestProperties"] = None,
        **kwargs
    ):
        """
        :keyword id: Private Endpoint Connection Resource Id.
        :paramtype id: str
        :keyword properties: The connection state of the private endpoint connection.
        :paramtype properties: ~api_management_client.models.PrivateEndpointConnectionRequestProperties
        """
        super(PrivateEndpointConnectionRequest, self).__init__(**kwargs)
        self.id = id
        self.properties = properties


class PrivateEndpointConnectionRequestProperties(msrest.serialization.Model):
    """The connection state of the private endpoint connection.

    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~api_management_client.models.PrivateLinkServiceConnectionState
    """

    _attribute_map = {
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(
        self,
        *,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~api_management_client.models.PrivateLinkServiceConnectionState
        """
        super(PrivateEndpointConnectionRequestProperties, self).__init__(**kwargs)
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~api_management_client.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~api_management_client.models.PrivateLinkResource]
        """
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected".
    :vartype status: str or ~api_management_client.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Possible values include: "Pending", "Approved", "Rejected".
        :paramtype status: str or ~api_management_client.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ProductCollection(msrest.serialization.Model):
    """Paged Products list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.ProductContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProductContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ProductContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.ProductContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(ProductCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class ProductContract(Resource):
    """Product details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar description: Product description. May include HTML formatting tags.
    :vartype description: str
    :ivar terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :vartype terms: str
    :ivar subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :vartype subscription_required: bool
    :ivar approval_required: whether subscription approval is required. If false, new subscriptions
     will be approved automatically enabling developers to call the product’s APIs immediately after
     subscribing. If true, administrators must manually approve the subscription before the
     developer can any of the product’s APIs. Can be present only if subscriptionRequired property
     is present and has a value of false.
    :vartype approval_required: bool
    :ivar subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :vartype subscriptions_limit: int
    :ivar state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :vartype state: str or ~api_management_client.models.ProductState
    :ivar display_name: Product name.
    :vartype display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'terms': {'key': 'properties.terms', 'type': 'str'},
        'subscription_required': {'key': 'properties.subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'properties.approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'properties.subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        terms: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        approval_required: Optional[bool] = None,
        subscriptions_limit: Optional[int] = None,
        state: Optional[Union[str, "ProductState"]] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Product description. May include HTML formatting tags.
        :paramtype description: str
        :keyword terms: Product terms of use. Developers trying to subscribe to the product will be
         presented and required to accept these terms before they can complete the subscription process.
        :paramtype terms: str
        :keyword subscription_required: Whether a product subscription is required for accessing APIs
         included in this product. If true, the product is referred to as "protected" and a valid
         subscription key is required for a request to an API included in the product to succeed. If
         false, the product is referred to as "open" and requests to an API included in the product can
         be made without a subscription key. If property is omitted when creating a new product it's
         value is assumed to be true.
        :paramtype subscription_required: bool
        :keyword approval_required: whether subscription approval is required. If false, new
         subscriptions will be approved automatically enabling developers to call the product’s APIs
         immediately after subscribing. If true, administrators must manually approve the subscription
         before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
         property is present and has a value of false.
        :paramtype approval_required: bool
        :keyword subscriptions_limit: Whether the number of subscriptions a user can have to this
         product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be
         present only if subscriptionRequired property is present and has a value of false.
        :paramtype subscriptions_limit: int
        :keyword state: whether product is published or not. Published products are discoverable by
         users of developer portal. Non published products are visible only to administrators. Default
         state of Product is notPublished. Possible values include: "notPublished", "published".
        :paramtype state: str or ~api_management_client.models.ProductState
        :keyword display_name: Product name.
        :paramtype display_name: str
        """
        super(ProductContract, self).__init__(**kwargs)
        self.description = description
        self.terms = terms
        self.subscription_required = subscription_required
        self.approval_required = approval_required
        self.subscriptions_limit = subscriptions_limit
        self.state = state
        self.display_name = display_name


class ProductEntityBaseParameters(msrest.serialization.Model):
    """Product Entity Base Parameters.

    :ivar description: Product description. May include HTML formatting tags.
    :vartype description: str
    :ivar terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :vartype terms: str
    :ivar subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :vartype subscription_required: bool
    :ivar approval_required: whether subscription approval is required. If false, new subscriptions
     will be approved automatically enabling developers to call the product’s APIs immediately after
     subscribing. If true, administrators must manually approve the subscription before the
     developer can any of the product’s APIs. Can be present only if subscriptionRequired property
     is present and has a value of false.
    :vartype approval_required: bool
    :ivar subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :vartype subscriptions_limit: int
    :ivar state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :vartype state: str or ~api_management_client.models.ProductState
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'terms': {'key': 'terms', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        terms: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        approval_required: Optional[bool] = None,
        subscriptions_limit: Optional[int] = None,
        state: Optional[Union[str, "ProductState"]] = None,
        **kwargs
    ):
        """
        :keyword description: Product description. May include HTML formatting tags.
        :paramtype description: str
        :keyword terms: Product terms of use. Developers trying to subscribe to the product will be
         presented and required to accept these terms before they can complete the subscription process.
        :paramtype terms: str
        :keyword subscription_required: Whether a product subscription is required for accessing APIs
         included in this product. If true, the product is referred to as "protected" and a valid
         subscription key is required for a request to an API included in the product to succeed. If
         false, the product is referred to as "open" and requests to an API included in the product can
         be made without a subscription key. If property is omitted when creating a new product it's
         value is assumed to be true.
        :paramtype subscription_required: bool
        :keyword approval_required: whether subscription approval is required. If false, new
         subscriptions will be approved automatically enabling developers to call the product’s APIs
         immediately after subscribing. If true, administrators must manually approve the subscription
         before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
         property is present and has a value of false.
        :paramtype approval_required: bool
        :keyword subscriptions_limit: Whether the number of subscriptions a user can have to this
         product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be
         present only if subscriptionRequired property is present and has a value of false.
        :paramtype subscriptions_limit: int
        :keyword state: whether product is published or not. Published products are discoverable by
         users of developer portal. Non published products are visible only to administrators. Default
         state of Product is notPublished. Possible values include: "notPublished", "published".
        :paramtype state: str or ~api_management_client.models.ProductState
        """
        super(ProductEntityBaseParameters, self).__init__(**kwargs)
        self.description = description
        self.terms = terms
        self.subscription_required = subscription_required
        self.approval_required = approval_required
        self.subscriptions_limit = subscriptions_limit
        self.state = state


class ProductContractProperties(ProductEntityBaseParameters):
    """Product profile.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Product description. May include HTML formatting tags.
    :vartype description: str
    :ivar terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :vartype terms: str
    :ivar subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :vartype subscription_required: bool
    :ivar approval_required: whether subscription approval is required. If false, new subscriptions
     will be approved automatically enabling developers to call the product’s APIs immediately after
     subscribing. If true, administrators must manually approve the subscription before the
     developer can any of the product’s APIs. Can be present only if subscriptionRequired property
     is present and has a value of false.
    :vartype approval_required: bool
    :ivar subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :vartype subscriptions_limit: int
    :ivar state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :vartype state: str or ~api_management_client.models.ProductState
    :ivar display_name: Required. Product name.
    :vartype display_name: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'required': True, 'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'terms': {'key': 'terms', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        description: Optional[str] = None,
        terms: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        approval_required: Optional[bool] = None,
        subscriptions_limit: Optional[int] = None,
        state: Optional[Union[str, "ProductState"]] = None,
        **kwargs
    ):
        """
        :keyword description: Product description. May include HTML formatting tags.
        :paramtype description: str
        :keyword terms: Product terms of use. Developers trying to subscribe to the product will be
         presented and required to accept these terms before they can complete the subscription process.
        :paramtype terms: str
        :keyword subscription_required: Whether a product subscription is required for accessing APIs
         included in this product. If true, the product is referred to as "protected" and a valid
         subscription key is required for a request to an API included in the product to succeed. If
         false, the product is referred to as "open" and requests to an API included in the product can
         be made without a subscription key. If property is omitted when creating a new product it's
         value is assumed to be true.
        :paramtype subscription_required: bool
        :keyword approval_required: whether subscription approval is required. If false, new
         subscriptions will be approved automatically enabling developers to call the product’s APIs
         immediately after subscribing. If true, administrators must manually approve the subscription
         before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
         property is present and has a value of false.
        :paramtype approval_required: bool
        :keyword subscriptions_limit: Whether the number of subscriptions a user can have to this
         product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be
         present only if subscriptionRequired property is present and has a value of false.
        :paramtype subscriptions_limit: int
        :keyword state: whether product is published or not. Published products are discoverable by
         users of developer portal. Non published products are visible only to administrators. Default
         state of Product is notPublished. Possible values include: "notPublished", "published".
        :paramtype state: str or ~api_management_client.models.ProductState
        :keyword display_name: Required. Product name.
        :paramtype display_name: str
        """
        super(ProductContractProperties, self).__init__(description=description, terms=terms, subscription_required=subscription_required, approval_required=approval_required, subscriptions_limit=subscriptions_limit, state=state, **kwargs)
        self.display_name = display_name


class ProductTagResourceContractProperties(ProductEntityBaseParameters):
    """Product profile.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Product description. May include HTML formatting tags.
    :vartype description: str
    :ivar terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :vartype terms: str
    :ivar subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :vartype subscription_required: bool
    :ivar approval_required: whether subscription approval is required. If false, new subscriptions
     will be approved automatically enabling developers to call the product’s APIs immediately after
     subscribing. If true, administrators must manually approve the subscription before the
     developer can any of the product’s APIs. Can be present only if subscriptionRequired property
     is present and has a value of false.
    :vartype approval_required: bool
    :ivar subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :vartype subscriptions_limit: int
    :ivar state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :vartype state: str or ~api_management_client.models.ProductState
    :ivar id: Identifier of the product in the form of /products/{productId}.
    :vartype id: str
    :ivar name: Required. Product name.
    :vartype name: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'name': {'required': True, 'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'terms': {'key': 'terms', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        terms: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        approval_required: Optional[bool] = None,
        subscriptions_limit: Optional[int] = None,
        state: Optional[Union[str, "ProductState"]] = None,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Product description. May include HTML formatting tags.
        :paramtype description: str
        :keyword terms: Product terms of use. Developers trying to subscribe to the product will be
         presented and required to accept these terms before they can complete the subscription process.
        :paramtype terms: str
        :keyword subscription_required: Whether a product subscription is required for accessing APIs
         included in this product. If true, the product is referred to as "protected" and a valid
         subscription key is required for a request to an API included in the product to succeed. If
         false, the product is referred to as "open" and requests to an API included in the product can
         be made without a subscription key. If property is omitted when creating a new product it's
         value is assumed to be true.
        :paramtype subscription_required: bool
        :keyword approval_required: whether subscription approval is required. If false, new
         subscriptions will be approved automatically enabling developers to call the product’s APIs
         immediately after subscribing. If true, administrators must manually approve the subscription
         before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
         property is present and has a value of false.
        :paramtype approval_required: bool
        :keyword subscriptions_limit: Whether the number of subscriptions a user can have to this
         product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be
         present only if subscriptionRequired property is present and has a value of false.
        :paramtype subscriptions_limit: int
        :keyword state: whether product is published or not. Published products are discoverable by
         users of developer portal. Non published products are visible only to administrators. Default
         state of Product is notPublished. Possible values include: "notPublished", "published".
        :paramtype state: str or ~api_management_client.models.ProductState
        :keyword id: Identifier of the product in the form of /products/{productId}.
        :paramtype id: str
        :keyword name: Required. Product name.
        :paramtype name: str
        """
        super(ProductTagResourceContractProperties, self).__init__(description=description, terms=terms, subscription_required=subscription_required, approval_required=approval_required, subscriptions_limit=subscriptions_limit, state=state, **kwargs)
        self.id = id
        self.name = name


class ProductUpdateParameters(msrest.serialization.Model):
    """Product Update parameters.

    :ivar description: Product description. May include HTML formatting tags.
    :vartype description: str
    :ivar terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :vartype terms: str
    :ivar subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :vartype subscription_required: bool
    :ivar approval_required: whether subscription approval is required. If false, new subscriptions
     will be approved automatically enabling developers to call the product’s APIs immediately after
     subscribing. If true, administrators must manually approve the subscription before the
     developer can any of the product’s APIs. Can be present only if subscriptionRequired property
     is present and has a value of false.
    :vartype approval_required: bool
    :ivar subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :vartype subscriptions_limit: int
    :ivar state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :vartype state: str or ~api_management_client.models.ProductState
    :ivar display_name: Product name.
    :vartype display_name: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'terms': {'key': 'properties.terms', 'type': 'str'},
        'subscription_required': {'key': 'properties.subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'properties.approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'properties.subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        terms: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        approval_required: Optional[bool] = None,
        subscriptions_limit: Optional[int] = None,
        state: Optional[Union[str, "ProductState"]] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Product description. May include HTML formatting tags.
        :paramtype description: str
        :keyword terms: Product terms of use. Developers trying to subscribe to the product will be
         presented and required to accept these terms before they can complete the subscription process.
        :paramtype terms: str
        :keyword subscription_required: Whether a product subscription is required for accessing APIs
         included in this product. If true, the product is referred to as "protected" and a valid
         subscription key is required for a request to an API included in the product to succeed. If
         false, the product is referred to as "open" and requests to an API included in the product can
         be made without a subscription key. If property is omitted when creating a new product it's
         value is assumed to be true.
        :paramtype subscription_required: bool
        :keyword approval_required: whether subscription approval is required. If false, new
         subscriptions will be approved automatically enabling developers to call the product’s APIs
         immediately after subscribing. If true, administrators must manually approve the subscription
         before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
         property is present and has a value of false.
        :paramtype approval_required: bool
        :keyword subscriptions_limit: Whether the number of subscriptions a user can have to this
         product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be
         present only if subscriptionRequired property is present and has a value of false.
        :paramtype subscriptions_limit: int
        :keyword state: whether product is published or not. Published products are discoverable by
         users of developer portal. Non published products are visible only to administrators. Default
         state of Product is notPublished. Possible values include: "notPublished", "published".
        :paramtype state: str or ~api_management_client.models.ProductState
        :keyword display_name: Product name.
        :paramtype display_name: str
        """
        super(ProductUpdateParameters, self).__init__(**kwargs)
        self.description = description
        self.terms = terms
        self.subscription_required = subscription_required
        self.approval_required = approval_required
        self.subscriptions_limit = subscriptions_limit
        self.state = state
        self.display_name = display_name


class ProductUpdateProperties(ProductEntityBaseParameters):
    """Parameters supplied to the Update Product operation.

    :ivar description: Product description. May include HTML formatting tags.
    :vartype description: str
    :ivar terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :vartype terms: str
    :ivar subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :vartype subscription_required: bool
    :ivar approval_required: whether subscription approval is required. If false, new subscriptions
     will be approved automatically enabling developers to call the product’s APIs immediately after
     subscribing. If true, administrators must manually approve the subscription before the
     developer can any of the product’s APIs. Can be present only if subscriptionRequired property
     is present and has a value of false.
    :vartype approval_required: bool
    :ivar subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :vartype subscriptions_limit: int
    :ivar state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :vartype state: str or ~api_management_client.models.ProductState
    :ivar display_name: Product name.
    :vartype display_name: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'terms': {'key': 'terms', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        terms: Optional[str] = None,
        subscription_required: Optional[bool] = None,
        approval_required: Optional[bool] = None,
        subscriptions_limit: Optional[int] = None,
        state: Optional[Union[str, "ProductState"]] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Product description. May include HTML formatting tags.
        :paramtype description: str
        :keyword terms: Product terms of use. Developers trying to subscribe to the product will be
         presented and required to accept these terms before they can complete the subscription process.
        :paramtype terms: str
        :keyword subscription_required: Whether a product subscription is required for accessing APIs
         included in this product. If true, the product is referred to as "protected" and a valid
         subscription key is required for a request to an API included in the product to succeed. If
         false, the product is referred to as "open" and requests to an API included in the product can
         be made without a subscription key. If property is omitted when creating a new product it's
         value is assumed to be true.
        :paramtype subscription_required: bool
        :keyword approval_required: whether subscription approval is required. If false, new
         subscriptions will be approved automatically enabling developers to call the product’s APIs
         immediately after subscribing. If true, administrators must manually approve the subscription
         before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
         property is present and has a value of false.
        :paramtype approval_required: bool
        :keyword subscriptions_limit: Whether the number of subscriptions a user can have to this
         product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be
         present only if subscriptionRequired property is present and has a value of false.
        :paramtype subscriptions_limit: int
        :keyword state: whether product is published or not. Published products are discoverable by
         users of developer portal. Non published products are visible only to administrators. Default
         state of Product is notPublished. Possible values include: "notPublished", "published".
        :paramtype state: str or ~api_management_client.models.ProductState
        :keyword display_name: Product name.
        :paramtype display_name: str
        """
        super(ProductUpdateProperties, self).__init__(description=description, terms=terms, subscription_required=subscription_required, approval_required=approval_required, subscriptions_limit=subscriptions_limit, state=state, **kwargs)
        self.display_name = display_name


class QuotaCounterCollection(msrest.serialization.Model):
    """Paged Quota Counter list representation.

    :ivar value: Quota counter values.
    :vartype value: list[~api_management_client.models.QuotaCounterContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QuotaCounterContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["QuotaCounterContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Quota counter values.
        :paramtype value: list[~api_management_client.models.QuotaCounterContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(QuotaCounterCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class QuotaCounterContract(msrest.serialization.Model):
    """Quota counter details.

    All required parameters must be populated in order to send to Azure.

    :ivar counter_key: Required. The Key value of the Counter. Must not be empty.
    :vartype counter_key: str
    :ivar period_key: Required. Identifier of the Period for which the counter was collected. Must
     not be empty.
    :vartype period_key: str
    :ivar period_start_time: Required. The date of the start of Counter Period. The date conforms
     to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype period_start_time: ~datetime.datetime
    :ivar period_end_time: Required. The date of the end of Counter Period. The date conforms to
     the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype period_end_time: ~datetime.datetime
    :ivar value: Quota Value Properties.
    :vartype value: ~api_management_client.models.QuotaCounterValueContractProperties
    """

    _validation = {
        'counter_key': {'required': True, 'min_length': 1},
        'period_key': {'required': True, 'min_length': 1},
        'period_start_time': {'required': True},
        'period_end_time': {'required': True},
    }

    _attribute_map = {
        'counter_key': {'key': 'counterKey', 'type': 'str'},
        'period_key': {'key': 'periodKey', 'type': 'str'},
        'period_start_time': {'key': 'periodStartTime', 'type': 'iso-8601'},
        'period_end_time': {'key': 'periodEndTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'QuotaCounterValueContractProperties'},
    }

    def __init__(
        self,
        *,
        counter_key: str,
        period_key: str,
        period_start_time: datetime.datetime,
        period_end_time: datetime.datetime,
        value: Optional["QuotaCounterValueContractProperties"] = None,
        **kwargs
    ):
        """
        :keyword counter_key: Required. The Key value of the Counter. Must not be empty.
        :paramtype counter_key: str
        :keyword period_key: Required. Identifier of the Period for which the counter was collected.
         Must not be empty.
        :paramtype period_key: str
        :keyword period_start_time: Required. The date of the start of Counter Period. The date
         conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601
         standard.
        :paramtype period_start_time: ~datetime.datetime
        :keyword period_end_time: Required. The date of the end of Counter Period. The date conforms to
         the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype period_end_time: ~datetime.datetime
        :keyword value: Quota Value Properties.
        :paramtype value: ~api_management_client.models.QuotaCounterValueContractProperties
        """
        super(QuotaCounterContract, self).__init__(**kwargs)
        self.counter_key = counter_key
        self.period_key = period_key
        self.period_start_time = period_start_time
        self.period_end_time = period_end_time
        self.value = value


class QuotaCounterValueContract(msrest.serialization.Model):
    """Quota counter value details.

    :ivar calls_count: Number of times Counter was called.
    :vartype calls_count: int
    :ivar kb_transferred: Data Transferred in KiloBytes.
    :vartype kb_transferred: float
    """

    _attribute_map = {
        'calls_count': {'key': 'value.callsCount', 'type': 'int'},
        'kb_transferred': {'key': 'value.kbTransferred', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        calls_count: Optional[int] = None,
        kb_transferred: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword calls_count: Number of times Counter was called.
        :paramtype calls_count: int
        :keyword kb_transferred: Data Transferred in KiloBytes.
        :paramtype kb_transferred: float
        """
        super(QuotaCounterValueContract, self).__init__(**kwargs)
        self.calls_count = calls_count
        self.kb_transferred = kb_transferred


class QuotaCounterValueContractProperties(msrest.serialization.Model):
    """Quota counter value details.

    :ivar calls_count: Number of times Counter was called.
    :vartype calls_count: int
    :ivar kb_transferred: Data Transferred in KiloBytes.
    :vartype kb_transferred: float
    """

    _attribute_map = {
        'calls_count': {'key': 'callsCount', 'type': 'int'},
        'kb_transferred': {'key': 'kbTransferred', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        calls_count: Optional[int] = None,
        kb_transferred: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword calls_count: Number of times Counter was called.
        :paramtype calls_count: int
        :keyword kb_transferred: Data Transferred in KiloBytes.
        :paramtype kb_transferred: float
        """
        super(QuotaCounterValueContractProperties, self).__init__(**kwargs)
        self.calls_count = calls_count
        self.kb_transferred = kb_transferred


class QuotaCounterValueUpdateContract(msrest.serialization.Model):
    """Quota counter value details.

    :ivar calls_count: Number of times Counter was called.
    :vartype calls_count: int
    :ivar kb_transferred: Data Transferred in KiloBytes.
    :vartype kb_transferred: float
    """

    _attribute_map = {
        'calls_count': {'key': 'properties.callsCount', 'type': 'int'},
        'kb_transferred': {'key': 'properties.kbTransferred', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        calls_count: Optional[int] = None,
        kb_transferred: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword calls_count: Number of times Counter was called.
        :paramtype calls_count: int
        :keyword kb_transferred: Data Transferred in KiloBytes.
        :paramtype kb_transferred: float
        """
        super(QuotaCounterValueUpdateContract, self).__init__(**kwargs)
        self.calls_count = calls_count
        self.kb_transferred = kb_transferred


class RecipientEmailCollection(msrest.serialization.Model):
    """Paged Recipient User list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.RecipientEmailContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecipientEmailContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RecipientEmailContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.RecipientEmailContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(RecipientEmailCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class RecipientEmailContract(Resource):
    """Recipient Email details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar email: User Email subscribed to notification.
    :vartype email: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email': {'key': 'properties.email', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword email: User Email subscribed to notification.
        :paramtype email: str
        """
        super(RecipientEmailContract, self).__init__(**kwargs)
        self.email = email


class RecipientsContractProperties(msrest.serialization.Model):
    """Notification Parameter contract.

    :ivar emails: List of Emails subscribed for the notification.
    :vartype emails: list[str]
    :ivar users: List of Users subscribed for the notification.
    :vartype users: list[str]
    """

    _attribute_map = {
        'emails': {'key': 'emails', 'type': '[str]'},
        'users': {'key': 'users', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        emails: Optional[List[str]] = None,
        users: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword emails: List of Emails subscribed for the notification.
        :paramtype emails: list[str]
        :keyword users: List of Users subscribed for the notification.
        :paramtype users: list[str]
        """
        super(RecipientsContractProperties, self).__init__(**kwargs)
        self.emails = emails
        self.users = users


class RecipientUserCollection(msrest.serialization.Model):
    """Paged Recipient User list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.RecipientUserContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecipientUserContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RecipientUserContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.RecipientUserContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(RecipientUserCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class RecipientUserContract(Resource):
    """Recipient User details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar user_id: API Management UserId subscribed to notification.
    :vartype user_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_id: API Management UserId subscribed to notification.
        :paramtype user_id: str
        """
        super(RecipientUserContract, self).__init__(**kwargs)
        self.user_id = user_id


class RegionContract(msrest.serialization.Model):
    """Region profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Region name.
    :vartype name: str
    :ivar is_master_region: whether Region is the master region.
    :vartype is_master_region: bool
    :ivar is_deleted: whether Region is deleted.
    :vartype is_deleted: bool
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_master_region': {'key': 'isMasterRegion', 'type': 'bool'},
        'is_deleted': {'key': 'isDeleted', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_master_region: Optional[bool] = None,
        is_deleted: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword is_master_region: whether Region is the master region.
        :paramtype is_master_region: bool
        :keyword is_deleted: whether Region is deleted.
        :paramtype is_deleted: bool
        """
        super(RegionContract, self).__init__(**kwargs)
        self.name = None
        self.is_master_region = is_master_region
        self.is_deleted = is_deleted


class RegionListResult(msrest.serialization.Model):
    """Lists Regions operation response details.

    :ivar value: Lists of Regions.
    :vartype value: list[~api_management_client.models.RegionContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RegionContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RegionContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Lists of Regions.
        :paramtype value: list[~api_management_client.models.RegionContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(RegionListResult, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class RegistrationDelegationSettingsProperties(msrest.serialization.Model):
    """User registration delegation settings properties.

    :ivar enabled: Enable or disable delegation for user registration.
    :vartype enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: Enable or disable delegation for user registration.
        :paramtype enabled: bool
        """
        super(RegistrationDelegationSettingsProperties, self).__init__(**kwargs)
        self.enabled = enabled


class RemotePrivateEndpointConnectionWrapper(msrest.serialization.Model):
    """Remote Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Private Endpoint connection resource id.
    :vartype id: str
    :ivar name: Private Endpoint Connection Name.
    :vartype name: str
    :ivar type: Private Endpoint Connection Resource Type.
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~api_management_client.models.ArmIdWrapper
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~api_management_client.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
    :vartype provisioning_state: str
    :ivar group_ids: All the Group ids.
    :vartype group_ids: list[str]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'group_ids': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'ArmIdWrapper'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'group_ids': {'key': 'properties.groupIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        private_endpoint: Optional["ArmIdWrapper"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword id: Private Endpoint connection resource id.
        :paramtype id: str
        :keyword name: Private Endpoint Connection Name.
        :paramtype name: str
        :keyword type: Private Endpoint Connection Resource Type.
        :paramtype type: str
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~api_management_client.models.ArmIdWrapper
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~api_management_client.models.PrivateLinkServiceConnectionState
        """
        super(RemotePrivateEndpointConnectionWrapper, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None
        self.group_ids = None


class ReportCollection(msrest.serialization.Model):
    """Paged Report records list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.ReportRecordContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReportRecordContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ReportRecordContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.ReportRecordContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(ReportCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class ReportRecordContract(msrest.serialization.Model):
    """Report data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name depending on report endpoint specifies product, API, operation or developer
     name.
    :vartype name: str
    :ivar timestamp: Start of aggregation period. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype timestamp: ~datetime.datetime
    :ivar interval: Length of aggregation period.  Interval must be multiple of 15 minutes and may
     not be zero. The value should be in ISO 8601 format
     (http://en.wikipedia.org/wiki/ISO_8601#Durations).
    :vartype interval: str
    :ivar country: Country to which this record data is related.
    :vartype country: str
    :ivar region: Country region to which this record data is related.
    :vartype region: str
    :ivar zip: Zip code to which this record data is related.
    :vartype zip: str
    :ivar user_id: User identifier path. /users/{userId}.
    :vartype user_id: str
    :ivar product_id: Product identifier path. /products/{productId}.
    :vartype product_id: str
    :ivar api_id: API identifier path. /apis/{apiId}.
    :vartype api_id: str
    :ivar operation_id: Operation identifier path. /apis/{apiId}/operations/{operationId}.
    :vartype operation_id: str
    :ivar api_region: API region identifier.
    :vartype api_region: str
    :ivar subscription_id: Subscription identifier path. /subscriptions/{subscriptionId}.
    :vartype subscription_id: str
    :ivar call_count_success: Number of successful calls. This includes calls returning
     HttpStatusCode <= 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect.
    :vartype call_count_success: int
    :ivar call_count_blocked: Number of calls blocked due to invalid credentials. This includes
     calls returning HttpStatusCode.Unauthorized and HttpStatusCode.Forbidden and
     HttpStatusCode.TooManyRequests.
    :vartype call_count_blocked: int
    :ivar call_count_failed: Number of calls failed due to proxy or backend errors. This includes
     calls returning HttpStatusCode.BadRequest(400) and any Code between
     HttpStatusCode.InternalServerError (500) and 600.
    :vartype call_count_failed: int
    :ivar call_count_other: Number of other calls.
    :vartype call_count_other: int
    :ivar call_count_total: Total number of calls.
    :vartype call_count_total: int
    :ivar bandwidth: Bandwidth consumed.
    :vartype bandwidth: long
    :ivar cache_hit_count: Number of times when content was served from cache policy.
    :vartype cache_hit_count: int
    :ivar cache_miss_count: Number of times content was fetched from backend.
    :vartype cache_miss_count: int
    :ivar api_time_avg: Average time it took to process request.
    :vartype api_time_avg: float
    :ivar api_time_min: Minimum time it took to process request.
    :vartype api_time_min: float
    :ivar api_time_max: Maximum time it took to process request.
    :vartype api_time_max: float
    :ivar service_time_avg: Average time it took to process request on backend.
    :vartype service_time_avg: float
    :ivar service_time_min: Minimum time it took to process request on backend.
    :vartype service_time_min: float
    :ivar service_time_max: Maximum time it took to process request on backend.
    :vartype service_time_max: float
    """

    _validation = {
        'user_id': {'readonly': True},
        'product_id': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'interval': {'key': 'interval', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'zip': {'key': 'zip', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
        'product_id': {'key': 'productId', 'type': 'str'},
        'api_id': {'key': 'apiId', 'type': 'str'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'api_region': {'key': 'apiRegion', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'call_count_success': {'key': 'callCountSuccess', 'type': 'int'},
        'call_count_blocked': {'key': 'callCountBlocked', 'type': 'int'},
        'call_count_failed': {'key': 'callCountFailed', 'type': 'int'},
        'call_count_other': {'key': 'callCountOther', 'type': 'int'},
        'call_count_total': {'key': 'callCountTotal', 'type': 'int'},
        'bandwidth': {'key': 'bandwidth', 'type': 'long'},
        'cache_hit_count': {'key': 'cacheHitCount', 'type': 'int'},
        'cache_miss_count': {'key': 'cacheMissCount', 'type': 'int'},
        'api_time_avg': {'key': 'apiTimeAvg', 'type': 'float'},
        'api_time_min': {'key': 'apiTimeMin', 'type': 'float'},
        'api_time_max': {'key': 'apiTimeMax', 'type': 'float'},
        'service_time_avg': {'key': 'serviceTimeAvg', 'type': 'float'},
        'service_time_min': {'key': 'serviceTimeMin', 'type': 'float'},
        'service_time_max': {'key': 'serviceTimeMax', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        interval: Optional[str] = None,
        country: Optional[str] = None,
        region: Optional[str] = None,
        zip: Optional[str] = None,
        api_id: Optional[str] = None,
        operation_id: Optional[str] = None,
        api_region: Optional[str] = None,
        subscription_id: Optional[str] = None,
        call_count_success: Optional[int] = None,
        call_count_blocked: Optional[int] = None,
        call_count_failed: Optional[int] = None,
        call_count_other: Optional[int] = None,
        call_count_total: Optional[int] = None,
        bandwidth: Optional[int] = None,
        cache_hit_count: Optional[int] = None,
        cache_miss_count: Optional[int] = None,
        api_time_avg: Optional[float] = None,
        api_time_min: Optional[float] = None,
        api_time_max: Optional[float] = None,
        service_time_avg: Optional[float] = None,
        service_time_min: Optional[float] = None,
        service_time_max: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword name: Name depending on report endpoint specifies product, API, operation or developer
         name.
        :paramtype name: str
        :keyword timestamp: Start of aggregation period. The date conforms to the following format:
         ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype timestamp: ~datetime.datetime
        :keyword interval: Length of aggregation period.  Interval must be multiple of 15 minutes and
         may not be zero. The value should be in ISO 8601 format
         (http://en.wikipedia.org/wiki/ISO_8601#Durations).
        :paramtype interval: str
        :keyword country: Country to which this record data is related.
        :paramtype country: str
        :keyword region: Country region to which this record data is related.
        :paramtype region: str
        :keyword zip: Zip code to which this record data is related.
        :paramtype zip: str
        :keyword api_id: API identifier path. /apis/{apiId}.
        :paramtype api_id: str
        :keyword operation_id: Operation identifier path. /apis/{apiId}/operations/{operationId}.
        :paramtype operation_id: str
        :keyword api_region: API region identifier.
        :paramtype api_region: str
        :keyword subscription_id: Subscription identifier path. /subscriptions/{subscriptionId}.
        :paramtype subscription_id: str
        :keyword call_count_success: Number of successful calls. This includes calls returning
         HttpStatusCode <= 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect.
        :paramtype call_count_success: int
        :keyword call_count_blocked: Number of calls blocked due to invalid credentials. This includes
         calls returning HttpStatusCode.Unauthorized and HttpStatusCode.Forbidden and
         HttpStatusCode.TooManyRequests.
        :paramtype call_count_blocked: int
        :keyword call_count_failed: Number of calls failed due to proxy or backend errors. This
         includes calls returning HttpStatusCode.BadRequest(400) and any Code between
         HttpStatusCode.InternalServerError (500) and 600.
        :paramtype call_count_failed: int
        :keyword call_count_other: Number of other calls.
        :paramtype call_count_other: int
        :keyword call_count_total: Total number of calls.
        :paramtype call_count_total: int
        :keyword bandwidth: Bandwidth consumed.
        :paramtype bandwidth: long
        :keyword cache_hit_count: Number of times when content was served from cache policy.
        :paramtype cache_hit_count: int
        :keyword cache_miss_count: Number of times content was fetched from backend.
        :paramtype cache_miss_count: int
        :keyword api_time_avg: Average time it took to process request.
        :paramtype api_time_avg: float
        :keyword api_time_min: Minimum time it took to process request.
        :paramtype api_time_min: float
        :keyword api_time_max: Maximum time it took to process request.
        :paramtype api_time_max: float
        :keyword service_time_avg: Average time it took to process request on backend.
        :paramtype service_time_avg: float
        :keyword service_time_min: Minimum time it took to process request on backend.
        :paramtype service_time_min: float
        :keyword service_time_max: Maximum time it took to process request on backend.
        :paramtype service_time_max: float
        """
        super(ReportRecordContract, self).__init__(**kwargs)
        self.name = name
        self.timestamp = timestamp
        self.interval = interval
        self.country = country
        self.region = region
        self.zip = zip
        self.user_id = None
        self.product_id = None
        self.api_id = api_id
        self.operation_id = operation_id
        self.api_region = api_region
        self.subscription_id = subscription_id
        self.call_count_success = call_count_success
        self.call_count_blocked = call_count_blocked
        self.call_count_failed = call_count_failed
        self.call_count_other = call_count_other
        self.call_count_total = call_count_total
        self.bandwidth = bandwidth
        self.cache_hit_count = cache_hit_count
        self.cache_miss_count = cache_miss_count
        self.api_time_avg = api_time_avg
        self.api_time_min = api_time_min
        self.api_time_max = api_time_max
        self.service_time_avg = service_time_avg
        self.service_time_min = service_time_min
        self.service_time_max = service_time_max


class RepresentationContract(msrest.serialization.Model):
    """Operation request/response representation details.

    All required parameters must be populated in order to send to Azure.

    :ivar content_type: Required. Specifies a registered or custom content type for this
     representation, e.g. application/xml.
    :vartype content_type: str
    :ivar schema_id: Schema identifier. Applicable only if 'contentType' value is neither
     'application/x-www-form-urlencoded' nor 'multipart/form-data'.
    :vartype schema_id: str
    :ivar type_name: Type name defined by the schema. Applicable only if 'contentType' value is
     neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
    :vartype type_name: str
    :ivar form_parameters: Collection of form parameters. Required if 'contentType' value is either
     'application/x-www-form-urlencoded' or 'multipart/form-data'..
    :vartype form_parameters: list[~api_management_client.models.ParameterContract]
    :ivar examples: Exampled defined for the representation.
    :vartype examples: dict[str, ~api_management_client.models.ParameterExampleContract]
    """

    _validation = {
        'content_type': {'required': True},
    }

    _attribute_map = {
        'content_type': {'key': 'contentType', 'type': 'str'},
        'schema_id': {'key': 'schemaId', 'type': 'str'},
        'type_name': {'key': 'typeName', 'type': 'str'},
        'form_parameters': {'key': 'formParameters', 'type': '[ParameterContract]'},
        'examples': {'key': 'examples', 'type': '{ParameterExampleContract}'},
    }

    def __init__(
        self,
        *,
        content_type: str,
        schema_id: Optional[str] = None,
        type_name: Optional[str] = None,
        form_parameters: Optional[List["ParameterContract"]] = None,
        examples: Optional[Dict[str, "ParameterExampleContract"]] = None,
        **kwargs
    ):
        """
        :keyword content_type: Required. Specifies a registered or custom content type for this
         representation, e.g. application/xml.
        :paramtype content_type: str
        :keyword schema_id: Schema identifier. Applicable only if 'contentType' value is neither
         'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        :paramtype schema_id: str
        :keyword type_name: Type name defined by the schema. Applicable only if 'contentType' value is
         neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        :paramtype type_name: str
        :keyword form_parameters: Collection of form parameters. Required if 'contentType' value is
         either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
        :paramtype form_parameters: list[~api_management_client.models.ParameterContract]
        :keyword examples: Exampled defined for the representation.
        :paramtype examples: dict[str, ~api_management_client.models.ParameterExampleContract]
        """
        super(RepresentationContract, self).__init__(**kwargs)
        self.content_type = content_type
        self.schema_id = schema_id
        self.type_name = type_name
        self.form_parameters = form_parameters
        self.examples = examples


class RequestContract(msrest.serialization.Model):
    """Operation request details.

    :ivar description: Operation request description.
    :vartype description: str
    :ivar query_parameters: Collection of operation request query parameters.
    :vartype query_parameters: list[~api_management_client.models.ParameterContract]
    :ivar headers: Collection of operation request headers.
    :vartype headers: list[~api_management_client.models.ParameterContract]
    :ivar representations: Collection of operation request representations.
    :vartype representations: list[~api_management_client.models.RepresentationContract]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'query_parameters': {'key': 'queryParameters', 'type': '[ParameterContract]'},
        'headers': {'key': 'headers', 'type': '[ParameterContract]'},
        'representations': {'key': 'representations', 'type': '[RepresentationContract]'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        query_parameters: Optional[List["ParameterContract"]] = None,
        headers: Optional[List["ParameterContract"]] = None,
        representations: Optional[List["RepresentationContract"]] = None,
        **kwargs
    ):
        """
        :keyword description: Operation request description.
        :paramtype description: str
        :keyword query_parameters: Collection of operation request query parameters.
        :paramtype query_parameters: list[~api_management_client.models.ParameterContract]
        :keyword headers: Collection of operation request headers.
        :paramtype headers: list[~api_management_client.models.ParameterContract]
        :keyword representations: Collection of operation request representations.
        :paramtype representations: list[~api_management_client.models.RepresentationContract]
        """
        super(RequestContract, self).__init__(**kwargs)
        self.description = description
        self.query_parameters = query_parameters
        self.headers = headers
        self.representations = representations


class RequestReportCollection(msrest.serialization.Model):
    """Paged Report records list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.RequestReportRecordContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RequestReportRecordContract]'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RequestReportRecordContract"]] = None,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.RequestReportRecordContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        """
        super(RequestReportCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count


class RequestReportRecordContract(msrest.serialization.Model):
    """Request Report data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar api_id: API identifier path. /apis/{apiId}.
    :vartype api_id: str
    :ivar operation_id: Operation identifier path. /apis/{apiId}/operations/{operationId}.
    :vartype operation_id: str
    :ivar product_id: Product identifier path. /products/{productId}.
    :vartype product_id: str
    :ivar user_id: User identifier path. /users/{userId}.
    :vartype user_id: str
    :ivar method: The HTTP method associated with this request..
    :vartype method: str
    :ivar url: The full URL associated with this request.
    :vartype url: str
    :ivar ip_address: The client IP address associated with this request.
    :vartype ip_address: str
    :ivar backend_response_code: The HTTP status code received by the gateway as a result of
     forwarding this request to the backend.
    :vartype backend_response_code: str
    :ivar response_code: The HTTP status code returned by the gateway.
    :vartype response_code: int
    :ivar response_size: The size of the response returned by the gateway.
    :vartype response_size: int
    :ivar timestamp: The date and time when this request was received by the gateway in ISO 8601
     format.
    :vartype timestamp: ~datetime.datetime
    :ivar cache: Specifies if response cache was involved in generating the response. If the value
     is none, the cache was not used. If the value is hit, cached response was returned. If the
     value is miss, the cache was used but lookup resulted in a miss and request was fulfilled by
     the backend.
    :vartype cache: str
    :ivar api_time: The total time it took to process this request.
    :vartype api_time: float
    :ivar service_time: he time it took to forward this request to the backend and get the response
     back.
    :vartype service_time: float
    :ivar api_region: Azure region where the gateway that processed this request is located.
    :vartype api_region: str
    :ivar subscription_id: Subscription identifier path. /subscriptions/{subscriptionId}.
    :vartype subscription_id: str
    :ivar request_id: Request Identifier.
    :vartype request_id: str
    :ivar request_size: The size of this request..
    :vartype request_size: int
    """

    _validation = {
        'product_id': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'api_id': {'key': 'apiId', 'type': 'str'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'product_id': {'key': 'productId', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'backend_response_code': {'key': 'backendResponseCode', 'type': 'str'},
        'response_code': {'key': 'responseCode', 'type': 'int'},
        'response_size': {'key': 'responseSize', 'type': 'int'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'cache': {'key': 'cache', 'type': 'str'},
        'api_time': {'key': 'apiTime', 'type': 'float'},
        'service_time': {'key': 'serviceTime', 'type': 'float'},
        'api_region': {'key': 'apiRegion', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'request_size': {'key': 'requestSize', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        api_id: Optional[str] = None,
        operation_id: Optional[str] = None,
        method: Optional[str] = None,
        url: Optional[str] = None,
        ip_address: Optional[str] = None,
        backend_response_code: Optional[str] = None,
        response_code: Optional[int] = None,
        response_size: Optional[int] = None,
        timestamp: Optional[datetime.datetime] = None,
        cache: Optional[str] = None,
        api_time: Optional[float] = None,
        service_time: Optional[float] = None,
        api_region: Optional[str] = None,
        subscription_id: Optional[str] = None,
        request_id: Optional[str] = None,
        request_size: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword api_id: API identifier path. /apis/{apiId}.
        :paramtype api_id: str
        :keyword operation_id: Operation identifier path. /apis/{apiId}/operations/{operationId}.
        :paramtype operation_id: str
        :keyword method: The HTTP method associated with this request..
        :paramtype method: str
        :keyword url: The full URL associated with this request.
        :paramtype url: str
        :keyword ip_address: The client IP address associated with this request.
        :paramtype ip_address: str
        :keyword backend_response_code: The HTTP status code received by the gateway as a result of
         forwarding this request to the backend.
        :paramtype backend_response_code: str
        :keyword response_code: The HTTP status code returned by the gateway.
        :paramtype response_code: int
        :keyword response_size: The size of the response returned by the gateway.
        :paramtype response_size: int
        :keyword timestamp: The date and time when this request was received by the gateway in ISO 8601
         format.
        :paramtype timestamp: ~datetime.datetime
        :keyword cache: Specifies if response cache was involved in generating the response. If the
         value is none, the cache was not used. If the value is hit, cached response was returned. If
         the value is miss, the cache was used but lookup resulted in a miss and request was fulfilled
         by the backend.
        :paramtype cache: str
        :keyword api_time: The total time it took to process this request.
        :paramtype api_time: float
        :keyword service_time: he time it took to forward this request to the backend and get the
         response back.
        :paramtype service_time: float
        :keyword api_region: Azure region where the gateway that processed this request is located.
        :paramtype api_region: str
        :keyword subscription_id: Subscription identifier path. /subscriptions/{subscriptionId}.
        :paramtype subscription_id: str
        :keyword request_id: Request Identifier.
        :paramtype request_id: str
        :keyword request_size: The size of this request..
        :paramtype request_size: int
        """
        super(RequestReportRecordContract, self).__init__(**kwargs)
        self.api_id = api_id
        self.operation_id = operation_id
        self.product_id = None
        self.user_id = None
        self.method = method
        self.url = url
        self.ip_address = ip_address
        self.backend_response_code = backend_response_code
        self.response_code = response_code
        self.response_size = response_size
        self.timestamp = timestamp
        self.cache = cache
        self.api_time = api_time
        self.service_time = service_time
        self.api_region = api_region
        self.subscription_id = subscription_id
        self.request_id = request_id
        self.request_size = request_size


class ResourceLocationDataContract(msrest.serialization.Model):
    """Resource location data properties.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. A canonical name for the geographic or physical location.
    :vartype name: str
    :ivar city: The city or locality where the resource is located.
    :vartype city: str
    :ivar district: The district, state, or province where the resource is located.
    :vartype district: str
    :ivar country_or_region: The country or region where the resource is located.
    :vartype country_or_region: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 256, 'min_length': 0},
        'city': {'max_length': 256, 'min_length': 0},
        'district': {'max_length': 256, 'min_length': 0},
        'country_or_region': {'max_length': 256, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'district': {'key': 'district', 'type': 'str'},
        'country_or_region': {'key': 'countryOrRegion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        city: Optional[str] = None,
        district: Optional[str] = None,
        country_or_region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. A canonical name for the geographic or physical location.
        :paramtype name: str
        :keyword city: The city or locality where the resource is located.
        :paramtype city: str
        :keyword district: The district, state, or province where the resource is located.
        :paramtype district: str
        :keyword country_or_region: The country or region where the resource is located.
        :paramtype country_or_region: str
        """
        super(ResourceLocationDataContract, self).__init__(**kwargs)
        self.name = name
        self.city = city
        self.district = district
        self.country_or_region = country_or_region


class ResourceSku(msrest.serialization.Model):
    """Describes an available API Management SKU.

    :ivar name: Name of the Sku. Possible values include: "Developer", "Standard", "Premium",
     "Basic", "Consumption", "Isolated".
    :vartype name: str or ~api_management_client.models.SkuType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "SkuType"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the Sku. Possible values include: "Developer", "Standard", "Premium",
         "Basic", "Consumption", "Isolated".
        :paramtype name: str or ~api_management_client.models.SkuType
        """
        super(ResourceSku, self).__init__(**kwargs)
        self.name = name


class ResourceSkuCapacity(msrest.serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar scale_type: The scale type applicable to the sku. Possible values include: "automatic",
     "manual", "none".
    :vartype scale_type: str or ~api_management_client.models.ResourceSkuCapacityScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class ResourceSkuResult(msrest.serialization.Model):
    """Describes an available API Management service SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar sku: Specifies API Management SKU.
    :vartype sku: ~api_management_client.models.ResourceSku
    :ivar capacity: Specifies the number of API Management units.
    :vartype capacity: ~api_management_client.models.ResourceSkuCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'readonly': True},
        'capacity': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'capacity': {'key': 'capacity', 'type': 'ResourceSkuCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceSkuResult, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class ResourceSkuResults(msrest.serialization.Model):
    """The API Management service SKUs operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The list of skus available for the service.
    :vartype value: list[~api_management_client.models.ResourceSkuResult]
    :ivar next_link: The uri to fetch the next page of API Management service Skus.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceSkuResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ResourceSkuResult"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. The list of skus available for the service.
        :paramtype value: list[~api_management_client.models.ResourceSkuResult]
        :keyword next_link: The uri to fetch the next page of API Management service Skus.
        :paramtype next_link: str
        """
        super(ResourceSkuResults, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResponseContract(msrest.serialization.Model):
    """Operation response details.

    All required parameters must be populated in order to send to Azure.

    :ivar status_code: Required. Operation response HTTP status code.
    :vartype status_code: int
    :ivar description: Operation response description.
    :vartype description: str
    :ivar representations: Collection of operation response representations.
    :vartype representations: list[~api_management_client.models.RepresentationContract]
    :ivar headers: Collection of operation response headers.
    :vartype headers: list[~api_management_client.models.ParameterContract]
    """

    _validation = {
        'status_code': {'required': True},
    }

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'description': {'key': 'description', 'type': 'str'},
        'representations': {'key': 'representations', 'type': '[RepresentationContract]'},
        'headers': {'key': 'headers', 'type': '[ParameterContract]'},
    }

    def __init__(
        self,
        *,
        status_code: int,
        description: Optional[str] = None,
        representations: Optional[List["RepresentationContract"]] = None,
        headers: Optional[List["ParameterContract"]] = None,
        **kwargs
    ):
        """
        :keyword status_code: Required. Operation response HTTP status code.
        :paramtype status_code: int
        :keyword description: Operation response description.
        :paramtype description: str
        :keyword representations: Collection of operation response representations.
        :paramtype representations: list[~api_management_client.models.RepresentationContract]
        :keyword headers: Collection of operation response headers.
        :paramtype headers: list[~api_management_client.models.ParameterContract]
        """
        super(ResponseContract, self).__init__(**kwargs)
        self.status_code = status_code
        self.description = description
        self.representations = representations
        self.headers = headers


class SamplingSettings(msrest.serialization.Model):
    """Sampling settings for Diagnostic.

    :ivar sampling_type: Sampling type. Possible values include: "fixed".
    :vartype sampling_type: str or ~api_management_client.models.SamplingType
    :ivar percentage: Rate of sampling for fixed-rate sampling.
    :vartype percentage: float
    """

    _validation = {
        'percentage': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'sampling_type': {'key': 'samplingType', 'type': 'str'},
        'percentage': {'key': 'percentage', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        sampling_type: Optional[Union[str, "SamplingType"]] = None,
        percentage: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword sampling_type: Sampling type. Possible values include: "fixed".
        :paramtype sampling_type: str or ~api_management_client.models.SamplingType
        :keyword percentage: Rate of sampling for fixed-rate sampling.
        :paramtype percentage: float
        """
        super(SamplingSettings, self).__init__(**kwargs)
        self.sampling_type = sampling_type
        self.percentage = percentage


class SaveConfigurationParameter(msrest.serialization.Model):
    """Save Tenant Configuration Contract details.

    :ivar branch: The name of the Git branch in which to commit the current configuration snapshot.
    :vartype branch: str
    :ivar force: The value if true, the current configuration database is committed to the Git
     repository, even if the Git repository has newer changes that would be overwritten.
    :vartype force: bool
    """

    _attribute_map = {
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'force': {'key': 'properties.force', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        force: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword branch: The name of the Git branch in which to commit the current configuration
         snapshot.
        :paramtype branch: str
        :keyword force: The value if true, the current configuration database is committed to the Git
         repository, even if the Git repository has newer changes that would be overwritten.
        :paramtype force: bool
        """
        super(SaveConfigurationParameter, self).__init__(**kwargs)
        self.branch = branch
        self.force = force


class SchemaCollection(msrest.serialization.Model):
    """The response of the list schema operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: API Schema Contract value.
    :vartype value: list[~api_management_client.models.SchemaContract]
    :ivar count: Total record count number.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SchemaContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: Total record count number.
        :paramtype count: long
        """
        super(SchemaCollection, self).__init__(**kwargs)
        self.value = None
        self.count = count
        self.next_link = None


class SchemaContract(Resource):
    """API Schema Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar content_type: Must be a valid a media type used in a Content-Type header as defined in
     the RFC 2616. Media type of the schema document (e.g. application/json, application/xml). </br>
     - ``Swagger`` Schema use ``application/vnd.ms-azure-apim.swagger.definitions+json`` </br> -
     ``WSDL`` Schema use ``application/vnd.ms-azure-apim.xsd+xml`` </br> - ``OpenApi`` Schema use
     ``application/vnd.oai.openapi.components+json`` </br> - ``WADL Schema`` use
     ``application/vnd.ms-azure-apim.wadl.grammars+xml``.
    :vartype content_type: str
    :ivar value: Json escaped string defining the document representing the Schema. Used for
     schemas other than Swagger/OpenAPI.
    :vartype value: str
    :ivar definitions: Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
    :vartype definitions: any
    :ivar components: Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null
     otherwise.
    :vartype components: any
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'content_type': {'key': 'properties.contentType', 'type': 'str'},
        'value': {'key': 'properties.document.value', 'type': 'str'},
        'definitions': {'key': 'properties.document.definitions', 'type': 'object'},
        'components': {'key': 'properties.document.components', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        content_type: Optional[str] = None,
        value: Optional[str] = None,
        definitions: Optional[Any] = None,
        components: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword content_type: Must be a valid a media type used in a Content-Type header as defined in
         the RFC 2616. Media type of the schema document (e.g. application/json, application/xml). </br>
         - ``Swagger`` Schema use ``application/vnd.ms-azure-apim.swagger.definitions+json`` </br> -
         ``WSDL`` Schema use ``application/vnd.ms-azure-apim.xsd+xml`` </br> - ``OpenApi`` Schema use
         ``application/vnd.oai.openapi.components+json`` </br> - ``WADL Schema`` use
         ``application/vnd.ms-azure-apim.wadl.grammars+xml``.
        :paramtype content_type: str
        :keyword value: Json escaped string defining the document representing the Schema. Used for
         schemas other than Swagger/OpenAPI.
        :paramtype value: str
        :keyword definitions: Types definitions. Used for Swagger/OpenAPI v1 schemas only, null
         otherwise.
        :paramtype definitions: any
        :keyword components: Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null
         otherwise.
        :paramtype components: any
        """
        super(SchemaContract, self).__init__(**kwargs)
        self.content_type = content_type
        self.value = value
        self.definitions = definitions
        self.components = components


class SubscriptionCollection(msrest.serialization.Model):
    """Paged Subscriptions list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.SubscriptionContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubscriptionContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SubscriptionContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.SubscriptionContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(SubscriptionCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class SubscriptionContract(Resource):
    """Subscription details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar owner_id: The user resource identifier of the subscription owner. The value is a valid
     relative URL in the format of /users/{userId} where {userId} is a user identifier.
    :vartype owner_id: str
    :ivar scope: Scope like /products/{productId} or /apis or /apis/{apiId}.
    :vartype scope: str
    :ivar display_name: The name of the subscription, or null if the subscription has no name.
    :vartype display_name: str
    :ivar state: Subscription state. Possible states are * active – the subscription is active, *
     suspended – the subscription is blocked, and the subscriber cannot call any APIs of the
     product, * submitted – the subscription request has been made by the developer, but has not yet
     been approved or rejected, * rejected – the subscription request has been denied by an
     administrator, * cancelled – the subscription has been cancelled by the developer or
     administrator, * expired – the subscription reached its expiration date and was deactivated.
     Possible values include: "suspended", "active", "expired", "submitted", "rejected",
     "cancelled".
    :vartype state: str or ~api_management_client.models.SubscriptionState
    :ivar created_date: Subscription creation date. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_date: ~datetime.datetime
    :ivar start_date: Subscription activation date. The setting is for audit purposes only and the
     subscription is not automatically activated. The subscription lifecycle can be managed by using
     the ``state`` property. The date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as
     specified by the ISO 8601 standard.
    :vartype start_date: ~datetime.datetime
    :ivar expiration_date: Subscription expiration date. The setting is for audit purposes only and
     the subscription is not automatically expired. The subscription lifecycle can be managed by
     using the ``state`` property. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype expiration_date: ~datetime.datetime
    :ivar end_date: Date when subscription was cancelled or expired. The setting is for audit
     purposes only and the subscription is not automatically cancelled. The subscription lifecycle
     can be managed by using the ``state`` property. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype end_date: ~datetime.datetime
    :ivar notification_date: Upcoming subscription expiration notification date. The date conforms
     to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype notification_date: ~datetime.datetime
    :ivar primary_key: Subscription primary key. This property will not be filled on 'GET'
     operations! Use '/listSecrets' POST request to get the value.
    :vartype primary_key: str
    :ivar secondary_key: Subscription secondary key. This property will not be filled on 'GET'
     operations! Use '/listSecrets' POST request to get the value.
    :vartype secondary_key: str
    :ivar state_comment: Optional subscription comment added by an administrator when the state is
     changed to the 'rejected'.
    :vartype state_comment: str
    :ivar allow_tracing: Determines whether tracing is enabled.
    :vartype allow_tracing: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 100, 'min_length': 0},
        'created_date': {'readonly': True},
        'primary_key': {'max_length': 256, 'min_length': 1},
        'secondary_key': {'max_length': 256, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'owner_id': {'key': 'properties.ownerId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'start_date': {'key': 'properties.startDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'end_date': {'key': 'properties.endDate', 'type': 'iso-8601'},
        'notification_date': {'key': 'properties.notificationDate', 'type': 'iso-8601'},
        'primary_key': {'key': 'properties.primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'properties.secondaryKey', 'type': 'str'},
        'state_comment': {'key': 'properties.stateComment', 'type': 'str'},
        'allow_tracing': {'key': 'properties.allowTracing', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        owner_id: Optional[str] = None,
        scope: Optional[str] = None,
        display_name: Optional[str] = None,
        state: Optional[Union[str, "SubscriptionState"]] = None,
        start_date: Optional[datetime.datetime] = None,
        expiration_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        notification_date: Optional[datetime.datetime] = None,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        state_comment: Optional[str] = None,
        allow_tracing: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword owner_id: The user resource identifier of the subscription owner. The value is a valid
         relative URL in the format of /users/{userId} where {userId} is a user identifier.
        :paramtype owner_id: str
        :keyword scope: Scope like /products/{productId} or /apis or /apis/{apiId}.
        :paramtype scope: str
        :keyword display_name: The name of the subscription, or null if the subscription has no name.
        :paramtype display_name: str
        :keyword state: Subscription state. Possible states are * active – the subscription is active,
         * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the
         product, * submitted – the subscription request has been made by the developer, but has not yet
         been approved or rejected, * rejected – the subscription request has been denied by an
         administrator, * cancelled – the subscription has been cancelled by the developer or
         administrator, * expired – the subscription reached its expiration date and was deactivated.
         Possible values include: "suspended", "active", "expired", "submitted", "rejected",
         "cancelled".
        :paramtype state: str or ~api_management_client.models.SubscriptionState
        :keyword start_date: Subscription activation date. The setting is for audit purposes only and
         the subscription is not automatically activated. The subscription lifecycle can be managed by
         using the ``state`` property. The date conforms to the following format:
         ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype start_date: ~datetime.datetime
        :keyword expiration_date: Subscription expiration date. The setting is for audit purposes only
         and the subscription is not automatically expired. The subscription lifecycle can be managed by
         using the ``state`` property. The date conforms to the following format:
         ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype expiration_date: ~datetime.datetime
        :keyword end_date: Date when subscription was cancelled or expired. The setting is for audit
         purposes only and the subscription is not automatically cancelled. The subscription lifecycle
         can be managed by using the ``state`` property. The date conforms to the following format:
         ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype end_date: ~datetime.datetime
        :keyword notification_date: Upcoming subscription expiration notification date. The date
         conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601
         standard.
        :paramtype notification_date: ~datetime.datetime
        :keyword primary_key: Subscription primary key. This property will not be filled on 'GET'
         operations! Use '/listSecrets' POST request to get the value.
        :paramtype primary_key: str
        :keyword secondary_key: Subscription secondary key. This property will not be filled on 'GET'
         operations! Use '/listSecrets' POST request to get the value.
        :paramtype secondary_key: str
        :keyword state_comment: Optional subscription comment added by an administrator when the state
         is changed to the 'rejected'.
        :paramtype state_comment: str
        :keyword allow_tracing: Determines whether tracing is enabled.
        :paramtype allow_tracing: bool
        """
        super(SubscriptionContract, self).__init__(**kwargs)
        self.owner_id = owner_id
        self.scope = scope
        self.display_name = display_name
        self.state = state
        self.created_date = None
        self.start_date = start_date
        self.expiration_date = expiration_date
        self.end_date = end_date
        self.notification_date = notification_date
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.state_comment = state_comment
        self.allow_tracing = allow_tracing


class SubscriptionCreateParameters(msrest.serialization.Model):
    """Subscription create details.

    :ivar owner_id: User (user id path) for whom subscription is being created in form
     /users/{userId}.
    :vartype owner_id: str
    :ivar scope: Scope like /products/{productId} or /apis or /apis/{apiId}.
    :vartype scope: str
    :ivar display_name: Subscription name.
    :vartype display_name: str
    :ivar primary_key: Primary subscription key. If not specified during request key will be
     generated automatically.
    :vartype primary_key: str
    :ivar secondary_key: Secondary subscription key. If not specified during request key will be
     generated automatically.
    :vartype secondary_key: str
    :ivar state: Initial subscription state. If no value is specified, subscription is created with
     Submitted state. Possible states are * active – the subscription is active, * suspended – the
     subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted –
     the subscription request has been made by the developer, but has not yet been approved or
     rejected, * rejected – the subscription request has been denied by an administrator, *
     cancelled – the subscription has been cancelled by the developer or administrator, * expired –
     the subscription reached its expiration date and was deactivated. Possible values include:
     "suspended", "active", "expired", "submitted", "rejected", "cancelled".
    :vartype state: str or ~api_management_client.models.SubscriptionState
    :ivar allow_tracing: Determines whether tracing can be enabled.
    :vartype allow_tracing: bool
    """

    _validation = {
        'display_name': {'max_length': 100, 'min_length': 1},
        'primary_key': {'max_length': 256, 'min_length': 1},
        'secondary_key': {'max_length': 256, 'min_length': 1},
    }

    _attribute_map = {
        'owner_id': {'key': 'properties.ownerId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'primary_key': {'key': 'properties.primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'properties.secondaryKey', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'allow_tracing': {'key': 'properties.allowTracing', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        owner_id: Optional[str] = None,
        scope: Optional[str] = None,
        display_name: Optional[str] = None,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        state: Optional[Union[str, "SubscriptionState"]] = None,
        allow_tracing: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword owner_id: User (user id path) for whom subscription is being created in form
         /users/{userId}.
        :paramtype owner_id: str
        :keyword scope: Scope like /products/{productId} or /apis or /apis/{apiId}.
        :paramtype scope: str
        :keyword display_name: Subscription name.
        :paramtype display_name: str
        :keyword primary_key: Primary subscription key. If not specified during request key will be
         generated automatically.
        :paramtype primary_key: str
        :keyword secondary_key: Secondary subscription key. If not specified during request key will be
         generated automatically.
        :paramtype secondary_key: str
        :keyword state: Initial subscription state. If no value is specified, subscription is created
         with Submitted state. Possible states are * active – the subscription is active, * suspended –
         the subscription is blocked, and the subscriber cannot call any APIs of the product, *
         submitted – the subscription request has been made by the developer, but has not yet been
         approved or rejected, * rejected – the subscription request has been denied by an
         administrator, * cancelled – the subscription has been cancelled by the developer or
         administrator, * expired – the subscription reached its expiration date and was deactivated.
         Possible values include: "suspended", "active", "expired", "submitted", "rejected",
         "cancelled".
        :paramtype state: str or ~api_management_client.models.SubscriptionState
        :keyword allow_tracing: Determines whether tracing can be enabled.
        :paramtype allow_tracing: bool
        """
        super(SubscriptionCreateParameters, self).__init__(**kwargs)
        self.owner_id = owner_id
        self.scope = scope
        self.display_name = display_name
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.state = state
        self.allow_tracing = allow_tracing


class SubscriptionKeyParameterNamesContract(msrest.serialization.Model):
    """Subscription key parameter names details.

    :ivar header: Subscription key header name.
    :vartype header: str
    :ivar query: Subscription key query string parameter name.
    :vartype query: str
    """

    _attribute_map = {
        'header': {'key': 'header', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        header: Optional[str] = None,
        query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword header: Subscription key header name.
        :paramtype header: str
        :keyword query: Subscription key query string parameter name.
        :paramtype query: str
        """
        super(SubscriptionKeyParameterNamesContract, self).__init__(**kwargs)
        self.header = header
        self.query = query


class SubscriptionKeysContract(msrest.serialization.Model):
    """Subscription keys.

    :ivar primary_key: Subscription primary key.
    :vartype primary_key: str
    :ivar secondary_key: Subscription secondary key.
    :vartype secondary_key: str
    """

    _validation = {
        'primary_key': {'max_length': 256, 'min_length': 1},
        'secondary_key': {'max_length': 256, 'min_length': 1},
    }

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword primary_key: Subscription primary key.
        :paramtype primary_key: str
        :keyword secondary_key: Subscription secondary key.
        :paramtype secondary_key: str
        """
        super(SubscriptionKeysContract, self).__init__(**kwargs)
        self.primary_key = primary_key
        self.secondary_key = secondary_key


class SubscriptionsDelegationSettingsProperties(msrest.serialization.Model):
    """Subscriptions delegation settings properties.

    :ivar enabled: Enable or disable delegation for subscriptions.
    :vartype enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: Enable or disable delegation for subscriptions.
        :paramtype enabled: bool
        """
        super(SubscriptionsDelegationSettingsProperties, self).__init__(**kwargs)
        self.enabled = enabled


class SubscriptionUpdateParameters(msrest.serialization.Model):
    """Subscription update details.

    :ivar owner_id: User identifier path: /users/{userId}.
    :vartype owner_id: str
    :ivar scope: Scope like /products/{productId} or /apis or /apis/{apiId}.
    :vartype scope: str
    :ivar expiration_date: Subscription expiration date. The setting is for audit purposes only and
     the subscription is not automatically expired. The subscription lifecycle can be managed by
     using the ``state`` property. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype expiration_date: ~datetime.datetime
    :ivar display_name: Subscription name.
    :vartype display_name: str
    :ivar primary_key: Primary subscription key.
    :vartype primary_key: str
    :ivar secondary_key: Secondary subscription key.
    :vartype secondary_key: str
    :ivar state: Subscription state. Possible states are * active – the subscription is active, *
     suspended – the subscription is blocked, and the subscriber cannot call any APIs of the
     product, * submitted – the subscription request has been made by the developer, but has not yet
     been approved or rejected, * rejected – the subscription request has been denied by an
     administrator, * cancelled – the subscription has been cancelled by the developer or
     administrator, * expired – the subscription reached its expiration date and was deactivated.
     Possible values include: "suspended", "active", "expired", "submitted", "rejected",
     "cancelled".
    :vartype state: str or ~api_management_client.models.SubscriptionState
    :ivar state_comment: Comments describing subscription state change by the administrator when
     the state is changed to the 'rejected'.
    :vartype state_comment: str
    :ivar allow_tracing: Determines whether tracing can be enabled.
    :vartype allow_tracing: bool
    """

    _validation = {
        'primary_key': {'max_length': 256, 'min_length': 1},
        'secondary_key': {'max_length': 256, 'min_length': 1},
    }

    _attribute_map = {
        'owner_id': {'key': 'properties.ownerId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'primary_key': {'key': 'properties.primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'properties.secondaryKey', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'state_comment': {'key': 'properties.stateComment', 'type': 'str'},
        'allow_tracing': {'key': 'properties.allowTracing', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        owner_id: Optional[str] = None,
        scope: Optional[str] = None,
        expiration_date: Optional[datetime.datetime] = None,
        display_name: Optional[str] = None,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        state: Optional[Union[str, "SubscriptionState"]] = None,
        state_comment: Optional[str] = None,
        allow_tracing: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword owner_id: User identifier path: /users/{userId}.
        :paramtype owner_id: str
        :keyword scope: Scope like /products/{productId} or /apis or /apis/{apiId}.
        :paramtype scope: str
        :keyword expiration_date: Subscription expiration date. The setting is for audit purposes only
         and the subscription is not automatically expired. The subscription lifecycle can be managed by
         using the ``state`` property. The date conforms to the following format:
         ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype expiration_date: ~datetime.datetime
        :keyword display_name: Subscription name.
        :paramtype display_name: str
        :keyword primary_key: Primary subscription key.
        :paramtype primary_key: str
        :keyword secondary_key: Secondary subscription key.
        :paramtype secondary_key: str
        :keyword state: Subscription state. Possible states are * active – the subscription is active,
         * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the
         product, * submitted – the subscription request has been made by the developer, but has not yet
         been approved or rejected, * rejected – the subscription request has been denied by an
         administrator, * cancelled – the subscription has been cancelled by the developer or
         administrator, * expired – the subscription reached its expiration date and was deactivated.
         Possible values include: "suspended", "active", "expired", "submitted", "rejected",
         "cancelled".
        :paramtype state: str or ~api_management_client.models.SubscriptionState
        :keyword state_comment: Comments describing subscription state change by the administrator when
         the state is changed to the 'rejected'.
        :paramtype state_comment: str
        :keyword allow_tracing: Determines whether tracing can be enabled.
        :paramtype allow_tracing: bool
        """
        super(SubscriptionUpdateParameters, self).__init__(**kwargs)
        self.owner_id = owner_id
        self.scope = scope
        self.expiration_date = expiration_date
        self.display_name = display_name
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.state = state
        self.state_comment = state_comment
        self.allow_tracing = allow_tracing


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~api_management_client.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~api_management_client.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~api_management_client.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~api_management_client.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagCollection(msrest.serialization.Model):
    """Paged Tag list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.TagContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TagContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TagContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.TagContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(TagCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class TagContract(Resource):
    """Tag Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar display_name: Tag name.
    :vartype display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Tag name.
        :paramtype display_name: str
        """
        super(TagContract, self).__init__(**kwargs)
        self.display_name = display_name


class TagCreateUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to Create/Update Tag operations.

    :ivar display_name: Tag name.
    :vartype display_name: str
    """

    _validation = {
        'display_name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Tag name.
        :paramtype display_name: str
        """
        super(TagCreateUpdateParameters, self).__init__(**kwargs)
        self.display_name = display_name


class TagDescriptionBaseProperties(msrest.serialization.Model):
    """Parameters supplied to the Create TagDescription operation.

    :ivar description: Description of the Tag.
    :vartype description: str
    :ivar external_docs_url: Absolute URL of external resources describing the tag.
    :vartype external_docs_url: str
    :ivar external_docs_description: Description of the external resources describing the tag.
    :vartype external_docs_description: str
    """

    _validation = {
        'external_docs_url': {'max_length': 2000, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'external_docs_url': {'key': 'externalDocsUrl', 'type': 'str'},
        'external_docs_description': {'key': 'externalDocsDescription', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        external_docs_url: Optional[str] = None,
        external_docs_description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the Tag.
        :paramtype description: str
        :keyword external_docs_url: Absolute URL of external resources describing the tag.
        :paramtype external_docs_url: str
        :keyword external_docs_description: Description of the external resources describing the tag.
        :paramtype external_docs_description: str
        """
        super(TagDescriptionBaseProperties, self).__init__(**kwargs)
        self.description = description
        self.external_docs_url = external_docs_url
        self.external_docs_description = external_docs_description


class TagDescriptionCollection(msrest.serialization.Model):
    """Paged TagDescription list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.TagDescriptionContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TagDescriptionContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TagDescriptionContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.TagDescriptionContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(TagDescriptionCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class TagDescriptionContract(Resource):
    """Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar description: Description of the Tag.
    :vartype description: str
    :ivar external_docs_url: Absolute URL of external resources describing the tag.
    :vartype external_docs_url: str
    :ivar external_docs_description: Description of the external resources describing the tag.
    :vartype external_docs_description: str
    :ivar tag_id: Identifier of the tag in the form of /tags/{tagId}.
    :vartype tag_id: str
    :ivar display_name: Tag name.
    :vartype display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'external_docs_url': {'max_length': 2000, 'min_length': 0},
        'display_name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_docs_url': {'key': 'properties.externalDocsUrl', 'type': 'str'},
        'external_docs_description': {'key': 'properties.externalDocsDescription', 'type': 'str'},
        'tag_id': {'key': 'properties.tagId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        external_docs_url: Optional[str] = None,
        external_docs_description: Optional[str] = None,
        tag_id: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the Tag.
        :paramtype description: str
        :keyword external_docs_url: Absolute URL of external resources describing the tag.
        :paramtype external_docs_url: str
        :keyword external_docs_description: Description of the external resources describing the tag.
        :paramtype external_docs_description: str
        :keyword tag_id: Identifier of the tag in the form of /tags/{tagId}.
        :paramtype tag_id: str
        :keyword display_name: Tag name.
        :paramtype display_name: str
        """
        super(TagDescriptionContract, self).__init__(**kwargs)
        self.description = description
        self.external_docs_url = external_docs_url
        self.external_docs_description = external_docs_description
        self.tag_id = tag_id
        self.display_name = display_name


class TagDescriptionContractProperties(TagDescriptionBaseProperties):
    """TagDescription contract Properties.

    :ivar description: Description of the Tag.
    :vartype description: str
    :ivar external_docs_url: Absolute URL of external resources describing the tag.
    :vartype external_docs_url: str
    :ivar external_docs_description: Description of the external resources describing the tag.
    :vartype external_docs_description: str
    :ivar tag_id: Identifier of the tag in the form of /tags/{tagId}.
    :vartype tag_id: str
    :ivar display_name: Tag name.
    :vartype display_name: str
    """

    _validation = {
        'external_docs_url': {'max_length': 2000, 'min_length': 0},
        'display_name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'external_docs_url': {'key': 'externalDocsUrl', 'type': 'str'},
        'external_docs_description': {'key': 'externalDocsDescription', 'type': 'str'},
        'tag_id': {'key': 'tagId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        external_docs_url: Optional[str] = None,
        external_docs_description: Optional[str] = None,
        tag_id: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the Tag.
        :paramtype description: str
        :keyword external_docs_url: Absolute URL of external resources describing the tag.
        :paramtype external_docs_url: str
        :keyword external_docs_description: Description of the external resources describing the tag.
        :paramtype external_docs_description: str
        :keyword tag_id: Identifier of the tag in the form of /tags/{tagId}.
        :paramtype tag_id: str
        :keyword display_name: Tag name.
        :paramtype display_name: str
        """
        super(TagDescriptionContractProperties, self).__init__(description=description, external_docs_url=external_docs_url, external_docs_description=external_docs_description, **kwargs)
        self.tag_id = tag_id
        self.display_name = display_name


class TagDescriptionCreateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create TagDescription operation.

    :ivar description: Description of the Tag.
    :vartype description: str
    :ivar external_docs_url: Absolute URL of external resources describing the tag.
    :vartype external_docs_url: str
    :ivar external_docs_description: Description of the external resources describing the tag.
    :vartype external_docs_description: str
    """

    _validation = {
        'external_docs_url': {'max_length': 2000, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_docs_url': {'key': 'properties.externalDocsUrl', 'type': 'str'},
        'external_docs_description': {'key': 'properties.externalDocsDescription', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        external_docs_url: Optional[str] = None,
        external_docs_description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the Tag.
        :paramtype description: str
        :keyword external_docs_url: Absolute URL of external resources describing the tag.
        :paramtype external_docs_url: str
        :keyword external_docs_description: Description of the external resources describing the tag.
        :paramtype external_docs_description: str
        """
        super(TagDescriptionCreateParameters, self).__init__(**kwargs)
        self.description = description
        self.external_docs_url = external_docs_url
        self.external_docs_description = external_docs_description


class TagResourceCollection(msrest.serialization.Model):
    """Paged Tag list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.TagResourceContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TagResourceContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TagResourceContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.TagResourceContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(TagResourceCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class TagResourceContract(msrest.serialization.Model):
    """TagResource contract properties.

    All required parameters must be populated in order to send to Azure.

    :ivar tag: Required. Tag associated with the resource.
    :vartype tag: ~api_management_client.models.TagResourceContractProperties
    :ivar api: API associated with the tag.
    :vartype api: ~api_management_client.models.ApiTagResourceContractProperties
    :ivar operation: Operation associated with the tag.
    :vartype operation: ~api_management_client.models.OperationTagResourceContractProperties
    :ivar product: Product associated with the tag.
    :vartype product: ~api_management_client.models.ProductTagResourceContractProperties
    """

    _validation = {
        'tag': {'required': True},
    }

    _attribute_map = {
        'tag': {'key': 'tag', 'type': 'TagResourceContractProperties'},
        'api': {'key': 'api', 'type': 'ApiTagResourceContractProperties'},
        'operation': {'key': 'operation', 'type': 'OperationTagResourceContractProperties'},
        'product': {'key': 'product', 'type': 'ProductTagResourceContractProperties'},
    }

    def __init__(
        self,
        *,
        tag: "TagResourceContractProperties",
        api: Optional["ApiTagResourceContractProperties"] = None,
        operation: Optional["OperationTagResourceContractProperties"] = None,
        product: Optional["ProductTagResourceContractProperties"] = None,
        **kwargs
    ):
        """
        :keyword tag: Required. Tag associated with the resource.
        :paramtype tag: ~api_management_client.models.TagResourceContractProperties
        :keyword api: API associated with the tag.
        :paramtype api: ~api_management_client.models.ApiTagResourceContractProperties
        :keyword operation: Operation associated with the tag.
        :paramtype operation: ~api_management_client.models.OperationTagResourceContractProperties
        :keyword product: Product associated with the tag.
        :paramtype product: ~api_management_client.models.ProductTagResourceContractProperties
        """
        super(TagResourceContract, self).__init__(**kwargs)
        self.tag = tag
        self.api = api
        self.operation = operation
        self.product = product


class TagResourceContractProperties(msrest.serialization.Model):
    """Contract defining the Tag property in the Tag Resource Contract.

    :ivar id: Tag identifier.
    :vartype id: str
    :ivar name: Tag Name.
    :vartype name: str
    """

    _validation = {
        'name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Tag identifier.
        :paramtype id: str
        :keyword name: Tag Name.
        :paramtype name: str
        """
        super(TagResourceContractProperties, self).__init__(**kwargs)
        self.id = id
        self.name = name


class TenantConfigurationSyncStateContract(Resource):
    """Result of Tenant Configuration Sync State.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar branch: The name of Git branch.
    :vartype branch: str
    :ivar commit_id: The latest commit Id.
    :vartype commit_id: str
    :ivar is_export: value indicating if last sync was save (true) or deploy (false) operation.
    :vartype is_export: bool
    :ivar is_synced: value indicating if last synchronization was later than the configuration
     change.
    :vartype is_synced: bool
    :ivar is_git_enabled: value indicating whether Git configuration access is enabled.
    :vartype is_git_enabled: bool
    :ivar sync_date: The date of the latest synchronization. The date conforms to the following
     format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype sync_date: ~datetime.datetime
    :ivar configuration_change_date: The date of the latest configuration change. The date conforms
     to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype configuration_change_date: ~datetime.datetime
    :ivar last_operation_id: Most recent tenant configuration operation identifier.
    :vartype last_operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'commit_id': {'key': 'properties.commitId', 'type': 'str'},
        'is_export': {'key': 'properties.isExport', 'type': 'bool'},
        'is_synced': {'key': 'properties.isSynced', 'type': 'bool'},
        'is_git_enabled': {'key': 'properties.isGitEnabled', 'type': 'bool'},
        'sync_date': {'key': 'properties.syncDate', 'type': 'iso-8601'},
        'configuration_change_date': {'key': 'properties.configurationChangeDate', 'type': 'iso-8601'},
        'last_operation_id': {'key': 'properties.lastOperationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        commit_id: Optional[str] = None,
        is_export: Optional[bool] = None,
        is_synced: Optional[bool] = None,
        is_git_enabled: Optional[bool] = None,
        sync_date: Optional[datetime.datetime] = None,
        configuration_change_date: Optional[datetime.datetime] = None,
        last_operation_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword branch: The name of Git branch.
        :paramtype branch: str
        :keyword commit_id: The latest commit Id.
        :paramtype commit_id: str
        :keyword is_export: value indicating if last sync was save (true) or deploy (false) operation.
        :paramtype is_export: bool
        :keyword is_synced: value indicating if last synchronization was later than the configuration
         change.
        :paramtype is_synced: bool
        :keyword is_git_enabled: value indicating whether Git configuration access is enabled.
        :paramtype is_git_enabled: bool
        :keyword sync_date: The date of the latest synchronization. The date conforms to the following
         format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype sync_date: ~datetime.datetime
        :keyword configuration_change_date: The date of the latest configuration change. The date
         conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601
         standard.
        :paramtype configuration_change_date: ~datetime.datetime
        :keyword last_operation_id: Most recent tenant configuration operation identifier.
        :paramtype last_operation_id: str
        """
        super(TenantConfigurationSyncStateContract, self).__init__(**kwargs)
        self.branch = branch
        self.commit_id = commit_id
        self.is_export = is_export
        self.is_synced = is_synced
        self.is_git_enabled = is_git_enabled
        self.sync_date = sync_date
        self.configuration_change_date = configuration_change_date
        self.last_operation_id = last_operation_id


class TenantSettingsCollection(msrest.serialization.Model):
    """Paged AccessInformation list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.TenantSettingsContract]
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TenantSettingsContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TenantSettingsCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class TenantSettingsContract(Resource):
    """Tenant Settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar settings: Tenant settings.
    :vartype settings: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'settings': {'key': 'properties.settings', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        settings: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword settings: Tenant settings.
        :paramtype settings: dict[str, str]
        """
        super(TenantSettingsContract, self).__init__(**kwargs)
        self.settings = settings


class TermsOfServiceProperties(msrest.serialization.Model):
    """Terms of service contract properties.

    :ivar text: A terms of service text.
    :vartype text: str
    :ivar enabled: Display terms of service during a sign-up process.
    :vartype enabled: bool
    :ivar consent_required: Ask user for consent to the terms of service.
    :vartype consent_required: bool
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'consent_required': {'key': 'consentRequired', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        enabled: Optional[bool] = None,
        consent_required: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword text: A terms of service text.
        :paramtype text: str
        :keyword enabled: Display terms of service during a sign-up process.
        :paramtype enabled: bool
        :keyword consent_required: Ask user for consent to the terms of service.
        :paramtype consent_required: bool
        """
        super(TermsOfServiceProperties, self).__init__(**kwargs)
        self.text = text
        self.enabled = enabled
        self.consent_required = consent_required


class TokenBodyParameterContract(msrest.serialization.Model):
    """OAuth acquire token request body parameter (www-url-form-encoded).

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. body parameter name.
    :vartype name: str
    :ivar value: Required. body parameter value.
    :vartype value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        """
        :keyword name: Required. body parameter name.
        :paramtype name: str
        :keyword value: Required. body parameter value.
        :paramtype value: str
        """
        super(TokenBodyParameterContract, self).__init__(**kwargs)
        self.name = name
        self.value = value


class UserCollection(msrest.serialization.Model):
    """Paged Users list representation.

    :ivar value: Page values.
    :vartype value: list[~api_management_client.models.UserContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UserContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["UserContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Page values.
        :paramtype value: list[~api_management_client.models.UserContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(UserCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class UserContract(Resource):
    """User details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :vartype state: str or ~api_management_client.models.UserState
    :ivar note: Optional note about a user set by the administrator.
    :vartype note: str
    :ivar identities: Collection of user identities.
    :vartype identities: list[~api_management_client.models.UserIdentityContract]
    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    :ivar email: Email address.
    :vartype email: str
    :ivar registration_date: Date of user registration. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype registration_date: ~datetime.datetime
    :ivar groups: Collection of groups user is part of.
    :vartype groups: list[~api_management_client.models.GroupContractProperties]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'groups': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'note': {'key': 'properties.note', 'type': 'str'},
        'identities': {'key': 'properties.identities', 'type': '[UserIdentityContract]'},
        'first_name': {'key': 'properties.firstName', 'type': 'str'},
        'last_name': {'key': 'properties.lastName', 'type': 'str'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'registration_date': {'key': 'properties.registrationDate', 'type': 'iso-8601'},
        'groups': {'key': 'properties.groups', 'type': '[GroupContractProperties]'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "UserState"]] = "active",
        note: Optional[str] = None,
        identities: Optional[List["UserIdentityContract"]] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email: Optional[str] = None,
        registration_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword state: Account state. Specifies whether the user is active or not. Blocked users are
         unable to sign into the developer portal or call any APIs of subscribed products. Default state
         is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
         "active".
        :paramtype state: str or ~api_management_client.models.UserState
        :keyword note: Optional note about a user set by the administrator.
        :paramtype note: str
        :keyword identities: Collection of user identities.
        :paramtype identities: list[~api_management_client.models.UserIdentityContract]
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        :keyword email: Email address.
        :paramtype email: str
        :keyword registration_date: Date of user registration. The date conforms to the following
         format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype registration_date: ~datetime.datetime
        """
        super(UserContract, self).__init__(**kwargs)
        self.state = state
        self.note = note
        self.identities = identities
        self.first_name = first_name
        self.last_name = last_name
        self.email = email
        self.registration_date = registration_date
        self.groups = None


class UserEntityBaseParameters(msrest.serialization.Model):
    """User Entity Base Parameters set.

    :ivar state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :vartype state: str or ~api_management_client.models.UserState
    :ivar note: Optional note about a user set by the administrator.
    :vartype note: str
    :ivar identities: Collection of user identities.
    :vartype identities: list[~api_management_client.models.UserIdentityContract]
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'note': {'key': 'note', 'type': 'str'},
        'identities': {'key': 'identities', 'type': '[UserIdentityContract]'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "UserState"]] = "active",
        note: Optional[str] = None,
        identities: Optional[List["UserIdentityContract"]] = None,
        **kwargs
    ):
        """
        :keyword state: Account state. Specifies whether the user is active or not. Blocked users are
         unable to sign into the developer portal or call any APIs of subscribed products. Default state
         is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
         "active".
        :paramtype state: str or ~api_management_client.models.UserState
        :keyword note: Optional note about a user set by the administrator.
        :paramtype note: str
        :keyword identities: Collection of user identities.
        :paramtype identities: list[~api_management_client.models.UserIdentityContract]
        """
        super(UserEntityBaseParameters, self).__init__(**kwargs)
        self.state = state
        self.note = note
        self.identities = identities


class UserContractProperties(UserEntityBaseParameters):
    """User profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :vartype state: str or ~api_management_client.models.UserState
    :ivar note: Optional note about a user set by the administrator.
    :vartype note: str
    :ivar identities: Collection of user identities.
    :vartype identities: list[~api_management_client.models.UserIdentityContract]
    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    :ivar email: Email address.
    :vartype email: str
    :ivar registration_date: Date of user registration. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype registration_date: ~datetime.datetime
    :ivar groups: Collection of groups user is part of.
    :vartype groups: list[~api_management_client.models.GroupContractProperties]
    """

    _validation = {
        'groups': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'note': {'key': 'note', 'type': 'str'},
        'identities': {'key': 'identities', 'type': '[UserIdentityContract]'},
        'first_name': {'key': 'firstName', 'type': 'str'},
        'last_name': {'key': 'lastName', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'registration_date': {'key': 'registrationDate', 'type': 'iso-8601'},
        'groups': {'key': 'groups', 'type': '[GroupContractProperties]'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "UserState"]] = "active",
        note: Optional[str] = None,
        identities: Optional[List["UserIdentityContract"]] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email: Optional[str] = None,
        registration_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword state: Account state. Specifies whether the user is active or not. Blocked users are
         unable to sign into the developer portal or call any APIs of subscribed products. Default state
         is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
         "active".
        :paramtype state: str or ~api_management_client.models.UserState
        :keyword note: Optional note about a user set by the administrator.
        :paramtype note: str
        :keyword identities: Collection of user identities.
        :paramtype identities: list[~api_management_client.models.UserIdentityContract]
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        :keyword email: Email address.
        :paramtype email: str
        :keyword registration_date: Date of user registration. The date conforms to the following
         format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
        :paramtype registration_date: ~datetime.datetime
        """
        super(UserContractProperties, self).__init__(state=state, note=note, identities=identities, **kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email = email
        self.registration_date = registration_date
        self.groups = None


class UserCreateParameterProperties(UserEntityBaseParameters):
    """Parameters supplied to the Create User operation.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :vartype state: str or ~api_management_client.models.UserState
    :ivar note: Optional note about a user set by the administrator.
    :vartype note: str
    :ivar identities: Collection of user identities.
    :vartype identities: list[~api_management_client.models.UserIdentityContract]
    :ivar email: Required. Email address. Must not be empty and must be unique within the service
     instance.
    :vartype email: str
    :ivar first_name: Required. First name.
    :vartype first_name: str
    :ivar last_name: Required. Last name.
    :vartype last_name: str
    :ivar password: User Password. If no value is provided, a default password is generated.
    :vartype password: str
    :ivar app_type: Determines the type of application which send the create user request. Default
     is legacy portal. Possible values include: "portal", "developerPortal".
    :vartype app_type: str or ~api_management_client.models.AppType
    :ivar confirmation: Determines the type of confirmation e-mail that will be sent to the newly
     created user. Possible values include: "signup", "invite".
    :vartype confirmation: str or ~api_management_client.models.Confirmation
    """

    _validation = {
        'email': {'required': True, 'max_length': 254, 'min_length': 1},
        'first_name': {'required': True, 'max_length': 100, 'min_length': 1},
        'last_name': {'required': True, 'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'note': {'key': 'note', 'type': 'str'},
        'identities': {'key': 'identities', 'type': '[UserIdentityContract]'},
        'email': {'key': 'email', 'type': 'str'},
        'first_name': {'key': 'firstName', 'type': 'str'},
        'last_name': {'key': 'lastName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'app_type': {'key': 'appType', 'type': 'str'},
        'confirmation': {'key': 'confirmation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email: str,
        first_name: str,
        last_name: str,
        state: Optional[Union[str, "UserState"]] = "active",
        note: Optional[str] = None,
        identities: Optional[List["UserIdentityContract"]] = None,
        password: Optional[str] = None,
        app_type: Optional[Union[str, "AppType"]] = None,
        confirmation: Optional[Union[str, "Confirmation"]] = None,
        **kwargs
    ):
        """
        :keyword state: Account state. Specifies whether the user is active or not. Blocked users are
         unable to sign into the developer portal or call any APIs of subscribed products. Default state
         is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
         "active".
        :paramtype state: str or ~api_management_client.models.UserState
        :keyword note: Optional note about a user set by the administrator.
        :paramtype note: str
        :keyword identities: Collection of user identities.
        :paramtype identities: list[~api_management_client.models.UserIdentityContract]
        :keyword email: Required. Email address. Must not be empty and must be unique within the
         service instance.
        :paramtype email: str
        :keyword first_name: Required. First name.
        :paramtype first_name: str
        :keyword last_name: Required. Last name.
        :paramtype last_name: str
        :keyword password: User Password. If no value is provided, a default password is generated.
        :paramtype password: str
        :keyword app_type: Determines the type of application which send the create user request.
         Default is legacy portal. Possible values include: "portal", "developerPortal".
        :paramtype app_type: str or ~api_management_client.models.AppType
        :keyword confirmation: Determines the type of confirmation e-mail that will be sent to the
         newly created user. Possible values include: "signup", "invite".
        :paramtype confirmation: str or ~api_management_client.models.Confirmation
        """
        super(UserCreateParameterProperties, self).__init__(state=state, note=note, identities=identities, **kwargs)
        self.email = email
        self.first_name = first_name
        self.last_name = last_name
        self.password = password
        self.app_type = app_type
        self.confirmation = confirmation


class UserCreateParameters(msrest.serialization.Model):
    """User create details.

    :ivar state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :vartype state: str or ~api_management_client.models.UserState
    :ivar note: Optional note about a user set by the administrator.
    :vartype note: str
    :ivar identities: Collection of user identities.
    :vartype identities: list[~api_management_client.models.UserIdentityContract]
    :ivar email: Email address. Must not be empty and must be unique within the service instance.
    :vartype email: str
    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    :ivar password: User Password. If no value is provided, a default password is generated.
    :vartype password: str
    :ivar app_type: Determines the type of application which send the create user request. Default
     is legacy portal. Possible values include: "portal", "developerPortal".
    :vartype app_type: str or ~api_management_client.models.AppType
    :ivar confirmation: Determines the type of confirmation e-mail that will be sent to the newly
     created user. Possible values include: "signup", "invite".
    :vartype confirmation: str or ~api_management_client.models.Confirmation
    """

    _validation = {
        'email': {'max_length': 254, 'min_length': 1},
        'first_name': {'max_length': 100, 'min_length': 1},
        'last_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'state': {'key': 'properties.state', 'type': 'str'},
        'note': {'key': 'properties.note', 'type': 'str'},
        'identities': {'key': 'properties.identities', 'type': '[UserIdentityContract]'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'first_name': {'key': 'properties.firstName', 'type': 'str'},
        'last_name': {'key': 'properties.lastName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'app_type': {'key': 'properties.appType', 'type': 'str'},
        'confirmation': {'key': 'properties.confirmation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "UserState"]] = "active",
        note: Optional[str] = None,
        identities: Optional[List["UserIdentityContract"]] = None,
        email: Optional[str] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        password: Optional[str] = None,
        app_type: Optional[Union[str, "AppType"]] = None,
        confirmation: Optional[Union[str, "Confirmation"]] = None,
        **kwargs
    ):
        """
        :keyword state: Account state. Specifies whether the user is active or not. Blocked users are
         unable to sign into the developer portal or call any APIs of subscribed products. Default state
         is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
         "active".
        :paramtype state: str or ~api_management_client.models.UserState
        :keyword note: Optional note about a user set by the administrator.
        :paramtype note: str
        :keyword identities: Collection of user identities.
        :paramtype identities: list[~api_management_client.models.UserIdentityContract]
        :keyword email: Email address. Must not be empty and must be unique within the service
         instance.
        :paramtype email: str
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        :keyword password: User Password. If no value is provided, a default password is generated.
        :paramtype password: str
        :keyword app_type: Determines the type of application which send the create user request.
         Default is legacy portal. Possible values include: "portal", "developerPortal".
        :paramtype app_type: str or ~api_management_client.models.AppType
        :keyword confirmation: Determines the type of confirmation e-mail that will be sent to the
         newly created user. Possible values include: "signup", "invite".
        :paramtype confirmation: str or ~api_management_client.models.Confirmation
        """
        super(UserCreateParameters, self).__init__(**kwargs)
        self.state = state
        self.note = note
        self.identities = identities
        self.email = email
        self.first_name = first_name
        self.last_name = last_name
        self.password = password
        self.app_type = app_type
        self.confirmation = confirmation


class UserIdentityCollection(msrest.serialization.Model):
    """List of Users Identity list representation.

    :ivar value: User Identity values.
    :vartype value: list[~api_management_client.models.UserIdentityContract]
    :ivar count: Total record count number across all pages.
    :vartype count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UserIdentityContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["UserIdentityContract"]] = None,
        count: Optional[int] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: User Identity values.
        :paramtype value: list[~api_management_client.models.UserIdentityContract]
        :keyword count: Total record count number across all pages.
        :paramtype count: long
        :keyword next_link: Next page link if any.
        :paramtype next_link: str
        """
        super(UserIdentityCollection, self).__init__(**kwargs)
        self.value = value
        self.count = count
        self.next_link = next_link


class UserIdentityContract(msrest.serialization.Model):
    """User identity details.

    :ivar provider: Identity provider name.
    :vartype provider: str
    :ivar id: Identifier value within provider.
    :vartype id: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Identity provider name.
        :paramtype provider: str
        :keyword id: Identifier value within provider.
        :paramtype id: str
        """
        super(UserIdentityContract, self).__init__(**kwargs)
        self.provider = provider
        self.id = id


class UserIdentityProperties(msrest.serialization.Model):
    """UserIdentityProperties.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword principal_id: The principal id of user assigned identity.
        :paramtype principal_id: str
        :keyword client_id: The client id of user assigned identity.
        :paramtype client_id: str
        """
        super(UserIdentityProperties, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.client_id = client_id


class UserTokenParameters(msrest.serialization.Model):
    """Get User Token parameters.

    :ivar key_type: The Key to be used to generate token for user. Possible values include:
     "primary", "secondary".
    :vartype key_type: str or ~api_management_client.models.KeyType
    :ivar expiry: The Expiry time of the Token. Maximum token expiry time is set to 30 days. The
     date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601
     standard.
    :vartype expiry: ~datetime.datetime
    """

    _attribute_map = {
        'key_type': {'key': 'properties.keyType', 'type': 'str'},
        'expiry': {'key': 'properties.expiry', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        key_type: Optional[Union[str, "KeyType"]] = None,
        expiry: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword key_type: The Key to be used to generate token for user. Possible values include:
         "primary", "secondary".
        :paramtype key_type: str or ~api_management_client.models.KeyType
        :keyword expiry: The Expiry time of the Token. Maximum token expiry time is set to 30 days. The
         date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601
         standard.
        :paramtype expiry: ~datetime.datetime
        """
        super(UserTokenParameters, self).__init__(**kwargs)
        self.key_type = key_type
        self.expiry = expiry


class UserTokenResult(msrest.serialization.Model):
    """Get User Token response details.

    :ivar value: Shared Access Authorization token for the User.
    :vartype value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Shared Access Authorization token for the User.
        :paramtype value: str
        """
        super(UserTokenResult, self).__init__(**kwargs)
        self.value = value


class UserUpdateParameters(msrest.serialization.Model):
    """User update parameters.

    :ivar state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :vartype state: str or ~api_management_client.models.UserState
    :ivar note: Optional note about a user set by the administrator.
    :vartype note: str
    :ivar identities: Collection of user identities.
    :vartype identities: list[~api_management_client.models.UserIdentityContract]
    :ivar email: Email address. Must not be empty and must be unique within the service instance.
    :vartype email: str
    :ivar password: User Password.
    :vartype password: str
    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    """

    _validation = {
        'email': {'max_length': 254, 'min_length': 1},
        'first_name': {'max_length': 100, 'min_length': 1},
        'last_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'state': {'key': 'properties.state', 'type': 'str'},
        'note': {'key': 'properties.note', 'type': 'str'},
        'identities': {'key': 'properties.identities', 'type': '[UserIdentityContract]'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'first_name': {'key': 'properties.firstName', 'type': 'str'},
        'last_name': {'key': 'properties.lastName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "UserState"]] = "active",
        note: Optional[str] = None,
        identities: Optional[List["UserIdentityContract"]] = None,
        email: Optional[str] = None,
        password: Optional[str] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword state: Account state. Specifies whether the user is active or not. Blocked users are
         unable to sign into the developer portal or call any APIs of subscribed products. Default state
         is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
         "active".
        :paramtype state: str or ~api_management_client.models.UserState
        :keyword note: Optional note about a user set by the administrator.
        :paramtype note: str
        :keyword identities: Collection of user identities.
        :paramtype identities: list[~api_management_client.models.UserIdentityContract]
        :keyword email: Email address. Must not be empty and must be unique within the service
         instance.
        :paramtype email: str
        :keyword password: User Password.
        :paramtype password: str
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        """
        super(UserUpdateParameters, self).__init__(**kwargs)
        self.state = state
        self.note = note
        self.identities = identities
        self.email = email
        self.password = password
        self.first_name = first_name
        self.last_name = last_name


class UserUpdateParametersProperties(UserEntityBaseParameters):
    """Parameters supplied to the Update User operation.

    :ivar state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :vartype state: str or ~api_management_client.models.UserState
    :ivar note: Optional note about a user set by the administrator.
    :vartype note: str
    :ivar identities: Collection of user identities.
    :vartype identities: list[~api_management_client.models.UserIdentityContract]
    :ivar email: Email address. Must not be empty and must be unique within the service instance.
    :vartype email: str
    :ivar password: User Password.
    :vartype password: str
    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    """

    _validation = {
        'email': {'max_length': 254, 'min_length': 1},
        'first_name': {'max_length': 100, 'min_length': 1},
        'last_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'note': {'key': 'note', 'type': 'str'},
        'identities': {'key': 'identities', 'type': '[UserIdentityContract]'},
        'email': {'key': 'email', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'first_name': {'key': 'firstName', 'type': 'str'},
        'last_name': {'key': 'lastName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "UserState"]] = "active",
        note: Optional[str] = None,
        identities: Optional[List["UserIdentityContract"]] = None,
        email: Optional[str] = None,
        password: Optional[str] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword state: Account state. Specifies whether the user is active or not. Blocked users are
         unable to sign into the developer portal or call any APIs of subscribed products. Default state
         is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
         "active".
        :paramtype state: str or ~api_management_client.models.UserState
        :keyword note: Optional note about a user set by the administrator.
        :paramtype note: str
        :keyword identities: Collection of user identities.
        :paramtype identities: list[~api_management_client.models.UserIdentityContract]
        :keyword email: Email address. Must not be empty and must be unique within the service
         instance.
        :paramtype email: str
        :keyword password: User Password.
        :paramtype password: str
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        """
        super(UserUpdateParametersProperties, self).__init__(state=state, note=note, identities=identities, **kwargs)
        self.email = email
        self.password = password
        self.first_name = first_name
        self.last_name = last_name


class VirtualNetworkConfiguration(msrest.serialization.Model):
    """Configuration of a virtual network to which API Management service is deployed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vnetid: The virtual network ID. This is typically a GUID. Expect a null GUID by default.
    :vartype vnetid: str
    :ivar subnetname: The name of the subnet.
    :vartype subnetname: str
    :ivar subnet_resource_id: The full resource ID of a subnet in a virtual network to deploy the
     API Management service in.
    :vartype subnet_resource_id: str
    """

    _validation = {
        'vnetid': {'readonly': True},
        'subnetname': {'readonly': True},
        'subnet_resource_id': {'pattern': r'^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$'},
    }

    _attribute_map = {
        'vnetid': {'key': 'vnetid', 'type': 'str'},
        'subnetname': {'key': 'subnetname', 'type': 'str'},
        'subnet_resource_id': {'key': 'subnetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subnet_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword subnet_resource_id: The full resource ID of a subnet in a virtual network to deploy
         the API Management service in.
        :paramtype subnet_resource_id: str
        """
        super(VirtualNetworkConfiguration, self).__init__(**kwargs)
        self.vnetid = None
        self.subnetname = None
        self.subnet_resource_id = subnet_resource_id


class X509CertificateName(msrest.serialization.Model):
    """Properties of server X509Names.

    :ivar name: Common Name of the Certificate.
    :vartype name: str
    :ivar issuer_certificate_thumbprint: Thumbprint for the Issuer of the Certificate.
    :vartype issuer_certificate_thumbprint: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'issuer_certificate_thumbprint': {'key': 'issuerCertificateThumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        issuer_certificate_thumbprint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Common Name of the Certificate.
        :paramtype name: str
        :keyword issuer_certificate_thumbprint: Thumbprint for the Issuer of the Certificate.
        :paramtype issuer_certificate_thumbprint: str
        """
        super(X509CertificateName, self).__init__(**kwargs)
        self.name = name
        self.issuer_certificate_thumbprint = issuer_certificate_thumbprint
