/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "ConvexPolyhedronPy.h"

using namespace boost::python;

void exportConvexPolyhedron()
{
  // Check that Boost 1.34.0 or higher is being used.
  // If so, disable auto-generation of C++ signatures for Epydoc
  // (which stumbles over indentation in the auto-generated strings).
  #if ((BOOST_VERSION / 100000 >= 1) \
      && (BOOST_VERSION / 100 % 1000 >= 34)) \
      || (BOOST_VERSION / 100000 >= 2)
    boost::python::docstring_options no_autogen(true,false);
  #endif

  class_<ConvexPolyhedron, bases<BoxWithPlanes3D> >(
        "ConvexPolyhedron",
        "A class defining a convex polyhedral L{AVolume3D} bounded by planes.",
        init<>()
      )  
      .def(init<const ConvexPolyhedron &>())
      .def(
        init<Vector3,Vector3>(
          ( arg("minPoint"), arg("maxPoint") ),
          "Specifies the bounding box of a convex polyhedron.\n"
          "@type minPoint: L{Vector3}\n"
          "@kwarg minPoint: Coordinate of bottom-left-front corner of the bounding box\n"
          "@type maxPoint: L{Vector3}\n"
          "@kwarg maxPoint: Coordinate of upper-right-back corner of the bounding box\n"
        )
      )
       .def(self_ns::str(self))
      ;
}
