from oglpm import *
from att_obj import *

class Tube:
    def __init__(self,sym,length):
        self.sym = sym
	self.length=length
	self.radius = length/20.0
	angle = 2*pi/sym
	self.points = []
	for i in range(sym+1):
	    a = angle*i
	    self.points.append((sin(a)*self.radius,cos(a)*self.radius))
	self.dlist = Dlist()
	self.dlist.begininit()
  	glBegin(GL_QUAD_STRIP)
	p = self.points[0]
	glColor3f(0.0,0.0,0.0)
	glVertex3f(p[0],p[1],0.0)
	glColor3f(1.0,1.0,1.0)
	glVertex3f(p[0]*.3,p[1]*.3,self.length)	
	for i in range(1,self.sym+1):
	    p = self.points[i]
	    glColor3f(0.0,0.0,0.0)
	    glVertex3f(p[0],p[1],0.0)
	    glColor3f(1.0,1.0,1.0)	    
	    glVertex3f(p[0]*.3,p[1]*.3,self.length)
	glEnd()	    
	glBegin(GL_LINES)
	glColor3f(0.0,0.3,0.2)
	for i in range(self.sym):
	    p = self.points[i]
	    glVertex3f(p[0],p[1],0.0)
	    glVertex3f(p[0]*.3,p[1]*.3,self.length)
	glEnd()
	self.dlist.endinit()

    def draw(self):
        self.dlist.draw()
        
class treewrapper(Att_Obj):
    def __init__(self,n,length,angle1,angle2,location):
        Att_Obj.__init__(self,location)
        self.tree = Tubetree(n,length,angle1,angle2)
      
    def draw(self):
        self.tree.draw()
        
class Tubetree:
    def __init__(self,n,length,angle1,angle2):
        from whrandom import *
        self.twopi = 2*pi
        self.n = n
        self.a = 60
        self.length=length
        self.angle1 = angle1
        self.angle2 = angle2
        self.trunk = Tube(n+4,self.length)
        self.branches = 0
        if n > 0:
            self.branches = []
            for i in range(randint(1,4)):
                self.branches.append(Tubetree(n-1,self.length,self.angle1,self.angle2))
        
    def draw(self):
        glPushMatrix()
        self.trunk.draw()
        glTranslate(0,0,self.length)
        glScale(.6,.6,.8)
        if self.branches:
            l = len(self.branches)
            for i in range(l):
	        glRotate(self.angle1,0,1,0)
	        #glRotate(self.angle2,sin(i*self.twopi/l),cos(i*self.twopi/l),0)
	        self.branches[i].draw()
        else:  #draw leaf
            glRotate(self.angle2,1,1,1)
            glColor3f(1,1,1)
            glPointSize(2.0)
            glBegin(GL_POINTS)
            glVertex3f(-7,-7,0)
            glVertex3f(-7,7,0)
            glVertex3f(7,7,0)
            glVertex3f(7,-7,0)
            glEnd()
            glColor3f(1,0,0)
            glPointSize(4.0)
            glBegin(GL_POINTS)
            glVertex3f(0,0,5)
            glEnd()
            glColor3f(0,.6,0)
            glPointSize(8.0)
            glBegin(GL_POINTS)
            glVertex3f(-7,-7,0)
            glVertex3f(-7,7,0)
            glVertex3f(7,7,0)
            glVertex3f(7,-7,0)
            glEnd()
            glPointSize(10.0)
            glColor3f(0,0,0)
            glBegin(GL_POINTS)
            glVertex3f(-7,-7,0)
            glVertex3f(-7,7,0)
            glVertex3f(7,7,0)
            glVertex3f(7,-7,0)
            glEnd()
            glPopMatrix()


class Curlingtree:
    def __init__(self,n,length,angle1,angle2):
        from whrandom import *
	self.twopi = 2*pi
	self.n = n
	self.a = 60
        self.length=length
	self.angle1 = angle1
	self.angle2 = angle2
	self.trunk = Tube(n+4,self.length)
	self.branches = 0
	if n > 0:
	    self.branches = []
            for i in range(2):
	        self.branches.append(Curlingtree2(n-1,self.length,self.angle1,self.angle2))

    def drawforlist(self,n,a):
        glPushMatrix()
	self.trunk.draw()
	glTranslate(0,0,self.length)
	glScale(.6,.6,.8)
	if self.branches and (n>0):
	    l = len(self.branches)
	    for i in range(l):
	        glRotate(a,0,1,0)
	        #glRotate(self.angle2,sin(i*self.twopi/l),cos(i*self.twopi/l),0)
		self.branches[i].drawforlist(n-1,a)
	else:  #draw leaf
	    glRotate(45,1,1,1)
	    glColor3f(1,1,1)
	    glPointSize(2.0)
	    glBegin(GL_POINTS)
	    glVertex3f(-7,-7,0)
	    glVertex3f(-7,7,0)
	    glVertex3f(7,7,0)
	    glVertex3f(7,-7,0)
	    glEnd()
	    glColor3f(1,0,0)
	    glPointSize(4.0)
	    glBegin(GL_POINTS)
	    glVertex3f(0,0,5)
	    glEnd()
	    glColor3f(0,.6,0)
	    glPointSize(8.0)
	    glBegin(GL_POINTS)
	    glVertex3f(-7,-7,0)
	    glVertex3f(-7,7,0)
	    glVertex3f(7,7,0)
	    glVertex3f(7,-7,0)
	    glEnd()
	    glPointSize(10.0)
	    glColor3f(0,0,0)
	    glBegin(GL_POINTS)
	    glVertex3f(-7,-7,0)
	    glVertex3f(-7,7,0)
	    glVertex3f(7,7,0)
	    glVertex3f(7,-7,0)
	    glEnd()
	glPopMatrix()

    def draw(self,distance):
        from whrandom import *
        if distance < 150:
	    self.a = (self.a + 2)%90
            self.drawforlist(self.n,self.a)
	else:
	    self.drawforlist(self.n-1,self.a)
	    
class Curlingtree2:
    def __init__(self,n,length,angle1,angle2):
        from whrandom import *
	self.twopi = 2*pi
	self.n = n
	self.a = 60
        self.length=length
	self.angle1 = angle1
	self.angle2 = angle2
	self.trunk = Tube(n+4,self.length)
	self.branches = 0
	if n > 0:
	    self.branches = []
            for i in range(2):
	        self.branches.append(Curlingtree2(n-1,self.length,self.angle1,self.angle2))
	
	
    def drawforlist(self,n,a):
        glPushMatrix()
	self.trunk.draw()
	glTranslate(0,0,self.length)
	glScale(.4,.4,.4)
	if self.branches and (n>0):
	    l = len(self.branches)
	    for i in range(l):
	        #glRotate(a,0,1,0)
	        glRotate(a,sin(i*self.twopi/l),cos(i*self.twopi/l),0)
		self.branches[i].drawforlist(n-1,a)
	else:  #draw leaf
	    glRotate(45,1,1,1)
	    glColor3f(1,1,1)
	    glPointSize(2.0)
	    glBegin(GL_POINTS)
	    glVertex3f(-7,-7,0)
	    glVertex3f(-7,7,0)
	    glVertex3f(7,7,0)
	    glVertex3f(7,-7,0)
	    glEnd()
	    glColor3f(1,0,0)
	    glPointSize(4.0)
	    glBegin(GL_POINTS)
	    glVertex3f(0,0,5)
	    glEnd()
	    glColor3f(0,.6,0)
	    glPointSize(8.0)
	    glBegin(GL_POINTS)
	    glVertex3f(-7,-7,0)
	    glVertex3f(-7,7,0)
	    glVertex3f(7,7,0)
	    glVertex3f(7,-7,0)
	    glEnd()
	    glPointSize(10.0)
	    glColor3f(0,0,0)
	    glBegin(GL_POINTS)
	    glVertex3f(-7,-7,0)
	    glVertex3f(-7,7,0)
	    glVertex3f(7,7,0)
	    glVertex3f(7,-7,0)
	    glEnd()
	glPopMatrix()

    def draw(self,distance):
        from whrandom import *
	glDisable(GL_LIGHTING)
        if distance < 150:
	    self.a = (self.a + 6)%360
            self.drawforlist(self.n,self.a)
	else:
	    self.drawforlist(self.n,self.a)
