// C++ interface wrapper code.
//
// Generated by SIP v2.5 on Fri Aug 10 18:47:46 2001
//
// Terms and Conditions
// 
// Copyright (c) 1998, 1999, 2000, 2001
// 	Phil Thompson <phil@river-bank.demon.co.uk>
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
// IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// 
// Except as contained in this notice, the name of the copyright holder shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from the
// copyright holder.

#include "sipqtDeclqt.h"
#include "sipqtQIODevice.h"


PyObject *sipClass_QIODevice;

static void sipDealloc_QIODevice(sipThisType *);

static PyTypeObject sipType_QIODevice = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	sipName_qt_QIODevice,
	sizeof (sipThisType),
	0,
	(destructor)sipDealloc_QIODevice,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	Py_TPFLAGS_DEFAULT,
	0,
	0,
	0,
};
#line 70 "qiodevice.sip"
// Virtual handler for functions that fill a buffer and return the number of
// bytes read.

static int doRead(const sipMethodCache *pymc,sipThisType *sipThis,int relLock,
		  char *buf,unsigned buflen,char *fname)
{
	int nread;
	PyObject *pyArgs, *pyRes = NULL;

	if ((pyArgs = Py_BuildValue("(Oi)",sipThis -> sipSelf,buflen)) == NULL)
		goto reperr;

	pyRes = sipEvalMethod(&pymc -> pyMethod,pyArgs);

	Py_DECREF(pyArgs);

	if (pyRes != NULL)
	{
		if (pyRes == Py_None)
		{
			nread = -1;

			goto releaseLock;
		}

		if ((nread = PyString_Size(pyRes)) >= 0)
		{
			memcpy(buf,PyString_AS_STRING(pyRes),nread);

			goto releaseLock;
		}

		sipBadVirtualResultType(sipName_qt_QIODevice,fname);
	}

reperr:
	PyErr_Print();

releaseLock:
	Py_XDECREF(pyRes);

	sipCondReleaseLock(relLock);

	return nread;
}
#line 114 "sipqtQIODevice.cpp"

sipQIODevice::sipQIODevice(): QIODevice()
{
	sipCommonCtor(sipPyMethods,13);
}

sipQIODevice::~sipQIODevice()
{
	sipCommonDtor(sipPyThis);
}

int sipQIODevice::ungetch(int a0)
{
	int relLock;

	if (sipIsPyMethod(&sipPyMethods[0],sipPyThis,sipName_qt_QIODevice,sipName_qt_ungetch,&relLock))
		return sipQIODevice::sipVH_ungetch(&sipPyMethods[0],sipPyThis,relLock,a0);
}

int sipQIODevice::putch(int a0)
{
	int relLock;

	if (sipIsPyMethod(&sipPyMethods[1],sipPyThis,sipName_qt_QIODevice,sipName_qt_putch,&relLock))
		return sipQIODevice::sipVH_putch(&sipPyMethods[1],sipPyThis,relLock,a0);
}

int sipQIODevice::getch()
{
	int relLock;

	if (sipIsPyMethod(&sipPyMethods[2],sipPyThis,sipName_qt_QIODevice,sipName_qt_getch,&relLock))
		return sipQIODevice::sipVH_getch(&sipPyMethods[2],sipPyThis,relLock);
}

int sipQIODevice::readLine(char * a0,unsigned a1)
{
	int relLock;

	return sipIsPyMethod(&sipPyMethods[3],sipPyThis,NULL,sipName_qt_readLine,&relLock) ?
		sipQIODevice::sipVH_readLine(&sipPyMethods[3],sipPyThis,relLock,a0,a1) :
		QIODevice::readLine(a0,a1);
}

int sipQIODevice::writeBlock(const char * a0,unsigned a1)
{
	int relLock;

	if (sipIsPyMethod(&sipPyMethods[4],sipPyThis,sipName_qt_QIODevice,sipName_qt_writeBlock,&relLock))
		return sipQIODevice::sipVH_writeBlock(&sipPyMethods[4],sipPyThis,relLock,a0,a1);
}

int sipQIODevice::readBlock(char * a0,unsigned a1)
{
	int relLock;

	if (sipIsPyMethod(&sipPyMethods[5],sipPyThis,sipName_qt_QIODevice,sipName_qt_readBlock,&relLock))
		return sipQIODevice::sipVH_readBlock(&sipPyMethods[5],sipPyThis,relLock,a0,a1);
}

bool sipQIODevice::atEnd() const
{
	int relLock;

	return sipIsPyMethod((sipMethodCache *)&sipPyMethods[6],sipPyThis,NULL,sipName_qt_atEnd,&relLock) ?
		sipQIODevice::sipVH_atEnd(&sipPyMethods[6],sipPyThis,relLock) :
		QIODevice::atEnd();
}

bool sipQIODevice::at(int a0)
{
	int relLock;

	return sipIsPyMethod(&sipPyMethods[7],sipPyThis,NULL,sipName_qt_at,&relLock) ?
		sipQIODevice::sipVH_at(&sipPyMethods[7],sipPyThis,relLock,a0) :
		QIODevice::at(a0);
}

int sipQIODevice::at() const
{
	int relLock;

	return sipIsPyMethod((sipMethodCache *)&sipPyMethods[8],sipPyThis,NULL,sipName_qt_at,&relLock) ?
		sipQIODevice::sipVH_at(&sipPyMethods[8],sipPyThis,relLock) :
		QIODevice::at();
}

unsigned sipQIODevice::size() const
{
	int relLock;

	if (sipIsPyMethod((sipMethodCache *)&sipPyMethods[9],sipPyThis,sipName_qt_QIODevice,sipName_qt_size,&relLock))
		return sipQIODevice::sipVH_size(&sipPyMethods[9],sipPyThis,relLock);
}

void sipQIODevice::flush()
{
	int relLock;

	if (sipIsPyMethod(&sipPyMethods[10],sipPyThis,sipName_qt_QIODevice,sipName_qt_flush,&relLock))
		sipQIODevice::sipVH_flush(&sipPyMethods[10],sipPyThis,relLock);
}

void sipQIODevice::close()
{
	int relLock;

	if (sipIsPyMethod(&sipPyMethods[11],sipPyThis,sipName_qt_QIODevice,sipName_qt_close,&relLock))
		sipQIODevice::sipVH_close(&sipPyMethods[11],sipPyThis,relLock);
}

bool sipQIODevice::open(int a0)
{
	int relLock;

	if (sipIsPyMethod(&sipPyMethods[12],sipPyThis,sipName_qt_QIODevice,sipName_qt_open,&relLock))
		return sipQIODevice::sipVH_open(&sipPyMethods[12],sipPyThis,relLock,a0);
}

// The common handler for all classes that inherit this virtual member
// function.

int sipQIODevice::sipVH_ungetch(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock,int a0)
{
	int res;
	PyObject *resobj;
	PyObject *sipArgs;

	sipArgs = Py_BuildValue("(Oi)",sipThis -> sipSelf,a0);

	if (sipArgs == NULL)
		goto reportError;

	resobj = sipEvalMethod(&pymc -> pyMethod,sipArgs);

	Py_DECREF(sipArgs);

	if (resobj != NULL)
	{
		res = (int)PyInt_AsLong(resobj);

		Py_DECREF(resobj);

		if (PyErr_Occurred() == NULL)
		{
			goto releaseLock;
		}

		sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_ungetch);
	}

reportError:
	PyErr_Print();

releaseLock:
	sipCondReleaseLock(sipRelLock);

	return res;
}

// The common handler for all classes that inherit this virtual member
// function.

int sipQIODevice::sipVH_putch(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock,int a0)
{
	int res;
	PyObject *resobj;
	PyObject *sipArgs;

	sipArgs = Py_BuildValue("(Oi)",sipThis -> sipSelf,a0);

	if (sipArgs == NULL)
		goto reportError;

	resobj = sipEvalMethod(&pymc -> pyMethod,sipArgs);

	Py_DECREF(sipArgs);

	if (resobj != NULL)
	{
		res = (int)PyInt_AsLong(resobj);

		Py_DECREF(resobj);

		if (PyErr_Occurred() == NULL)
		{
			goto releaseLock;
		}

		sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_putch);
	}

reportError:
	PyErr_Print();

releaseLock:
	sipCondReleaseLock(sipRelLock);

	return res;
}

// The common handler for all classes that inherit this virtual member
// function.

int sipQIODevice::sipVH_getch(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock)
{
	int res;
	PyObject *resobj;
	PyObject *sipArgs;

	sipArgs = Py_BuildValue("(O)",sipThis -> sipSelf);

	if (sipArgs == NULL)
		goto reportError;

	resobj = sipEvalMethod(&pymc -> pyMethod,sipArgs);

	Py_DECREF(sipArgs);

	if (resobj != NULL)
	{
		res = (int)PyInt_AsLong(resobj);

		Py_DECREF(resobj);

		if (PyErr_Occurred() == NULL)
		{
			goto releaseLock;
		}

		sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_getch);
	}

reportError:
	PyErr_Print();

releaseLock:
	sipCondReleaseLock(sipRelLock);

	return res;
}

// The common handler for all classes that inherit this virtual member
// function.

int sipQIODevice::sipVH_readLine(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock,char * a0,unsigned a1)
{
#line 187 "qiodevice.sip"
		return doRead(pymc,sipThis,sipRelLock,a0,a1,sipName_qt_readLine);
#line 364 "sipqtQIODevice.cpp"
}

// The common handler for all classes that inherit this virtual member
// function.

int sipQIODevice::sipVH_writeBlock(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock,const char * a0,unsigned a1)
{
#line 154 "qiodevice.sip"
		int nwritten;
		PyObject *pyArgs, *pyRes;

		if ((pyArgs = Py_BuildValue("(Os#i)",sipThis -> sipSelf,a0,a1,a1)) == NULL)
			goto reperr;

		pyRes = sipEvalMethod(&pymc -> pyMethod,pyArgs);

		Py_DECREF(pyArgs);

		if (pyRes != NULL)
		{
			nwritten = (int)PyInt_AsLong(pyRes);

			Py_DECREF(pyRes);

			if (PyErr_Occurred() != NULL)
				goto releaseLock;

			sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_writeBlock);
		}

reperr:
		PyErr_Print();

releaseLock:
		sipCondReleaseLock(sipRelLock);

		return nwritten;
#line 402 "sipqtQIODevice.cpp"
}

// The common handler for all classes that inherit this virtual member
// function.

int sipQIODevice::sipVH_readBlock(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock,char * a0,unsigned a1)
{
#line 149 "qiodevice.sip"
		return doRead(pymc,sipThis,sipRelLock,a0,a1,sipName_qt_readBlock);
#line 412 "sipqtQIODevice.cpp"
}

// The common handler for all classes that inherit this virtual member
// function.

bool sipQIODevice::sipVH_atEnd(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock)
{
	bool res;
	PyObject *resobj;
	PyObject *sipArgs;

	sipArgs = Py_BuildValue("(O)",sipThis -> sipSelf);

	if (sipArgs == NULL)
		goto reportError;

	resobj = sipEvalMethod(&pymc -> pyMethod,sipArgs);

	Py_DECREF(sipArgs);

	if (resobj != NULL)
	{
		res = (bool)PyInt_AsLong(resobj);

		Py_DECREF(resobj);

		if (PyErr_Occurred() == NULL)
		{
			goto releaseLock;
		}

		sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_atEnd);
	}

reportError:
	PyErr_Print();

releaseLock:
	sipCondReleaseLock(sipRelLock);

	return res;
}

// The common handler for all classes that inherit this virtual member
// function.

bool sipQIODevice::sipVH_at(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock,int a0)
{
	bool res;
	PyObject *resobj;
	PyObject *sipArgs;

	sipArgs = Py_BuildValue("(Oi)",sipThis -> sipSelf,a0);

	if (sipArgs == NULL)
		goto reportError;

	resobj = sipEvalMethod(&pymc -> pyMethod,sipArgs);

	Py_DECREF(sipArgs);

	if (resobj != NULL)
	{
		res = (bool)PyInt_AsLong(resobj);

		Py_DECREF(resobj);

		if (PyErr_Occurred() == NULL)
		{
			goto releaseLock;
		}

		sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_at);
	}

reportError:
	PyErr_Print();

releaseLock:
	sipCondReleaseLock(sipRelLock);

	return res;
}

// The common handler for all classes that inherit this virtual member
// function.

int sipQIODevice::sipVH_at(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock)
{
	int res;
	PyObject *resobj;
	PyObject *sipArgs;

	sipArgs = Py_BuildValue("(O)",sipThis -> sipSelf);

	if (sipArgs == NULL)
		goto reportError;

	resobj = sipEvalMethod(&pymc -> pyMethod,sipArgs);

	Py_DECREF(sipArgs);

	if (resobj != NULL)
	{
		res = (int)PyInt_AsLong(resobj);

		Py_DECREF(resobj);

		if (PyErr_Occurred() == NULL)
		{
			goto releaseLock;
		}

		sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_at);
	}

reportError:
	PyErr_Print();

releaseLock:
	sipCondReleaseLock(sipRelLock);

	return res;
}

// The common handler for all classes that inherit this virtual member
// function.

unsigned sipQIODevice::sipVH_size(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock)
{
	unsigned res;
	PyObject *resobj;
	PyObject *sipArgs;

	sipArgs = Py_BuildValue("(O)",sipThis -> sipSelf);

	if (sipArgs == NULL)
		goto reportError;

	resobj = sipEvalMethod(&pymc -> pyMethod,sipArgs);

	Py_DECREF(sipArgs);

	if (resobj != NULL)
	{
		res = (unsigned)PyInt_AsLong(resobj);

		Py_DECREF(resobj);

		if (PyErr_Occurred() == NULL)
		{
			goto releaseLock;
		}

		sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_size);
	}

reportError:
	PyErr_Print();

releaseLock:
	sipCondReleaseLock(sipRelLock);

	return res;
}

// The common handler for all classes that inherit this virtual member
// function.

void sipQIODevice::sipVH_flush(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock)
{
	PyObject *resobj;
	PyObject *sipArgs;

	sipArgs = Py_BuildValue("(O)",sipThis -> sipSelf);

	if (sipArgs == NULL)
		goto reportError;

	resobj = sipEvalMethod(&pymc -> pyMethod,sipArgs);

	Py_DECREF(sipArgs);

	if (resobj != NULL)
	{
		Py_DECREF(resobj);

		if (resobj == Py_None)
			goto releaseLock;

		sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_flush);
	}

reportError:
	PyErr_Print();

releaseLock:
	sipCondReleaseLock(sipRelLock);
}

// The common handler for all classes that inherit this virtual member
// function.

void sipQIODevice::sipVH_close(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock)
{
	PyObject *resobj;
	PyObject *sipArgs;

	sipArgs = Py_BuildValue("(O)",sipThis -> sipSelf);

	if (sipArgs == NULL)
		goto reportError;

	resobj = sipEvalMethod(&pymc -> pyMethod,sipArgs);

	Py_DECREF(sipArgs);

	if (resobj != NULL)
	{
		Py_DECREF(resobj);

		if (resobj == Py_None)
			goto releaseLock;

		sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_close);
	}

reportError:
	PyErr_Print();

releaseLock:
	sipCondReleaseLock(sipRelLock);
}

// The common handler for all classes that inherit this virtual member
// function.

bool sipQIODevice::sipVH_open(const sipMethodCache *pymc,sipThisType *sipThis,int sipRelLock,int a0)
{
	bool res;
	PyObject *resobj;
	PyObject *sipArgs;

	sipArgs = Py_BuildValue("(Oi)",sipThis -> sipSelf,a0);

	if (sipArgs == NULL)
		goto reportError;

	resobj = sipEvalMethod(&pymc -> pyMethod,sipArgs);

	Py_DECREF(sipArgs);

	if (resobj != NULL)
	{
		res = (bool)PyInt_AsLong(resobj);

		Py_DECREF(resobj);

		if (PyErr_Occurred() == NULL)
		{
			goto releaseLock;
		}

		sipBadVirtualResultType(sipName_qt_QIODevice,sipName_qt_open);
	}

reportError:
	PyErr_Print();

releaseLock:
	sipCondReleaseLock(sipRelLock);

	return res;
}

void sipQIODevice::sipProtect_setFlags(int a0)
{
	QIODevice::setFlags(a0);
}

void sipQIODevice::sipProtect_setType(int a0)
{
	QIODevice::setType(a0);
}

void sipQIODevice::sipProtect_setMode(int a0)
{
	QIODevice::setMode(a0);
}

void sipQIODevice::sipProtect_setState(int a0)
{
	QIODevice::setState(a0);
}

void sipQIODevice::sipProtect_setStatus(int a0)
{
	QIODevice::setStatus(a0);
}

static PyObject *sipDo_QIODevice_flags(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			int res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::flags();

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_flags);

	return NULL;
}

static PyObject *sipDo_QIODevice_mode(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			int res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::mode();

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_mode);

	return NULL;
}

static PyObject *sipDo_QIODevice_state(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			int res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::state();

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_state);

	return NULL;
}

static PyObject *sipDo_QIODevice_isDirectAccess(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isDirectAccess();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isDirectAccess);

	return NULL;
}

static PyObject *sipDo_QIODevice_isSequentialAccess(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isSequentialAccess();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isSequentialAccess);

	return NULL;
}

static PyObject *sipDo_QIODevice_isCombinedAccess(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isCombinedAccess();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isCombinedAccess);

	return NULL;
}

static PyObject *sipDo_QIODevice_isBuffered(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isBuffered();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isBuffered);

	return NULL;
}

static PyObject *sipDo_QIODevice_isRaw(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isRaw();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isRaw);

	return NULL;
}

static PyObject *sipDo_QIODevice_isSynchronous(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isSynchronous();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isSynchronous);

	return NULL;
}

static PyObject *sipDo_QIODevice_isAsynchronous(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isAsynchronous();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isAsynchronous);

	return NULL;
}

static PyObject *sipDo_QIODevice_isTranslated(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isTranslated();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isTranslated);

	return NULL;
}

static PyObject *sipDo_QIODevice_isReadable(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isReadable();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isReadable);

	return NULL;
}

static PyObject *sipDo_QIODevice_isWritable(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isWritable();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isWritable);

	return NULL;
}

static PyObject *sipDo_QIODevice_isReadWrite(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isReadWrite();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isReadWrite);

	return NULL;
}

static PyObject *sipDo_QIODevice_isInactive(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isInactive();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isInactive);

	return NULL;
}

static PyObject *sipDo_QIODevice_isOpen(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::isOpen();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_isOpen);

	return NULL;
}

static PyObject *sipDo_QIODevice_status(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			int res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::status();

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_status);

	return NULL;
}

static PyObject *sipDo_QIODevice_resetStatus(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			ptr -> QIODevice::resetStatus();

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_resetStatus);

	return NULL;
}

static PyObject *sipDo_QIODevice_at(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			int res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::at();

			return PyInt_FromLong((long)res);
		}
	}

	{
		int a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::at( a0);

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_at);

	return NULL;
}

static PyObject *sipDo_QIODevice_atEnd(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::atEnd();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_atEnd);

	return NULL;
}

static PyObject *sipDo_QIODevice_reset(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			bool res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::reset();

			return sipConvertFromBool((int)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_reset);

	return NULL;
}

static PyObject *sipDo_QIODevice_writeBlock(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		const QByteArray * a0;
		PyObject *a0obj;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"I",sipCanConvertTo_QByteArray,&a0obj))
		{
			int res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			int iserr = 0;

			int istemp0 = sipConvertTo_QByteArray(a0obj,(QByteArray **)&a0,1,&iserr);

			if (iserr)
				return NULL;

			res = ptr -> QIODevice::writeBlock(* a0);

			if (istemp0)
				delete a0;

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_writeBlock);

	return NULL;
}

static PyObject *sipDo_QIODevice_readLine(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		char * a0;
		unsigned a1;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"si",&a0,&a1))
		{
			int res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = ptr -> QIODevice::readLine( a0, a1);

			return PyInt_FromLong((long)res);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_readLine);

	return NULL;
}

static PyObject *sipDo_QIODevice_readAll(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,""))
		{
			QByteArray *res;
			QIODevice *ptr;

			if ((ptr = (QIODevice *)sipGetCppPtr(sipThis,sipClass_QIODevice)) == NULL)
				return NULL;

			res = new QByteArray(ptr -> QIODevice::readAll());

			return sipNewCppToSelf(res,sipClass_QByteArray,SIP_SIMPLE | SIP_PY_OWNED);
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_readAll);

	return NULL;
}

static PyObject *sipDo_QIODevice_setFlags(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		int a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			sipQIODevice *ptr;

			if ((ptr = (sipQIODevice *)sipGetComplexCppPtr(sipThis)) == NULL)
				return NULL;

			ptr -> sipProtect_setFlags( a0);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_setFlags);

	return NULL;
}

static PyObject *sipDo_QIODevice_setType(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		int a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			sipQIODevice *ptr;

			if ((ptr = (sipQIODevice *)sipGetComplexCppPtr(sipThis)) == NULL)
				return NULL;

			ptr -> sipProtect_setType( a0);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_setType);

	return NULL;
}

static PyObject *sipDo_QIODevice_setMode(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		int a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			sipQIODevice *ptr;

			if ((ptr = (sipQIODevice *)sipGetComplexCppPtr(sipThis)) == NULL)
				return NULL;

			ptr -> sipProtect_setMode( a0);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_setMode);

	return NULL;
}

static PyObject *sipDo_QIODevice_setState(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		int a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			sipQIODevice *ptr;

			if ((ptr = (sipQIODevice *)sipGetComplexCppPtr(sipThis)) == NULL)
				return NULL;

			ptr -> sipProtect_setState( a0);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_setState);

	return NULL;
}

static PyObject *sipDo_QIODevice_setStatus(PyObject *sipThisObj,PyObject *sipArgs)
{
	sipThisType *sipThis;
	int sipArgsParsed = 0;

	if ((sipThis = sipGetThis(sipThisObj,&sipArgs,sipClass_QIODevice)) == NULL)
		return NULL;

	{
		int a0;

		if (sipParseArgs(&sipArgsParsed,sipArgs,"i",&a0))
		{
			sipQIODevice *ptr;

			if ((ptr = (sipQIODevice *)sipGetComplexCppPtr(sipThis)) == NULL)
				return NULL;

			ptr -> sipProtect_setStatus( a0);

			Py_INCREF(Py_None);
			return Py_None;
		}
	}

	// Report an error if the arguments couldn't be parsed.

	sipNoMethod(sipArgsParsed,sipName_qt_QIODevice,sipName_qt_setStatus);

	return NULL;
}

// Cast a pointer to a type somewhere in its superclass hierachy.

const void *sipCast_QIODevice(const void *ptr,PyObject *targetClass)
{
	if (targetClass == sipClass_QIODevice)
		return ptr;

	return NULL;
}

static void sipDealloc_QIODevice(sipThisType *sipThis)
{
	if (sipThis -> u.cppPtr != NULL)
	{
		if (!sipIsSimple(sipThis))
			((sipQIODevice *)sipThis -> u.cppPtr) -> sipPyThis = NULL;

		if (sipIsPyOwned(sipThis))
			if (sipIsSimple(sipThis))
				delete (QIODevice *)sipThis -> u.cppPtr;
			else
				delete (sipQIODevice *)sipThis -> u.cppPtr;
	}

	sipDeleteThis(sipThis);
}

PyObject *sipNew_QIODevice(PyObject *sipSelf,PyObject *sipArgs)
{
	static sipExtraType et = {
		sipCast_QIODevice,
		(void *)sipNewProxy_qt,
		NULL
	};

	sipThisType *sipThis = NULL;
	const void *sipNew = NULL;
	int sipFlags = SIP_PY_OWNED;
	int sipArgsParsed = 0;

	// See if there is something pending.

	sipNew = sipGetPending(&sipFlags);

	if (sipNew == NULL)
	{
		if (sipParseArgs(&sipArgsParsed,sipArgs,"-"))
		{
			sipNew = new sipQIODevice();
		}
	}

	if (sipNew == NULL)
	{
		sipNoCtor(sipArgsParsed,sipName_qt_QIODevice);
		return NULL;
	}

	// Wrap the object.

	if ((sipThis = sipCreateThis(sipSelf,sipNew,&sipType_QIODevice,sipFlags,&et)) == NULL)
	{
		if (sipFlags & SIP_PY_OWNED)
			if (sipFlags & SIP_SIMPLE)
				delete (QIODevice *)sipNew;
			else
				delete (sipQIODevice *)sipNew;

		return NULL;
	}

	if (!(sipFlags & SIP_SIMPLE))
		((sipQIODevice *)sipNew) -> sipPyThis = sipThis;

	Py_INCREF(Py_None);
	return Py_None;
}

PyMethodDef sipClassAttrTab_QIODevice[] = {
	{sipName_qt_flags, sipDo_QIODevice_flags, METH_VARARGS, NULL},
	{sipName_qt_mode, sipDo_QIODevice_mode, METH_VARARGS, NULL},
	{sipName_qt_state, sipDo_QIODevice_state, METH_VARARGS, NULL},
	{sipName_qt_isDirectAccess, sipDo_QIODevice_isDirectAccess, METH_VARARGS, NULL},
	{sipName_qt_isSequentialAccess, sipDo_QIODevice_isSequentialAccess, METH_VARARGS, NULL},
	{sipName_qt_isCombinedAccess, sipDo_QIODevice_isCombinedAccess, METH_VARARGS, NULL},
	{sipName_qt_isBuffered, sipDo_QIODevice_isBuffered, METH_VARARGS, NULL},
	{sipName_qt_isRaw, sipDo_QIODevice_isRaw, METH_VARARGS, NULL},
	{sipName_qt_isSynchronous, sipDo_QIODevice_isSynchronous, METH_VARARGS, NULL},
	{sipName_qt_isAsynchronous, sipDo_QIODevice_isAsynchronous, METH_VARARGS, NULL},
	{sipName_qt_isTranslated, sipDo_QIODevice_isTranslated, METH_VARARGS, NULL},
	{sipName_qt_isReadable, sipDo_QIODevice_isReadable, METH_VARARGS, NULL},
	{sipName_qt_isWritable, sipDo_QIODevice_isWritable, METH_VARARGS, NULL},
	{sipName_qt_isReadWrite, sipDo_QIODevice_isReadWrite, METH_VARARGS, NULL},
	{sipName_qt_isInactive, sipDo_QIODevice_isInactive, METH_VARARGS, NULL},
	{sipName_qt_isOpen, sipDo_QIODevice_isOpen, METH_VARARGS, NULL},
	{sipName_qt_status, sipDo_QIODevice_status, METH_VARARGS, NULL},
	{sipName_qt_resetStatus, sipDo_QIODevice_resetStatus, METH_VARARGS, NULL},
	{sipName_qt_at, sipDo_QIODevice_at, METH_VARARGS, NULL},
	{sipName_qt_atEnd, sipDo_QIODevice_atEnd, METH_VARARGS, NULL},
	{sipName_qt_reset, sipDo_QIODevice_reset, METH_VARARGS, NULL},
	{sipName_qt_writeBlock, sipDo_QIODevice_writeBlock, METH_VARARGS, NULL},
	{sipName_qt_readLine, sipDo_QIODevice_readLine, METH_VARARGS, NULL},
	{sipName_qt_readAll, sipDo_QIODevice_readAll, METH_VARARGS, NULL},
	{sipName_qt_setFlags, sipDo_QIODevice_setFlags, METH_VARARGS, NULL},
	{sipName_qt_setType, sipDo_QIODevice_setType, METH_VARARGS, NULL},
	{sipName_qt_setMode, sipDo_QIODevice_setMode, METH_VARARGS, NULL},
	{sipName_qt_setState, sipDo_QIODevice_setState, METH_VARARGS, NULL},
	{sipName_qt_setStatus, sipDo_QIODevice_setStatus, METH_VARARGS, NULL},
	{NULL}
};

int sipCanConvertTo_QIODevice(PyObject *sipPy)
{
	return sipIsSubClassInstance(sipPy,sipClass_QIODevice);
}

void sipConvertTo_QIODevice(PyObject *sipPy,QIODevice **sipCppPtr,int sipWillDeref,int *sipIsErr)
{
	if (*sipIsErr || sipPy == NULL)
		return;

	if (sipPy == Py_None)
	{
		sipCheckNone(sipWillDeref,sipIsErr,sipName_qt_QIODevice);
		*sipCppPtr = NULL;

		return;
	}

	*sipCppPtr = (QIODevice *)sipConvertToCpp(sipPy,sipClass_QIODevice,sipIsErr);
}

QIODevice *sipForceConvertTo_QIODevice(PyObject *valobj,int *iserrp)
{
	if (*iserrp || valobj == NULL || valobj == Py_None)
		return NULL;

	if (sipCanConvertTo_QIODevice(valobj))
	{
		QIODevice *val;

		sipConvertTo_QIODevice(valobj,&val,0,iserrp);

		return val;
	}

	sipBadClass(sipName_qt_QIODevice);

	*iserrp = 1;

	return NULL;
}
