def split_path(path):
    """Splits a module name into package, and module"""
    from string import rindex
    try:
	ix = rindex(path, '.')
	return path[:ix], path[ix+1:]
    except ValueError:
	return None, path

def parent_path(path):
    """Returns the parent package name of given module.
    'None' is returned if module has no parent"""
    return split_path(path)[0]

def id2name(id):
    "Convert id (path) to relative name (i.e. strip package/class names)"
    from string import rfind
    ix = rfind(id, '.')
    if ix != -1:
	return id[ix+1:]
    else:
	return id
