/***************************************************************************
  grainpage.h
  -------------------
  A dialog page for grains
  -------------------
  begin         October 10th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  3. Neither name of the copyright holders nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef GRAINPAGE_H
#define GRAINPAGE_H

#include "grain.h"
#include "ingredientpage.h"

class QCheckBox;

class GrainPage : public IngredientPage  {
    Q_OBJECT
public:
    // constructor
    GrainPage(QWidget *parent, const char *name, QObject *doc, QObject *calc);
    // destructor
    ~GrainPage();

protected slots:
    // recieved if add clicked
    void slotAddGrain();    
    // recieved if remove clicked
    void slotRemoveGrain();    
    // recieved if apply clicked
    void slotApplyGrain();    
    // receives if document has changed
    void slotDocumentChanged();
    // update the widgets in the entry area
    void slotUpdateEntryItems(const QString &name);
    // received if an ingredient was selected
    void slotItemSelected(QListViewItem *item);

private:
    // update the list view
    void updateListView();
    // set a combobox to item
    void setComboItem(QComboBox *combo, const QString &text);
    
private:
    QLabel* extractlabel_;
    FixedSpinBox* extractspin_;
    QLabel* colorlabel_;
    FixedSpinBox* colorspin_;
    QLabel* uselabel_;
    QComboBox* usecombo_;
    GrainListItem* currentitem_;
};

#endif // GRAINPAGE_H
