/****************************************************************************
**
** Copyright (C) 2003-2007 Trolltech ASA. All rights reserved.
**
** This file is part of a Qt Solutions component.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** Trolltech sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include <QtGui>
#include <qtbrowserplugin.h>

#include <plib/ssg.h>
#include "glcontrol.hpp"
#include "messages.hpp"
#include "astar.hpp"


int g_mouse_mode=0;
int g_mouse_x=0;
int g_mouse_y=0;
int g_mouse_button=0;
sgVec3 g_poi; // point of interest
int g_window_w=0;
int g_window_h=0;
int g_key=0;
int g_playmode=0;
int g_switch = 0;
long g_nextid=0;
Glcontrol    *g_gl=NULL;
QString g_prjpath;
// Catalog
QString g_3dcatalogpath;
QString g_scriptcatalogpath;
QString g_soundcatalogpath;
QString g_shadercatalogpath;
QString g_physikcatalogpath;

QString g_apppath;
Messages *g_messages = NULL;
FolderListItem *g_tmpItem=NULL;
FolderListItem *g_switchScene = NULL;
// AStar
aStar *gastar= NULL;

class QCweb3d : public QWidget
{
    Q_OBJECT
    Q_PROPERTY(QString text READ text WRITE setText)

    Q_CLASSINFO("ClassID", "{4a22176d-118f-4185-9653-9f98958a6df8}")
    Q_CLASSINFO("InterfaceID", "{1df735ba-da4f-4fb7-8f35-b8dfbf8cfd9a}")
    Q_CLASSINFO("EventsID", "{349de213-f8bd-4d2e-a2cf-eab407c03245}")

    Q_CLASSINFO("MIME", "qcweb3d/very:xxx:QCweb3d and useless")
    Q_CLASSINFO("ToSuperClass", "QCweb3d")
    Q_CLASSINFO("DefaultProperty", "text")

public:
    QCweb3d(QWidget *parent = 0)
        : QWidget(parent)
    {
        m_text = QString::fromLatin1("Empty");
//        g_gl = new Glcontrol();
        g_gl = new Glcontrol(this);
        QHBoxLayout *layout = new QHBoxLayout;
        layout->addWidget(g_gl);
        this->setLayout(layout);
        this->show();
    }

    ~QCweb3d()
    {
       delete g_gl;
       g_gl=NULL;
    }

    void mousePressEvent(QMouseEvent *)
    {
        mouseDown();
    }
    void mouseMoveEvent(QMouseEvent *e)
    {
        mouseMove(e->x(), e->y());
    }
    void mouseReleaseEvent(QMouseEvent*)
    {
        mouseUp();
    }
    QString text() const
    {
        return m_text;
    }

public slots:
    void about()
    {
        QMessageBox::aboutQt(this);
    }
    void setText(const QString &text)
    {
        m_text = text;
        update();
    }

signals:
    void mouseDown();
    void mouseMove(int x, int y);
    void mouseUp();

protected:
    void paintEvent(QPaintEvent*)
    {
        QPainter p(this);
        QRect r(rect());
//        g_gl->show();
//        g_gl->resizeGL( 600, 400 );
//          resize(300,300);
//        g_gl->resizeGL( r.width(), r.height() );
//        r.adjust(0, 0, -1, -1);
//        p.drawRect(r);
//        p.drawText(r, Qt::AlignCenter, m_text);
    }

private:
    QString m_text;
};

#include "qcweb3d.moc"

QTNPFACTORY_BEGIN("QCweb3d Plugin", "A QCake-based LiveConnected plug-in that plays qcake files")
    QTNPCLASS(QCweb3d)
QTNPFACTORY_END()

#ifdef QAXSERVER
#include <ActiveQt/QAxFactory>
QAXFACTORY_BEGIN("{9a3216bf-7e20-482c-84c6-06167bacb616}", "{07538ca5-eb7a-4f24-a3c4-a120c6e04dc4}")
    QAXCLASS(QCweb3d)
QAXFACTORY_END()
#endif
