/***************************************************************************
                          player.h  -  description
                             -------------------
    begin                : Mit Sep 25 13:11:41 CEST 2002
    copyright            : (C) 2002 by Harald Krippel
    email                : neuro.harald@surfeu.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef PLAYER_H
#define PLAYER_H

/**
	@author Harald Krippel <harald@the-develop.net>
*/


#include "globdefines.h"
#include <plib/ssg.h>
#include <ode/ode.h>


class Player
{
   public:
     Player(void);
     void   createOdeBody(dWorldID odworld, dSpaceID odspace);
     void   update(float dt);
     void   setTransform (ssgTransform *objtrans, const dReal pos[3], const dReal R[12]);
     void   setCamera (const dReal pos[3], const dReal R[12]);
     void   kbd ( char key );
     void   maus ( float x, float y );
     void   SetPosition ();
     void   GetPosition ( sgCoord  *bodypos );
     ~Player(void);

   ssgTransform *objtrans[MAX_PLAYER_OBJ*2];
   float rotspeed;
   float transspeed;
   float fmax2;
   float tmprotspeed;
   float tmptransspeed;
   float netrotspeed;
   float nettransspeed;
   
   sgCoord      pos;
   char kbforward;
   char kbback;
   char kbleft;      
   char kbright;

   int camtyp;
   sgMat4 cmat;
   float  camrotw;
   float  camhight;
   float  camradius;

   char kbcamrotadd;
   char kbcamrotsub;
   char kbcamradadd;
   char kbcamradsub;
   char kbcamheightadd;
   char kbcamheightsub;
   
   float gox;
   float goy;
   float gmox;
   float gmoy;
   
   int  controller;
   int  jaxis[2][2];

   
    /* ode test */
    dMass odm;
    dBodyID odbody[MAX_PLAYER_OBJ];
    dGeomID odbox[MAX_PLAYER_OBJ];
    dSpaceID car_space;
    dGeomID odsphere[MAX_PLAYER_OBJ];
    dJointID odjoint[MAX_PLAYER_OBJ];	// joint[0] is the front wheel
  
protected:

};

#endif
