//
// C++ Implementation: scripting
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>
#include "scripting.hpp"
#include "splamodel.hpp"
#include "joystickenv.hpp"
#include "astar.hpp"
#include "glcontrol.hpp"
#include "messages.hpp"

QcakeScriptApi * QcakeScriptApi::theInstancePtr = 0;

QcakeScriptApi::QcakeScriptApi(QObject *parent)
{
  inititem= NULL;
}

QcakeScriptApi::~QcakeScriptApi()
{

}

QcakeScriptApi * QcakeScriptApi::theInstance(QObject *parent) {
    if (theInstancePtr == 0) {
        theInstancePtr = new QcakeScriptApi(parent);
    }
    return theInstancePtr;
}

void QcakeScriptApi::Init (FolderListItem *item)
{
  qWarning ( "spla: splInit()\n" ) ;
  inititem = item;
  while (!splaModel::g_Models.isEmpty())
     delete splaModel::g_Models.takeFirst();
}

splaModel *QcakeScriptApi::getModel ( int i )
{
  if ( i < 0 || i >=  splaModel::g_Models.size ())
  {
    qWarning ( "spla: There is no such model as '%d'\n", i ) ;
    QString qmsg = "spla: There is no such model\n";
    ErrorMsg errormsg(qmsg);
    return NULL;
  }
  return splaModel::g_Models.at ( i );
}

void QcakeScriptApi::debug(const QString &msg)
{
    QString qmsg;

    QTextStream(&qmsg) << "jsDebug: " << msg << "\n";
    ErrorMsg errormsg(qmsg);
}

float QcakeScriptApi::getPositionX(int hh)
{
  splaModel *model=getModel ( hh );
  if(model){
    return model-> getPositionX () ; 
  }
  return 0;
}
float QcakeScriptApi::getPositionY(int hh)
{
  splaModel *model=getModel ( hh );
  if(model){
    return model-> getPositionY () ; 
  }
  return 0;
}

float QcakeScriptApi::getPositionZ(int hh)
{
  splaModel *model=getModel ( hh );
  if(model){
    return model-> getPositionZ () ; 
  }
  return 0;
}

float QcakeScriptApi::getPositionH(int hh)
{
  splaModel *model=getModel ( hh );
  if(model){
    return model-> getPositionH () ; 
  }
  return 0;
}

float QcakeScriptApi::getPositionP(int hh)
{
  splaModel *model=getModel ( hh );
  if(model){
    return model-> getPositionP () ; 
  }
  return 0;
}

float QcakeScriptApi::getPositionR(int hh)
{
  splaModel *model=getModel ( hh );
  if(model){
    return model-> getPositionR () ; 
  }
  return 0;
}

float QcakeScriptApi::getJoystick ( int js,int a )
{
  float value = 0;

  ph_mutex.lock();
  JoystickEnv *Joystick=JoystickEnv::theInstance();
  value = Joystick->getAxis(js,a);
  ph_mutex.unlock();
  return(value);
}

int QcakeScriptApi::getJoyButton (int js)
{
  int value = 0;

  ph_mutex.lock();
  JoystickEnv *Joystick=JoystickEnv::theInstance();
  value = Joystick->getButtons(js);
  ph_mutex.unlock();
  return(value);
}

void QcakeScriptApi::addRelTorque ( int hh, float velx, float vely, float velz )
{
  splaModel *model=getModel ( hh );
  if(model){
    model-> addRelTorque ( velx, vely, velz ) ;
  }
}

void QcakeScriptApi::addRelForce ( int hh, float velx, float vely, float velz )
{
  splaModel *model=getModel ( hh );
  if(model){
    model-> addRelForce ( velx, vely, velz ) ;
  }
}

void QcakeScriptApi::Redraw ()
{
//  double dt = siFrameTimer -> getDeltaTime () ;
  double dt = 0 ;
  for (int i = 0; i < splaModel::g_Models.size(); ++i) {
     splaModel::g_Models.at(i) -> update ( dt ) ;
  }
}

int QcakeScriptApi::switchScene ( int hh)
{
  int value=0;
  splaModel *model=getModel ( hh );
  if(model){
    value = model-> switchScene ( ) ;
    return(value);
  }
  return 0;
}

int QcakeScriptApi::switchCamera ( int hh)
{
  int value=0;
  splaModel *model=getModel ( hh );
  if(model){
    value = model-> switchCamera ( ) ;
    return(value);
  }
  return 0;
}

void QcakeScriptApi::setSequence ( int hh, int sequence, int mode )
{
  splaModel *model=getModel ( hh );
  if(model){
    model-> setSequence ( sequence , mode ) ;
  }
}

void QcakeScriptApi::setAngularVel ( int hh, float velx, float vely, float velz )
{
  splaModel *model=getModel ( hh );
  if(model){
    model-> setAngularVel ( velx, vely, velz ) ;
  }
}

void QcakeScriptApi::setLinVel ( int hh, float velx, float vely, float velz )
{
  splaModel *model=getModel ( hh );
  if(model){
    model-> setLinVel ( velx, vely, velz ) ;
  }
}

void QcakeScriptApi::setRotation ( int hh, float h, float p, float r )
{
  splaModel *model=getModel ( hh );
  if(model){
    model-> setRotation ( h, p, r ) ;
  }
}

void QcakeScriptApi::rotation ( int hh, float h, float p, float r )
{
  splaModel *model=getModel ( hh );
  if(model){
    model-> Rotation ( h, p, r ) ;
  }
}

void QcakeScriptApi::setPosition ( int hh, float x, float y, float z,
                          float h, float p, float r )
{
  splaModel *model=getModel ( hh );
  if(model){
    model-> setPosition ( x, y, z, h, p, r ) ;
  }
}

void QcakeScriptApi::playSound ( int hh)
{
  splaModel *model=getModel ( hh );
  if(model){
    model-> playSound ( ) ;
  }
}

void QcakeScriptApi::stopSound ( int hh)
{
  splaModel *model=getModel ( hh );
  if(model){
   model-> stopSound ( ) ;
  }
}

int QcakeScriptApi::getRef ( int id )
{
  splaModel *m = new splaModel ( id ,inititem) ;
  return m -> getHandle () ;
}

int QcakeScriptApi::getMouse ( int a )
{
  int value = 0;

  if ( a == 0 )
  {
      value = g_mouse_x;
  }
  if ( a == 1 )
  {
      value = g_mouse_y;
  }
  return(value);
}

int QcakeScriptApi::getMouseButton (void)
{
  int value = 0;

  value = g_mouse_button;
  return(value);
}

/* get the global POI */
float QcakeScriptApi::get3DMouse ( int a )
{
  float value = 0.0f;

  if ( a == 0 )  // POI->x
  {
      value = g_poi[0];
  }
  if ( a == 1 ) // POI->y
  {
      value = g_poi[1];
  }
  if ( a == 2 ) // POI->z
  {
      value = g_poi[2];
  }
  return(value);
}

QString QcakeScriptApi::getAttribute ( int hh, char * attr)
{
  QString value;

  splaModel *model=getModel ( hh );
  if(model){
    value = model-> getAttribute ( attr ) ;
  }
  return(value);
}

int QcakeScriptApi::setAttribute ( int hh, char * attr, char * value)
{
  splaModel *model=getModel ( hh );
  if(model){
    model-> setAttribute ( attr , value) ;
  }
  return (0);
}

int QcakeScriptApi::getKey ()
{
  int tmp;

   tmp=g_key;
   g_key=0;
   return(tmp);
}

int QcakeScriptApi::srand (unsigned int seed)
{
   srand(seed);
   return(0);
}

float QcakeScriptApi::rand ()



{
   return((float)((float)rand()/ (float)RAND_MAX));
}

int QcakeScriptApi::astarFindPath (int pl,int sx,int sy,int tx,int ty)
{
  if(gastar == NULL){
    	qWarning ("splaAstarFindPath: ERROR - call splaAstarInit before use !\n" ) ;
  	return (0);
  }
  return(gastar->FindPath(pl,sx,sy,tx,ty));
}

int QcakeScriptApi::astarReadPathX (int pl,int sx)
{
  if(gastar == NULL){
    	qWarning ( "splaAstarFindPath: ERROR - call splaAstarInit before use !\n" ) ;
  	return (0);
  }
  return(gastar->ReadPathX(pl,sx));
}

int QcakeScriptApi::astarReadPathY (int pl,int sy)
{
  if(gastar == NULL){
    	qWarning ( "splaAstarFindPath: ERROR - call splaAstarInit before use !\n" ) ;
  	return (0);
  }
  return(gastar->ReadPathY(pl,sy));
}

int QcakeScriptApi::astarReadMap (const QString &file)
{
  if(gastar == NULL){
    	 qWarning( "splaAstarFindPath: ERROR - call splaAstarInit before use !\n" ) ;
  	return (0);
  }
  QString pfad =  g_prjpath + file;
  return(gastar->ReadMap(pfad.toAscii()));
}

int QcakeScriptApi::astarReadMapValue (int x, int y)
{
  if(gastar == NULL){
    	qWarning ( "splaAstarFindPath: ERROR - call splaAstarInit before use !\n" ) ;
  	return (0);
  }
  return(gastar->ReadMapValue(x,y));
}

int QcakeScriptApi::astarInit (int mapWidth, int mapHeight , int tileSize, int numberPeople)
{
  if(gastar != NULL)
  {
    delete gastar;
  }
  gastar = new aStar(mapWidth, mapHeight , tileSize, numberPeople);
  return(0);
}

int QcakeScriptApi::tmpobjInit (int hh, float x , float y, float z, float h , float p, float r, int id)
{
  sgCoord       pos ;

  sgSetCoord ( &pos,x,y,z,h,p,r ) ;
  splaModel *model=getModel ( hh );
  if(model){
    return(model->getFolderListItem()->addTmpObject(getModel ( hh )->getFolderListItem(),pos,id)); 
  }
  return 0;
}
