/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.util.SoftLog;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import king.KinfileIO;
import king.KingMain;

public class FileDropHandler
extends TransferHandler {
    KingMain kMain;
    ArrayList<Listener> listeners = new ArrayList();

    public FileDropHandler(KingMain kingMain) {
        this.kMain = kingMain;
        this.addFileDropListener(new KinFileOpen());
    }

    public void handleDropsFor(JComponent jComponent) {
        jComponent.setTransferHandler(this);
    }

    public void addFileDropListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void doFileDrop(File file) {
        if (!file.exists()) {
            SoftLog.err.println("Drag-n-drop of non-existant file!? '" + file + "'");
            return;
        }
        ArrayList<Listener> arrayList = new ArrayList<Listener>();
        for (Listener listener : this.listeners) {
            if (!listener.canHandleDroppedFile(file)) continue;
            arrayList.add(listener);
        }
        if (arrayList.size() == 0) {
            return;
        }
        if (arrayList.size() == 1) {
            ((Listener)arrayList.get(0)).handleDroppedFile(file);
        } else {
            Listener listener = (Listener)JOptionPane.showInputDialog(this.kMain.getTopWindow(), "What would you like to do with " + file.getName() + "?", "What would you like to do?", 3, null, arrayList.toArray(), arrayList.get(0));
            if (listener != null) {
                listener.handleDroppedFile(file);
            }
        }
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.doFileDrop((File)iterator.next());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace(SoftLog.err);
            }
        }
        return false;
    }

    private class KinFileOpen
    implements Listener {
        private KinFileOpen() {
        }

        public String toString() {
            return "Open the kinemage in KiNG";
        }

        public boolean canHandleDroppedFile(File file) {
            String string = file.getName().toLowerCase();
            return string.endsWith(".kin") || string.endsWith(".kin.gz") || string.endsWith(".kip");
        }

        public void handleDroppedFile(File file) {
            KinfileIO kinfileIO = FileDropHandler.this.kMain.getKinIO();
            kinfileIO.loadFile(file, null);
        }
    }

    public static interface Listener {
        public boolean canHandleDroppedFile(File var1);

        public void handleDroppedFile(File var1);
    }
}

