/*
 * Decompiled with CFR 0.152.
 */
package king.tool.bondrot;

import driftwood.r3.Transform;
import driftwood.r3.Triple;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import king.core.BondRot;
import king.core.KList;
import king.core.KPoint;

public class BondRotHandler {
    DecimalFormat df2 = new DecimalFormat("0.00");
    HashMap origMap = new HashMap();
    HashSet origSet = new HashSet();
    HashMap pointMap = new HashMap();
    HashMap rotMap = new HashMap();
    BondRot[] bondRotArray = null;

    public BondRotHandler(Collection collection) {
        Iterator iterator = collection.iterator();
        int n = 0;
        this.bondRotArray = new BondRot[collection.size()];
        while (iterator.hasNext()) {
            BondRot bondRot;
            this.bondRotArray[n] = bondRot = (BondRot)iterator.next();
            ++n;
            this.rotMap.put(bondRot.getName(), bondRot);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.origMap.put(bondRot, arrayList);
            this.pointMap.put(bondRot, arrayList2);
            for (KList kList : bondRot) {
                this.storeCoords(kList, arrayList2, arrayList);
            }
        }
    }

    private void storeCoords(KList kList, ArrayList arrayList, ArrayList arrayList2) {
        for (KPoint kPoint : kList) {
            arrayList.add(kPoint);
            Triple triple = new Triple(kPoint);
            if (this.origSet.contains(triple)) {
                for (Triple triple2 : this.origSet) {
                    if (!triple2.equals(triple)) continue;
                    triple = triple2;
                }
            }
            arrayList2.add(triple);
            this.origSet.add(triple);
        }
    }

    public void doRotation(BondRot bondRot, double d) {
        if (bondRot != null) {
            KList kList = bondRot.getAxisList();
            Iterator iterator = kList.iterator();
            Triple triple = new Triple((KPoint)iterator.next());
            Triple triple2 = new Triple((KPoint)iterator.next());
            Transform transform = new Transform();
            transform = transform.likeRotation(triple, triple2, d - bondRot.getCurrentAngle());
            Iterator iterator2 = ((ArrayList)this.origMap.get(bondRot)).iterator();
            for (KPoint kPoint : (ArrayList)this.pointMap.get(bondRot)) {
                Triple triple3 = new Triple(kPoint);
                transform.transform(triple3);
                kPoint.setX(triple3.getX());
                kPoint.setY(triple3.getY());
                kPoint.setZ(triple3.getZ());
            }
            bondRot.setCurrentAngle(d);
        }
    }

    public void updateCoords(BondRot bondRot) {
        ArrayList arrayList = (ArrayList)this.origMap.get(bondRot);
        ArrayList arrayList2 = (ArrayList)this.pointMap.get(bondRot);
        Iterator iterator = arrayList2.iterator();
        Iterator iterator2 = arrayList.iterator();
        while (iterator.hasNext()) {
            KPoint kPoint = (KPoint)iterator.next();
            Triple triple = (Triple)iterator2.next();
            triple.setXYZ(kPoint.getX(), kPoint.getY(), kPoint.getZ());
        }
    }

    public BondRot getBondRot(String string) {
        return (BondRot)this.rotMap.get(string);
    }

    public BondRot[] getBondRotArray() {
        return this.bondRotArray;
    }
}

