/*
 * Decompiled with CFR 0.152.
 */
package molikin.logic;

import driftwood.data.CheapSet;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import molikin.AtomClassifier;
import molikin.BallPrinter;
import molikin.DataCache;
import molikin.PseudoBackbone;
import molikin.ResClassifier;
import molikin.StickPrinter;
import molikin.Util;
import molikin.crayons.AltConfCrayon;
import molikin.crayons.BfactorCrayon;
import molikin.crayons.CompositeCrayon;
import molikin.crayons.DisulfideCrayon;
import molikin.crayons.HalfBondElementCrayon;
import molikin.crayons.OccupancyCrayon;
import molikin.crayons.ResTypeCrayon;
import molikin.logic.Logic;

public class BallAndStickLogic
implements Logic {
    public static final Object COLOR_BY_MC_SC = "backbone / sidechain";
    public static final Object COLOR_BY_RES_TYPE = "residue type";
    public static final Object COLOR_BY_ELEMENT = "element";
    public static final Object COLOR_BY_B_FACTOR = "B factor";
    public static final Object COLOR_BY_OCCUPANCY = "occupancy";
    static final DecimalFormat df = new DecimalFormat("00");
    PrintWriter out = null;
    StickPrinter sp = null;
    BallPrinter bp = null;
    public boolean doProtein;
    public boolean doNucleic;
    public boolean doHets;
    public boolean doIons;
    public boolean doWater;
    public boolean doPseudoBB;
    public boolean doBackbone;
    public boolean doSidechains;
    public boolean doHydrogens;
    public boolean doDisulfides;
    public boolean doBallsOnCarbon;
    public boolean doBallsOnAtoms;
    public Object colorBy = COLOR_BY_MC_SC;

    public void printKinemage(PrintWriter printWriter, Model model, Set set, String string) {
        this.printKinemage(printWriter, model, set, "", string);
    }

    public void printKinemage(PrintWriter printWriter, Model model, Set set, String string, String string2) {
        this.out = printWriter;
        this.sp = new StickPrinter(printWriter);
        this.bp = new BallPrinter(printWriter);
        if (this.colorBy == COLOR_BY_MC_SC) {
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new DisulfideCrayon()));
            this.bp.setCrayon(new AltConfCrayon());
        } else if (this.colorBy == COLOR_BY_RES_TYPE) {
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new ResTypeCrayon()));
            this.bp.setCrayon(new AltConfCrayon());
        } else if (this.colorBy == COLOR_BY_ELEMENT) {
            this.sp.setHalfBonds(true);
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new HalfBondElementCrayon()));
            this.bp.setCrayon(new AltConfCrayon());
        } else if (this.colorBy == COLOR_BY_B_FACTOR) {
            this.sp.setHalfBonds(true);
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new BfactorCrayon()));
            this.bp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new BfactorCrayon()));
        } else if (this.colorBy == COLOR_BY_OCCUPANCY) {
            this.sp.setHalfBonds(true);
            this.sp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new OccupancyCrayon()));
            this.bp.setCrayon(new CompositeCrayon().add(new AltConfCrayon()).add(new OccupancyCrayon()));
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.doProtein) {
            this.printProtein(model, set, string, string2);
        }
        if (this.doNucleic) {
            this.printNucAcid(model, set, string, string2);
        }
        if (this.doHets) {
            this.printHets(model, set, string);
        }
        if (this.doIons) {
            this.printIons(model, set, string);
        }
        if (this.doWater) {
            this.printWaters(model, set, string);
        }
        this.out.flush();
        this.out = null;
        this.sp = null;
        this.bp = null;
    }

    void printProtein(Model model, Set set, String string, String string2) {
        Object object;
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.proteinRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        Collection collection = dataCache.getCovalentGraph().getBonds();
        String string3 = " m" + df.format(Integer.parseInt(dataCache.getModelId())) + "_" + string.toLowerCase();
        if (this.doPseudoBB || atomClassifier.bbNotCa == 0) {
            object = this.doBackbone && atomClassifier.bbNotCa != 0 ? " off" : "";
            this.out.println("@vectorlist {protein ca} color= " + string2 + " master= {protein} master= {Calphas}" + (String)object);
            PseudoBackbone pseudoBackbone = dataCache.getPseudoBackbone();
            this.sp.printSticks(pseudoBackbone.getProteinBonds(), null, null, cheapSet, cheapSet, string3);
        }
        if (this.doBackbone && atomClassifier.bbHeavy.size() > 0) {
            this.out.println("@vectorlist {protein bb} color= " + string2 + " master= {protein} master= {backbone}");
            this.sp.printSticks(collection, atomClassifier.bbHeavy, atomClassifier.bbHeavy, cheapSet, cheapSet, string3);
            if (this.doHydrogens && atomClassifier.bbHydro.size() > 0) {
                this.out.println("@vectorlist {protein bbH} color= gray master= {protein} master= {backbone} master= {Hs}");
                this.sp.printSticks(collection, atomClassifier.bbHydro, atomClassifier.bbHeavy, cheapSet, cheapSet, string3);
            }
            if (this.doBallsOnAtoms) {
                this.printAtomBalls(atomClassifier.bbHeavy, cheapSet, this.doBallsOnCarbon ? string2 : null, "master= {protein} master= {backbone}");
            }
        }
        if (this.doSidechains && atomClassifier.scHeavy.size() > 0) {
            this.out.println("@vectorlist {protein sc} color= cyan master= {protein} master= {sidechains}");
            this.sp.printSticks(collection, atomClassifier.scHeavy, atomClassifier.bioHeavy, cheapSet, resClassifier.proteinRes, string3);
            if (this.doHydrogens && atomClassifier.scHydro.size() > 0) {
                this.out.println("@vectorlist {protein scH} color= gray master= {protein} master= {sidechains} master= {Hs}");
                this.sp.printSticks(collection, atomClassifier.scHydro, atomClassifier.bioHeavy, cheapSet, cheapSet, string3);
            }
            if (this.doBallsOnAtoms) {
                this.printAtomBalls(atomClassifier.scHeavy, cheapSet, this.doBallsOnCarbon ? "cyan" : null, "master= {protein} master= {sidechains}");
            }
        }
        if (this.doDisulfides) {
            object = Util.selectDisulfideResidues(collection);
            object.retainAll(cheapSet);
            if (atomClassifier.scHeavy.size() > 0 && object.size() > 0) {
                this.out.println("@vectorlist {protein ss} color= yellow master= {protein} master= {disulfides}");
                this.sp.printSticks(collection, atomClassifier.scHeavy, atomClassifier.bioHeavy, (Set)object, null, string3);
                if (this.doHydrogens && atomClassifier.scHydro.size() > 0) {
                    this.out.println("@vectorlist {protein ssH} color= gray master= {protein} master= {disulfides} master= {Hs}");
                    this.sp.printSticks(collection, atomClassifier.scHydro, atomClassifier.bioHeavy, (Set)object, (Set)object, string3);
                }
                if (this.doBallsOnAtoms) {
                    this.printAtomBalls(atomClassifier.scHeavy, (Set)object, this.doBallsOnCarbon ? "cyan" : null, "master= {protein} master= {disulfides}");
                }
            }
        }
    }

    void printNucAcid(Model model, Set set, String string, String string2) {
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.nucAcidRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        Collection collection = dataCache.getCovalentGraph().getBonds();
        String string3 = " m" + df.format(Integer.parseInt(dataCache.getModelId())) + "_" + string.toLowerCase();
        if (this.doPseudoBB) {
            String string4 = this.doBackbone ? " off" : "";
            this.out.println("@vectorlist {nuc. acid pseudobb} color= " + string2 + " master= {nucleic acid} master= {pseudo-bb}" + string4);
            PseudoBackbone pseudoBackbone = dataCache.getPseudoBackbone();
            this.sp.printSticks(pseudoBackbone.getNucAcidBonds(), null, null, cheapSet, cheapSet, string3);
        }
        if (this.doBackbone && atomClassifier.bbHeavy.size() > 0) {
            this.out.println("@vectorlist {nuc. acid bb} color= " + string2 + " master= {nucleic acid} master= {backbone}");
            this.sp.printSticks(collection, atomClassifier.bbHeavy, atomClassifier.bbHeavy, cheapSet, cheapSet, string3);
            if (this.doHydrogens && atomClassifier.bbHydro.size() > 0) {
                this.out.println("@vectorlist {nuc. acid bbH} color= gray master= {nucleic acid} master= {backbone} master= {Hs}");
                this.sp.printSticks(collection, atomClassifier.bbHydro, atomClassifier.bbHeavy, cheapSet, cheapSet, string3);
            }
            if (this.doBallsOnAtoms) {
                this.printAtomBalls(atomClassifier.bbHeavy, cheapSet, this.doBallsOnCarbon ? string2 : null, "master= {nucleic acid} master= {backbone}");
            }
        }
        if (this.doSidechains && atomClassifier.scHeavy.size() > 0) {
            this.out.println("@vectorlist {nuc. acid sc} color= cyan master= {nucleic acid} master= {sidechains}");
            this.sp.printSticks(collection, atomClassifier.scHeavy, atomClassifier.bioHeavy, cheapSet, cheapSet, string3);
            if (this.doHydrogens && atomClassifier.scHydro.size() > 0) {
                this.out.println("@vectorlist {nuc. acid scH} color= gray master= {nucleic acid} master= {sidechains} master= {Hs}");
                this.sp.printSticks(collection, atomClassifier.scHydro, atomClassifier.scHeavy, cheapSet, cheapSet, string3);
            }
            if (this.doBallsOnAtoms) {
                this.printAtomBalls(atomClassifier.scHeavy, cheapSet, this.doBallsOnCarbon ? "cyan" : null, "master= {nucleic acid} master= {sidechains}");
            }
        }
    }

    void printHets(Model model, Set set, String string) {
        CheapSet cheapSet;
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet2 = new CheapSet(resClassifier.ohetRes);
        cheapSet2.addAll(resClassifier.unknownRes);
        cheapSet2.retainAll(set);
        if (cheapSet2.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        Collection collection = dataCache.getCovalentGraph().getBonds();
        String string2 = " m" + df.format(Integer.parseInt(dataCache.getModelId())) + "_" + string.toLowerCase();
        if (atomClassifier.hetHeavy.size() == 0) {
            return;
        }
        this.out.println("@vectorlist {het} color= pink master= {hets}");
        this.sp.printSticks(collection, atomClassifier.hetHeavy, atomClassifier.hetHeavy, cheapSet2, cheapSet2, string2);
        if (this.doBallsOnAtoms) {
            this.printAtomBalls(atomClassifier.hetHeavy, cheapSet2, this.doBallsOnCarbon ? "pink" : null, "master= {hets}");
        }
        if (this.doHydrogens && atomClassifier.hetHydro.size() > 0) {
            this.out.println("@vectorlist {hetH} color= gray master= {hets} master= {Hs}");
            this.sp.printSticks(collection, atomClassifier.hetHydro, atomClassifier.hetHeavy, cheapSet2, cheapSet2, string2);
        }
        if (this.doProtein) {
            cheapSet = new CheapSet(set);
            cheapSet.retainAll(resClassifier.proteinRes);
            if (cheapSet.size() > 0 && this.doBackbone && atomClassifier.bbHeavy.size() > 0) {
                this.out.println("@vectorlist {het - protein bb} color= pinktint master= {hets} master= {protein} master= {backbone}");
                this.sp.printSticks(collection, atomClassifier.hetHeavy, atomClassifier.bbHeavy, cheapSet2, cheapSet, string2);
            }
            if (cheapSet.size() > 0 && this.doSidechains && atomClassifier.scHeavy.size() > 0) {
                this.out.println("@vectorlist {het - protein sc} color= pinktint master= {hets} master= {protein} master= {sidechains}");
                this.sp.printSticks(collection, atomClassifier.hetHeavy, atomClassifier.scHeavy, cheapSet2, cheapSet, string2);
            }
        }
        if (this.doNucleic) {
            cheapSet = new CheapSet(set);
            cheapSet.retainAll(resClassifier.nucAcidRes);
            if (cheapSet.size() > 0 && this.doBackbone && atomClassifier.bbHeavy.size() > 0) {
                this.out.println("@vectorlist {het - nuc. acid bb} color= pinktint master= {hets} master= {nucleic acid} master= {backbone}");
                this.sp.printSticks(collection, atomClassifier.hetHeavy, atomClassifier.bbHeavy, cheapSet2, cheapSet, string2);
            }
            if (cheapSet.size() > 0 && this.doSidechains && atomClassifier.scHeavy.size() > 0) {
                this.out.println("@vectorlist {het - nuc. acid sc} color= pinktint master= {hets} master= {nucleic acid} master= {sidechains}");
                this.sp.printSticks(collection, atomClassifier.hetHeavy, atomClassifier.scHeavy, cheapSet2, cheapSet, string2);
            }
        }
    }

    void printIons(Model model, Set set, String string) {
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.ionRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        if (atomClassifier.ion.size() == 0) {
            return;
        }
        String string2 = " m" + df.format(Integer.parseInt(dataCache.getModelId())) + "_" + string.toLowerCase();
        this.out.println("@spherelist {ions} color= gray radius= 0.5 master= {ions}");
        this.bp.printBalls(atomClassifier.ion, cheapSet, string2);
    }

    void printWaters(Model model, Set set, String string) {
        DataCache dataCache = DataCache.getDataFor(model);
        ResClassifier resClassifier = dataCache.getResClassifier();
        CheapSet cheapSet = new CheapSet(set);
        cheapSet.retainAll(resClassifier.waterRes);
        if (cheapSet.size() == 0) {
            return;
        }
        AtomClassifier atomClassifier = dataCache.getAtomClassifier();
        if (atomClassifier.watHeavy.size() == 0) {
            return;
        }
        String string2 = " m" + df.format(Integer.parseInt(dataCache.getModelId())) + "_" + string.toLowerCase();
        this.out.println("@balllist {waters} color= peachtint radius= 0.15 master= {waters}");
        this.bp.printBalls(atomClassifier.watHeavy, cheapSet, string2);
        if (this.doHydrogens && atomClassifier.watHydro.size() > 0) {
            Collection collection = dataCache.getCovalentGraph().getBonds();
            this.out.println("@vectorlist {waterH} color= gray master= {waters} master= {Hs}");
            this.sp.printSticks(collection, atomClassifier.watHydro, atomClassifier.watHeavy, cheapSet, cheapSet, string2);
        }
    }

    void printAtomBalls(Collection collection, Set set, String string, String string2) {
        Collection<Object> collection2;
        Object object;
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        for (Object object2 : collection) {
            object = ((AtomState)object2).getElement();
            if (((String)object).equals("H") || ((String)object).equals("Q") || string == null && ((String)object).equals("C") || !set.contains(((AtomState)object2).getResidue())) continue;
            collection2 = (Collection)hashMap.get(object);
            if (collection2 == null) {
                collection2 = new ArrayList<Object>();
                hashMap.put(object, (ArrayList<Object>)collection2);
            }
            collection2.add(object2);
        }
        for (Object object2 : hashMap.keySet()) {
            object = (Collection)hashMap.get(object2);
            collection2 = Util.getElementColor((String)object2);
            this.out.println("@balllist {" + (String)object2 + " balls} color= " + (String)((Object)collection2) + " radius= 0.2 master= {" + (String)object2 + "} " + string2);
            this.bp.printBalls((Collection)object);
        }
    }
}

