/***************************************************************************
 *   Copyright (C) 2003 by Moris Ravasio                                   *
 *   moris_ravasio@hotmail.com                                             *
 *                                                                         *
 *   Copyright (C) 2007 by Matvey Kozhev                                   *
 *   sikon@lucidfox.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "qinkdlg.h"

#include <QLocale>
#include <QMessageBox>
#include <QTranslator>
#include <QDebug>
#include <QIcon>

static const int buttonIconSize = 16;
const char *appname = "QInk";
const char *version = "0.3.5";
const char *description = QT_TR_NOOP("A Qt Printer Ink Level Monitor Utility<br /><br />"
        "Copyright (C) 2003 Moris Ravasio &lt;moris_ravasio@hotmail.com&gt;<br />"
        "Copyright (C) 2007 Matvey Kozhev &lt;sikon@lucidfox.org&gt;");

IconTheme *iconTheme;

QIcon getButtonIcon(const QString& name)
{
    QString path = iconTheme->getIconPath(name, buttonIconSize);
    
    if(path.isEmpty())
        return QIcon(RESDIR "/" + name + ".png");
    else
        return QIcon(path);
}

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    IconTheme theme;
    iconTheme = &theme;
    theme.loadDefaultTheme();
    
    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name());
    app.installTranslator(&qtTranslator);

    QTranslator appTranslator;
    appTranslator.load(RESDIR "/" + QLocale::system().name());
    app.installTranslator(&appTranslator);
    app.setQuitOnLastWindowClosed(false);

    QInkDlg dlg;
    return app.exec();
}
