/*
 * QNix      (C) 2001 Derek Greene     <del@chek.com>
 * Based on code from ModSystem & Redmond kwin clients
 *  			   (C) 2000 Daniel M. Duley  <mosfet@kde.org>
 * 					 (C) 2001 Karol Szwed <gallium@kde.org>
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef KWIN_CUSTOM_H
#define KWIN_CUSTOM_H

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <kwin/kwinbutton.h>
#include <kwin/client.h>

class QLabel;
class QSpacerItem;
class QBoxLayout;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

namespace KWinInternal
{

	enum Buttons{ BtnMax=0, BtnMin, BtnClose, BtnMenu };

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// CLASS : QNixButton
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	class QNixButton : public KWinInternal::KWinButton
	{
		public:
			QNixButton(Client *parent=0, const char *name=0, const Buttons type=BtnMax, const unsigned char *bitmap=NULL,  bool menuButton=false, bool isMini=false, const QString& tip=NULL);
			void     setBitmap(const unsigned char *bitmap);
			void     setPixmap(const QPixmap &p);
			void     reset();
			QSize    sizeHint() const;
			int      last_button;

		protected:
			// Events
			void     mousePressEvent(QMouseEvent* e);
			void     mouseReleaseEvent(QMouseEvent* e);
			void     enterEvent( QEvent *e);
			void     leaveEvent( QEvent *e);

			// Draw the button
			void     drawButton(QPainter *p);
			void     drawButtonLabel(QPainter *){;}
			// Protected attributes
			QBitmap  deco;
			QPixmap  pix;
			bool     menuBtn;			// is this the menu button?
			bool     miniBtn;
			Client*  client;			// owner
			Buttons  m_type;			// button type
			bool		 b_highlight;
	};

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// CLASS : QNixClient
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
  class QNiXClient : public KWinInternal::Client
  {
    Q_OBJECT

    public:
      QNiXClient( Workspace *,  WId, QWidget * parent = 0, const char * name = 0 );
      ~QNiXClient() {/* empty */};

    protected:
			// Events
      void resizeEvent(QResizeEvent *);
      void paintEvent(QPaintEvent *);
      void mouseDoubleClickEvent(QMouseEvent *);
      void captionChange(const QString &);
      void stickyChange(bool on);
      void maximizeChange(bool);
			void activeChange(bool);
	 		void iconChange();
			// Return mouse position
      MousePosition mousePosition(const QPoint &) const;

    protected slots:
      void slotReset();
			void slotMaximize();
			void slotMenu();

    signals:
      void stkyChange(bool);
      void maxChange(bool);

    private:
			bool smallButtons;
			int  titleHeight;
			// titlebar widget
     	QSpacerItem* 	 	titlebar;
			// title bar buttons
			QNixButton* 		button[5];
			// layouts
			QVBoxLayout*		mainLayout;
			QHBoxLayout*		titleLayout;
			QHBoxLayout*		windowLayout;
			// Function which defines layout of this client
      void setupLayout();
  };

}


//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// PIXMAPS
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

static const char *kdelogo[] = {
/* columns rows colors chars-per-pixel */
"16 16 8 1",
" 	c None",
".	c #000000",
"+	c #A0A0A4",
"@	c #FFFFFF",
"#	c #585858",
"$	c #C0C0C0",
"%	c #808080",
"&	c #DCDCDC",
"                ",
"     ..    ..   ",
"    .+@.  .@#.  ",
"   .@@@. .@@@#  ",
"   .@@@..$@@$.  ",
"   .@@@.@@@$.   ",
"   .@@@%@@$.    ",
"   .@@@&@@.     ",
"   .@@@@@@.     ",
"   .@@@$@@&.    ",
"   .@@@.@@@.    ",
"   .@@@.+@@@.   ",
"   .@@@..$@@&.  ",
"   .@@%. .@@@.  ",
"   ....   ...   ",
"                "};

static const char *qnixlogo[]={
/* columns rows colors chars-per-pixel */
"12 14 27 1",
". c None",
"m c #4a4a4a",
"n c #524e47",
"q c #565554",
"t c #63605a",
"o c #64583c",
"w c #696969",
"y c #6d675d",
"v c #6f6a61",
"x c #736d63",
"h c #787167",
"r c #7d766b",
"s c #7f796f",
"k c #827b70",
"p c #837868",
"l c #8a702f",
"u c #8d7a4a",
"d c #9a8a65",
"j c #a3863d",
"# c #a59a81",
"g c #b29549",
"b c #b79f63",
"i c #be952a",
"a c #c5a34b",
"f c #d3a837",
"c c #e2ad22",
"e c #fabe1b",
".....##.....",
".....aa.....",
".bb..cc..bb.",
".defgeegfed.",
".hieeijeeih.",
".kjelmnoejp.",
"feecqrstieea",
"uicch..hccij",
"vnlefddielnw",
".xceeeeeecv.",
".jcloecolej.",
".uonniinnou.",
".vv.ylly.yv.",
".....tt....."
};

static const char* iqnixlogo[] = {
/* columns rows colors chars-per-pixel */
"12 15 25 1",
" 	g None",
".	g #9A9A9A",
"+	g #A3A3A3",
"@	g #9F9F9F",
"#	g #ADADAD",
"$	g #8A8A8A",
"%	g #BEBEBE",
"&	g #A8A8A8",
"*	g #959595",
"=	g #727272",
"-	g #868686",
";	g #7B7B7B",
">	g #707070",
",	g #4A4A4A",
"'	g #4E4E4E",
")	g #585858",
"!	g #797979",
"~	g #555555",
"{	g #767676",
"]	g #606060",
"^	g #7A7A7A",
"/	g #6A6A6A",
"(	g #696969",
"_	g #6D6D6D",
":	g #676767",
"     ..     ",
"     ++     ",
" @@  ##  @@ ",
" $%&*%%*&%$ ",
" =*%%*-%%*= ",
" ;-%>,')%-! ",
"&%%#~{!]*%%+",
"^*##=  =##*-",
"/'>%&$$*%>'(",
" _#%%%%%%#/ ",
" -#>)%#)>%- ",
" ^)''**'')^ ",
" // :>>: :/ ",
"     ]]     ",
"            "};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#endif
