/*
 * QNix      (C) 2001 Derek Greene     <del@chek.com>
 * Based on code from HCStyle & MegaGradient Style :
 *  			   (C) 2000 Daniel M. Duley  <mosfet@kde.org>
 *           (C) 2000 Dirk Mueller     <mueller@kde.org>
 *           (C) 2001 Martijn Klingens <mklingens@yahoo.com>
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef QNIXSTYLE_H
#define QNIXSTYLE_H

#include <kstyle.h>
#include <qpainter.h>
#include <qdrawutil.h>
#include <qpalette.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qscrollbar.h>
#include <qbitmap.h>
#include <qintdict.h>
#include <limits.h>

class KPixmap;
class GradientSet;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Enumerated Types
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

enum GradientType{ VSmallest=0, VSmall, VMed, VLarge,
                   HSmallest,   HSmall, HMed, HLarge,
									 VSmallestRev, VSmallRev, VMedRev, VLargeRev,
									 HSmallestRev, HSmallRev, HMedRev, HLargeRev};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CLASS : QNixStyle
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

class QNixStyle : public KStyle
{
	public:
		// Consturctor
    QNixStyle();
		// Destructor
    ~QNixStyle() { /* do nothing */ };

		// Buttons
		virtual void drawPushButtonLabel (QPushButton *btn, QPainter *p);
    void 	drawButton(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, bool sunken = FALSE, const QBrush *fill = 0 );
    void 	drawButtonMask(QPainter *p, int x, int y, int w, int h);
    QRect buttonRect(int x, int y, int w, int h);
    void 	drawBevelButton(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, bool sunken = FALSE, const QBrush *fill = 0 );
    void 	drawPushButton(QPushButton *btn, QPainter *p);
		// Checkboxes
    QSize indicatorSize() const;
		void  drawIndicator(QPainter* p, int x, int y, int w, int h, const QColorGroup &g, int state, bool down = FALSE, bool enabled = TRUE );
    void  drawIndicatorMask(QPainter *p, int x, int y, int w, int h, int);
		// Radio buttons
    QSize exclusiveIndicatorSize() const;
    void  drawExclusiveIndicator(QPainter* p,  int x, int y, int w, int h, const QColorGroup &g, bool on,  bool down = FALSE, bool enabled =  TRUE );
    void  drawExclusiveIndicatorMask(QPainter *p, int x, int y, int w,  int h, bool);
		// Combo buttons
		void  drawComboButton(QPainter *p, int x, int y, int w, int h,  const QColorGroup &g, bool sunken = FALSE,  bool editable = FALSE, bool enabled = TRUE, const QBrush *fill = 0 );
    QRect comboButtonRect(int x, int y, int w, int h);
    QRect comboButtonFocusRect(int x, int y, int w, int h);
    void 	drawComboButtonMask(QPainter *p, int x, int y, int w, int h);
		// Scrollbars
    void 	drawScrollBarControls(QPainter*,  const QScrollBar*, int sliderStart, uint controls, uint activeControl );
    QStyle::ScrollControl scrollBarPointOver(const QScrollBar *sb,  int sliderStart, const QPoint &p);
    void scrollBarMetrics(const QScrollBar *sb, int &sliderMin, int &sliderMax, int &sliderLength, int &buttonDim);
    int  sliderLength() const;
    void drawArrow(QPainter *p, Qt::ArrowType type, bool down, int x, int y, int w, int h, const QColorGroup &g, bool enabled=true, const QBrush *fill = 0);
    void drawSlider(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, Orientation orient,  bool tickAbove, bool tickBelow);
    void drawSliderMask(QPainter *p, int x, int y, int w, int h, Orientation orient, bool, bool);
    void drawFocusRect(QPainter *p, const QRect &r, const QColorGroup &g, const QColor *pen, bool atBorder);
		// Progress bar
    void drawKProgressBlock(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, QBrush *fill);
		// Menus
    void drawPopupPanel(QPainter* p, int x, int y, int w, int h, const QColorGroup &g, int lineWidth, const QBrush *fill);
    void drawKMenuItem(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, bool active,    QMenuItem *item, QBrush *fill=NULL);
    void drawKMenuBar(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, bool macMode,  QBrush *fill=NULL);
    void drawPopupMenuItem(QPainter *p, bool checkable, int maxpmw, int tab, QMenuItem *mi, const QPalette &pal, bool act, bool enabled, int x, int y, int w, int h);
    int  popupMenuItemHeight(bool c, QMenuItem *mi, const QFontMetrics &fm);
    void polishPopupMenu(QPopupMenu *mnu);
		// Toolbars
    void drawKToolBar(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, KToolBarPos type,  QBrush *fill=NULL);
    void drawKBarHandle(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, KToolBarPos type, QBrush *fill=NULL);
    void drawKToolBarButton(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, bool sunken=false, bool raised = true, bool enabled = true, bool popup = false, KToolButtonType icontext = Icon,                        const QString& btext=QString::null, const QPixmap *icon=NULL,  QFont *font=NULL, QWidget *btn=NULL);
		// Tabs
    void drawTab(QPainter *p, const QTabBar *tabBar, QTab *tab, bool selected);
    void drawTabMask( QPainter*, const QTabBar*, QTab*, bool selected );
    void tabbarMetrics(const QTabBar *t, int &hFrame, int &vFrame, int &overlap);
		// Splitters
    void drawSplitter(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, Orientation orient);
    int  splitterWidth() const {return(6);}
		// Panels
    void drawPanel(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, bool sunken, int lineWidth, const QBrush *fill);
		// Kicker
    void drawKickerAppletHandle(QPainter *p, int x, int y, int w, int h,  const QColorGroup &g, QBrush *);
    void drawKickerTaskButton(QPainter *p, int x, int y, int w, int h, const QColorGroup &g, const QString &title, bool active, QPixmap *icon, QBrush *fill);

    // for repainting toolbuttons when the toolbar is resized
    bool eventFilter(QObject *obj, QEvent *ev);
		// misc
    int  defaultFrameWidth() const {return(2);}
    virtual void polish(QWidget *w);
    virtual void unPolish(QWidget *w);
    virtual void polish(QApplication *a) { KStyle::polish(a); }
    virtual void unPolish(QApplication *a) { KStyle::unPolish(a); }
    virtual void polish(QPalette &p);


	protected:
		// Draw gradients
    void drawVGradient(QPainter *p, const QColorGroup &g, QColorGroup::ColorRole type, int x, int y, int w, int h, int sx, int sy, int tw, int th, bool flip=false);
    void drawHGradient(QPainter *p, const QColorGroup &g, QColorGroup::ColorRole type, int x, int y, int w, int h, int sx, int sy, int tw, int th, bool flip=false);
		// Scrollbars
    void drawSBDeco(QPainter *p, const QRect &r, const QColorGroup &g, bool horiz);
    void drawSBButton(QPainter *p, const QRect &r, const QColorGroup &g, bool down=false, bool horiz = true, bool reverse = false);

	private:
    bool 										highcolor;
    QIntDict<GradientSet>		gDict;
};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CLASS : GradientSet
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

class GradientSet
{
	public:
    GradientSet(const QColor &baseColor);
    ~GradientSet();
    KPixmap* gradient(GradientType type);
    QColor* color(){return(&c);}
	private:
    KPixmap *gradients[16];
    QColor c;
};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*static unsigned char radiomask_bits[] = {
  0xf0, 0x01, 0xfc, 0x07, 0xfe, 0x0b, 0xfe, 0x0b, 0xff, 0x17, 0xff, 0x17,
  0xff, 0x17, 0xff, 0x17, 0xff, 0x17, 0xfe, 0x0b, 0xf2, 0x09, 0x0c, 0x06,
  0xf0, 0x01};
static unsigned char radiomask_bits[] = {
 0xf8,0x03,0xfc,0x03,0xfe,0xf7,0xff,0xef,0xff,0x0f,0xff,0x2f,0xff,0x5f,0xff,
 0xaf,0xff,0x0f,0xfe,0xf7,0xfc,0xf3,0xf8,0x41,0xf8,0x01,0x00,0x00,0x70,0x00,
 0x00,0x00,0x31,0x00,0x00,0x00,0x68,0x94,0x12,0x08,0x78,0x96,0x05,0x08,0x78,
 0x96,0x05,0x08,0x78,0x96,0x05,0x08 };
*/

static unsigned char radiomask_bits[] = {
 0xf0,0x07,0xf8,0x07,0xfc,0xef,0xfe,0xff,0xfe,0x1f,0xfe,0x3f,0xfe,0xdf,0xfe,
 0xbf,0xfe,0x1f,0xfc,0xaf,0xf8,0xe7,0xf0,0x43,0xf0,0x03,0x00,0x00,0x70,0x00,
 0x00,0x00,0x49,0x00,0x00,0x00,0x00,0x24,0x00,0x6b,0x00,0x69,0x00,0x63,0x00,
 0x6f,0x00,0x5f,0x00,0x66,0x00,0x6f };

#endif
