/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#ifndef __plextor_ecx
#define __plextor_ecx

#include <qpx_mmc.h>

#include <ui/plextor_ext_cx_ui.h>

const int ehres = 300;
const int evres = 160;

class QCanvas;
class QCanvasLine;
class QCanvasView;

class plextor_ext_cx : public plextor_ext_cx_UI
{
	Q_OBJECT
public:
	plextor_ext_cx( QWidget* parent, const char* name, bool modal, WFlags fl,
		err* BLER, err* E11, err* E21, err* E31, err* E12, err* E22, err* E32,
		int* blk_tot, int* blk_max, float* blk_avg, unsigned int* colors, unsigned int* lcolors, int limit);
	~plextor_ext_cx();
//	void setptr();
//	void setcolor(int* colors);
//	void setlimit(int limit);
	void redraw();

//public functions:

private:
	err*		data[7];
	int*		dtot;
	int*		dmax;
	float*		davg;
	unsigned int	color[7];
	unsigned int	colorl[7];
	int		hlimit;
	QCanvas*	Canvas[7];
	QCanvasView*	CanvasView[7];
	QCanvasLine**	Grid[7];
	QCanvasLine**	ResL[7];
	QCanvasLine**	ResD[7];
	QCanvasLine**	Lim;

private slots:
	void DrawGrid(int idx);
	void pxecx_close();
};

#endif
